package software.amazon.awscdk.services.secretsmanager;

/**
 * Secret rotation for a service or database.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret mySecret;
 * IConnectable myDatabase;
 * Vpc myVpc;
 * SecretRotation.Builder.create(this, "SecretRotation")
 *         .application(SecretRotationApplication.MYSQL_ROTATION_SINGLE_USER) // MySQL single user scheme
 *         .secret(mySecret)
 *         .target(myDatabase) // a Connectable
 *         .vpc(myVpc) // The VPC where the secret rotation application will be deployed
 *         .excludeCharacters(" %+:;{}")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.093Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.SecretRotation")
public class SecretRotation extends software.constructs.Construct {

    protected SecretRotation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretRotation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretRotation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.SecretRotation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.SecretRotation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.secretsmanager.SecretRotationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.secretsmanager.SecretRotationProps.Builder();
        }

        /**
         * The serverless application for the rotation.
         * <p>
         * @return {@code this}
         * @param application The serverless application for the rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(final software.amazon.awscdk.services.secretsmanager.SecretRotationApplication application) {
            this.props.application(application);
            return this;
        }

        /**
         * The secret to rotate. It must be a JSON string with the following format:.
         * <p>
         * <blockquote><pre>
         * {
         *    "engine": &lt;required: database engine&gt;,
         *    "host": &lt;required: instance host name&gt;,
         *    "username": &lt;required: username&gt;,
         *    "password": &lt;required: password&gt;,
         *    "dbname": &lt;optional: database name&gt;,
         *    "port": &lt;optional: if not specified, default port will be used&gt;,
         *    "masterarn": &lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;
         * }
         * </pre></blockquote>
         * <p>
         * This is typically the case for a secret referenced from an <code>AWS::SecretsManager::SecretTargetAttachment</code>
         * or an <code>ISecret</code> returned by the <code>attach()</code> method of <code>Secret</code>.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html</a>
         * @param secret The secret to rotate. It must be a JSON string with the following format:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * The target service or database.
         * <p>
         * @return {@code this}
         * @param target The target service or database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.ec2.IConnectable target) {
            this.props.target(target);
            return this;
        }

        /**
         * The VPC where the Lambda rotation function will run.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the Lambda rotation function will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * <p>
         * Default: Duration.days(30)
         * <p>
         * @return {@code this}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(final software.amazon.awscdk.Duration automaticallyAfter) {
            this.props.automaticallyAfter(automaticallyAfter);
            return this;
        }

        /**
         * The VPC interface endpoint to use for the Secrets Manager API.
         * <p>
         * If you enable private DNS hostnames for your VPC private endpoint (the default), you don't
         * need to specify an endpoint. The standard Secrets Manager DNS hostname the Secrets Manager
         * CLI and SDKs use by default (https://secretsmanager.<region>.amazonaws.com) automatically
         * resolves to your VPC endpoint.
         * <p>
         * Default: https://secretsmanager.<region>.amazonaws.com
         * <p>
         * @return {@code this}
         * @param endpoint The VPC interface endpoint to use for the Secrets Manager API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        /**
         * Characters which should not appear in the generated password.
         * <p>
         * Default: - no additional characters are explicitly excluded
         * <p>
         * @return {@code this}
         * @param excludeCharacters Characters which should not appear in the generated password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(final java.lang.String excludeCharacters) {
            this.props.excludeCharacters(excludeCharacters);
            return this;
        }

        /**
         * The master secret for a multi user rotation scheme.
         * <p>
         * Default: - single user rotation scheme
         * <p>
         * @return {@code this}
         * @param masterSecret The master secret for a multi user rotation scheme. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterSecret(final software.amazon.awscdk.services.secretsmanager.ISecret masterSecret) {
            this.props.masterSecret(masterSecret);
            return this;
        }

        /**
         * The security group for the Lambda rotation function.
         * <p>
         * Default: - a new security group is created
         * <p>
         * @return {@code this}
         * @param securityGroup The security group for the Lambda rotation function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * The type of subnets in the VPC where the Lambda rotation function will run.
         * <p>
         * Default: - the Vpc default strategy if not specified.
         * <p>
         * @return {@code this}
         * @param vpcSubnets The type of subnets in the VPC where the Lambda rotation function will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.SecretRotation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.SecretRotation build() {
            return new software.amazon.awscdk.services.secretsmanager.SecretRotation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
