package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a `CfnConfigurationSet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnConfigurationSetProps cfnConfigurationSetProps = CfnConfigurationSetProps.builder()
 *         .deliveryOptions(DeliveryOptionsProperty.builder()
 *                 .sendingPoolName("sendingPoolName")
 *                 .tlsPolicy("tlsPolicy")
 *                 .build())
 *         .name("name")
 *         .reputationOptions(ReputationOptionsProperty.builder()
 *                 .reputationMetricsEnabled(false)
 *                 .build())
 *         .sendingOptions(SendingOptionsProperty.builder()
 *                 .sendingEnabled(false)
 *                 .build())
 *         .suppressionOptions(SuppressionOptionsProperty.builder()
 *                 .suppressedReasons(List.of("suppressedReasons"))
 *                 .build())
 *         .trackingOptions(TrackingOptionsProperty.builder()
 *                 .customRedirectDomain("customRedirectDomain")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.204Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnConfigurationSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::SES::ConfigurationSet.DeliveryOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryOptions() {
        return null;
    }

    /**
     * The name of the configuration set. The name must meet the following requirements:.
     * <p>
     * <ul>
     * <li>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
     * <li>Contain 64 characters or fewer.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * `AWS::SES::ConfigurationSet.ReputationOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReputationOptions() {
        return null;
    }

    /**
     * `AWS::SES::ConfigurationSet.SendingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSendingOptions() {
        return null;
    }

    /**
     * `AWS::SES::ConfigurationSet.SuppressionOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSuppressionOptions() {
        return null;
    }

    /**
     * `AWS::SES::ConfigurationSet.TrackingOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTrackingOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationSetProps> {
        java.lang.Object deliveryOptions;
        java.lang.String name;
        java.lang.Object reputationOptions;
        java.lang.Object sendingOptions;
        java.lang.Object suppressionOptions;
        java.lang.Object trackingOptions;

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getDeliveryOptions}
         * @param deliveryOptions `AWS::SES::ConfigurationSet.DeliveryOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(software.amazon.awscdk.services.ses.CfnConfigurationSet.DeliveryOptionsProperty deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getDeliveryOptions}
         * @param deliveryOptions `AWS::SES::ConfigurationSet.DeliveryOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryOptions(software.amazon.awscdk.IResolvable deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getName}
         * @param name The name of the configuration set. The name must meet the following requirements:.
         *             <ul>
         *             <li>Contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</li>
         *             <li>Contain 64 characters or fewer.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getReputationOptions}
         * @param reputationOptions `AWS::SES::ConfigurationSet.ReputationOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(software.amazon.awscdk.services.ses.CfnConfigurationSet.ReputationOptionsProperty reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getReputationOptions}
         * @param reputationOptions `AWS::SES::ConfigurationSet.ReputationOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationOptions(software.amazon.awscdk.IResolvable reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getSendingOptions}
         * @param sendingOptions `AWS::SES::ConfigurationSet.SendingOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(software.amazon.awscdk.services.ses.CfnConfigurationSet.SendingOptionsProperty sendingOptions) {
            this.sendingOptions = sendingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getSendingOptions}
         * @param sendingOptions `AWS::SES::ConfigurationSet.SendingOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingOptions(software.amazon.awscdk.IResolvable sendingOptions) {
            this.sendingOptions = sendingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getSuppressionOptions}
         * @param suppressionOptions `AWS::SES::ConfigurationSet.SuppressionOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionOptions(software.amazon.awscdk.services.ses.CfnConfigurationSet.SuppressionOptionsProperty suppressionOptions) {
            this.suppressionOptions = suppressionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getSuppressionOptions}
         * @param suppressionOptions `AWS::SES::ConfigurationSet.SuppressionOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionOptions(software.amazon.awscdk.IResolvable suppressionOptions) {
            this.suppressionOptions = suppressionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getTrackingOptions}
         * @param trackingOptions `AWS::SES::ConfigurationSet.TrackingOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(software.amazon.awscdk.services.ses.CfnConfigurationSet.TrackingOptionsProperty trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getTrackingOptions}
         * @param trackingOptions `AWS::SES::ConfigurationSet.TrackingOptions`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingOptions(software.amazon.awscdk.IResolvable trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationSetProps {
        private final java.lang.Object deliveryOptions;
        private final java.lang.String name;
        private final java.lang.Object reputationOptions;
        private final java.lang.Object sendingOptions;
        private final java.lang.Object suppressionOptions;
        private final java.lang.Object trackingOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryOptions = software.amazon.jsii.Kernel.get(this, "deliveryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reputationOptions = software.amazon.jsii.Kernel.get(this, "reputationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sendingOptions = software.amazon.jsii.Kernel.get(this, "sendingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.suppressionOptions = software.amazon.jsii.Kernel.get(this, "suppressionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.trackingOptions = software.amazon.jsii.Kernel.get(this, "trackingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryOptions = builder.deliveryOptions;
            this.name = builder.name;
            this.reputationOptions = builder.reputationOptions;
            this.sendingOptions = builder.sendingOptions;
            this.suppressionOptions = builder.suppressionOptions;
            this.trackingOptions = builder.trackingOptions;
        }

        @Override
        public final java.lang.Object getDeliveryOptions() {
            return this.deliveryOptions;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getReputationOptions() {
            return this.reputationOptions;
        }

        @Override
        public final java.lang.Object getSendingOptions() {
            return this.sendingOptions;
        }

        @Override
        public final java.lang.Object getSuppressionOptions() {
            return this.suppressionOptions;
        }

        @Override
        public final java.lang.Object getTrackingOptions() {
            return this.trackingOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeliveryOptions() != null) {
                data.set("deliveryOptions", om.valueToTree(this.getDeliveryOptions()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getReputationOptions() != null) {
                data.set("reputationOptions", om.valueToTree(this.getReputationOptions()));
            }
            if (this.getSendingOptions() != null) {
                data.set("sendingOptions", om.valueToTree(this.getSendingOptions()));
            }
            if (this.getSuppressionOptions() != null) {
                data.set("suppressionOptions", om.valueToTree(this.getSuppressionOptions()));
            }
            if (this.getTrackingOptions() != null) {
                data.set("trackingOptions", om.valueToTree(this.getTrackingOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnConfigurationSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationSetProps.Jsii$Proxy that = (CfnConfigurationSetProps.Jsii$Proxy) o;

            if (this.deliveryOptions != null ? !this.deliveryOptions.equals(that.deliveryOptions) : that.deliveryOptions != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.reputationOptions != null ? !this.reputationOptions.equals(that.reputationOptions) : that.reputationOptions != null) return false;
            if (this.sendingOptions != null ? !this.sendingOptions.equals(that.sendingOptions) : that.sendingOptions != null) return false;
            if (this.suppressionOptions != null ? !this.suppressionOptions.equals(that.suppressionOptions) : that.suppressionOptions != null) return false;
            return this.trackingOptions != null ? this.trackingOptions.equals(that.trackingOptions) : that.trackingOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryOptions != null ? this.deliveryOptions.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.reputationOptions != null ? this.reputationOptions.hashCode() : 0);
            result = 31 * result + (this.sendingOptions != null ? this.sendingOptions.hashCode() : 0);
            result = 31 * result + (this.suppressionOptions != null ? this.suppressionOptions.hashCode() : 0);
            result = 31 * result + (this.trackingOptions != null ? this.trackingOptions.hashCode() : 0);
            return result;
        }
    }
}
