package software.amazon.awscdk.services.sns;

/**
 * Properties for defining a `CfnTopic`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sns.*;
 * Object dataProtectionPolicy;
 * CfnTopicProps cfnTopicProps = CfnTopicProps.builder()
 *         .contentBasedDeduplication(false)
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .displayName("displayName")
 *         .fifoTopic(false)
 *         .kmsMasterKeyId("kmsMasterKeyId")
 *         .signatureVersion("signatureVersion")
 *         .subscription(List.of(SubscriptionProperty.builder()
 *                 .endpoint("endpoint")
 *                 .protocol("protocol")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .topicName("topicName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.CfnTopicProps")
@software.amazon.jsii.Jsii.Proxy(CfnTopicProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTopicProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Enables content-based deduplication for FIFO topics.
     * <p>
     * <ul>
     * <li>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code> . If you create a FIFO topic and this attribute is <code>false</code> , you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action.</li>
     * <li>When you set <code>ContentBasedDeduplication</code> to <code>true</code> , Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</li>
     * </ul>
     * <p>
     * (Optional) To override the generated value, you can specify a value for the the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContentBasedDeduplication() {
        return null;
    }

    /**
     * `AWS::SNS::Topic.DataProtectionPolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataProtectionPolicy() {
        return null;
    }

    /**
     * The display name to use for an Amazon SNS topic with SMS subscriptions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * Set to true to create a FIFO topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFifoTopic() {
        return null;
    }

    /**
     * The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key terms</a> . For more examples, see <code>[KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)</code> in the <em>AWS Key Management Service API Reference</em> .
     * <p>
     * This property applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
        return null;
    }

    /**
     * `AWS::SNS::Topic.SignatureVersion`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSignatureVersion() {
        return null;
    }

    /**
     * The Amazon SNS subscriptions (endpoints) for this topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubscription() {
        return null;
    }

    /**
     * The list of tags to add to a new topic.
     * <p>
     * <blockquote>
     * <p>
     * To be able to tag a topic on creation, you must have the <code>sns:CreateTopic</code> and <code>sns:TagResource</code> permissions.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the topic you want to create.
     * <p>
     * Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with <code>.fifo</code> .
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the topic name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTopicName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTopicProps> {
        java.lang.Object contentBasedDeduplication;
        java.lang.Object dataProtectionPolicy;
        java.lang.String displayName;
        java.lang.Object fifoTopic;
        java.lang.String kmsMasterKeyId;
        java.lang.String signatureVersion;
        java.lang.Object subscription;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String topicName;

        /**
         * Sets the value of {@link CfnTopicProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication Enables content-based deduplication for FIFO topics.
         *                                  <ul>
         *                                  <li>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code> . If you create a FIFO topic and this attribute is <code>false</code> , you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action.</li>
         *                                  <li>When you set <code>ContentBasedDeduplication</code> to <code>true</code> , Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</li>
         *                                  </ul>
         *                                  <p>
         *                                  (Optional) To override the generated value, you can specify a value for the the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication Enables content-based deduplication for FIFO topics.
         *                                  <ul>
         *                                  <li>By default, <code>ContentBasedDeduplication</code> is set to <code>false</code> . If you create a FIFO topic and this attribute is <code>false</code> , you must specify a value for the <code>MessageDeduplicationId</code> parameter for the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Publish.html">Publish</a> action.</li>
         *                                  <li>When you set <code>ContentBasedDeduplication</code> to <code>true</code> , Amazon SNS uses a SHA-256 hash to generate the <code>MessageDeduplicationId</code> using the body of the message (but not the attributes of the message).</li>
         *                                  </ul>
         *                                  <p>
         *                                  (Optional) To override the generated value, you can specify a value for the the <code>MessageDeduplicationId</code> parameter for the <code>Publish</code> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(software.amazon.awscdk.IResolvable contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDataProtectionPolicy}
         * @param dataProtectionPolicy `AWS::SNS::Topic.DataProtectionPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionPolicy(java.lang.Object dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDisplayName}
         * @param displayName The display name to use for an Amazon SNS topic with SMS subscriptions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getFifoTopic}
         * @param fifoTopic Set to true to create a FIFO topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoTopic(java.lang.Boolean fifoTopic) {
            this.fifoTopic = fifoTopic;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getFifoTopic}
         * @param fifoTopic Set to true to create a FIFO topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoTopic(software.amazon.awscdk.IResolvable fifoTopic) {
            this.fifoTopic = fifoTopic;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getKmsMasterKeyId}
         * @param kmsMasterKeyId The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
         *                       For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key terms</a> . For more examples, see <code>[KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)</code> in the <em>AWS Key Management Service API Reference</em> .
         *                       <p>
         *                       This property applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getSignatureVersion}
         * @param signatureVersion `AWS::SNS::Topic.SignatureVersion`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signatureVersion(java.lang.String signatureVersion) {
            this.signatureVersion = signatureVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getSubscription}
         * @param subscription The Amazon SNS subscriptions (endpoints) for this topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscription(software.amazon.awscdk.IResolvable subscription) {
            this.subscription = subscription;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getSubscription}
         * @param subscription The Amazon SNS subscriptions (endpoints) for this topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscription(java.util.List<? extends java.lang.Object> subscription) {
            this.subscription = subscription;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getTags}
         * @param tags The list of tags to add to a new topic.
         *             <blockquote>
         *             <p>
         *             To be able to tag a topic on creation, you must have the <code>sns:CreateTopic</code> and <code>sns:TagResource</code> permissions.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getTopicName}
         * @param topicName The name of the topic you want to create.
         *                  Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with <code>.fifo</code> .
         *                  <p>
         *                  If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the topic name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicName(java.lang.String topicName) {
            this.topicName = topicName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTopicProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTopicProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTopicProps {
        private final java.lang.Object contentBasedDeduplication;
        private final java.lang.Object dataProtectionPolicy;
        private final java.lang.String displayName;
        private final java.lang.Object fifoTopic;
        private final java.lang.String kmsMasterKeyId;
        private final java.lang.String signatureVersion;
        private final java.lang.Object subscription;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String topicName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentBasedDeduplication = software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataProtectionPolicy = software.amazon.jsii.Kernel.get(this, "dataProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fifoTopic = software.amazon.jsii.Kernel.get(this, "fifoTopic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsMasterKeyId = software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signatureVersion = software.amazon.jsii.Kernel.get(this, "signatureVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscription = software.amazon.jsii.Kernel.get(this, "subscription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentBasedDeduplication = builder.contentBasedDeduplication;
            this.dataProtectionPolicy = builder.dataProtectionPolicy;
            this.displayName = builder.displayName;
            this.fifoTopic = builder.fifoTopic;
            this.kmsMasterKeyId = builder.kmsMasterKeyId;
            this.signatureVersion = builder.signatureVersion;
            this.subscription = builder.subscription;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.topicName = builder.topicName;
        }

        @Override
        public final java.lang.Object getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public final java.lang.Object getDataProtectionPolicy() {
            return this.dataProtectionPolicy;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.Object getFifoTopic() {
            return this.fifoTopic;
        }

        @Override
        public final java.lang.String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final java.lang.String getSignatureVersion() {
            return this.signatureVersion;
        }

        @Override
        public final java.lang.Object getSubscription() {
            return this.subscription;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTopicName() {
            return this.topicName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getDataProtectionPolicy() != null) {
                data.set("dataProtectionPolicy", om.valueToTree(this.getDataProtectionPolicy()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getFifoTopic() != null) {
                data.set("fifoTopic", om.valueToTree(this.getFifoTopic()));
            }
            if (this.getKmsMasterKeyId() != null) {
                data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
            }
            if (this.getSignatureVersion() != null) {
                data.set("signatureVersion", om.valueToTree(this.getSignatureVersion()));
            }
            if (this.getSubscription() != null) {
                data.set("subscription", om.valueToTree(this.getSubscription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTopicName() != null) {
                data.set("topicName", om.valueToTree(this.getTopicName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.CfnTopicProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTopicProps.Jsii$Proxy that = (CfnTopicProps.Jsii$Proxy) o;

            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            if (this.dataProtectionPolicy != null ? !this.dataProtectionPolicy.equals(that.dataProtectionPolicy) : that.dataProtectionPolicy != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.fifoTopic != null ? !this.fifoTopic.equals(that.fifoTopic) : that.fifoTopic != null) return false;
            if (this.kmsMasterKeyId != null ? !this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId != null) return false;
            if (this.signatureVersion != null ? !this.signatureVersion.equals(that.signatureVersion) : that.signatureVersion != null) return false;
            if (this.subscription != null ? !this.subscription.equals(that.subscription) : that.subscription != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.topicName != null ? this.topicName.equals(that.topicName) : that.topicName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0;
            result = 31 * result + (this.dataProtectionPolicy != null ? this.dataProtectionPolicy.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.fifoTopic != null ? this.fifoTopic.hashCode() : 0);
            result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
            result = 31 * result + (this.signatureVersion != null ? this.signatureVersion.hashCode() : 0);
            result = 31 * result + (this.subscription != null ? this.subscription.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.topicName != null ? this.topicName.hashCode() : 0);
            return result;
        }
    }
}
