package software.amazon.awscdk.services.sqs;

/**
 * Properties for defining a `CfnQueue`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sqs.*;
 * Object redriveAllowPolicy;
 * Object redrivePolicy;
 * CfnQueueProps cfnQueueProps = CfnQueueProps.builder()
 *         .contentBasedDeduplication(false)
 *         .deduplicationScope("deduplicationScope")
 *         .delaySeconds(123)
 *         .fifoQueue(false)
 *         .fifoThroughputLimit("fifoThroughputLimit")
 *         .kmsDataKeyReusePeriodSeconds(123)
 *         .kmsMasterKeyId("kmsMasterKeyId")
 *         .maximumMessageSize(123)
 *         .messageRetentionPeriod(123)
 *         .queueName("queueName")
 *         .receiveMessageWaitTimeSeconds(123)
 *         .redriveAllowPolicy(redriveAllowPolicy)
 *         .redrivePolicy(redrivePolicy)
 *         .sqsManagedSseEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .visibilityTimeout(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.305Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.CfnQueueProps")
@software.amazon.jsii.Jsii.Proxy(CfnQueueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnQueueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
     * <p>
     * During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message. For more information, see the <code>ContentBasedDeduplication</code> attribute for the <code>[CreateQueue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html)</code> action in the <em>Amazon SQS API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContentBasedDeduplication() {
        return null;
    }

    /**
     * For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level.
     * <p>
     * Valid values are <code>messageGroup</code> and <code>queue</code> .
     * <p>
     * To enable high throughput for a FIFO queue, set this attribute to <code>messageGroup</code> <em>and</em> set the <code>FifoThroughputLimit</code> attribute to <code>perMessageGroupId</code> . If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">High throughput for FIFO queues</a> and <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeduplicationScope() {
        return null;
    }

    /**
     * The time in seconds for which the delivery of all messages in the queue is delayed.
     * <p>
     * You can specify an integer value of <code>0</code> to <code>900</code> (15 minutes). The default value is <code>0</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDelaySeconds() {
        return null;
    }

    /**
     * If set to true, creates a FIFO queue.
     * <p>
     * If you don't specify this property, Amazon SQS creates a standard queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFifoQueue() {
        return null;
    }

    /**
     * For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group.
     * <p>
     * Valid values are <code>perQueue</code> and <code>perMessageGroupId</code> .
     * <p>
     * To enable high throughput for a FIFO queue, set this attribute to <code>perMessageGroupId</code> <em>and</em> set the <code>DeduplicationScope</code> attribute to <code>messageGroup</code> . If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">High throughput for FIFO queues</a> and <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFifoThroughputLimit() {
        return null;
    }

    /**
     * The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
     * <p>
     * The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
     * <p>
     * <blockquote>
     * <p>
     * A shorter time period provides better security, but results in more calls to AWS KMS , which might incur charges after Free Tier. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">Encryption at rest</a> in the <em>Amazon SQS Developer Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getKmsDataKeyReusePeriodSeconds() {
        return null;
    }

    /**
     * The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK.
     * <p>
     * To use the AWS managed CMK for Amazon SQS , specify the (default) alias <code>alias/aws/sqs</code> . For more information, see the following:
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">Encryption at rest</a> in the <em>Amazon SQS Developer Guide</em></li>
     * <li><a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a> in the <em>Amazon SQS API Reference</em></li>
     * <li>The Customer Master Keys section of the <a href="https://docs.aws.amazon.com/https://d0.awsstatic.com/whitepapers/aws-kms-best-practices.pdf">AWS Key Management Service Best Practices</a> whitepaper</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
        return null;
    }

    /**
     * The limit of how many bytes that a message can contain before Amazon SQS rejects it.
     * <p>
     * You can specify an integer value from <code>1,024</code> bytes (1 KiB) to <code>262,144</code> bytes (256 KiB). The default value is <code>262,144</code> (256 KiB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumMessageSize() {
        return null;
    }

    /**
     * The number of seconds that Amazon SQS retains a message.
     * <p>
     * You can specify an integer value from <code>60</code> seconds (1 minute) to <code>1,209,600</code> seconds (14 days). The default value is <code>345,600</code> seconds (4 days).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMessageRetentionPeriod() {
        return null;
    }

    /**
     * A name for the queue.
     * <p>
     * To create a FIFO queue, the name of your FIFO queue must end with the <code>.fifo</code> suffix. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the queue name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueueName() {
        return null;
    }

    /**
     * Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available.
     * <p>
     * You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-short-and-long-polling.html#sqs-long-polling">Consuming messages using long polling</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReceiveMessageWaitTimeSeconds() {
        return null;
    }

    /**
     * The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
     * <p>
     * The parameters are as follows:
     * <p>
     * <ul>
     * <li><code>redrivePermission</code> : The permission type that defines which source queues can specify the current queue as the dead-letter queue. Valid values are:</li>
     * <li><code>allowAll</code> : (Default) Any source queues in this AWS account in the same Region can specify this queue as the dead-letter queue.</li>
     * <li><code>denyAll</code> : No source queues can specify this queue as the dead-letter queue.</li>
     * <li><code>byQueue</code> : Only queues specified by the <code>sourceQueueArns</code> parameter can specify this queue as the dead-letter queue.</li>
     * <li><code>sourceQueueArns</code> : The Amazon Resource Names (ARN)s of the source queues that can specify this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the <code>redrivePermission</code> parameter is set to <code>byQueue</code> . You can specify up to 10 source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter to <code>allowAll</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedriveAllowPolicy() {
        return null;
    }

    /**
     * The string that includes the parameters for the dead-letter queue functionality of the source queue as a JSON object.
     * <p>
     * The parameters are as follows:
     * <p>
     * <ul>
     * <li><code>deadLetterTargetArn</code> : The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</li>
     * <li><code>maxReceiveCount</code> : The number of times a message is delivered to the source queue before being moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a standard queue must also be a standard queue.
     * <p>
     * </blockquote>
     * <p>
     * <em>JSON</em>
     * <p>
     * <code>{ "deadLetterTargetArn" : *String* , "maxReceiveCount" : *Integer* }</code>
     * <p>
     * <em>YAML</em>
     * <p>
     * <code>deadLetterTargetArn : *String*</code>
     * <p>
     * <code>maxReceiveCount : *Integer*</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedrivePolicy() {
        return null;
    }

    /**
     * `AWS::SQS::Queue.SqsManagedSseEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSqsManagedSseEnabled() {
        return null;
    }

    /**
     * The tags that you attach to this queue.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource tag</a> in the <em>AWS CloudFormation User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The length of time during which a message will be unavailable after a message is delivered from the queue.
     * <p>
     * This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue.
     * <p>
     * Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
     * <p>
     * For more information about Amazon SQS queue visibility timeouts, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility timeout</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVisibilityTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnQueueProps> {
        java.lang.Object contentBasedDeduplication;
        java.lang.String deduplicationScope;
        java.lang.Number delaySeconds;
        java.lang.Object fifoQueue;
        java.lang.String fifoThroughputLimit;
        java.lang.Number kmsDataKeyReusePeriodSeconds;
        java.lang.String kmsMasterKeyId;
        java.lang.Number maximumMessageSize;
        java.lang.Number messageRetentionPeriod;
        java.lang.String queueName;
        java.lang.Number receiveMessageWaitTimeSeconds;
        java.lang.Object redriveAllowPolicy;
        java.lang.Object redrivePolicy;
        java.lang.Object sqsManagedSseEnabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number visibilityTimeout;

        /**
         * Sets the value of {@link CfnQueueProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
         *                                  During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message. For more information, see the <code>ContentBasedDeduplication</code> attribute for the <code>[CreateQueue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html)</code> action in the <em>Amazon SQS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication.
         *                                  During the deduplication interval, Amazon SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message. For more information, see the <code>ContentBasedDeduplication</code> attribute for the <code>[CreateQueue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html)</code> action in the <em>Amazon SQS API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(software.amazon.awscdk.IResolvable contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getDeduplicationScope}
         * @param deduplicationScope For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level.
         *                           Valid values are <code>messageGroup</code> and <code>queue</code> .
         *                           <p>
         *                           To enable high throughput for a FIFO queue, set this attribute to <code>messageGroup</code> <em>and</em> set the <code>FifoThroughputLimit</code> attribute to <code>perMessageGroupId</code> . If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">High throughput for FIFO queues</a> and <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deduplicationScope(java.lang.String deduplicationScope) {
            this.deduplicationScope = deduplicationScope;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getDelaySeconds}
         * @param delaySeconds The time in seconds for which the delivery of all messages in the queue is delayed.
         *                     You can specify an integer value of <code>0</code> to <code>900</code> (15 minutes). The default value is <code>0</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder delaySeconds(java.lang.Number delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getFifoQueue}
         * @param fifoQueue If set to true, creates a FIFO queue.
         *                  If you don't specify this property, Amazon SQS creates a standard queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(java.lang.Boolean fifoQueue) {
            this.fifoQueue = fifoQueue;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getFifoQueue}
         * @param fifoQueue If set to true, creates a FIFO queue.
         *                  If you don't specify this property, Amazon SQS creates a standard queue. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoQueue(software.amazon.awscdk.IResolvable fifoQueue) {
            this.fifoQueue = fifoQueue;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getFifoThroughputLimit}
         * @param fifoThroughputLimit For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group.
         *                            Valid values are <code>perQueue</code> and <code>perMessageGroupId</code> .
         *                            <p>
         *                            To enable high throughput for a FIFO queue, set this attribute to <code>perMessageGroupId</code> <em>and</em> set the <code>DeduplicationScope</code> attribute to <code>messageGroup</code> . If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html">High throughput for FIFO queues</a> and <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html">Quotas related to messages</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoThroughputLimit(java.lang.String fifoThroughputLimit) {
            this.fifoThroughputLimit = fifoThroughputLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getKmsDataKeyReusePeriodSeconds}
         * @param kmsDataKeyReusePeriodSeconds The length of time in seconds for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.
         *                                     The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
         *                                     <p>
         *                                     <blockquote>
         *                                     <p>
         *                                     A shorter time period provides better security, but results in more calls to AWS KMS , which might incur charges after Free Tier. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work">Encryption at rest</a> in the <em>Amazon SQS Developer Guide</em> .
         *                                     <p>
         *                                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsDataKeyReusePeriodSeconds(java.lang.Number kmsDataKeyReusePeriodSeconds) {
            this.kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getKmsMasterKeyId}
         * @param kmsMasterKeyId The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK.
         *                       To use the AWS managed CMK for Amazon SQS , specify the (default) alias <code>alias/aws/sqs</code> . For more information, see the following:
         *                       <p>
         *                       <ul>
         *                       <li><a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html">Encryption at rest</a> in the <em>Amazon SQS Developer Guide</em></li>
         *                       <li><a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a> in the <em>Amazon SQS API Reference</em></li>
         *                       <li>The Customer Master Keys section of the <a href="https://docs.aws.amazon.com/https://d0.awsstatic.com/whitepapers/aws-kms-best-practices.pdf">AWS Key Management Service Best Practices</a> whitepaper</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getMaximumMessageSize}
         * @param maximumMessageSize The limit of how many bytes that a message can contain before Amazon SQS rejects it.
         *                           You can specify an integer value from <code>1,024</code> bytes (1 KiB) to <code>262,144</code> bytes (256 KiB). The default value is <code>262,144</code> (256 KiB).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumMessageSize(java.lang.Number maximumMessageSize) {
            this.maximumMessageSize = maximumMessageSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getMessageRetentionPeriod}
         * @param messageRetentionPeriod The number of seconds that Amazon SQS retains a message.
         *                               You can specify an integer value from <code>60</code> seconds (1 minute) to <code>1,209,600</code> seconds (14 days). The default value is <code>345,600</code> seconds (4 days).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageRetentionPeriod(java.lang.Number messageRetentionPeriod) {
            this.messageRetentionPeriod = messageRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getQueueName}
         * @param queueName A name for the queue.
         *                  To create a FIFO queue, the name of your FIFO queue must end with the <code>.fifo</code> suffix. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html">FIFO queues</a> in the <em>Amazon SQS Developer Guide</em> .
         *                  <p>
         *                  If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the queue name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> in the <em>AWS CloudFormation User Guide</em> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queueName(java.lang.String queueName) {
            this.queueName = queueName;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getReceiveMessageWaitTimeSeconds}
         * @param receiveMessageWaitTimeSeconds Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available.
         *                                      You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property. For more information, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-short-and-long-polling.html#sqs-long-polling">Consuming messages using long polling</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiveMessageWaitTimeSeconds(java.lang.Number receiveMessageWaitTimeSeconds) {
            this.receiveMessageWaitTimeSeconds = receiveMessageWaitTimeSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getRedriveAllowPolicy}
         * @param redriveAllowPolicy The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object.
         *                           The parameters are as follows:
         *                           <p>
         *                           <ul>
         *                           <li><code>redrivePermission</code> : The permission type that defines which source queues can specify the current queue as the dead-letter queue. Valid values are:</li>
         *                           <li><code>allowAll</code> : (Default) Any source queues in this AWS account in the same Region can specify this queue as the dead-letter queue.</li>
         *                           <li><code>denyAll</code> : No source queues can specify this queue as the dead-letter queue.</li>
         *                           <li><code>byQueue</code> : Only queues specified by the <code>sourceQueueArns</code> parameter can specify this queue as the dead-letter queue.</li>
         *                           <li><code>sourceQueueArns</code> : The Amazon Resource Names (ARN)s of the source queues that can specify this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the <code>redrivePermission</code> parameter is set to <code>byQueue</code> . You can specify up to 10 source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> parameter to <code>allowAll</code> .</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redriveAllowPolicy(java.lang.Object redriveAllowPolicy) {
            this.redriveAllowPolicy = redriveAllowPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getRedrivePolicy}
         * @param redrivePolicy The string that includes the parameters for the dead-letter queue functionality of the source queue as a JSON object.
         *                      The parameters are as follows:
         *                      <p>
         *                      <ul>
         *                      <li><code>deadLetterTargetArn</code> : The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded.</li>
         *                      <li><code>maxReceiveCount</code> : The number of times a message is delivered to the source queue before being moved to the dead-letter queue. When the <code>ReceiveCount</code> for a message exceeds the <code>maxReceiveCount</code> for a queue, Amazon SQS moves the message to the dead-letter-queue.</li>
         *                      </ul>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a standard queue must also be a standard queue.
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      <em>JSON</em>
         *                      <p>
         *                      <code>{ "deadLetterTargetArn" : *String* , "maxReceiveCount" : *Integer* }</code>
         *                      <p>
         *                      <em>YAML</em>
         *                      <p>
         *                      <code>deadLetterTargetArn : *String*</code>
         *                      <p>
         *                      <code>maxReceiveCount : *Integer*</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePolicy(java.lang.Object redrivePolicy) {
            this.redrivePolicy = redrivePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getSqsManagedSseEnabled}
         * @param sqsManagedSseEnabled `AWS::SQS::Queue.SqsManagedSseEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqsManagedSseEnabled(java.lang.Boolean sqsManagedSseEnabled) {
            this.sqsManagedSseEnabled = sqsManagedSseEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getSqsManagedSseEnabled}
         * @param sqsManagedSseEnabled `AWS::SQS::Queue.SqsManagedSseEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sqsManagedSseEnabled(software.amazon.awscdk.IResolvable sqsManagedSseEnabled) {
            this.sqsManagedSseEnabled = sqsManagedSseEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getTags}
         * @param tags The tags that you attach to this queue.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource tag</a> in the <em>AWS CloudFormation User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueueProps#getVisibilityTimeout}
         * @param visibilityTimeout The length of time during which a message will be unavailable after a message is delivered from the queue.
         *                          This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue.
         *                          <p>
         *                          Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
         *                          <p>
         *                          For more information about Amazon SQS queue visibility timeouts, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html">Visibility timeout</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(java.lang.Number visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnQueueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnQueueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnQueueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnQueueProps {
        private final java.lang.Object contentBasedDeduplication;
        private final java.lang.String deduplicationScope;
        private final java.lang.Number delaySeconds;
        private final java.lang.Object fifoQueue;
        private final java.lang.String fifoThroughputLimit;
        private final java.lang.Number kmsDataKeyReusePeriodSeconds;
        private final java.lang.String kmsMasterKeyId;
        private final java.lang.Number maximumMessageSize;
        private final java.lang.Number messageRetentionPeriod;
        private final java.lang.String queueName;
        private final java.lang.Number receiveMessageWaitTimeSeconds;
        private final java.lang.Object redriveAllowPolicy;
        private final java.lang.Object redrivePolicy;
        private final java.lang.Object sqsManagedSseEnabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number visibilityTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentBasedDeduplication = software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deduplicationScope = software.amazon.jsii.Kernel.get(this, "deduplicationScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.delaySeconds = software.amazon.jsii.Kernel.get(this, "delaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.fifoQueue = software.amazon.jsii.Kernel.get(this, "fifoQueue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fifoThroughputLimit = software.amazon.jsii.Kernel.get(this, "fifoThroughputLimit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsDataKeyReusePeriodSeconds = software.amazon.jsii.Kernel.get(this, "kmsDataKeyReusePeriodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsMasterKeyId = software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maximumMessageSize = software.amazon.jsii.Kernel.get(this, "maximumMessageSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.messageRetentionPeriod = software.amazon.jsii.Kernel.get(this, "messageRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.queueName = software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.receiveMessageWaitTimeSeconds = software.amazon.jsii.Kernel.get(this, "receiveMessageWaitTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.redriveAllowPolicy = software.amazon.jsii.Kernel.get(this, "redriveAllowPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redrivePolicy = software.amazon.jsii.Kernel.get(this, "redrivePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sqsManagedSseEnabled = software.amazon.jsii.Kernel.get(this, "sqsManagedSseEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.visibilityTimeout = software.amazon.jsii.Kernel.get(this, "visibilityTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentBasedDeduplication = builder.contentBasedDeduplication;
            this.deduplicationScope = builder.deduplicationScope;
            this.delaySeconds = builder.delaySeconds;
            this.fifoQueue = builder.fifoQueue;
            this.fifoThroughputLimit = builder.fifoThroughputLimit;
            this.kmsDataKeyReusePeriodSeconds = builder.kmsDataKeyReusePeriodSeconds;
            this.kmsMasterKeyId = builder.kmsMasterKeyId;
            this.maximumMessageSize = builder.maximumMessageSize;
            this.messageRetentionPeriod = builder.messageRetentionPeriod;
            this.queueName = builder.queueName;
            this.receiveMessageWaitTimeSeconds = builder.receiveMessageWaitTimeSeconds;
            this.redriveAllowPolicy = builder.redriveAllowPolicy;
            this.redrivePolicy = builder.redrivePolicy;
            this.sqsManagedSseEnabled = builder.sqsManagedSseEnabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.visibilityTimeout = builder.visibilityTimeout;
        }

        @Override
        public final java.lang.Object getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public final java.lang.String getDeduplicationScope() {
            return this.deduplicationScope;
        }

        @Override
        public final java.lang.Number getDelaySeconds() {
            return this.delaySeconds;
        }

        @Override
        public final java.lang.Object getFifoQueue() {
            return this.fifoQueue;
        }

        @Override
        public final java.lang.String getFifoThroughputLimit() {
            return this.fifoThroughputLimit;
        }

        @Override
        public final java.lang.Number getKmsDataKeyReusePeriodSeconds() {
            return this.kmsDataKeyReusePeriodSeconds;
        }

        @Override
        public final java.lang.String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final java.lang.Number getMaximumMessageSize() {
            return this.maximumMessageSize;
        }

        @Override
        public final java.lang.Number getMessageRetentionPeriod() {
            return this.messageRetentionPeriod;
        }

        @Override
        public final java.lang.String getQueueName() {
            return this.queueName;
        }

        @Override
        public final java.lang.Number getReceiveMessageWaitTimeSeconds() {
            return this.receiveMessageWaitTimeSeconds;
        }

        @Override
        public final java.lang.Object getRedriveAllowPolicy() {
            return this.redriveAllowPolicy;
        }

        @Override
        public final java.lang.Object getRedrivePolicy() {
            return this.redrivePolicy;
        }

        @Override
        public final java.lang.Object getSqsManagedSseEnabled() {
            return this.sqsManagedSseEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getDeduplicationScope() != null) {
                data.set("deduplicationScope", om.valueToTree(this.getDeduplicationScope()));
            }
            if (this.getDelaySeconds() != null) {
                data.set("delaySeconds", om.valueToTree(this.getDelaySeconds()));
            }
            if (this.getFifoQueue() != null) {
                data.set("fifoQueue", om.valueToTree(this.getFifoQueue()));
            }
            if (this.getFifoThroughputLimit() != null) {
                data.set("fifoThroughputLimit", om.valueToTree(this.getFifoThroughputLimit()));
            }
            if (this.getKmsDataKeyReusePeriodSeconds() != null) {
                data.set("kmsDataKeyReusePeriodSeconds", om.valueToTree(this.getKmsDataKeyReusePeriodSeconds()));
            }
            if (this.getKmsMasterKeyId() != null) {
                data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
            }
            if (this.getMaximumMessageSize() != null) {
                data.set("maximumMessageSize", om.valueToTree(this.getMaximumMessageSize()));
            }
            if (this.getMessageRetentionPeriod() != null) {
                data.set("messageRetentionPeriod", om.valueToTree(this.getMessageRetentionPeriod()));
            }
            if (this.getQueueName() != null) {
                data.set("queueName", om.valueToTree(this.getQueueName()));
            }
            if (this.getReceiveMessageWaitTimeSeconds() != null) {
                data.set("receiveMessageWaitTimeSeconds", om.valueToTree(this.getReceiveMessageWaitTimeSeconds()));
            }
            if (this.getRedriveAllowPolicy() != null) {
                data.set("redriveAllowPolicy", om.valueToTree(this.getRedriveAllowPolicy()));
            }
            if (this.getRedrivePolicy() != null) {
                data.set("redrivePolicy", om.valueToTree(this.getRedrivePolicy()));
            }
            if (this.getSqsManagedSseEnabled() != null) {
                data.set("sqsManagedSseEnabled", om.valueToTree(this.getSqsManagedSseEnabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVisibilityTimeout() != null) {
                data.set("visibilityTimeout", om.valueToTree(this.getVisibilityTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sqs.CfnQueueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnQueueProps.Jsii$Proxy that = (CfnQueueProps.Jsii$Proxy) o;

            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            if (this.deduplicationScope != null ? !this.deduplicationScope.equals(that.deduplicationScope) : that.deduplicationScope != null) return false;
            if (this.delaySeconds != null ? !this.delaySeconds.equals(that.delaySeconds) : that.delaySeconds != null) return false;
            if (this.fifoQueue != null ? !this.fifoQueue.equals(that.fifoQueue) : that.fifoQueue != null) return false;
            if (this.fifoThroughputLimit != null ? !this.fifoThroughputLimit.equals(that.fifoThroughputLimit) : that.fifoThroughputLimit != null) return false;
            if (this.kmsDataKeyReusePeriodSeconds != null ? !this.kmsDataKeyReusePeriodSeconds.equals(that.kmsDataKeyReusePeriodSeconds) : that.kmsDataKeyReusePeriodSeconds != null) return false;
            if (this.kmsMasterKeyId != null ? !this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId != null) return false;
            if (this.maximumMessageSize != null ? !this.maximumMessageSize.equals(that.maximumMessageSize) : that.maximumMessageSize != null) return false;
            if (this.messageRetentionPeriod != null ? !this.messageRetentionPeriod.equals(that.messageRetentionPeriod) : that.messageRetentionPeriod != null) return false;
            if (this.queueName != null ? !this.queueName.equals(that.queueName) : that.queueName != null) return false;
            if (this.receiveMessageWaitTimeSeconds != null ? !this.receiveMessageWaitTimeSeconds.equals(that.receiveMessageWaitTimeSeconds) : that.receiveMessageWaitTimeSeconds != null) return false;
            if (this.redriveAllowPolicy != null ? !this.redriveAllowPolicy.equals(that.redriveAllowPolicy) : that.redriveAllowPolicy != null) return false;
            if (this.redrivePolicy != null ? !this.redrivePolicy.equals(that.redrivePolicy) : that.redrivePolicy != null) return false;
            if (this.sqsManagedSseEnabled != null ? !this.sqsManagedSseEnabled.equals(that.sqsManagedSseEnabled) : that.sqsManagedSseEnabled != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.visibilityTimeout != null ? this.visibilityTimeout.equals(that.visibilityTimeout) : that.visibilityTimeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0;
            result = 31 * result + (this.deduplicationScope != null ? this.deduplicationScope.hashCode() : 0);
            result = 31 * result + (this.delaySeconds != null ? this.delaySeconds.hashCode() : 0);
            result = 31 * result + (this.fifoQueue != null ? this.fifoQueue.hashCode() : 0);
            result = 31 * result + (this.fifoThroughputLimit != null ? this.fifoThroughputLimit.hashCode() : 0);
            result = 31 * result + (this.kmsDataKeyReusePeriodSeconds != null ? this.kmsDataKeyReusePeriodSeconds.hashCode() : 0);
            result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
            result = 31 * result + (this.maximumMessageSize != null ? this.maximumMessageSize.hashCode() : 0);
            result = 31 * result + (this.messageRetentionPeriod != null ? this.messageRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.queueName != null ? this.queueName.hashCode() : 0);
            result = 31 * result + (this.receiveMessageWaitTimeSeconds != null ? this.receiveMessageWaitTimeSeconds.hashCode() : 0);
            result = 31 * result + (this.redriveAllowPolicy != null ? this.redriveAllowPolicy.hashCode() : 0);
            result = 31 * result + (this.redrivePolicy != null ? this.redrivePolicy.hashCode() : 0);
            result = 31 * result + (this.sqsManagedSseEnabled != null ? this.sqsManagedSseEnabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.visibilityTimeout != null ? this.visibilityTimeout.hashCode() : 0);
            return result;
        }
    }
}
