package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for DynamoDeleteItem Task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table myTable;
 * DynamoDeleteItem.Builder.create(this, "DeleteItem")
 *         .key(Map.of("MessageId", DynamoAttributeValue.fromString("message-007")))
 *         .table(myTable)
 *         .resultPath(JsonPath.DISCARD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.493Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.DynamoDeleteItemProps")
@software.amazon.jsii.Jsii.Proxy(DynamoDeleteItemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DynamoDeleteItemProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * Primary key of the item to retrieve.
     * <p>
     * For the primary key, you must provide all of the attributes.
     * For example, with a simple primary key, you only need to provide a value for the partition key.
     * For a composite primary key, you must provide values for both the partition key and the sort key.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getKey();

    /**
     * The name of the table containing the requested item.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable getTable();

    /**
     * A condition that must be satisfied in order for a conditional DeleteItem to succeed.
     * <p>
     * Default: - No condition expression
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ConditionExpression">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ConditionExpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConditionExpression() {
        return null;
    }

    /**
     * One or more substitution tokens for attribute names in an expression.
     * <p>
     * Default: - No expression attribute names
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeNames">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeNames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
        return null;
    }

    /**
     * One or more values that can be substituted in an expression.
     * <p>
     * Default: - No expression attribute values
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeValues">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ExpressionAttributeValues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getExpressionAttributeValues() {
        return null;
    }

    /**
     * Determines the level of detail about provisioned throughput consumption that is returned in the response.
     * <p>
     * Default: DynamoConsumedCapacity.NONE
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnConsumedCapacity">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnConsumedCapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
        return null;
    }

    /**
     * Determines whether item collection metrics are returned.
     * <p>
     * If set to SIZE, the response includes statistics about item collections, if any,
     * that were modified during the operation are returned in the response.
     * If set to NONE (the default), no statistics are returned.
     * <p>
     * Default: DynamoItemCollectionMetrics.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
        return null;
    }

    /**
     * Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
     * <p>
     * Default: DynamoReturnValues.NONE
     * <p>
     * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnValues">https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DeleteItem.html#DDB-DeleteItem-request-ReturnValues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DynamoDeleteItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DynamoDeleteItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DynamoDeleteItemProps> {
        java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> key;
        software.amazon.awscdk.services.dynamodb.ITable table;
        java.lang.String conditionExpression;
        java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> expressionAttributeValues;
        software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;
        java.lang.String comment;
        software.amazon.awscdk.Duration heartbeat;
        java.lang.String inputPath;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        java.lang.String outputPath;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getKey}
         * @param key Primary key of the item to retrieve. This parameter is required.
         *            For the primary key, you must provide all of the attributes.
         *            For example, with a simple primary key, you only need to provide a value for the partition key.
         *            For a composite primary key, you must provide values for both the partition key and the sort key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder key(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> key) {
            this.key = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)key;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getTable}
         * @param table The name of the table containing the requested item. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(software.amazon.awscdk.services.dynamodb.ITable table) {
            this.table = table;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getConditionExpression}
         * @param conditionExpression A condition that must be satisfied in order for a conditional DeleteItem to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditionExpression(java.lang.String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getExpressionAttributeNames}
         * @param expressionAttributeNames One or more substitution tokens for attribute names in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expressionAttributeNames(java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames) {
            this.expressionAttributeNames = expressionAttributeNames;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getExpressionAttributeValues}
         * @param expressionAttributeValues One or more values that can be substituted in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder expressionAttributeValues(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)expressionAttributeValues;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getReturnConsumedCapacity}
         * @param returnConsumedCapacity Determines the level of detail about provisioned throughput consumption that is returned in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnConsumedCapacity(software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getReturnItemCollectionMetrics}
         * @param returnItemCollectionMetrics Determines whether item collection metrics are returned.
         *                                    If set to SIZE, the response includes statistics about item collections, if any,
         *                                    that were modified during the operation are returned in the response.
         *                                    If set to NONE (the default), no statistics are returned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnItemCollectionMetrics(software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getReturnValues}
         * @param returnValues Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnValues(software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link DynamoDeleteItemProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DynamoDeleteItemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DynamoDeleteItemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DynamoDeleteItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDeleteItemProps {
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> key;
        private final software.amazon.awscdk.services.dynamodb.ITable table;
        private final java.lang.String conditionExpression;
        private final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> expressionAttributeValues;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;
        private final java.lang.String comment;
        private final software.amazon.awscdk.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue.class)));
            this.table = software.amazon.jsii.Kernel.get(this, "table", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class));
            this.conditionExpression = software.amazon.jsii.Kernel.get(this, "conditionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expressionAttributeNames = software.amazon.jsii.Kernel.get(this, "expressionAttributeNames", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expressionAttributeValues = software.amazon.jsii.Kernel.get(this, "expressionAttributeValues", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue.class)));
            this.returnConsumedCapacity = software.amazon.jsii.Kernel.get(this, "returnConsumedCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity.class));
            this.returnItemCollectionMetrics = software.amazon.jsii.Kernel.get(this, "returnItemCollectionMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics.class));
            this.returnValues = software.amazon.jsii.Kernel.get(this, "returnValues", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)java.util.Objects.requireNonNull(builder.key, "key is required");
            this.table = java.util.Objects.requireNonNull(builder.table, "table is required");
            this.conditionExpression = builder.conditionExpression;
            this.expressionAttributeNames = builder.expressionAttributeNames;
            this.expressionAttributeValues = (java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue>)builder.expressionAttributeValues;
            this.returnConsumedCapacity = builder.returnConsumedCapacity;
            this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
            this.returnValues = builder.returnValues;
            this.comment = builder.comment;
            this.heartbeat = builder.heartbeat;
            this.inputPath = builder.inputPath;
            this.integrationPattern = builder.integrationPattern;
            this.outputPath = builder.outputPath;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.timeout = builder.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getKey() {
            return this.key;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ITable getTable() {
            return this.table;
        }

        @Override
        public final java.lang.String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue> getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
            return this.returnValues;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("table", om.valueToTree(this.getTable()));
            if (this.getConditionExpression() != null) {
                data.set("conditionExpression", om.valueToTree(this.getConditionExpression()));
            }
            if (this.getExpressionAttributeNames() != null) {
                data.set("expressionAttributeNames", om.valueToTree(this.getExpressionAttributeNames()));
            }
            if (this.getExpressionAttributeValues() != null) {
                data.set("expressionAttributeValues", om.valueToTree(this.getExpressionAttributeValues()));
            }
            if (this.getReturnConsumedCapacity() != null) {
                data.set("returnConsumedCapacity", om.valueToTree(this.getReturnConsumedCapacity()));
            }
            if (this.getReturnItemCollectionMetrics() != null) {
                data.set("returnItemCollectionMetrics", om.valueToTree(this.getReturnItemCollectionMetrics()));
            }
            if (this.getReturnValues() != null) {
                data.set("returnValues", om.valueToTree(this.getReturnValues()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.DynamoDeleteItemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DynamoDeleteItemProps.Jsii$Proxy that = (DynamoDeleteItemProps.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!table.equals(that.table)) return false;
            if (this.conditionExpression != null ? !this.conditionExpression.equals(that.conditionExpression) : that.conditionExpression != null) return false;
            if (this.expressionAttributeNames != null ? !this.expressionAttributeNames.equals(that.expressionAttributeNames) : that.expressionAttributeNames != null) return false;
            if (this.expressionAttributeValues != null ? !this.expressionAttributeValues.equals(that.expressionAttributeValues) : that.expressionAttributeValues != null) return false;
            if (this.returnConsumedCapacity != null ? !this.returnConsumedCapacity.equals(that.returnConsumedCapacity) : that.returnConsumedCapacity != null) return false;
            if (this.returnItemCollectionMetrics != null ? !this.returnItemCollectionMetrics.equals(that.returnItemCollectionMetrics) : that.returnItemCollectionMetrics != null) return false;
            if (this.returnValues != null ? !this.returnValues.equals(that.returnValues) : that.returnValues != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.table.hashCode());
            result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeNames != null ? this.expressionAttributeNames.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeValues != null ? this.expressionAttributeValues.hashCode() : 0);
            result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
            result = 31 * result + (this.returnItemCollectionMetrics != null ? this.returnItemCollectionMetrics.hashCode() : 0);
            result = 31 * result + (this.returnValues != null ? this.returnValues.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
