package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Configuration for a shuffle option for input data in a channel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * ShuffleConfig shuffleConfig = ShuffleConfig.builder()
 *         .seed(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.579Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ShuffleConfig")
@software.amazon.jsii.Jsii.Proxy(ShuffleConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ShuffleConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Determines the shuffling order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSeed();

    /**
     * @return a {@link Builder} of {@link ShuffleConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ShuffleConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ShuffleConfig> {
        java.lang.Number seed;

        /**
         * Sets the value of {@link ShuffleConfig#getSeed}
         * @param seed Determines the shuffling order. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder seed(java.lang.Number seed) {
            this.seed = seed;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ShuffleConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ShuffleConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ShuffleConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShuffleConfig {
        private final java.lang.Number seed;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.seed = software.amazon.jsii.Kernel.get(this, "seed", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.seed = java.util.Objects.requireNonNull(builder.seed, "seed is required");
        }

        @Override
        public final java.lang.Number getSeed() {
            return this.seed;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("seed", om.valueToTree(this.getSeed()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.ShuffleConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ShuffleConfig.Jsii$Proxy that = (ShuffleConfig.Jsii$Proxy) o;

            return this.seed.equals(that.seed);
        }

        @Override
        public final int hashCode() {
            int result = this.seed.hashCode();
            return result;
        }
    }
}
