package software.amazon.awscdk.services.wafv2;

/**
 * A CloudFormation `AWS::WAFv2::RuleGroup`.
 * <p>
 * <blockquote>
 * <p>
 * This is the latest version of <em>AWS WAF</em> , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
 * <p>
 * </blockquote>
 * <p>
 * Use an <code>RuleGroup</code> to define a collection of rules for inspecting and controlling web requests. You use a rule group in an <code>WebACL</code> by providing its Amazon Resource Name (ARN) to the rule statement <code>RuleGroupReferenceStatement</code> , when you add rules to the web ACL.
 * <p>
 * When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * Object all;
 * Object allow;
 * Object allQueryArguments;
 * Object block;
 * Object captcha;
 * Object count;
 * Object method;
 * Object queryString;
 * Object singleHeader;
 * Object singleQueryArgument;
 * StatementProperty statementProperty_;
 * Object uriPath;
 * CfnRuleGroup cfnRuleGroup = CfnRuleGroup.Builder.create(this, "MyCfnRuleGroup")
 *         .capacity(123)
 *         .scope("scope")
 *         .visibilityConfig(VisibilityConfigProperty.builder()
 *                 .cloudWatchMetricsEnabled(false)
 *                 .metricName("metricName")
 *                 .sampledRequestsEnabled(false)
 *                 .build())
 *         // the properties below are optional
 *         .customResponseBodies(Map.of(
 *                 "customResponseBodiesKey", CustomResponseBodyProperty.builder()
 *                         .content("content")
 *                         .contentType("contentType")
 *                         .build()))
 *         .description("description")
 *         .name("name")
 *         .rules(List.of(RuleProperty.builder()
 *                 .name("name")
 *                 .priority(123)
 *                 .statement(StatementProperty.builder()
 *                         .andStatement(AndStatementProperty.builder()
 *                                 .statements(List.of(statementProperty_))
 *                                 .build())
 *                         .byteMatchStatement(ByteMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .positionalConstraint("positionalConstraint")
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .searchString("searchString")
 *                                 .searchStringBase64("searchStringBase64")
 *                                 .build())
 *                         .geoMatchStatement(GeoMatchStatementProperty.builder()
 *                                 .countryCodes(List.of("countryCodes"))
 *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
 *                                         .fallbackBehavior("fallbackBehavior")
 *                                         .headerName("headerName")
 *                                         .build())
 *                                 .build())
 *                         .ipSetReferenceStatement(Map.of(
 *                                 "arn", "arn",
 *                                 // the properties below are optional
 *                                 "ipSetForwardedIpConfig", Map.of(
 *                                         "fallbackBehavior", "fallbackBehavior",
 *                                         "headerName", "headerName",
 *                                         "position", "position")))
 *                         .labelMatchStatement(LabelMatchStatementProperty.builder()
 *                                 .key("key")
 *                                 .scope("scope")
 *                                 .build())
 *                         .notStatement(NotStatementProperty.builder()
 *                                 .statement(statementProperty_)
 *                                 .build())
 *                         .orStatement(OrStatementProperty.builder()
 *                                 .statements(List.of(statementProperty_))
 *                                 .build())
 *                         .rateBasedStatement(RateBasedStatementProperty.builder()
 *                                 .aggregateKeyType("aggregateKeyType")
 *                                 .limit(123)
 *                                 // the properties below are optional
 *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
 *                                         .fallbackBehavior("fallbackBehavior")
 *                                         .headerName("headerName")
 *                                         .build())
 *                                 .scopeDownStatement(statementProperty_)
 *                                 .build())
 *                         .regexMatchStatement(RegexMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .regexString("regexString")
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
 *                                 .arn("arn")
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
 *                                 .comparisonOperator("comparisonOperator")
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .size(123)
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .sqliMatchStatement(SqliMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .sensitivityLevel("sensitivityLevel")
 *                                 .build())
 *                         .xssMatchStatement(XssMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .visibilityConfig(VisibilityConfigProperty.builder()
 *                         .cloudWatchMetricsEnabled(false)
 *                         .metricName("metricName")
 *                         .sampledRequestsEnabled(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .action(RuleActionProperty.builder()
 *                         .allow(allow)
 *                         .block(block)
 *                         .captcha(captcha)
 *                         .count(count)
 *                         .build())
 *                 .captchaConfig(CaptchaConfigProperty.builder()
 *                         .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
 *                                 .immunityTime(123)
 *                                 .build())
 *                         .build())
 *                 .ruleLabels(List.of(LabelProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.717Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup")
public class CfnRuleGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRuleGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRuleGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wafv2.CfnRuleGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::WAFv2::RuleGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRuleGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wafv2.CfnRuleGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Labels that rules in this rule group add to matching requests.
     * <p>
     * These labels are defined in the <code>RuleLabels</code> for a <code>Rule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAvailableLabels() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailableLabels", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Labels that rules in this rule group match against.
     * <p>
     * Each of these labels is defined in a <code>LabelMatchStatement</code> specification, in the rule statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrConsumedLabels() {
        return software.amazon.jsii.Kernel.get(this, "attrConsumedLabels", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The ID of the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The label namespace prefix for this rule group.
     * <p>
     * All labels added by rules in this rule group have this prefix.
     * <p>
     * The syntax for the label namespace prefix for a rule group is the following: <code>awswaf:&lt;account ID&gt;:rule group:&lt;rule group name&gt;:</code>
     * <p>
     * When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLabelNamespace() {
        return software.amazon.jsii.Kernel.get(this, "attrLabelNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     * <p>
     * <blockquote>
     * <p>
     * To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The web ACL capacity units (WCUs) required for this rule group.
     * <p>
     * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getCapacity() {
        return software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The web ACL capacity units (WCUs) required for this rule group.
     * <p>
     * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacity(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "capacity", java.util.Objects.requireNonNull(value, "capacity is required"));
    }

    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
     * <p>
     * A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AWS AppSync GraphQL API. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
     * <p>
     * <blockquote>
     * <p>
     * For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScope() {
        return software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
     * <p>
     * A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AWS AppSync GraphQL API. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
     * <p>
     * <blockquote>
     * <p>
     * For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScope(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scope", java.util.Objects.requireNonNull(value, "scope is required"));
    }

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getVisibilityConfig() {
        return software.amazon.jsii.Kernel.get(this, "visibilityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibilityConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wafv2.CfnRuleGroup.VisibilityConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "visibilityConfig", java.util.Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibilityConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "visibilityConfig", java.util.Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    /**
     * A map of custom response keys and content bodies.
     * <p>
     * When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomResponseBodies() {
        return software.amazon.jsii.Kernel.get(this, "customResponseBodies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map of custom response keys and content bodies.
     * <p>
     * When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomResponseBodies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customResponseBodies", value);
    }

    /**
     * A map of custom response keys and content bodies.
     * <p>
     * When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomResponseBodies(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.wafv2.CfnRuleGroup.CustomResponseBodyProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.wafv2.CfnRuleGroup.CustomResponseBodyProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "customResponseBodies", value);
    }

    /**
     * A description of the rule group that helps with identification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the rule group that helps with identification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the rule group.
     * <p>
     * You cannot change the name of a rule group after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule group.
     * <p>
     * You cannot change the name of a rule group after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The rule statements used to identify the web requests that you want to allow, block, or count.
     * <p>
     * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
        return software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The rule statements used to identify the web requests that you want to allow, block, or count.
     * <p>
     * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rules", value);
    }

    /**
     * The rule statements used to identify the web requests that you want to allow, block, or count.
     * <p>
     * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.wafv2.CfnRuleGroup.RuleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.wafv2.CfnRuleGroup.RuleProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "rules", value);
    }
    /**
     * A logical rule statement used to combine other rule statements with AND logic.
     * <p>
     * You provide more than one <code>Statement</code> within the <code>AndStatement</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * StatementProperty statementProperty_;
     * Object uriPath;
     * AndStatementProperty andStatementProperty = AndStatementProperty.builder()
     *         .statements(List.of(StatementProperty.builder()
     *                 .andStatement(AndStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .positionalConstraint("positionalConstraint")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .searchString("searchString")
     *                         .searchStringBase64("searchStringBase64")
     *                         .build())
     *                 .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                         .countryCodes(List.of("countryCodes"))
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .build())
     *                 .ipSetReferenceStatement(Map.of(
     *                         "arn", "arn",
     *                         // the properties below are optional
     *                         "ipSetForwardedIpConfig", Map.of(
     *                                 "fallbackBehavior", "fallbackBehavior",
     *                                 "headerName", "headerName",
     *                                 "position", "position")))
     *                 .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                         .key("key")
     *                         .scope("scope")
     *                         .build())
     *                 .notStatement(NotStatementProperty.builder()
     *                         .statement(statementProperty_)
     *                         .build())
     *                 .orStatement(OrStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .rateBasedStatement(RateBasedStatementProperty.builder()
     *                         .aggregateKeyType("aggregateKeyType")
     *                         .limit(123)
     *                         // the properties below are optional
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .scopeDownStatement(statementProperty_)
     *                         .build())
     *                 .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .regexString("regexString")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                         .arn("arn")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .size(123)
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .sensitivityLevel("sensitivityLevel")
     *                         .build())
     *                 .xssMatchStatement(XssMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.AndStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(AndStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AndStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The statements to combine with AND logic.
         * <p>
         * You can use any statements that can be nested.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatements();

        /**
         * @return a {@link Builder} of {@link AndStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AndStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AndStatementProperty> {
            java.lang.Object statements;

            /**
             * Sets the value of {@link AndStatementProperty#getStatements}
             * @param statements The statements to combine with AND logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(software.amazon.awscdk.IResolvable statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Sets the value of {@link AndStatementProperty#getStatements}
             * @param statements The statements to combine with AND logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(java.util.List<? extends java.lang.Object> statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AndStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AndStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AndStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AndStatementProperty {
            private final java.lang.Object statements;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statements = software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statements = java.util.Objects.requireNonNull(builder.statements, "statements is required");
            }

            @Override
            public final java.lang.Object getStatements() {
                return this.statements;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statements", om.valueToTree(this.getStatements()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.AndStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AndStatementProperty.Jsii$Proxy that = (AndStatementProperty.Jsii$Proxy) o;

                return this.statements.equals(that.statements);
            }

            @Override
            public final int hashCode() {
                int result = this.statements.hashCode();
                return result;
            }
        }
    }
    /**
     * Inspect the body of the web request. The body immediately follows the request headers.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * BodyProperty bodyProperty = BodyProperty.builder()
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.BodyProperty")
    @software.amazon.jsii.Jsii.Proxy(BodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * What AWS WAF should do if the body is larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the body normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.
         * <p>
         * Default: <code>CONTINUE</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOversizeHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BodyProperty> {
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link BodyProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the body is larger than AWS WAF can inspect.
             *                         AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the body normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             *                         <p>
             *                         You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.
             *                         <p>
             *                         Default: <code>CONTINUE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BodyProperty {
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.oversizeHandling = builder.oversizeHandling;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOversizeHandling() != null) {
                    data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.BodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BodyProperty.Jsii$Proxy that = (BodyProperty.Jsii$Proxy) o;

                return this.oversizeHandling != null ? this.oversizeHandling.equals(that.oversizeHandling) : that.oversizeHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.oversizeHandling != null ? this.oversizeHandling.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A rule statement that defines a string match search for AWS WAF to apply to web requests.
     * <p>
     * The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * ByteMatchStatementProperty byteMatchStatementProperty = ByteMatchStatementProperty.builder()
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriPath(uriPath)
     *                 .build())
     *         .positionalConstraint("positionalConstraint")
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         // the properties below are optional
     *         .searchString("searchString")
     *         .searchStringBase64("searchStringBase64")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.ByteMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(ByteMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ByteMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of the web request that you want AWS WAF to inspect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * The area within the portion of the web request that you want AWS WAF to search for `SearchString` .
         * <p>
         * Valid values include the following:
         * <p>
         * <em>CONTAINS</em>
         * <p>
         * The specified part of the web request must include the value of <code>SearchString</code> , but the location doesn't matter.
         * <p>
         * <em>CONTAINS_WORD</em>
         * <p>
         * The specified part of the web request must include the value of <code>SearchString</code> , and <code>SearchString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>SearchString</code> must be a word, which means that both of the following are true:
         * <p>
         * <ul>
         * <li><code>SearchString</code> is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and <code>;BadBot</code> .</li>
         * <li><code>SearchString</code> is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> and <code>-BadBot;</code> .</li>
         * </ul>
         * <p>
         * <em>EXACTLY</em>
         * <p>
         * The value of the specified part of the web request must exactly match the value of <code>SearchString</code> .
         * <p>
         * <em>STARTS_WITH</em>
         * <p>
         * The value of <code>SearchString</code> must appear at the beginning of the specified part of the web request.
         * <p>
         * <em>ENDS_WITH</em>
         * <p>
         * The value of <code>SearchString</code> must appear at the end of the specified part of the web request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPositionalConstraint();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * A string value that you want AWS WAF to search for.
         * <p>
         * AWS WAF searches only in the part of web requests that you designate for inspection in <code>FieldToMatch</code> . The maximum length of the value is 50 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.
         * <p>
         * Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.
         * <p>
         * For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code> . If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code> , you provide the string <code>BadBot</code> in the value of <code>SearchString</code> .
         * <p>
         * You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSearchString() {
            return null;
        }

        /**
         * String to search for in a web request component, base64-encoded.
         * <p>
         * If you don't want to encode the string, specify the unencoded value in <code>SearchString</code> instead.
         * <p>
         * You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSearchStringBase64() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ByteMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ByteMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ByteMatchStatementProperty> {
            java.lang.Object fieldToMatch;
            java.lang.String positionalConstraint;
            java.lang.Object textTransformations;
            java.lang.String searchString;
            java.lang.String searchStringBase64;

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnRuleGroup.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getPositionalConstraint}
             * @param positionalConstraint The area within the portion of the web request that you want AWS WAF to search for `SearchString` . This parameter is required.
             *                             Valid values include the following:
             *                             <p>
             *                             <em>CONTAINS</em>
             *                             <p>
             *                             The specified part of the web request must include the value of <code>SearchString</code> , but the location doesn't matter.
             *                             <p>
             *                             <em>CONTAINS_WORD</em>
             *                             <p>
             *                             The specified part of the web request must include the value of <code>SearchString</code> , and <code>SearchString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>SearchString</code> must be a word, which means that both of the following are true:
             *                             <p>
             *                             <ul>
             *                             <li><code>SearchString</code> is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and <code>;BadBot</code> .</li>
             *                             <li><code>SearchString</code> is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> and <code>-BadBot;</code> .</li>
             *                             </ul>
             *                             <p>
             *                             <em>EXACTLY</em>
             *                             <p>
             *                             The value of the specified part of the web request must exactly match the value of <code>SearchString</code> .
             *                             <p>
             *                             <em>STARTS_WITH</em>
             *                             <p>
             *                             The value of <code>SearchString</code> must appear at the beginning of the specified part of the web request.
             *                             <p>
             *                             <em>ENDS_WITH</em>
             *                             <p>
             *                             The value of <code>SearchString</code> must appear at the end of the specified part of the web request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder positionalConstraint(java.lang.String positionalConstraint) {
                this.positionalConstraint = positionalConstraint;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getSearchString}
             * @param searchString A string value that you want AWS WAF to search for.
             *                     AWS WAF searches only in the part of web requests that you designate for inspection in <code>FieldToMatch</code> . The maximum length of the value is 50 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.
             *                     <p>
             *                     Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.
             *                     <p>
             *                     For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code> . If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code> , you provide the string <code>BadBot</code> in the value of <code>SearchString</code> .
             *                     <p>
             *                     You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchString(java.lang.String searchString) {
                this.searchString = searchString;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getSearchStringBase64}
             * @param searchStringBase64 String to search for in a web request component, base64-encoded.
             *                           If you don't want to encode the string, specify the unencoded value in <code>SearchString</code> instead.
             *                           <p>
             *                           You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchStringBase64(java.lang.String searchStringBase64) {
                this.searchStringBase64 = searchStringBase64;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ByteMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ByteMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ByteMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ByteMatchStatementProperty {
            private final java.lang.Object fieldToMatch;
            private final java.lang.String positionalConstraint;
            private final java.lang.Object textTransformations;
            private final java.lang.String searchString;
            private final java.lang.String searchStringBase64;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.positionalConstraint = software.amazon.jsii.Kernel.get(this, "positionalConstraint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.searchString = software.amazon.jsii.Kernel.get(this, "searchString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.searchStringBase64 = software.amazon.jsii.Kernel.get(this, "searchStringBase64", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.positionalConstraint = java.util.Objects.requireNonNull(builder.positionalConstraint, "positionalConstraint is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
                this.searchString = builder.searchString;
                this.searchStringBase64 = builder.searchStringBase64;
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.String getPositionalConstraint() {
                return this.positionalConstraint;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            public final java.lang.String getSearchString() {
                return this.searchString;
            }

            @Override
            public final java.lang.String getSearchStringBase64() {
                return this.searchStringBase64;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("positionalConstraint", om.valueToTree(this.getPositionalConstraint()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));
                if (this.getSearchString() != null) {
                    data.set("searchString", om.valueToTree(this.getSearchString()));
                }
                if (this.getSearchStringBase64() != null) {
                    data.set("searchStringBase64", om.valueToTree(this.getSearchStringBase64()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.ByteMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ByteMatchStatementProperty.Jsii$Proxy that = (ByteMatchStatementProperty.Jsii$Proxy) o;

                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                if (!positionalConstraint.equals(that.positionalConstraint)) return false;
                if (!textTransformations.equals(that.textTransformations)) return false;
                if (this.searchString != null ? !this.searchString.equals(that.searchString) : that.searchString != null) return false;
                return this.searchStringBase64 != null ? this.searchStringBase64.equals(that.searchStringBase64) : that.searchStringBase64 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldToMatch.hashCode();
                result = 31 * result + (this.positionalConstraint.hashCode());
                result = 31 * result + (this.textTransformations.hashCode());
                result = 31 * result + (this.searchString != null ? this.searchString.hashCode() : 0);
                result = 31 * result + (this.searchStringBase64 != null ? this.searchStringBase64.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies how AWS WAF should handle `CAPTCHA` evaluations.
     * <p>
     * This is available at the web ACL level and in each rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CaptchaConfigProperty captchaConfigProperty = CaptchaConfigProperty.builder()
     *         .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
     *                 .immunityTime(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptchaConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptchaConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines how long a `CAPTCHA` token remains valid after the client successfully solves a `CAPTCHA` puzzle.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImmunityTimeProperty() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptchaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptchaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptchaConfigProperty> {
            java.lang.Object immunityTimeProperty;

            /**
             * Sets the value of {@link CaptchaConfigProperty#getImmunityTimeProperty}
             * @param immunityTimeProperty Determines how long a `CAPTCHA` token remains valid after the client successfully solves a `CAPTCHA` puzzle.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTimeProperty(software.amazon.awscdk.services.wafv2.CfnRuleGroup.ImmunityTimePropertyProperty immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            /**
             * Sets the value of {@link CaptchaConfigProperty#getImmunityTimeProperty}
             * @param immunityTimeProperty Determines how long a `CAPTCHA` token remains valid after the client successfully solves a `CAPTCHA` puzzle.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTimeProperty(software.amazon.awscdk.IResolvable immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptchaConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptchaConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptchaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptchaConfigProperty {
            private final java.lang.Object immunityTimeProperty;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.immunityTimeProperty = software.amazon.jsii.Kernel.get(this, "immunityTimeProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.immunityTimeProperty = builder.immunityTimeProperty;
            }

            @Override
            public final java.lang.Object getImmunityTimeProperty() {
                return this.immunityTimeProperty;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImmunityTimeProperty() != null) {
                    data.set("immunityTimeProperty", om.valueToTree(this.getImmunityTimeProperty()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptchaConfigProperty.Jsii$Proxy that = (CaptchaConfigProperty.Jsii$Proxy) o;

                return this.immunityTimeProperty != null ? this.immunityTimeProperty.equals(that.immunityTimeProperty) : that.immunityTimeProperty == null;
            }

            @Override
            public final int hashCode() {
                int result = this.immunityTimeProperty != null ? this.immunityTimeProperty.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The filter to use to identify the subset of cookies to inspect in a web request.
     * <p>
     * You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
     * <p>
     * Example JSON: <code>"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * CookieMatchPatternProperty cookieMatchPatternProperty = CookieMatchPatternProperty.builder()
     *         .all(all)
     *         .excludedCookies(List.of("excludedCookies"))
     *         .includedCookies(List.of("includedCookies"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookieMatchPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(CookieMatchPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookieMatchPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Inspect all cookies.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAll() {
            return null;
        }

        /**
         * Inspect only the cookies whose keys don't match any of the strings specified here.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedCookies() {
            return null;
        }

        /**
         * Inspect only the cookies that have a key that matches one of the strings specified here.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedCookies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookieMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookieMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookieMatchPatternProperty> {
            java.lang.Object all;
            java.util.List<java.lang.String> excludedCookies;
            java.util.List<java.lang.String> includedCookies;

            /**
             * Sets the value of {@link CookieMatchPatternProperty#getAll}
             * @param all Inspect all cookies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder all(java.lang.Object all) {
                this.all = all;
                return this;
            }

            /**
             * Sets the value of {@link CookieMatchPatternProperty#getExcludedCookies}
             * @param excludedCookies Inspect only the cookies whose keys don't match any of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedCookies(java.util.List<java.lang.String> excludedCookies) {
                this.excludedCookies = excludedCookies;
                return this;
            }

            /**
             * Sets the value of {@link CookieMatchPatternProperty#getIncludedCookies}
             * @param includedCookies Inspect only the cookies that have a key that matches one of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedCookies(java.util.List<java.lang.String> includedCookies) {
                this.includedCookies = includedCookies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookieMatchPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookieMatchPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookieMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookieMatchPatternProperty {
            private final java.lang.Object all;
            private final java.util.List<java.lang.String> excludedCookies;
            private final java.util.List<java.lang.String> includedCookies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludedCookies = software.amazon.jsii.Kernel.get(this, "excludedCookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includedCookies = software.amazon.jsii.Kernel.get(this, "includedCookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.all = builder.all;
                this.excludedCookies = builder.excludedCookies;
                this.includedCookies = builder.includedCookies;
            }

            @Override
            public final java.lang.Object getAll() {
                return this.all;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedCookies() {
                return this.excludedCookies;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedCookies() {
                return this.includedCookies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAll() != null) {
                    data.set("all", om.valueToTree(this.getAll()));
                }
                if (this.getExcludedCookies() != null) {
                    data.set("excludedCookies", om.valueToTree(this.getExcludedCookies()));
                }
                if (this.getIncludedCookies() != null) {
                    data.set("includedCookies", om.valueToTree(this.getIncludedCookies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookieMatchPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookieMatchPatternProperty.Jsii$Proxy that = (CookieMatchPatternProperty.Jsii$Proxy) o;

                if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
                if (this.excludedCookies != null ? !this.excludedCookies.equals(that.excludedCookies) : that.excludedCookies != null) return false;
                return this.includedCookies != null ? this.includedCookies.equals(that.includedCookies) : that.includedCookies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.all != null ? this.all.hashCode() : 0;
                result = 31 * result + (this.excludedCookies != null ? this.excludedCookies.hashCode() : 0);
                result = 31 * result + (this.includedCookies != null ? this.includedCookies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Inspect the cookies in the web request.
     * <p>
     * You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * Example JSON: <code>"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * CookiesProperty cookiesProperty = CookiesProperty.builder()
     *         .matchPattern(CookieMatchPatternProperty.builder()
     *                 .all(all)
     *                 .excludedCookies(List.of("excludedCookies"))
     *                 .includedCookies(List.of("includedCookies"))
     *                 .build())
     *         .matchScope("matchScope")
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The filter to use to identify the subset of cookies to inspect in a web request.
         * <p>
         * You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
         * <p>
         * Example JSON: <code>"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchPattern();

        /**
         * The parts of the cookies to inspect with the rule inspection criteria.
         * <p>
         * If you specify <code>All</code> , AWS WAF inspects both keys and values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchScope();

        /**
         * What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the cookies normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOversizeHandling();

        /**
         * @return a {@link Builder} of {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesProperty> {
            java.lang.Object matchPattern;
            java.lang.String matchScope;
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link CookiesProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of cookies to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.services.wafv2.CfnRuleGroup.CookieMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of cookies to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getMatchScope}
             * @param matchScope The parts of the cookies to inspect with the rule inspection criteria. This parameter is required.
             *                   If you specify <code>All</code> , AWS WAF inspects both keys and values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchScope(java.lang.String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. This parameter is required.
             *                         AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the cookies normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesProperty {
            private final java.lang.Object matchPattern;
            private final java.lang.String matchScope;
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPattern = software.amazon.jsii.Kernel.get(this, "matchPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchScope = software.amazon.jsii.Kernel.get(this, "matchScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPattern = java.util.Objects.requireNonNull(builder.matchPattern, "matchPattern is required");
                this.matchScope = java.util.Objects.requireNonNull(builder.matchScope, "matchScope is required");
                this.oversizeHandling = java.util.Objects.requireNonNull(builder.oversizeHandling, "oversizeHandling is required");
            }

            @Override
            public final java.lang.Object getMatchPattern() {
                return this.matchPattern;
            }

            @Override
            public final java.lang.String getMatchScope() {
                return this.matchScope;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPattern", om.valueToTree(this.getMatchPattern()));
                data.set("matchScope", om.valueToTree(this.getMatchScope()));
                data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesProperty.Jsii$Proxy that = (CookiesProperty.Jsii$Proxy) o;

                if (!matchPattern.equals(that.matchPattern)) return false;
                if (!matchScope.equals(that.matchScope)) return false;
                return this.oversizeHandling.equals(that.oversizeHandling);
            }

            @Override
            public final int hashCode() {
                int result = this.matchPattern.hashCode();
                result = 31 * result + (this.matchScope.hashCode());
                result = 31 * result + (this.oversizeHandling.hashCode());
                return result;
            }
        }
    }
    /**
     * The response body to use in a custom response to a web request.
     * <p>
     * This is referenced by key from <code>CustomResponse</code> <code>CustomResponseBodyKey</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CustomResponseBodyProperty customResponseBodyProperty = CustomResponseBodyProperty.builder()
     *         .content("content")
     *         .contentType("contentType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseBodyProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomResponseBodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomResponseBodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The payload of the custom response.
         * <p>
         * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the <code>ContentType</code> setting.
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContent();

        /**
         * The type of content in the payload that you are defining in the `Content` string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContentType();

        /**
         * @return a {@link Builder} of {@link CustomResponseBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomResponseBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomResponseBodyProperty> {
            java.lang.String content;
            java.lang.String contentType;

            /**
             * Sets the value of {@link CustomResponseBodyProperty#getContent}
             * @param content The payload of the custom response. This parameter is required.
             *                You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the <code>ContentType</code> setting.
             *                <p>
             *                For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(java.lang.String content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link CustomResponseBodyProperty#getContentType}
             * @param contentType The type of content in the payload that you are defining in the `Content` string. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomResponseBodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomResponseBodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomResponseBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResponseBodyProperty {
            private final java.lang.String content;
            private final java.lang.String contentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
                this.contentType = java.util.Objects.requireNonNull(builder.contentType, "contentType is required");
            }

            @Override
            public final java.lang.String getContent() {
                return this.content;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("content", om.valueToTree(this.getContent()));
                data.set("contentType", om.valueToTree(this.getContentType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseBodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomResponseBodyProperty.Jsii$Proxy that = (CustomResponseBodyProperty.Jsii$Proxy) o;

                if (!content.equals(that.content)) return false;
                return this.contentType.equals(that.contentType);
            }

            @Override
            public final int hashCode() {
                int result = this.content.hashCode();
                result = 31 * result + (this.contentType.hashCode());
                return result;
            }
        }
    }
    /**
     * The part of the web request that you want AWS WAF to inspect.
     * <p>
     * Include the single <code>FieldToMatch</code> type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in <code>FieldToMatch</code> for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.
     * <p>
     * Example JSON for a <code>QueryString</code> field to match:
     * <p>
     * <code>"FieldToMatch": { "QueryString": {} }</code>
     * <p>
     * Example JSON for a <code>Method</code> field to match specification:
     * <p>
     * <code>"FieldToMatch": { "Method": { "Name": "DELETE" } }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * FieldToMatchProperty fieldToMatchProperty = FieldToMatchProperty.builder()
     *         .allQueryArguments(allQueryArguments)
     *         .body(BodyProperty.builder()
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .cookies(CookiesProperty.builder()
     *                 .matchPattern(CookieMatchPatternProperty.builder()
     *                         .all(all)
     *                         .excludedCookies(List.of("excludedCookies"))
     *                         .includedCookies(List.of("includedCookies"))
     *                         .build())
     *                 .matchScope("matchScope")
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .headers(HeadersProperty.builder()
     *                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                         .all(all)
     *                         .excludedHeaders(List.of("excludedHeaders"))
     *                         .includedHeaders(List.of("includedHeaders"))
     *                         .build())
     *                 .matchScope("matchScope")
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .jsonBody(JsonBodyProperty.builder()
     *                 .matchPattern(JsonMatchPatternProperty.builder()
     *                         .all(all)
     *                         .includedPaths(List.of("includedPaths"))
     *                         .build())
     *                 .matchScope("matchScope")
     *                 // the properties below are optional
     *                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .method(method)
     *         .queryString(queryString)
     *         .singleHeader(singleHeader)
     *         .singleQueryArgument(singleQueryArgument)
     *         .uriPath(uriPath)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.FieldToMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldToMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldToMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Inspect all query arguments.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllQueryArguments() {
            return null;
        }

        /**
         * Inspect the request body as plain text.
         * <p>
         * The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         * <p>
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the <code>Body</code> object configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBody() {
            return null;
        }

        /**
         * Inspect the request cookies.
         * <p>
         * You must configure scope and pattern matching filters in the <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the <code>Cookies</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCookies() {
            return null;
        }

        /**
         * Inspect the request headers.
         * <p>
         * You must configure scope and pattern matching filters in the <code>Headers</code> object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the <code>Headers</code> object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaders() {
            return null;
        }

        /**
         * Inspect the request body as JSON.
         * <p>
         * The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         * <p>
         * Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the <code>JsonBody</code> object configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonBody() {
            return null;
        }

        /**
         * Inspect the HTTP method.
         * <p>
         * The method indicates the type of operation that the request is asking the origin to perform.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMethod() {
            return null;
        }

        /**
         * Inspect the query string.
         * <p>
         * This is the part of a URL that appears after a <code>?</code> character, if any.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryString() {
            return null;
        }

        /**
         * Inspect a single header.
         * <p>
         * Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code> . This setting isn't case sensitive.
         * <p>
         * Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
         * <p>
         * Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code> setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleHeader() {
            return null;
        }

        /**
         * Inspect a single query argument.
         * <p>
         * Provide the name of the query argument to inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The name can be up to 30 characters long and isn't case sensitive.
         * <p>
         * Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleQueryArgument() {
            return null;
        }

        /**
         * Inspect the request URI path.
         * <p>
         * This is the part of the web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUriPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldToMatchProperty> {
            java.lang.Object allQueryArguments;
            java.lang.Object body;
            java.lang.Object cookies;
            java.lang.Object headers;
            java.lang.Object jsonBody;
            java.lang.Object method;
            java.lang.Object queryString;
            java.lang.Object singleHeader;
            java.lang.Object singleQueryArgument;
            java.lang.Object uriPath;

            /**
             * Sets the value of {@link FieldToMatchProperty#getAllQueryArguments}
             * @param allQueryArguments Inspect all query arguments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allQueryArguments(java.lang.Object allQueryArguments) {
                this.allQueryArguments = allQueryArguments;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getBody}
             * @param body Inspect the request body as plain text.
             *             The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *             <p>
             *             Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the <code>Body</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.services.wafv2.CfnRuleGroup.BodyProperty body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getBody}
             * @param body Inspect the request body as plain text.
             *             The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *             <p>
             *             Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the <code>Body</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.IResolvable body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getCookies}
             * @param cookies Inspect the request cookies.
             *                You must configure scope and pattern matching filters in the <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the <code>Cookies</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.services.wafv2.CfnRuleGroup.CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getCookies}
             * @param cookies Inspect the request cookies.
             *                You must configure scope and pattern matching filters in the <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the <code>Cookies</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getHeaders}
             * @param headers Inspect the request headers.
             *                You must configure scope and pattern matching filters in the <code>Headers</code> object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the <code>Headers</code> object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.services.wafv2.CfnRuleGroup.HeadersProperty headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getHeaders}
             * @param headers Inspect the request headers.
             *                You must configure scope and pattern matching filters in the <code>Headers</code> object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the <code>Headers</code> object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJsonBody}
             * @param jsonBody Inspect the request body as JSON.
             *                 The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *                 <p>
             *                 Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the <code>JsonBody</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonBody(software.amazon.awscdk.services.wafv2.CfnRuleGroup.JsonBodyProperty jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJsonBody}
             * @param jsonBody Inspect the request body as JSON.
             *                 The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *                 <p>
             *                 Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the <code>JsonBody</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonBody(software.amazon.awscdk.IResolvable jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getMethod}
             * @param method Inspect the HTTP method.
             *               The method indicates the type of operation that the request is asking the origin to perform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.Object method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getQueryString}
             * @param queryString Inspect the query string.
             *                    This is the part of a URL that appears after a <code>?</code> character, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.Object queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getSingleHeader}
             * @param singleHeader Inspect a single header.
             *                     Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code> . This setting isn't case sensitive.
             *                     <p>
             *                     Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
             *                     <p>
             *                     Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code> setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeader(java.lang.Object singleHeader) {
                this.singleHeader = singleHeader;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getSingleQueryArgument}
             * @param singleQueryArgument Inspect a single query argument.
             *                            Provide the name of the query argument to inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The name can be up to 30 characters long and isn't case sensitive.
             *                            <p>
             *                            Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleQueryArgument(java.lang.Object singleQueryArgument) {
                this.singleQueryArgument = singleQueryArgument;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getUriPath}
             * @param uriPath Inspect the request URI path.
             *                This is the part of the web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriPath(java.lang.Object uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldToMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldToMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldToMatchProperty {
            private final java.lang.Object allQueryArguments;
            private final java.lang.Object body;
            private final java.lang.Object cookies;
            private final java.lang.Object headers;
            private final java.lang.Object jsonBody;
            private final java.lang.Object method;
            private final java.lang.Object queryString;
            private final java.lang.Object singleHeader;
            private final java.lang.Object singleQueryArgument;
            private final java.lang.Object uriPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allQueryArguments = software.amazon.jsii.Kernel.get(this, "allQueryArguments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cookies = software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jsonBody = software.amazon.jsii.Kernel.get(this, "jsonBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleHeader = software.amazon.jsii.Kernel.get(this, "singleHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleQueryArgument = software.amazon.jsii.Kernel.get(this, "singleQueryArgument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uriPath = software.amazon.jsii.Kernel.get(this, "uriPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allQueryArguments = builder.allQueryArguments;
                this.body = builder.body;
                this.cookies = builder.cookies;
                this.headers = builder.headers;
                this.jsonBody = builder.jsonBody;
                this.method = builder.method;
                this.queryString = builder.queryString;
                this.singleHeader = builder.singleHeader;
                this.singleQueryArgument = builder.singleQueryArgument;
                this.uriPath = builder.uriPath;
            }

            @Override
            public final java.lang.Object getAllQueryArguments() {
                return this.allQueryArguments;
            }

            @Override
            public final java.lang.Object getBody() {
                return this.body;
            }

            @Override
            public final java.lang.Object getCookies() {
                return this.cookies;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            public final java.lang.Object getJsonBody() {
                return this.jsonBody;
            }

            @Override
            public final java.lang.Object getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getSingleHeader() {
                return this.singleHeader;
            }

            @Override
            public final java.lang.Object getSingleQueryArgument() {
                return this.singleQueryArgument;
            }

            @Override
            public final java.lang.Object getUriPath() {
                return this.uriPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllQueryArguments() != null) {
                    data.set("allQueryArguments", om.valueToTree(this.getAllQueryArguments()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getJsonBody() != null) {
                    data.set("jsonBody", om.valueToTree(this.getJsonBody()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getQueryString() != null) {
                    data.set("queryString", om.valueToTree(this.getQueryString()));
                }
                if (this.getSingleHeader() != null) {
                    data.set("singleHeader", om.valueToTree(this.getSingleHeader()));
                }
                if (this.getSingleQueryArgument() != null) {
                    data.set("singleQueryArgument", om.valueToTree(this.getSingleQueryArgument()));
                }
                if (this.getUriPath() != null) {
                    data.set("uriPath", om.valueToTree(this.getUriPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.FieldToMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldToMatchProperty.Jsii$Proxy that = (FieldToMatchProperty.Jsii$Proxy) o;

                if (this.allQueryArguments != null ? !this.allQueryArguments.equals(that.allQueryArguments) : that.allQueryArguments != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.cookies != null ? !this.cookies.equals(that.cookies) : that.cookies != null) return false;
                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                if (this.jsonBody != null ? !this.jsonBody.equals(that.jsonBody) : that.jsonBody != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
                if (this.singleHeader != null ? !this.singleHeader.equals(that.singleHeader) : that.singleHeader != null) return false;
                if (this.singleQueryArgument != null ? !this.singleQueryArgument.equals(that.singleQueryArgument) : that.singleQueryArgument != null) return false;
                return this.uriPath != null ? this.uriPath.equals(that.uriPath) : that.uriPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allQueryArguments != null ? this.allQueryArguments.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                result = 31 * result + (this.jsonBody != null ? this.jsonBody.hashCode() : 0);
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
                result = 31 * result + (this.singleHeader != null ? this.singleHeader.hashCode() : 0);
                result = 31 * result + (this.singleQueryArgument != null ? this.singleQueryArgument.hashCode() : 0);
                result = 31 * result + (this.uriPath != null ? this.uriPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
     * <p>
     * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
     * <p>
     * <blockquote>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * <p>
     * </blockquote>
     * <p>
     * This configuration is used for <code>GeoMatchStatement</code> and <code>RateBasedStatement</code> . For <code>IPSetReferenceStatement</code> , use <code>IPSetForwardedIPConfig</code> instead.
     * <p>
     * AWS WAF only evaluates the first IP address found in the specified HTTP header.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ForwardedIPConfigurationProperty forwardedIPConfigurationProperty = ForwardedIPConfigurationProperty.builder()
     *         .fallbackBehavior("fallbackBehavior")
     *         .headerName("headerName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardedIPConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardedIPConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * The name of the HTTP header to use for the IP address.
         * <p>
         * For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * @return a {@link Builder} of {@link ForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardedIPConfigurationProperty> {
            java.lang.String fallbackBehavior;
            java.lang.String headerName;

            /**
             * Sets the value of {@link ForwardedIPConfigurationProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. This parameter is required.
             *                         <blockquote>
             *                         <p>
             *                         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedIPConfigurationProperty#getHeaderName}
             * @param headerName The name of the HTTP header to use for the IP address. This parameter is required.
             *                   For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardedIPConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardedIPConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardedIPConfigurationProperty {
            private final java.lang.String fallbackBehavior;
            private final java.lang.String headerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
                this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));
                data.set("headerName", om.valueToTree(this.getHeaderName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardedIPConfigurationProperty.Jsii$Proxy that = (ForwardedIPConfigurationProperty.Jsii$Proxy) o;

                if (!fallbackBehavior.equals(that.fallbackBehavior)) return false;
                return this.headerName.equals(that.headerName);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                result = 31 * result + (this.headerName.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement used to identify web requests based on country of origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * GeoMatchStatementProperty geoMatchStatementProperty = GeoMatchStatementProperty.builder()
     *         .countryCodes(List.of("countryCodes"))
     *         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .headerName("headerName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.GeoMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of two-character country codes, for example, `[ "US", "CN" ]` , from the alpha-2 country ISO codes of the ISO 3166 international standard.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCountryCodes() {
            return null;
        }

        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
         * <p>
         * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedIpConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoMatchStatementProperty> {
            java.util.List<java.lang.String> countryCodes;
            java.lang.Object forwardedIpConfig;

            /**
             * Sets the value of {@link GeoMatchStatementProperty#getCountryCodes}
             * @param countryCodes An array of two-character country codes, for example, `[ "US", "CN" ]` , from the alpha-2 country ISO codes of the ISO 3166 international standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCodes(java.util.List<java.lang.String> countryCodes) {
                this.countryCodes = countryCodes;
                return this;
            }

            /**
             * Sets the value of {@link GeoMatchStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.services.wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link GeoMatchStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.IResolvable forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoMatchStatementProperty {
            private final java.util.List<java.lang.String> countryCodes;
            private final java.lang.Object forwardedIpConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.countryCodes = software.amazon.jsii.Kernel.get(this, "countryCodes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.forwardedIpConfig = software.amazon.jsii.Kernel.get(this, "forwardedIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.countryCodes = builder.countryCodes;
                this.forwardedIpConfig = builder.forwardedIpConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getCountryCodes() {
                return this.countryCodes;
            }

            @Override
            public final java.lang.Object getForwardedIpConfig() {
                return this.forwardedIpConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCountryCodes() != null) {
                    data.set("countryCodes", om.valueToTree(this.getCountryCodes()));
                }
                if (this.getForwardedIpConfig() != null) {
                    data.set("forwardedIpConfig", om.valueToTree(this.getForwardedIpConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.GeoMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoMatchStatementProperty.Jsii$Proxy that = (GeoMatchStatementProperty.Jsii$Proxy) o;

                if (this.countryCodes != null ? !this.countryCodes.equals(that.countryCodes) : that.countryCodes != null) return false;
                return this.forwardedIpConfig != null ? this.forwardedIpConfig.equals(that.forwardedIpConfig) : that.forwardedIpConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.countryCodes != null ? this.countryCodes.hashCode() : 0;
                result = 31 * result + (this.forwardedIpConfig != null ? this.forwardedIpConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The filter to use to identify the subset of headers to inspect in a web request.
     * <p>
     * You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
     * <p>
     * Example JSON: <code>"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * HeaderMatchPatternProperty headerMatchPatternProperty = HeaderMatchPatternProperty.builder()
     *         .all(all)
     *         .excludedHeaders(List.of("excludedHeaders"))
     *         .includedHeaders(List.of("includedHeaders"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeaderMatchPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(HeaderMatchPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeaderMatchPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Inspect all headers.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAll() {
            return null;
        }

        /**
         * Inspect only the headers whose keys don't match any of the strings specified here.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedHeaders() {
            return null;
        }

        /**
         * Inspect only the headers that have a key that matches one of the strings specified here.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedHeaders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeaderMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeaderMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeaderMatchPatternProperty> {
            java.lang.Object all;
            java.util.List<java.lang.String> excludedHeaders;
            java.util.List<java.lang.String> includedHeaders;

            /**
             * Sets the value of {@link HeaderMatchPatternProperty#getAll}
             * @param all Inspect all headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder all(java.lang.Object all) {
                this.all = all;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchPatternProperty#getExcludedHeaders}
             * @param excludedHeaders Inspect only the headers whose keys don't match any of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedHeaders(java.util.List<java.lang.String> excludedHeaders) {
                this.excludedHeaders = excludedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchPatternProperty#getIncludedHeaders}
             * @param includedHeaders Inspect only the headers that have a key that matches one of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedHeaders(java.util.List<java.lang.String> includedHeaders) {
                this.includedHeaders = includedHeaders;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeaderMatchPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeaderMatchPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeaderMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeaderMatchPatternProperty {
            private final java.lang.Object all;
            private final java.util.List<java.lang.String> excludedHeaders;
            private final java.util.List<java.lang.String> includedHeaders;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludedHeaders = software.amazon.jsii.Kernel.get(this, "excludedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includedHeaders = software.amazon.jsii.Kernel.get(this, "includedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.all = builder.all;
                this.excludedHeaders = builder.excludedHeaders;
                this.includedHeaders = builder.includedHeaders;
            }

            @Override
            public final java.lang.Object getAll() {
                return this.all;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedHeaders() {
                return this.excludedHeaders;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedHeaders() {
                return this.includedHeaders;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAll() != null) {
                    data.set("all", om.valueToTree(this.getAll()));
                }
                if (this.getExcludedHeaders() != null) {
                    data.set("excludedHeaders", om.valueToTree(this.getExcludedHeaders()));
                }
                if (this.getIncludedHeaders() != null) {
                    data.set("includedHeaders", om.valueToTree(this.getIncludedHeaders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeaderMatchPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeaderMatchPatternProperty.Jsii$Proxy that = (HeaderMatchPatternProperty.Jsii$Proxy) o;

                if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
                if (this.excludedHeaders != null ? !this.excludedHeaders.equals(that.excludedHeaders) : that.excludedHeaders != null) return false;
                return this.includedHeaders != null ? this.includedHeaders.equals(that.includedHeaders) : that.includedHeaders == null;
            }

            @Override
            public final int hashCode() {
                int result = this.all != null ? this.all.hashCode() : 0;
                result = 31 * result + (this.excludedHeaders != null ? this.excludedHeaders.hashCode() : 0);
                result = 31 * result + (this.includedHeaders != null ? this.includedHeaders.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Inspect all headers in the web request.
     * <p>
     * You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * If you want to inspect just the value of a single header, use the <code>SingleHeader</code> <code>FieldToMatch</code> setting instead.
     * <p>
     * Example JSON: <code>"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * HeadersProperty headersProperty = HeadersProperty.builder()
     *         .matchPattern(HeaderMatchPatternProperty.builder()
     *                 .all(all)
     *                 .excludedHeaders(List.of("excludedHeaders"))
     *                 .includedHeaders(List.of("includedHeaders"))
     *                 .build())
     *         .matchScope("matchScope")
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(HeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The filter to use to identify the subset of headers to inspect in a web request.
         * <p>
         * You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
         * <p>
         * Example JSON: <code>"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchPattern();

        /**
         * The parts of the headers to match with the rule inspection criteria.
         * <p>
         * If you specify <code>All</code> , AWS WAF inspects both keys and values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchScope();

        /**
         * What AWS WAF should do if the headers of the request are larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the headers normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOversizeHandling();

        /**
         * @return a {@link Builder} of {@link HeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeadersProperty> {
            java.lang.Object matchPattern;
            java.lang.String matchScope;
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link HeadersProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of headers to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.services.wafv2.CfnRuleGroup.HeaderMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link HeadersProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of headers to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link HeadersProperty#getMatchScope}
             * @param matchScope The parts of the headers to match with the rule inspection criteria. This parameter is required.
             *                   If you specify <code>All</code> , AWS WAF inspects both keys and values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchScope(java.lang.String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            /**
             * Sets the value of {@link HeadersProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the headers of the request are larger than AWS WAF can inspect. This parameter is required.
             *                         AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the headers normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeadersProperty {
            private final java.lang.Object matchPattern;
            private final java.lang.String matchScope;
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPattern = software.amazon.jsii.Kernel.get(this, "matchPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchScope = software.amazon.jsii.Kernel.get(this, "matchScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPattern = java.util.Objects.requireNonNull(builder.matchPattern, "matchPattern is required");
                this.matchScope = java.util.Objects.requireNonNull(builder.matchScope, "matchScope is required");
                this.oversizeHandling = java.util.Objects.requireNonNull(builder.oversizeHandling, "oversizeHandling is required");
            }

            @Override
            public final java.lang.Object getMatchPattern() {
                return this.matchPattern;
            }

            @Override
            public final java.lang.String getMatchScope() {
                return this.matchScope;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPattern", om.valueToTree(this.getMatchPattern()));
                data.set("matchScope", om.valueToTree(this.getMatchScope()));
                data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeadersProperty.Jsii$Proxy that = (HeadersProperty.Jsii$Proxy) o;

                if (!matchPattern.equals(that.matchPattern)) return false;
                if (!matchScope.equals(that.matchScope)) return false;
                return this.oversizeHandling.equals(that.oversizeHandling);
            }

            @Override
            public final int hashCode() {
                int result = this.matchPattern.hashCode();
                result = 31 * result + (this.matchScope.hashCode());
                result = 31 * result + (this.oversizeHandling.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
     * <p>
     * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
     * <p>
     * <blockquote>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * <p>
     * </blockquote>
     * <p>
     * This configuration is used only for <code>IPSetReferenceStatement</code> . For <code>GeoMatchStatement</code> and <code>RateBasedStatement</code> , use <code>ForwardedIPConfig</code> instead.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * IPSetForwardedIPConfigurationProperty iPSetForwardedIPConfigurationProperty = Map.of(
     *         "fallbackBehavior", "fallbackBehavior",
     *         "headerName", "headerName",
     *         "position", "position");
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetForwardedIPConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IPSetForwardedIPConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IPSetForwardedIPConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * The name of the HTTP header to use for the IP address.
         * <p>
         * For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * The position in the header to search for the IP address.
         * <p>
         * The header can contain IP addresses of the original client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and the rest identify proxies that the request went through.
         * <p>
         * The options for this setting are the following:
         * <p>
         * <ul>
         * <li>FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.</li>
         * <li>LAST - Inspect the last IP address in the list of IP addresses in the header.</li>
         * <li>ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPosition();

        /**
         * @return a {@link Builder} of {@link IPSetForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IPSetForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IPSetForwardedIPConfigurationProperty> {
            java.lang.String fallbackBehavior;
            java.lang.String headerName;
            java.lang.String position;

            /**
             * Sets the value of {@link IPSetForwardedIPConfigurationProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. This parameter is required.
             *                         <blockquote>
             *                         <p>
             *                         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Sets the value of {@link IPSetForwardedIPConfigurationProperty#getHeaderName}
             * @param headerName The name of the HTTP header to use for the IP address. This parameter is required.
             *                   For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Sets the value of {@link IPSetForwardedIPConfigurationProperty#getPosition}
             * @param position The position in the header to search for the IP address. This parameter is required.
             *                 The header can contain IP addresses of the original client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and the rest identify proxies that the request went through.
             *                 <p>
             *                 The options for this setting are the following:
             *                 <p>
             *                 <ul>
             *                 <li>FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.</li>
             *                 <li>LAST - Inspect the last IP address in the list of IP addresses in the header.</li>
             *                 <li>ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(java.lang.String position) {
                this.position = position;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IPSetForwardedIPConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IPSetForwardedIPConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IPSetForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPSetForwardedIPConfigurationProperty {
            private final java.lang.String fallbackBehavior;
            private final java.lang.String headerName;
            private final java.lang.String position;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.position = software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
                this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
                this.position = java.util.Objects.requireNonNull(builder.position, "position is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            public final java.lang.String getPosition() {
                return this.position;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));
                data.set("headerName", om.valueToTree(this.getHeaderName()));
                data.set("position", om.valueToTree(this.getPosition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetForwardedIPConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IPSetForwardedIPConfigurationProperty.Jsii$Proxy that = (IPSetForwardedIPConfigurationProperty.Jsii$Proxy) o;

                if (!fallbackBehavior.equals(that.fallbackBehavior)) return false;
                if (!headerName.equals(that.headerName)) return false;
                return this.position.equals(that.position);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                result = 31 * result + (this.headerName.hashCode());
                result = 31 * result + (this.position.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement used to detect web requests coming from particular IP addresses or address ranges.
     * <p>
     * To use this, create an <code>IPSet</code> that specifies the addresses you want to detect, then use the ARN of that set in this statement.
     * <p>
     * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * IPSetReferenceStatementProperty iPSetReferenceStatementProperty = Map.of(
     *         "arn", "arn",
     *         // the properties below are optional
     *         "ipSetForwardedIpConfig", Map.of(
     *                 "fallbackBehavior", "fallbackBehavior",
     *                 "headerName", "headerName",
     *                 "position", "position"));
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(IPSetReferenceStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IPSetReferenceStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the `IPSet` that this statement references.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
         * <p>
         * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpSetForwardedIpConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IPSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IPSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IPSetReferenceStatementProperty> {
            java.lang.String arn;
            java.lang.Object ipSetForwardedIpConfig;

            /**
             * Sets the value of {@link IPSetReferenceStatementProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the `IPSet` that this statement references. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link IPSetReferenceStatementProperty#getIpSetForwardedIpConfig}
             * @param ipSetForwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                               Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetForwardedIpConfig(software.amazon.awscdk.services.wafv2.CfnRuleGroup.IPSetForwardedIPConfigurationProperty ipSetForwardedIpConfig) {
                this.ipSetForwardedIpConfig = ipSetForwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link IPSetReferenceStatementProperty#getIpSetForwardedIpConfig}
             * @param ipSetForwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                               Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetForwardedIpConfig(software.amazon.awscdk.IResolvable ipSetForwardedIpConfig) {
                this.ipSetForwardedIpConfig = ipSetForwardedIpConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IPSetReferenceStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IPSetReferenceStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IPSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPSetReferenceStatementProperty {
            private final java.lang.String arn;
            private final java.lang.Object ipSetForwardedIpConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipSetForwardedIpConfig = software.amazon.jsii.Kernel.get(this, "ipSetForwardedIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.ipSetForwardedIpConfig = builder.ipSetForwardedIpConfig;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getIpSetForwardedIpConfig() {
                return this.ipSetForwardedIpConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                if (this.getIpSetForwardedIpConfig() != null) {
                    data.set("ipSetForwardedIpConfig", om.valueToTree(this.getIpSetForwardedIpConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetReferenceStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IPSetReferenceStatementProperty.Jsii$Proxy that = (IPSetReferenceStatementProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.ipSetForwardedIpConfig != null ? this.ipSetForwardedIpConfig.equals(that.ipSetForwardedIpConfig) : that.ipSetForwardedIpConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.ipSetForwardedIpConfig != null ? this.ipSetForwardedIpConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines how long a `CAPTCHA` token remains valid after the client successfully solves a `CAPTCHA` puzzle.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ImmunityTimePropertyProperty immunityTimePropertyProperty = ImmunityTimePropertyProperty.builder()
     *         .immunityTime(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.ImmunityTimePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(ImmunityTimePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImmunityTimePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time, in seconds, that a `CAPTCHA` token is valid.
         * <p>
         * The default setting is 300.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getImmunityTime();

        /**
         * @return a {@link Builder} of {@link ImmunityTimePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImmunityTimePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImmunityTimePropertyProperty> {
            java.lang.Number immunityTime;

            /**
             * Sets the value of {@link ImmunityTimePropertyProperty#getImmunityTime}
             * @param immunityTime The amount of time, in seconds, that a `CAPTCHA` token is valid. This parameter is required.
             *                     The default setting is 300.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTime(java.lang.Number immunityTime) {
                this.immunityTime = immunityTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImmunityTimePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImmunityTimePropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImmunityTimePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImmunityTimePropertyProperty {
            private final java.lang.Number immunityTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.immunityTime = software.amazon.jsii.Kernel.get(this, "immunityTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.immunityTime = java.util.Objects.requireNonNull(builder.immunityTime, "immunityTime is required");
            }

            @Override
            public final java.lang.Number getImmunityTime() {
                return this.immunityTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("immunityTime", om.valueToTree(this.getImmunityTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.ImmunityTimePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImmunityTimePropertyProperty.Jsii$Proxy that = (ImmunityTimePropertyProperty.Jsii$Proxy) o;

                return this.immunityTime.equals(that.immunityTime);
            }

            @Override
            public final int hashCode() {
                int result = this.immunityTime.hashCode();
                return result;
            }
        }
    }
    /**
     * Inspect the body of the web request as JSON. The body immediately follows the request headers.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.
     * <p>
     * Example JSON: <code>"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * JsonBodyProperty jsonBodyProperty = JsonBodyProperty.builder()
     *         .matchPattern(JsonMatchPatternProperty.builder()
     *                 .all(all)
     *                 .includedPaths(List.of("includedPaths"))
     *                 .build())
     *         .matchScope("matchScope")
     *         // the properties below are optional
     *         .invalidFallbackBehavior("invalidFallbackBehavior")
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonBodyProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonBodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonBodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The patterns to look for in the JSON body.
         * <p>
         * AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchPattern();

        /**
         * The parts of the JSON to match against using the `MatchPattern` .
         * <p>
         * If you specify <code>All</code> , AWS WAF matches against keys and values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchScope();

        /**
         * What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.
         * <p>
         * <ul>
         * <li><code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
         * <p>
         * AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.
         * <p>
         * AWS WAF parses the JSON in the following examples as two valid key, value pairs:
         * <p>
         * <ul>
         * <li>Missing comma: <code>{"key1":"value1""key2":"value2"}</code></li>
         * <li>Missing colon: <code>{"key1":"value1","key2""value2"}</code></li>
         * <li>Extra colons: <code>{"key1"::"value1","key2""value2"}</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvalidFallbackBehavior() {
            return null;
        }

        /**
         * What AWS WAF should do if the body is larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the body normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.
         * <p>
         * Default: <code>CONTINUE</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOversizeHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonBodyProperty> {
            java.lang.Object matchPattern;
            java.lang.String matchScope;
            java.lang.String invalidFallbackBehavior;
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchPattern}
             * @param matchPattern The patterns to look for in the JSON body. This parameter is required.
             *                     AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.services.wafv2.CfnRuleGroup.JsonMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchPattern}
             * @param matchPattern The patterns to look for in the JSON body. This parameter is required.
             *                     AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchScope}
             * @param matchScope The parts of the JSON to match against using the `MatchPattern` . This parameter is required.
             *                   If you specify <code>All</code> , AWS WAF matches against keys and values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchScope(java.lang.String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getInvalidFallbackBehavior}
             * @param invalidFallbackBehavior What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.
             *                                <ul>
             *                                <li><code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.</li>
             *                                <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                                <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                                </ul>
             *                                <p>
             *                                If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
             *                                <p>
             *                                AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.
             *                                <p>
             *                                AWS WAF parses the JSON in the following examples as two valid key, value pairs:
             *                                <p>
             *                                <ul>
             *                                <li>Missing comma: <code>{"key1":"value1""key2":"value2"}</code></li>
             *                                <li>Missing colon: <code>{"key1":"value1","key2""value2"}</code></li>
             *                                <li>Extra colons: <code>{"key1"::"value1","key2""value2"}</code></li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invalidFallbackBehavior(java.lang.String invalidFallbackBehavior) {
                this.invalidFallbackBehavior = invalidFallbackBehavior;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the body is larger than AWS WAF can inspect.
             *                         AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the body normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             *                         <p>
             *                         You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.
             *                         <p>
             *                         Default: <code>CONTINUE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonBodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonBodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonBodyProperty {
            private final java.lang.Object matchPattern;
            private final java.lang.String matchScope;
            private final java.lang.String invalidFallbackBehavior;
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPattern = software.amazon.jsii.Kernel.get(this, "matchPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchScope = software.amazon.jsii.Kernel.get(this, "matchScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invalidFallbackBehavior = software.amazon.jsii.Kernel.get(this, "invalidFallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPattern = java.util.Objects.requireNonNull(builder.matchPattern, "matchPattern is required");
                this.matchScope = java.util.Objects.requireNonNull(builder.matchScope, "matchScope is required");
                this.invalidFallbackBehavior = builder.invalidFallbackBehavior;
                this.oversizeHandling = builder.oversizeHandling;
            }

            @Override
            public final java.lang.Object getMatchPattern() {
                return this.matchPattern;
            }

            @Override
            public final java.lang.String getMatchScope() {
                return this.matchScope;
            }

            @Override
            public final java.lang.String getInvalidFallbackBehavior() {
                return this.invalidFallbackBehavior;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPattern", om.valueToTree(this.getMatchPattern()));
                data.set("matchScope", om.valueToTree(this.getMatchScope()));
                if (this.getInvalidFallbackBehavior() != null) {
                    data.set("invalidFallbackBehavior", om.valueToTree(this.getInvalidFallbackBehavior()));
                }
                if (this.getOversizeHandling() != null) {
                    data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonBodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonBodyProperty.Jsii$Proxy that = (JsonBodyProperty.Jsii$Proxy) o;

                if (!matchPattern.equals(that.matchPattern)) return false;
                if (!matchScope.equals(that.matchScope)) return false;
                if (this.invalidFallbackBehavior != null ? !this.invalidFallbackBehavior.equals(that.invalidFallbackBehavior) : that.invalidFallbackBehavior != null) return false;
                return this.oversizeHandling != null ? this.oversizeHandling.equals(that.oversizeHandling) : that.oversizeHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchPattern.hashCode();
                result = 31 * result + (this.matchScope.hashCode());
                result = 31 * result + (this.invalidFallbackBehavior != null ? this.invalidFallbackBehavior.hashCode() : 0);
                result = 31 * result + (this.oversizeHandling != null ? this.oversizeHandling.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The patterns to look for in the JSON body.
     * <p>
     * AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the <code>FieldToMatch</code> option <code>JsonBody</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * JsonMatchPatternProperty jsonMatchPatternProperty = JsonMatchPatternProperty.builder()
     *         .all(all)
     *         .includedPaths(List.of("includedPaths"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonMatchPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonMatchPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonMatchPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Match all of the elements. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.
         * <p>
         * You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAll() {
            return null;
        }

        /**
         * Match only the specified include paths. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.
         * <p>
         * Provide the include paths using JSON Pointer syntax. For example, <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code> . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .
         * <p>
         * You must specify either this setting or the <code>All</code> setting, but not both.
         * <p>
         * <blockquote>
         * <p>
         * Don't use this option to include all paths. Instead, use the <code>All</code> setting.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedPaths() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonMatchPatternProperty> {
            java.lang.Object all;
            java.util.List<java.lang.String> includedPaths;

            /**
             * Sets the value of {@link JsonMatchPatternProperty#getAll}
             * @param all Match all of the elements. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.
             *            You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder all(java.lang.Object all) {
                this.all = all;
                return this;
            }

            /**
             * Sets the value of {@link JsonMatchPatternProperty#getIncludedPaths}
             * @param includedPaths Match only the specified include paths. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.
             *                      Provide the include paths using JSON Pointer syntax. For example, <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code> . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .
             *                      <p>
             *                      You must specify either this setting or the <code>All</code> setting, but not both.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      Don't use this option to include all paths. Instead, use the <code>All</code> setting.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedPaths(java.util.List<java.lang.String> includedPaths) {
                this.includedPaths = includedPaths;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonMatchPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonMatchPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonMatchPatternProperty {
            private final java.lang.Object all;
            private final java.util.List<java.lang.String> includedPaths;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includedPaths = software.amazon.jsii.Kernel.get(this, "includedPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.all = builder.all;
                this.includedPaths = builder.includedPaths;
            }

            @Override
            public final java.lang.Object getAll() {
                return this.all;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedPaths() {
                return this.includedPaths;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAll() != null) {
                    data.set("all", om.valueToTree(this.getAll()));
                }
                if (this.getIncludedPaths() != null) {
                    data.set("includedPaths", om.valueToTree(this.getIncludedPaths()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonMatchPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonMatchPatternProperty.Jsii$Proxy that = (JsonMatchPatternProperty.Jsii$Proxy) o;

                if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
                return this.includedPaths != null ? this.includedPaths.equals(that.includedPaths) : that.includedPaths == null;
            }

            @Override
            public final int hashCode() {
                int result = this.all != null ? this.all.hashCode() : 0;
                result = 31 * result + (this.includedPaths != null ? this.includedPaths.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL.
     * <p>
     * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * LabelMatchStatementProperty labelMatchStatementProperty = LabelMatchStatementProperty.builder()
     *         .key("key")
     *         .scope("scope")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:.
         * <p>
         * <ul>
         * <li>If the <code>Scope</code> indicates <code>LABEL</code> , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.</li>
         * <li>If the <code>Scope</code> indicates <code>NAMESPACE</code> , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.</li>
         * </ul>
         * <p>
         * Labels are case sensitive and components of a label must be separated by colon, for example <code>NS1:NS2:name</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * Specify whether you want to match using the label name or just the namespace.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScope();

        /**
         * @return a {@link Builder} of {@link LabelMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelMatchStatementProperty> {
            java.lang.String key;
            java.lang.String scope;

            /**
             * Sets the value of {@link LabelMatchStatementProperty#getKey}
             * @param key The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:. This parameter is required.
             *            <ul>
             *            <li>If the <code>Scope</code> indicates <code>LABEL</code> , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.</li>
             *            <li>If the <code>Scope</code> indicates <code>NAMESPACE</code> , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.</li>
             *            </ul>
             *            <p>
             *            Labels are case sensitive and components of a label must be separated by colon, for example <code>NS1:NS2:name</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link LabelMatchStatementProperty#getScope}
             * @param scope Specify whether you want to match using the label name or just the namespace. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelMatchStatementProperty {
            private final java.lang.String key;
            private final java.lang.String scope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("scope", om.valueToTree(this.getScope()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelMatchStatementProperty.Jsii$Proxy that = (LabelMatchStatementProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.scope.equals(that.scope);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.scope.hashCode());
                return result;
            }
        }
    }
    /**
     * A single label container.
     * <p>
     * This is used as an element of a label array in <code>RuleLabels</code> inside a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * LabelProperty labelProperty = LabelProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The label string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link LabelProperty#getName}
             * @param name The label string. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelProperty.Jsii$Proxy that = (LabelProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * List of labels used by one or more of the rules of a `RuleGroup` .
     * <p>
     * This summary object is used for the following rule group lists:
     * <p>
     * <ul>
     * <li><code>AvailableLabels</code> - Labels that rules add to matching requests. These labels are defined in the <code>RuleLabels</code> for a rule.</li>
     * <li><code>ConsumedLabels</code> - Labels that rules match against. These labels are defined in a <code>LabelMatchStatement</code> specification, in the <code>Statement</code> definition of a rule.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * LabelSummaryProperty labelSummaryProperty = LabelSummaryProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelSummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelSummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelSummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An individual label specification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LabelSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelSummaryProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link LabelSummaryProperty#getName}
             * @param name An individual label specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelSummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelSummaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelSummaryProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelSummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelSummaryProperty.Jsii$Proxy that = (LabelSummaryProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A logical rule statement used to negate the results of another rule statement.
     * <p>
     * You provide one <code>Statement</code> within the <code>NotStatement</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * StatementProperty statementProperty_;
     * Object uriPath;
     * NotStatementProperty notStatementProperty = NotStatementProperty.builder()
     *         .statement(StatementProperty.builder()
     *                 .andStatement(AndStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .positionalConstraint("positionalConstraint")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .searchString("searchString")
     *                         .searchStringBase64("searchStringBase64")
     *                         .build())
     *                 .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                         .countryCodes(List.of("countryCodes"))
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .build())
     *                 .ipSetReferenceStatement(Map.of(
     *                         "arn", "arn",
     *                         // the properties below are optional
     *                         "ipSetForwardedIpConfig", Map.of(
     *                                 "fallbackBehavior", "fallbackBehavior",
     *                                 "headerName", "headerName",
     *                                 "position", "position")))
     *                 .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                         .key("key")
     *                         .scope("scope")
     *                         .build())
     *                 .notStatement(NotStatementProperty.builder()
     *                         .statement(statementProperty_)
     *                         .build())
     *                 .orStatement(OrStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .rateBasedStatement(RateBasedStatementProperty.builder()
     *                         .aggregateKeyType("aggregateKeyType")
     *                         .limit(123)
     *                         // the properties below are optional
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .scopeDownStatement(statementProperty_)
     *                         .build())
     *                 .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .regexString("regexString")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                         .arn("arn")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .size(123)
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .sensitivityLevel("sensitivityLevel")
     *                         .build())
     *                 .xssMatchStatement(XssMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.NotStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(NotStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The statement to negate.
         * <p>
         * You can use any statement that can be nested.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatement();

        /**
         * @return a {@link Builder} of {@link NotStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotStatementProperty> {
            java.lang.Object statement;

            /**
             * Sets the value of {@link NotStatementProperty#getStatement}
             * @param statement The statement to negate. This parameter is required.
             *                  You can use any statement that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.StatementProperty statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Sets the value of {@link NotStatementProperty#getStatement}
             * @param statement The statement to negate. This parameter is required.
             *                  You can use any statement that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(software.amazon.awscdk.IResolvable statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotStatementProperty {
            private final java.lang.Object statement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
            }

            @Override
            public final java.lang.Object getStatement() {
                return this.statement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statement", om.valueToTree(this.getStatement()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.NotStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotStatementProperty.Jsii$Proxy that = (NotStatementProperty.Jsii$Proxy) o;

                return this.statement.equals(that.statement);
            }

            @Override
            public final int hashCode() {
                int result = this.statement.hashCode();
                return result;
            }
        }
    }
    /**
     * A logical rule statement used to combine other rule statements with OR logic.
     * <p>
     * You provide more than one <code>Statement</code> within the <code>OrStatement</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * StatementProperty statementProperty_;
     * Object uriPath;
     * OrStatementProperty orStatementProperty = OrStatementProperty.builder()
     *         .statements(List.of(StatementProperty.builder()
     *                 .andStatement(AndStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .positionalConstraint("positionalConstraint")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .searchString("searchString")
     *                         .searchStringBase64("searchStringBase64")
     *                         .build())
     *                 .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                         .countryCodes(List.of("countryCodes"))
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .build())
     *                 .ipSetReferenceStatement(Map.of(
     *                         "arn", "arn",
     *                         // the properties below are optional
     *                         "ipSetForwardedIpConfig", Map.of(
     *                                 "fallbackBehavior", "fallbackBehavior",
     *                                 "headerName", "headerName",
     *                                 "position", "position")))
     *                 .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                         .key("key")
     *                         .scope("scope")
     *                         .build())
     *                 .notStatement(NotStatementProperty.builder()
     *                         .statement(statementProperty_)
     *                         .build())
     *                 .orStatement(OrStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .rateBasedStatement(RateBasedStatementProperty.builder()
     *                         .aggregateKeyType("aggregateKeyType")
     *                         .limit(123)
     *                         // the properties below are optional
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .scopeDownStatement(statementProperty_)
     *                         .build())
     *                 .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .regexString("regexString")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                         .arn("arn")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .size(123)
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .sensitivityLevel("sensitivityLevel")
     *                         .build())
     *                 .xssMatchStatement(XssMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.OrStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(OrStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The statements to combine with OR logic.
         * <p>
         * You can use any statements that can be nested.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatements();

        /**
         * @return a {@link Builder} of {@link OrStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrStatementProperty> {
            java.lang.Object statements;

            /**
             * Sets the value of {@link OrStatementProperty#getStatements}
             * @param statements The statements to combine with OR logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(software.amazon.awscdk.IResolvable statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Sets the value of {@link OrStatementProperty#getStatements}
             * @param statements The statements to combine with OR logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(java.util.List<? extends java.lang.Object> statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrStatementProperty {
            private final java.lang.Object statements;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statements = software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statements = java.util.Objects.requireNonNull(builder.statements, "statements is required");
            }

            @Override
            public final java.lang.Object getStatements() {
                return this.statements;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statements", om.valueToTree(this.getStatements()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.OrStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrStatementProperty.Jsii$Proxy that = (OrStatementProperty.Jsii$Proxy) o;

                return this.statements.equals(that.statements);
            }

            @Override
            public final int hashCode() {
                int result = this.statements.hashCode();
                return result;
            }
        }
    }
    /**
     * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.
     * <p>
     * You can use this to put a temporary block on requests from an IP address that is sending excessive requests.
     * <p>
     * AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
     * <p>
     * When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.
     * <p>
     * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:
     * <p>
     * <ul>
     * <li>An IP match statement with an IP set that specified the address 192.0.2.44.</li>
     * <li>A string match statement that searches in the User-Agent header for the string BadBot.</li>
     * </ul>
     * <p>
     * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.
     * <p>
     * You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code> . You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * StatementProperty statementProperty_;
     * Object uriPath;
     * RateBasedStatementProperty rateBasedStatementProperty = RateBasedStatementProperty.builder()
     *         .aggregateKeyType("aggregateKeyType")
     *         .limit(123)
     *         // the properties below are optional
     *         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .headerName("headerName")
     *                 .build())
     *         .scopeDownStatement(StatementProperty.builder()
     *                 .andStatement(AndStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .positionalConstraint("positionalConstraint")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .searchString("searchString")
     *                         .searchStringBase64("searchStringBase64")
     *                         .build())
     *                 .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                         .countryCodes(List.of("countryCodes"))
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .build())
     *                 .ipSetReferenceStatement(Map.of(
     *                         "arn", "arn",
     *                         // the properties below are optional
     *                         "ipSetForwardedIpConfig", Map.of(
     *                                 "fallbackBehavior", "fallbackBehavior",
     *                                 "headerName", "headerName",
     *                                 "position", "position")))
     *                 .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                         .key("key")
     *                         .scope("scope")
     *                         .build())
     *                 .notStatement(NotStatementProperty.builder()
     *                         .statement(statementProperty_)
     *                         .build())
     *                 .orStatement(OrStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .rateBasedStatement(RateBasedStatementProperty.builder()
     *                         .aggregateKeyType("aggregateKeyType")
     *                         .limit(123)
     *                         // the properties below are optional
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .scopeDownStatement(statementProperty_)
     *                         .build())
     *                 .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .regexString("regexString")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                         .arn("arn")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .size(123)
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .sensitivityLevel("sensitivityLevel")
     *                         .build())
     *                 .xssMatchStatement(XssMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateBasedStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(RateBasedStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateBasedStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Setting that indicates how to aggregate the request counts. The options are the following:.
         * <p>
         * <ul>
         * <li>IP - Aggregate the request counts on the IP address from the web request origin.</li>
         * <li>FORWARDED_IP - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the <code>ForwardedIPConfig</code> , to specify the header to use.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAggregateKeyType();

        /**
         * The limit on requests per 5-minute period for a single originating IP address.
         * <p>
         * If the statement includes a <code>ScopeDownStatement</code> , this limit is applied only to the requests that match the statement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLimit();

        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
         * <p>
         * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * This is required if <code>AggregateKeyType</code> is set to <code>FORWARDED_IP</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedIpConfig() {
            return null;
        }

        /**
         * An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement.
         * <p>
         * Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScopeDownStatement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RateBasedStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateBasedStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateBasedStatementProperty> {
            java.lang.String aggregateKeyType;
            java.lang.Number limit;
            java.lang.Object forwardedIpConfig;
            java.lang.Object scopeDownStatement;

            /**
             * Sets the value of {@link RateBasedStatementProperty#getAggregateKeyType}
             * @param aggregateKeyType Setting that indicates how to aggregate the request counts. The options are the following:. This parameter is required.
             *                         <ul>
             *                         <li>IP - Aggregate the request counts on the IP address from the web request origin.</li>
             *                         <li>FORWARDED_IP - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the <code>ForwardedIPConfig</code> , to specify the header to use.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregateKeyType(java.lang.String aggregateKeyType) {
                this.aggregateKeyType = aggregateKeyType;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getLimit}
             * @param limit The limit on requests per 5-minute period for a single originating IP address. This parameter is required.
             *              If the statement includes a <code>ScopeDownStatement</code> , this limit is applied only to the requests that match the statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limit(java.lang.Number limit) {
                this.limit = limit;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             *                          <p>
             *                          This is required if <code>AggregateKeyType</code> is set to <code>FORWARDED_IP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.services.wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             *                          <p>
             *                          This is required if <code>AggregateKeyType</code> is set to <code>FORWARDED_IP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.IResolvable forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getScopeDownStatement}
             * @param scopeDownStatement An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement.
             *                           Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopeDownStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.StatementProperty scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getScopeDownStatement}
             * @param scopeDownStatement An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement.
             *                           Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopeDownStatement(software.amazon.awscdk.IResolvable scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateBasedStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateBasedStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateBasedStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateBasedStatementProperty {
            private final java.lang.String aggregateKeyType;
            private final java.lang.Number limit;
            private final java.lang.Object forwardedIpConfig;
            private final java.lang.Object scopeDownStatement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregateKeyType = software.amazon.jsii.Kernel.get(this, "aggregateKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.limit = software.amazon.jsii.Kernel.get(this, "limit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.forwardedIpConfig = software.amazon.jsii.Kernel.get(this, "forwardedIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scopeDownStatement = software.amazon.jsii.Kernel.get(this, "scopeDownStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregateKeyType = java.util.Objects.requireNonNull(builder.aggregateKeyType, "aggregateKeyType is required");
                this.limit = java.util.Objects.requireNonNull(builder.limit, "limit is required");
                this.forwardedIpConfig = builder.forwardedIpConfig;
                this.scopeDownStatement = builder.scopeDownStatement;
            }

            @Override
            public final java.lang.String getAggregateKeyType() {
                return this.aggregateKeyType;
            }

            @Override
            public final java.lang.Number getLimit() {
                return this.limit;
            }

            @Override
            public final java.lang.Object getForwardedIpConfig() {
                return this.forwardedIpConfig;
            }

            @Override
            public final java.lang.Object getScopeDownStatement() {
                return this.scopeDownStatement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("aggregateKeyType", om.valueToTree(this.getAggregateKeyType()));
                data.set("limit", om.valueToTree(this.getLimit()));
                if (this.getForwardedIpConfig() != null) {
                    data.set("forwardedIpConfig", om.valueToTree(this.getForwardedIpConfig()));
                }
                if (this.getScopeDownStatement() != null) {
                    data.set("scopeDownStatement", om.valueToTree(this.getScopeDownStatement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateBasedStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateBasedStatementProperty.Jsii$Proxy that = (RateBasedStatementProperty.Jsii$Proxy) o;

                if (!aggregateKeyType.equals(that.aggregateKeyType)) return false;
                if (!limit.equals(that.limit)) return false;
                if (this.forwardedIpConfig != null ? !this.forwardedIpConfig.equals(that.forwardedIpConfig) : that.forwardedIpConfig != null) return false;
                return this.scopeDownStatement != null ? this.scopeDownStatement.equals(that.scopeDownStatement) : that.scopeDownStatement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregateKeyType.hashCode();
                result = 31 * result + (this.limit.hashCode());
                result = 31 * result + (this.forwardedIpConfig != null ? this.forwardedIpConfig.hashCode() : 0);
                result = 31 * result + (this.scopeDownStatement != null ? this.scopeDownStatement.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A rule statement used to search web request components for a match against a single regular expression.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * RegexMatchStatementProperty regexMatchStatementProperty = RegexMatchStatementProperty.builder()
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriPath(uriPath)
     *                 .build())
     *         .regexString("regexString")
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(RegexMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegexMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of the web request that you want AWS WAF to inspect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * The string representing the regular expression.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegexString();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RegexMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegexMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegexMatchStatementProperty> {
            java.lang.Object fieldToMatch;
            java.lang.String regexString;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnRuleGroup.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getRegexString}
             * @param regexString The string representing the regular expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexString(java.lang.String regexString) {
                this.regexString = regexString;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegexMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegexMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegexMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegexMatchStatementProperty {
            private final java.lang.Object fieldToMatch;
            private final java.lang.String regexString;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regexString = software.amazon.jsii.Kernel.get(this, "regexString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.regexString = java.util.Objects.requireNonNull(builder.regexString, "regexString is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.String getRegexString() {
                return this.regexString;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("regexString", om.valueToTree(this.getRegexString()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegexMatchStatementProperty.Jsii$Proxy that = (RegexMatchStatementProperty.Jsii$Proxy) o;

                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                if (!regexString.equals(that.regexString)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldToMatch.hashCode();
                result = 31 * result + (this.regexString.hashCode());
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement used to search web request components for matches with regular expressions.
     * <p>
     * To use this, create a <code>RegexPatternSet</code> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.
     * <p>
     * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * RegexPatternSetReferenceStatementProperty regexPatternSetReferenceStatementProperty = RegexPatternSetReferenceStatementProperty.builder()
     *         .arn("arn")
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriPath(uriPath)
     *                 .build())
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(RegexPatternSetReferenceStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegexPatternSetReferenceStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the `RegexPatternSet` that this statement references.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The part of the web request that you want AWS WAF to inspect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RegexPatternSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegexPatternSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegexPatternSetReferenceStatementProperty> {
            java.lang.String arn;
            java.lang.Object fieldToMatch;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the `RegexPatternSet` that this statement references. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnRuleGroup.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegexPatternSetReferenceStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegexPatternSetReferenceStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegexPatternSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegexPatternSetReferenceStatementProperty {
            private final java.lang.String arn;
            private final java.lang.Object fieldToMatch;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegexPatternSetReferenceStatementProperty.Jsii$Proxy that = (RegexPatternSetReferenceStatementProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.fieldToMatch.hashCode());
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * The action that AWS WAF should take on a web request when it matches a rule's statement.
     * <p>
     * Settings at the web ACL level can override the rule action setting.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object allow;
     * Object block;
     * Object captcha;
     * Object count;
     * RuleActionProperty ruleActionProperty = RuleActionProperty.builder()
     *         .allow(allow)
     *         .block(block)
     *         .captcha(captcha)
     *         .count(count)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleActionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Instructs AWS WAF to allow the web request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllow() {
            return null;
        }

        /**
         * Instructs AWS WAF to block the web request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlock() {
            return null;
        }

        /**
         * Specifies that AWS WAF should run a `CAPTCHA` check against the request:.
         * <p>
         * <ul>
         * <li>If the request includes a valid, unexpired <code>CAPTCHA</code> token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a <code>CountAction</code> .</li>
         * <li>If the request doesn't include a valid, unexpired <code>CAPTCHA</code> token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.</li>
         * </ul>
         * <p>
         * AWS WAF generates a response that it sends back to the client, which includes the following:
         * <p>
         * <ul>
         * <li>The header <code>x-amzn-waf-action</code> with a value of <code>captcha</code> .</li>
         * <li>The HTTP status code <code>405 Method Not Allowed</code> .</li>
         * <li>If the request contains an <code>Accept</code> header with a value of <code>text/html</code> , the response includes a <code>CAPTCHA</code> challenge.</li>
         * </ul>
         * <p>
         * You can configure the expiration time in the <code>CaptchaConfig</code> <code>ImmunityTimeProperty</code> setting at the rule and web ACL level. The rule setting overrides the web ACL setting.
         * <p>
         * This action option is available for rules. It isn't available for web ACL default actions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptcha() {
            return null;
        }

        /**
         * Instructs AWS WAF to count the web request and allow it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleActionProperty> {
            java.lang.Object allow;
            java.lang.Object block;
            java.lang.Object captcha;
            java.lang.Object count;

            /**
             * Sets the value of {@link RuleActionProperty#getAllow}
             * @param allow Instructs AWS WAF to allow the web request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allow(java.lang.Object allow) {
                this.allow = allow;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getBlock}
             * @param block Instructs AWS WAF to block the web request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder block(java.lang.Object block) {
                this.block = block;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getCaptcha}
             * @param captcha Specifies that AWS WAF should run a `CAPTCHA` check against the request:.
             *                <ul>
             *                <li>If the request includes a valid, unexpired <code>CAPTCHA</code> token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a <code>CountAction</code> .</li>
             *                <li>If the request doesn't include a valid, unexpired <code>CAPTCHA</code> token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.</li>
             *                </ul>
             *                <p>
             *                AWS WAF generates a response that it sends back to the client, which includes the following:
             *                <p>
             *                <ul>
             *                <li>The header <code>x-amzn-waf-action</code> with a value of <code>captcha</code> .</li>
             *                <li>The HTTP status code <code>405 Method Not Allowed</code> .</li>
             *                <li>If the request contains an <code>Accept</code> header with a value of <code>text/html</code> , the response includes a <code>CAPTCHA</code> challenge.</li>
             *                </ul>
             *                <p>
             *                You can configure the expiration time in the <code>CaptchaConfig</code> <code>ImmunityTimeProperty</code> setting at the rule and web ACL level. The rule setting overrides the web ACL setting.
             *                <p>
             *                This action option is available for rules. It isn't available for web ACL default actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captcha(java.lang.Object captcha) {
                this.captcha = captcha;
                return this;
            }

            /**
             * Sets the value of {@link RuleActionProperty#getCount}
             * @param count Instructs AWS WAF to count the web request and allow it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Object count) {
                this.count = count;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleActionProperty {
            private final java.lang.Object allow;
            private final java.lang.Object block;
            private final java.lang.Object captcha;
            private final java.lang.Object count;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allow = software.amazon.jsii.Kernel.get(this, "allow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.block = software.amazon.jsii.Kernel.get(this, "block", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.captcha = software.amazon.jsii.Kernel.get(this, "captcha", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allow = builder.allow;
                this.block = builder.block;
                this.captcha = builder.captcha;
                this.count = builder.count;
            }

            @Override
            public final java.lang.Object getAllow() {
                return this.allow;
            }

            @Override
            public final java.lang.Object getBlock() {
                return this.block;
            }

            @Override
            public final java.lang.Object getCaptcha() {
                return this.captcha;
            }

            @Override
            public final java.lang.Object getCount() {
                return this.count;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllow() != null) {
                    data.set("allow", om.valueToTree(this.getAllow()));
                }
                if (this.getBlock() != null) {
                    data.set("block", om.valueToTree(this.getBlock()));
                }
                if (this.getCaptcha() != null) {
                    data.set("captcha", om.valueToTree(this.getCaptcha()));
                }
                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleActionProperty.Jsii$Proxy that = (RuleActionProperty.Jsii$Proxy) o;

                if (this.allow != null ? !this.allow.equals(that.allow) : that.allow != null) return false;
                if (this.block != null ? !this.block.equals(that.block) : that.block != null) return false;
                if (this.captcha != null ? !this.captcha.equals(that.captcha) : that.captcha != null) return false;
                return this.count != null ? this.count.equals(that.count) : that.count == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allow != null ? this.allow.hashCode() : 0;
                result = 31 * result + (this.block != null ? this.block.hashCode() : 0);
                result = 31 * result + (this.captcha != null ? this.captcha.hashCode() : 0);
                result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single rule, which you can use in a `WebACL` or `RuleGroup` to identify web requests that you want to allow, block, or count.
     * <p>
     * Each rule includes one top-level <code>Statement</code> that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allow;
     * Object allQueryArguments;
     * Object block;
     * Object captcha;
     * Object count;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * StatementProperty statementProperty_;
     * Object uriPath;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .name("name")
     *         .priority(123)
     *         .statement(StatementProperty.builder()
     *                 .andStatement(AndStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .positionalConstraint("positionalConstraint")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .searchString("searchString")
     *                         .searchStringBase64("searchStringBase64")
     *                         .build())
     *                 .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                         .countryCodes(List.of("countryCodes"))
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .build())
     *                 .ipSetReferenceStatement(Map.of(
     *                         "arn", "arn",
     *                         // the properties below are optional
     *                         "ipSetForwardedIpConfig", Map.of(
     *                                 "fallbackBehavior", "fallbackBehavior",
     *                                 "headerName", "headerName",
     *                                 "position", "position")))
     *                 .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                         .key("key")
     *                         .scope("scope")
     *                         .build())
     *                 .notStatement(NotStatementProperty.builder()
     *                         .statement(statementProperty_)
     *                         .build())
     *                 .orStatement(OrStatementProperty.builder()
     *                         .statements(List.of(statementProperty_))
     *                         .build())
     *                 .rateBasedStatement(RateBasedStatementProperty.builder()
     *                         .aggregateKeyType("aggregateKeyType")
     *                         .limit(123)
     *                         // the properties below are optional
     *                         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                 .fallbackBehavior("fallbackBehavior")
     *                                 .headerName("headerName")
     *                                 .build())
     *                         .scopeDownStatement(statementProperty_)
     *                         .build())
     *                 .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .regexString("regexString")
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                         .arn("arn")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .size(123)
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .sensitivityLevel("sensitivityLevel")
     *                         .build())
     *                 .xssMatchStatement(XssMatchStatementProperty.builder()
     *                         .fieldToMatch(FieldToMatchProperty.builder()
     *                                 .allQueryArguments(allQueryArguments)
     *                                 .body(BodyProperty.builder()
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .cookies(CookiesProperty.builder()
     *                                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedCookies(List.of("excludedCookies"))
     *                                                 .includedCookies(List.of("includedCookies"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .headers(HeadersProperty.builder()
     *                                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                                 .includedHeaders(List.of("includedHeaders"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .jsonBody(JsonBodyProperty.builder()
     *                                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                                 .all(all)
     *                                                 .includedPaths(List.of("includedPaths"))
     *                                                 .build())
     *                                         .matchScope("matchScope")
     *                                         // the properties below are optional
     *                                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                         .oversizeHandling("oversizeHandling")
     *                                         .build())
     *                                 .method(method)
     *                                 .queryString(queryString)
     *                                 .singleHeader(singleHeader)
     *                                 .singleQueryArgument(singleQueryArgument)
     *                                 .uriPath(uriPath)
     *                                 .build())
     *                         .textTransformations(List.of(TextTransformationProperty.builder()
     *                                 .priority(123)
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .visibilityConfig(VisibilityConfigProperty.builder()
     *                 .cloudWatchMetricsEnabled(false)
     *                 .metricName("metricName")
     *                 .sampledRequestsEnabled(false)
     *                 .build())
     *         // the properties below are optional
     *         .action(RuleActionProperty.builder()
     *                 .allow(allow)
     *                 .block(block)
     *                 .captcha(captcha)
     *                 .count(count)
     *                 .build())
     *         .captchaConfig(CaptchaConfigProperty.builder()
     *                 .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
     *                         .immunityTime(123)
     *                         .build())
     *                 .build())
     *         .ruleLabels(List.of(LabelProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the rule.
         * <p>
         * You can't change the name of a <code>Rule</code> after you create it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * If you define more than one `Rule` in a `WebACL` , AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority` .
         * <p>
         * AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * The AWS WAF processing statement for the rule, for example `ByteMatchStatement` or `SizeConstraintStatement` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatement();

        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVisibilityConfig();

        /**
         * The action that AWS WAF should take on a web request when it matches the rule statement.
         * <p>
         * Settings at the web ACL level can override the rule action setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAction() {
            return null;
        }

        /**
         * Specifies how AWS WAF should handle `CAPTCHA` evaluations.
         * <p>
         * If you don't specify this, AWS WAF uses the <code>CAPTCHA</code> configuration that's defined for the web ACL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptchaConfig() {
            return null;
        }

        /**
         * Labels to apply to web requests that match the rule match statement.
         * <p>
         * AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
         * <p>
         * Rules that run after this rule in the web ACL can match against these labels using a <code>LabelMatchStatement</code> .
         * <p>
         * For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:
         * <p>
         * <ul>
         * <li>Separate each component of the label with a colon.</li>
         * <li>Each namespace or name can have up to 128 characters.</li>
         * <li>You can specify up to 5 namespaces in a label.</li>
         * <li>Don't use the following reserved words in your label specification: <code>aws</code> , <code>waf</code> , <code>managed</code> , <code>rulegroup</code> , <code>webacl</code> , <code>regexpatternset</code> , or <code>ipset</code> .</li>
         * </ul>
         * <p>
         * For example, <code>myLabelName</code> or <code>nameSpace1:nameSpace2:myLabelName</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleLabels() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.String name;
            java.lang.Number priority;
            java.lang.Object statement;
            java.lang.Object visibilityConfig;
            java.lang.Object action;
            java.lang.Object captchaConfig;
            java.lang.Object ruleLabels;

            /**
             * Sets the value of {@link RuleProperty#getName}
             * @param name The name of the rule. This parameter is required.
             *             You can't change the name of a <code>Rule</code> after you create it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getPriority}
             * @param priority If you define more than one `Rule` in a `WebACL` , AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority` . This parameter is required.
             *                 AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getStatement}
             * @param statement The AWS WAF processing statement for the rule, for example `ByteMatchStatement` or `SizeConstraintStatement` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.StatementProperty statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getStatement}
             * @param statement The AWS WAF processing statement for the rule, for example `ByteMatchStatement` or `SizeConstraintStatement` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(software.amazon.awscdk.IResolvable statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getVisibilityConfig}
             * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visibilityConfig(software.amazon.awscdk.services.wafv2.CfnRuleGroup.VisibilityConfigProperty visibilityConfig) {
                this.visibilityConfig = visibilityConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getVisibilityConfig}
             * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder visibilityConfig(software.amazon.awscdk.IResolvable visibilityConfig) {
                this.visibilityConfig = visibilityConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAction}
             * @param action The action that AWS WAF should take on a web request when it matches the rule statement.
             *               Settings at the web ACL level can override the rule action setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.wafv2.CfnRuleGroup.RuleActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAction}
             * @param action The action that AWS WAF should take on a web request when it matches the rule statement.
             *               Settings at the web ACL level can override the rule action setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getCaptchaConfig}
             * @param captchaConfig Specifies how AWS WAF should handle `CAPTCHA` evaluations.
             *                      If you don't specify this, AWS WAF uses the <code>CAPTCHA</code> configuration that's defined for the web ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captchaConfig(software.amazon.awscdk.services.wafv2.CfnRuleGroup.CaptchaConfigProperty captchaConfig) {
                this.captchaConfig = captchaConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getCaptchaConfig}
             * @param captchaConfig Specifies how AWS WAF should handle `CAPTCHA` evaluations.
             *                      If you don't specify this, AWS WAF uses the <code>CAPTCHA</code> configuration that's defined for the web ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captchaConfig(software.amazon.awscdk.IResolvable captchaConfig) {
                this.captchaConfig = captchaConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getRuleLabels}
             * @param ruleLabels Labels to apply to web requests that match the rule match statement.
             *                   AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
             *                   <p>
             *                   Rules that run after this rule in the web ACL can match against these labels using a <code>LabelMatchStatement</code> .
             *                   <p>
             *                   For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:
             *                   <p>
             *                   <ul>
             *                   <li>Separate each component of the label with a colon.</li>
             *                   <li>Each namespace or name can have up to 128 characters.</li>
             *                   <li>You can specify up to 5 namespaces in a label.</li>
             *                   <li>Don't use the following reserved words in your label specification: <code>aws</code> , <code>waf</code> , <code>managed</code> , <code>rulegroup</code> , <code>webacl</code> , <code>regexpatternset</code> , or <code>ipset</code> .</li>
             *                   </ul>
             *                   <p>
             *                   For example, <code>myLabelName</code> or <code>nameSpace1:nameSpace2:myLabelName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleLabels(software.amazon.awscdk.IResolvable ruleLabels) {
                this.ruleLabels = ruleLabels;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getRuleLabels}
             * @param ruleLabels Labels to apply to web requests that match the rule match statement.
             *                   AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.
             *                   <p>
             *                   Rules that run after this rule in the web ACL can match against these labels using a <code>LabelMatchStatement</code> .
             *                   <p>
             *                   For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:
             *                   <p>
             *                   <ul>
             *                   <li>Separate each component of the label with a colon.</li>
             *                   <li>Each namespace or name can have up to 128 characters.</li>
             *                   <li>You can specify up to 5 namespaces in a label.</li>
             *                   <li>Don't use the following reserved words in your label specification: <code>aws</code> , <code>waf</code> , <code>managed</code> , <code>rulegroup</code> , <code>webacl</code> , <code>regexpatternset</code> , or <code>ipset</code> .</li>
             *                   </ul>
             *                   <p>
             *                   For example, <code>myLabelName</code> or <code>nameSpace1:nameSpace2:myLabelName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleLabels(java.util.List<? extends java.lang.Object> ruleLabels) {
                this.ruleLabels = ruleLabels;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.String name;
            private final java.lang.Number priority;
            private final java.lang.Object statement;
            private final java.lang.Object visibilityConfig;
            private final java.lang.Object action;
            private final java.lang.Object captchaConfig;
            private final java.lang.Object ruleLabels;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.visibilityConfig = software.amazon.jsii.Kernel.get(this, "visibilityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.captchaConfig = software.amazon.jsii.Kernel.get(this, "captchaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleLabels = software.amazon.jsii.Kernel.get(this, "ruleLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
                this.visibilityConfig = java.util.Objects.requireNonNull(builder.visibilityConfig, "visibilityConfig is required");
                this.action = builder.action;
                this.captchaConfig = builder.captchaConfig;
                this.ruleLabels = builder.ruleLabels;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Object getStatement() {
                return this.statement;
            }

            @Override
            public final java.lang.Object getVisibilityConfig() {
                return this.visibilityConfig;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getCaptchaConfig() {
                return this.captchaConfig;
            }

            @Override
            public final java.lang.Object getRuleLabels() {
                return this.ruleLabels;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("priority", om.valueToTree(this.getPriority()));
                data.set("statement", om.valueToTree(this.getStatement()));
                data.set("visibilityConfig", om.valueToTree(this.getVisibilityConfig()));
                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getCaptchaConfig() != null) {
                    data.set("captchaConfig", om.valueToTree(this.getCaptchaConfig()));
                }
                if (this.getRuleLabels() != null) {
                    data.set("ruleLabels", om.valueToTree(this.getRuleLabels()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!priority.equals(that.priority)) return false;
                if (!statement.equals(that.statement)) return false;
                if (!visibilityConfig.equals(that.visibilityConfig)) return false;
                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                if (this.captchaConfig != null ? !this.captchaConfig.equals(that.captchaConfig) : that.captchaConfig != null) return false;
                return this.ruleLabels != null ? this.ruleLabels.equals(that.ruleLabels) : that.ruleLabels == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.priority.hashCode());
                result = 31 * result + (this.statement.hashCode());
                result = 31 * result + (this.visibilityConfig.hashCode());
                result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
                result = 31 * result + (this.captchaConfig != null ? this.captchaConfig.hashCode() : 0);
                result = 31 * result + (this.ruleLabels != null ? this.ruleLabels.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).
     * <p>
     * For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
     * <p>
     * If you configure AWS WAF to inspect the request body, AWS WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you could use a size constraint statement to block requests that have a request body greater than 8192 bytes.
     * <p>
     * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * SizeConstraintStatementProperty sizeConstraintStatementProperty = SizeConstraintStatementProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriPath(uriPath)
     *                 .build())
     *         .size(123)
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.SizeConstraintStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(SizeConstraintStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SizeConstraintStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operator to use to compare the request part to the size setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

        /**
         * The part of the web request that you want AWS WAF to inspect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * The size, in byte, to compare to the request part, after any transformations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSize();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link SizeConstraintStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SizeConstraintStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SizeConstraintStatementProperty> {
            java.lang.String comparisonOperator;
            java.lang.Object fieldToMatch;
            java.lang.Number size;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link SizeConstraintStatementProperty#getComparisonOperator}
             * @param comparisonOperator The operator to use to compare the request part to the size setting. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link SizeConstraintStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnRuleGroup.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link SizeConstraintStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link SizeConstraintStatementProperty#getSize}
             * @param size The size, in byte, to compare to the request part, after any transformations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link SizeConstraintStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link SizeConstraintStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SizeConstraintStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SizeConstraintStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SizeConstraintStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SizeConstraintStatementProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.Object fieldToMatch;
            private final java.lang.Number size;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("size", om.valueToTree(this.getSize()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.SizeConstraintStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SizeConstraintStatementProperty.Jsii$Proxy that = (SizeConstraintStatementProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                if (!size.equals(that.size)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.fieldToMatch.hashCode());
                result = 31 * result + (this.size.hashCode());
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement that inspects for malicious SQL code.
     * <p>
     * Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * SqliMatchStatementProperty sqliMatchStatementProperty = SqliMatchStatementProperty.builder()
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriPath(uriPath)
     *                 .build())
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         // the properties below are optional
     *         .sensitivityLevel("sensitivityLevel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.SqliMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(SqliMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqliMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of the web request that you want AWS WAF to inspect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * `CfnRuleGroup.SqliMatchStatementProperty.SensitivityLevel`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSensitivityLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqliMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqliMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqliMatchStatementProperty> {
            java.lang.Object fieldToMatch;
            java.lang.Object textTransformations;
            java.lang.String sensitivityLevel;

            /**
             * Sets the value of {@link SqliMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnRuleGroup.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link SqliMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link SqliMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link SqliMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link SqliMatchStatementProperty#getSensitivityLevel}
             * @param sensitivityLevel `CfnRuleGroup.SqliMatchStatementProperty.SensitivityLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sensitivityLevel(java.lang.String sensitivityLevel) {
                this.sensitivityLevel = sensitivityLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqliMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqliMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqliMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqliMatchStatementProperty {
            private final java.lang.Object fieldToMatch;
            private final java.lang.Object textTransformations;
            private final java.lang.String sensitivityLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sensitivityLevel = software.amazon.jsii.Kernel.get(this, "sensitivityLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
                this.sensitivityLevel = builder.sensitivityLevel;
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            public final java.lang.String getSensitivityLevel() {
                return this.sensitivityLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));
                if (this.getSensitivityLevel() != null) {
                    data.set("sensitivityLevel", om.valueToTree(this.getSensitivityLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.SqliMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqliMatchStatementProperty.Jsii$Proxy that = (SqliMatchStatementProperty.Jsii$Proxy) o;

                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                if (!textTransformations.equals(that.textTransformations)) return false;
                return this.sensitivityLevel != null ? this.sensitivityLevel.equals(that.sensitivityLevel) : that.sensitivityLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldToMatch.hashCode();
                result = 31 * result + (this.textTransformations.hashCode());
                result = 31 * result + (this.sensitivityLevel != null ? this.sensitivityLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The processing guidance for a rule, used by AWS WAF to determine whether a web request matches the rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * AndStatementProperty andStatementProperty_;
     * Object method;
     * NotStatementProperty notStatementProperty_;
     * OrStatementProperty orStatementProperty_;
     * Object queryString;
     * RateBasedStatementProperty rateBasedStatementProperty_;
     * Object singleHeader;
     * Object singleQueryArgument;
     * StatementProperty statementProperty_;
     * Object uriPath;
     * StatementProperty statementProperty = StatementProperty.builder()
     *         .andStatement(AndStatementProperty.builder()
     *                 .statements(List.of(StatementProperty.builder()
     *                         .andStatement(andStatementProperty_)
     *                         .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .positionalConstraint("positionalConstraint")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .searchString("searchString")
     *                                 .searchStringBase64("searchStringBase64")
     *                                 .build())
     *                         .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                                 .countryCodes(List.of("countryCodes"))
     *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                         .fallbackBehavior("fallbackBehavior")
     *                                         .headerName("headerName")
     *                                         .build())
     *                                 .build())
     *                         .ipSetReferenceStatement(Map.of(
     *                                 "arn", "arn",
     *                                 // the properties below are optional
     *                                 "ipSetForwardedIpConfig", Map.of(
     *                                         "fallbackBehavior", "fallbackBehavior",
     *                                         "headerName", "headerName",
     *                                         "position", "position")))
     *                         .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                                 .key("key")
     *                                 .scope("scope")
     *                                 .build())
     *                         .notStatement(NotStatementProperty.builder()
     *                                 .statement(statementProperty_)
     *                                 .build())
     *                         .orStatement(OrStatementProperty.builder()
     *                                 .statements(List.of(statementProperty_))
     *                                 .build())
     *                         .rateBasedStatement(RateBasedStatementProperty.builder()
     *                                 .aggregateKeyType("aggregateKeyType")
     *                                 .limit(123)
     *                                 // the properties below are optional
     *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                         .fallbackBehavior("fallbackBehavior")
     *                                         .headerName("headerName")
     *                                         .build())
     *                                 .scopeDownStatement(statementProperty_)
     *                                 .build())
     *                         .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .regexString("regexString")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                                 .arn("arn")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                                 .comparisonOperator("comparisonOperator")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .size(123)
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .sensitivityLevel("sensitivityLevel")
     *                                 .build())
     *                         .xssMatchStatement(XssMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                 .fieldToMatch(FieldToMatchProperty.builder()
     *                         .allQueryArguments(allQueryArguments)
     *                         .body(BodyProperty.builder()
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .cookies(CookiesProperty.builder()
     *                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedCookies(List.of("excludedCookies"))
     *                                         .includedCookies(List.of("includedCookies"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .headers(HeadersProperty.builder()
     *                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                         .includedHeaders(List.of("includedHeaders"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .jsonBody(JsonBodyProperty.builder()
     *                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .includedPaths(List.of("includedPaths"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 // the properties below are optional
     *                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .method(method)
     *                         .queryString(queryString)
     *                         .singleHeader(singleHeader)
     *                         .singleQueryArgument(singleQueryArgument)
     *                         .uriPath(uriPath)
     *                         .build())
     *                 .positionalConstraint("positionalConstraint")
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 // the properties below are optional
     *                 .searchString("searchString")
     *                 .searchStringBase64("searchStringBase64")
     *                 .build())
     *         .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                 .countryCodes(List.of("countryCodes"))
     *                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .headerName("headerName")
     *                         .build())
     *                 .build())
     *         .ipSetReferenceStatement(Map.of(
     *                 "arn", "arn",
     *                 // the properties below are optional
     *                 "ipSetForwardedIpConfig", Map.of(
     *                         "fallbackBehavior", "fallbackBehavior",
     *                         "headerName", "headerName",
     *                         "position", "position")))
     *         .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                 .key("key")
     *                 .scope("scope")
     *                 .build())
     *         .notStatement(NotStatementProperty.builder()
     *                 .statement(StatementProperty.builder()
     *                         .andStatement(AndStatementProperty.builder()
     *                                 .statements(List.of(statementProperty_))
     *                                 .build())
     *                         .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .positionalConstraint("positionalConstraint")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .searchString("searchString")
     *                                 .searchStringBase64("searchStringBase64")
     *                                 .build())
     *                         .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                                 .countryCodes(List.of("countryCodes"))
     *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                         .fallbackBehavior("fallbackBehavior")
     *                                         .headerName("headerName")
     *                                         .build())
     *                                 .build())
     *                         .ipSetReferenceStatement(Map.of(
     *                                 "arn", "arn",
     *                                 // the properties below are optional
     *                                 "ipSetForwardedIpConfig", Map.of(
     *                                         "fallbackBehavior", "fallbackBehavior",
     *                                         "headerName", "headerName",
     *                                         "position", "position")))
     *                         .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                                 .key("key")
     *                                 .scope("scope")
     *                                 .build())
     *                         .notStatement(notStatementProperty_)
     *                         .orStatement(OrStatementProperty.builder()
     *                                 .statements(List.of(statementProperty_))
     *                                 .build())
     *                         .rateBasedStatement(RateBasedStatementProperty.builder()
     *                                 .aggregateKeyType("aggregateKeyType")
     *                                 .limit(123)
     *                                 // the properties below are optional
     *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                         .fallbackBehavior("fallbackBehavior")
     *                                         .headerName("headerName")
     *                                         .build())
     *                                 .scopeDownStatement(statementProperty_)
     *                                 .build())
     *                         .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .regexString("regexString")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                                 .arn("arn")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                                 .comparisonOperator("comparisonOperator")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .size(123)
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .sensitivityLevel("sensitivityLevel")
     *                                 .build())
     *                         .xssMatchStatement(XssMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .orStatement(OrStatementProperty.builder()
     *                 .statements(List.of(StatementProperty.builder()
     *                         .andStatement(AndStatementProperty.builder()
     *                                 .statements(List.of(statementProperty_))
     *                                 .build())
     *                         .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .positionalConstraint("positionalConstraint")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .searchString("searchString")
     *                                 .searchStringBase64("searchStringBase64")
     *                                 .build())
     *                         .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                                 .countryCodes(List.of("countryCodes"))
     *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                         .fallbackBehavior("fallbackBehavior")
     *                                         .headerName("headerName")
     *                                         .build())
     *                                 .build())
     *                         .ipSetReferenceStatement(Map.of(
     *                                 "arn", "arn",
     *                                 // the properties below are optional
     *                                 "ipSetForwardedIpConfig", Map.of(
     *                                         "fallbackBehavior", "fallbackBehavior",
     *                                         "headerName", "headerName",
     *                                         "position", "position")))
     *                         .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                                 .key("key")
     *                                 .scope("scope")
     *                                 .build())
     *                         .notStatement(NotStatementProperty.builder()
     *                                 .statement(statementProperty_)
     *                                 .build())
     *                         .orStatement(orStatementProperty_)
     *                         .rateBasedStatement(RateBasedStatementProperty.builder()
     *                                 .aggregateKeyType("aggregateKeyType")
     *                                 .limit(123)
     *                                 // the properties below are optional
     *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                         .fallbackBehavior("fallbackBehavior")
     *                                         .headerName("headerName")
     *                                         .build())
     *                                 .scopeDownStatement(statementProperty_)
     *                                 .build())
     *                         .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .regexString("regexString")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                                 .arn("arn")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                                 .comparisonOperator("comparisonOperator")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .size(123)
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .sensitivityLevel("sensitivityLevel")
     *                                 .build())
     *                         .xssMatchStatement(XssMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .rateBasedStatement(RateBasedStatementProperty.builder()
     *                 .aggregateKeyType("aggregateKeyType")
     *                 .limit(123)
     *                 // the properties below are optional
     *                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .headerName("headerName")
     *                         .build())
     *                 .scopeDownStatement(StatementProperty.builder()
     *                         .andStatement(AndStatementProperty.builder()
     *                                 .statements(List.of(statementProperty_))
     *                                 .build())
     *                         .byteMatchStatement(ByteMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .positionalConstraint("positionalConstraint")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .searchString("searchString")
     *                                 .searchStringBase64("searchStringBase64")
     *                                 .build())
     *                         .geoMatchStatement(GeoMatchStatementProperty.builder()
     *                                 .countryCodes(List.of("countryCodes"))
     *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                                         .fallbackBehavior("fallbackBehavior")
     *                                         .headerName("headerName")
     *                                         .build())
     *                                 .build())
     *                         .ipSetReferenceStatement(Map.of(
     *                                 "arn", "arn",
     *                                 // the properties below are optional
     *                                 "ipSetForwardedIpConfig", Map.of(
     *                                         "fallbackBehavior", "fallbackBehavior",
     *                                         "headerName", "headerName",
     *                                         "position", "position")))
     *                         .labelMatchStatement(LabelMatchStatementProperty.builder()
     *                                 .key("key")
     *                                 .scope("scope")
     *                                 .build())
     *                         .notStatement(NotStatementProperty.builder()
     *                                 .statement(statementProperty_)
     *                                 .build())
     *                         .orStatement(OrStatementProperty.builder()
     *                                 .statements(List.of(statementProperty_))
     *                                 .build())
     *                         .rateBasedStatement(rateBasedStatementProperty_)
     *                         .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .regexString("regexString")
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                                 .arn("arn")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                                 .comparisonOperator("comparisonOperator")
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .size(123)
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .sensitivityLevel("sensitivityLevel")
     *                                 .build())
     *                         .xssMatchStatement(XssMatchStatementProperty.builder()
     *                                 .fieldToMatch(FieldToMatchProperty.builder()
     *                                         .allQueryArguments(allQueryArguments)
     *                                         .body(BodyProperty.builder()
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .cookies(CookiesProperty.builder()
     *                                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedCookies(List.of("excludedCookies"))
     *                                                         .includedCookies(List.of("includedCookies"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .headers(HeadersProperty.builder()
     *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                                         .includedHeaders(List.of("includedHeaders"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .jsonBody(JsonBodyProperty.builder()
     *                                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                                         .all(all)
     *                                                         .includedPaths(List.of("includedPaths"))
     *                                                         .build())
     *                                                 .matchScope("matchScope")
     *                                                 // the properties below are optional
     *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                                 .oversizeHandling("oversizeHandling")
     *                                                 .build())
     *                                         .method(method)
     *                                         .queryString(queryString)
     *                                         .singleHeader(singleHeader)
     *                                         .singleQueryArgument(singleQueryArgument)
     *                                         .uriPath(uriPath)
     *                                         .build())
     *                                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                                         .priority(123)
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .regexMatchStatement(RegexMatchStatementProperty.builder()
     *                 .fieldToMatch(FieldToMatchProperty.builder()
     *                         .allQueryArguments(allQueryArguments)
     *                         .body(BodyProperty.builder()
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .cookies(CookiesProperty.builder()
     *                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedCookies(List.of("excludedCookies"))
     *                                         .includedCookies(List.of("includedCookies"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .headers(HeadersProperty.builder()
     *                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                         .includedHeaders(List.of("includedHeaders"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .jsonBody(JsonBodyProperty.builder()
     *                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .includedPaths(List.of("includedPaths"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 // the properties below are optional
     *                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .method(method)
     *                         .queryString(queryString)
     *                         .singleHeader(singleHeader)
     *                         .singleQueryArgument(singleQueryArgument)
     *                         .uriPath(uriPath)
     *                         .build())
     *                 .regexString("regexString")
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
     *                 .arn("arn")
     *                 .fieldToMatch(FieldToMatchProperty.builder()
     *                         .allQueryArguments(allQueryArguments)
     *                         .body(BodyProperty.builder()
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .cookies(CookiesProperty.builder()
     *                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedCookies(List.of("excludedCookies"))
     *                                         .includedCookies(List.of("includedCookies"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .headers(HeadersProperty.builder()
     *                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                         .includedHeaders(List.of("includedHeaders"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .jsonBody(JsonBodyProperty.builder()
     *                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .includedPaths(List.of("includedPaths"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 // the properties below are optional
     *                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .method(method)
     *                         .queryString(queryString)
     *                         .singleHeader(singleHeader)
     *                         .singleQueryArgument(singleQueryArgument)
     *                         .uriPath(uriPath)
     *                         .build())
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
     *                 .comparisonOperator("comparisonOperator")
     *                 .fieldToMatch(FieldToMatchProperty.builder()
     *                         .allQueryArguments(allQueryArguments)
     *                         .body(BodyProperty.builder()
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .cookies(CookiesProperty.builder()
     *                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedCookies(List.of("excludedCookies"))
     *                                         .includedCookies(List.of("includedCookies"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .headers(HeadersProperty.builder()
     *                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                         .includedHeaders(List.of("includedHeaders"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .jsonBody(JsonBodyProperty.builder()
     *                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .includedPaths(List.of("includedPaths"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 // the properties below are optional
     *                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .method(method)
     *                         .queryString(queryString)
     *                         .singleHeader(singleHeader)
     *                         .singleQueryArgument(singleQueryArgument)
     *                         .uriPath(uriPath)
     *                         .build())
     *                 .size(123)
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .sqliMatchStatement(SqliMatchStatementProperty.builder()
     *                 .fieldToMatch(FieldToMatchProperty.builder()
     *                         .allQueryArguments(allQueryArguments)
     *                         .body(BodyProperty.builder()
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .cookies(CookiesProperty.builder()
     *                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedCookies(List.of("excludedCookies"))
     *                                         .includedCookies(List.of("includedCookies"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .headers(HeadersProperty.builder()
     *                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                         .includedHeaders(List.of("includedHeaders"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .jsonBody(JsonBodyProperty.builder()
     *                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .includedPaths(List.of("includedPaths"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 // the properties below are optional
     *                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .method(method)
     *                         .queryString(queryString)
     *                         .singleHeader(singleHeader)
     *                         .singleQueryArgument(singleQueryArgument)
     *                         .uriPath(uriPath)
     *                         .build())
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 // the properties below are optional
     *                 .sensitivityLevel("sensitivityLevel")
     *                 .build())
     *         .xssMatchStatement(XssMatchStatementProperty.builder()
     *                 .fieldToMatch(FieldToMatchProperty.builder()
     *                         .allQueryArguments(allQueryArguments)
     *                         .body(BodyProperty.builder()
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .cookies(CookiesProperty.builder()
     *                                 .matchPattern(CookieMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedCookies(List.of("excludedCookies"))
     *                                         .includedCookies(List.of("includedCookies"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .headers(HeadersProperty.builder()
     *                                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .excludedHeaders(List.of("excludedHeaders"))
     *                                         .includedHeaders(List.of("includedHeaders"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .jsonBody(JsonBodyProperty.builder()
     *                                 .matchPattern(JsonMatchPatternProperty.builder()
     *                                         .all(all)
     *                                         .includedPaths(List.of("includedPaths"))
     *                                         .build())
     *                                 .matchScope("matchScope")
     *                                 // the properties below are optional
     *                                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                                 .oversizeHandling("oversizeHandling")
     *                                 .build())
     *                         .method(method)
     *                         .queryString(queryString)
     *                         .singleHeader(singleHeader)
     *                         .singleQueryArgument(singleQueryArgument)
     *                         .uriPath(uriPath)
     *                         .build())
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.StatementProperty")
    @software.amazon.jsii.Jsii.Proxy(StatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A logical rule statement used to combine other rule statements with AND logic.
         * <p>
         * You provide more than one <code>Statement</code> within the <code>AndStatement</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAndStatement() {
            return null;
        }

        /**
         * A rule statement that defines a string match search for AWS WAF to apply to web requests.
         * <p>
         * The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getByteMatchStatement() {
            return null;
        }

        /**
         * A rule statement used to identify web requests based on country of origin.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeoMatchStatement() {
            return null;
        }

        /**
         * A rule statement used to detect web requests coming from particular IP addresses or address ranges.
         * <p>
         * To use this, create an <code>IPSet</code> that specifies the addresses you want to detect, then use the ARN of that set in this statement.
         * <p>
         * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpSetReferenceStatement() {
            return null;
        }

        /**
         * A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL.
         * <p>
         * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLabelMatchStatement() {
            return null;
        }

        /**
         * A logical rule statement used to negate the results of another rule statement.
         * <p>
         * You provide one <code>Statement</code> within the <code>NotStatement</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotStatement() {
            return null;
        }

        /**
         * A logical rule statement used to combine other rule statements with OR logic.
         * <p>
         * You provide more than one <code>Statement</code> within the <code>OrStatement</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrStatement() {
            return null;
        }

        /**
         * A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.
         * <p>
         * You can use this to put a temporary block on requests from an IP address that is sending excessive requests.
         * <p>
         * AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
         * <p>
         * When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.
         * <p>
         * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:
         * <p>
         * <ul>
         * <li>An IP match statement with an IP set that specified the address 192.0.2.44.</li>
         * <li>A string match statement that searches in the User-Agent header for the string BadBot.</li>
         * </ul>
         * <p>
         * In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.
         * <p>
         * You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code> . You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRateBasedStatement() {
            return null;
        }

        /**
         * A rule statement used to search web request components for a match against a single regular expression.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegexMatchStatement() {
            return null;
        }

        /**
         * A rule statement used to search web request components for matches with regular expressions.
         * <p>
         * To use this, create a <code>RegexPatternSet</code> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.
         * <p>
         * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegexPatternSetReferenceStatement() {
            return null;
        }

        /**
         * A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).
         * <p>
         * For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
         * <p>
         * If you configure AWS WAF to inspect the request body, AWS WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you could use a size constraint statement to block requests that have a request body greater than 8192 bytes.
         * <p>
         * If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSizeConstraintStatement() {
            return null;
        }

        /**
         * A rule statement that inspects for malicious SQL code.
         * <p>
         * Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqliMatchStatement() {
            return null;
        }

        /**
         * A rule statement that inspects for cross-site scripting (XSS) attacks.
         * <p>
         * In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getXssMatchStatement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatementProperty> {
            java.lang.Object andStatement;
            java.lang.Object byteMatchStatement;
            java.lang.Object geoMatchStatement;
            java.lang.Object ipSetReferenceStatement;
            java.lang.Object labelMatchStatement;
            java.lang.Object notStatement;
            java.lang.Object orStatement;
            java.lang.Object rateBasedStatement;
            java.lang.Object regexMatchStatement;
            java.lang.Object regexPatternSetReferenceStatement;
            java.lang.Object sizeConstraintStatement;
            java.lang.Object sqliMatchStatement;
            java.lang.Object xssMatchStatement;

            /**
             * Sets the value of {@link StatementProperty#getAndStatement}
             * @param andStatement A logical rule statement used to combine other rule statements with AND logic.
             *                     You provide more than one <code>Statement</code> within the <code>AndStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.AndStatementProperty andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getAndStatement}
             * @param andStatement A logical rule statement used to combine other rule statements with AND logic.
             *                     You provide more than one <code>Statement</code> within the <code>AndStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andStatement(software.amazon.awscdk.IResolvable andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getByteMatchStatement}
             * @param byteMatchStatement A rule statement that defines a string match search for AWS WAF to apply to web requests.
             *                           The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder byteMatchStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.ByteMatchStatementProperty byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getByteMatchStatement}
             * @param byteMatchStatement A rule statement that defines a string match search for AWS WAF to apply to web requests.
             *                           The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder byteMatchStatement(software.amazon.awscdk.IResolvable byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getGeoMatchStatement}
             * @param geoMatchStatement A rule statement used to identify web requests based on country of origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoMatchStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.GeoMatchStatementProperty geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getGeoMatchStatement}
             * @param geoMatchStatement A rule statement used to identify web requests based on country of origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoMatchStatement(software.amazon.awscdk.IResolvable geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getIpSetReferenceStatement}
             * @param ipSetReferenceStatement A rule statement used to detect web requests coming from particular IP addresses or address ranges.
             *                                To use this, create an <code>IPSet</code> that specifies the addresses you want to detect, then use the ARN of that set in this statement.
             *                                <p>
             *                                Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetReferenceStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.IPSetReferenceStatementProperty ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getIpSetReferenceStatement}
             * @param ipSetReferenceStatement A rule statement used to detect web requests coming from particular IP addresses or address ranges.
             *                                To use this, create an <code>IPSet</code> that specifies the addresses you want to detect, then use the ARN of that set in this statement.
             *                                <p>
             *                                Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetReferenceStatement(software.amazon.awscdk.IResolvable ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getLabelMatchStatement}
             * @param labelMatchStatement A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL.
             *                            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelMatchStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.LabelMatchStatementProperty labelMatchStatement) {
                this.labelMatchStatement = labelMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getLabelMatchStatement}
             * @param labelMatchStatement A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL.
             *                            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelMatchStatement(software.amazon.awscdk.IResolvable labelMatchStatement) {
                this.labelMatchStatement = labelMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getNotStatement}
             * @param notStatement A logical rule statement used to negate the results of another rule statement.
             *                     You provide one <code>Statement</code> within the <code>NotStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.NotStatementProperty notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getNotStatement}
             * @param notStatement A logical rule statement used to negate the results of another rule statement.
             *                     You provide one <code>Statement</code> within the <code>NotStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notStatement(software.amazon.awscdk.IResolvable notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getOrStatement}
             * @param orStatement A logical rule statement used to combine other rule statements with OR logic.
             *                    You provide more than one <code>Statement</code> within the <code>OrStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.OrStatementProperty orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getOrStatement}
             * @param orStatement A logical rule statement used to combine other rule statements with OR logic.
             *                    You provide more than one <code>Statement</code> within the <code>OrStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orStatement(software.amazon.awscdk.IResolvable orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getRateBasedStatement}
             * @param rateBasedStatement A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.
             *                           You can use this to put a temporary block on requests from an IP address that is sending excessive requests.
             *                           <p>
             *                           AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
             *                           <p>
             *                           When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.
             *                           <p>
             *                           You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:
             *                           <p>
             *                           <ul>
             *                           <li>An IP match statement with an IP set that specified the address 192.0.2.44.</li>
             *                           <li>A string match statement that searches in the User-Agent header for the string BadBot.</li>
             *                           </ul>
             *                           <p>
             *                           In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.
             *                           <p>
             *                           You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code> . You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateBasedStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.RateBasedStatementProperty rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getRateBasedStatement}
             * @param rateBasedStatement A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.
             *                           You can use this to put a temporary block on requests from an IP address that is sending excessive requests.
             *                           <p>
             *                           AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
             *                           <p>
             *                           When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.
             *                           <p>
             *                           You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:
             *                           <p>
             *                           <ul>
             *                           <li>An IP match statement with an IP set that specified the address 192.0.2.44.</li>
             *                           <li>A string match statement that searches in the User-Agent header for the string BadBot.</li>
             *                           </ul>
             *                           <p>
             *                           In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.
             *                           <p>
             *                           You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code> . You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateBasedStatement(software.amazon.awscdk.IResolvable rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getRegexMatchStatement}
             * @param regexMatchStatement A rule statement used to search web request components for a match against a single regular expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexMatchStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.RegexMatchStatementProperty regexMatchStatement) {
                this.regexMatchStatement = regexMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getRegexMatchStatement}
             * @param regexMatchStatement A rule statement used to search web request components for a match against a single regular expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexMatchStatement(software.amazon.awscdk.IResolvable regexMatchStatement) {
                this.regexMatchStatement = regexMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getRegexPatternSetReferenceStatement}
             * @param regexPatternSetReferenceStatement A rule statement used to search web request components for matches with regular expressions.
             *                                          To use this, create a <code>RegexPatternSet</code> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.
             *                                          <p>
             *                                          Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexPatternSetReferenceStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getRegexPatternSetReferenceStatement}
             * @param regexPatternSetReferenceStatement A rule statement used to search web request components for matches with regular expressions.
             *                                          To use this, create a <code>RegexPatternSet</code> that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.
             *                                          <p>
             *                                          Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexPatternSetReferenceStatement(software.amazon.awscdk.IResolvable regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getSizeConstraintStatement}
             * @param sizeConstraintStatement A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).
             *                                For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
             *                                <p>
             *                                If you configure AWS WAF to inspect the request body, AWS WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you could use a size constraint statement to block requests that have a request body greater than 8192 bytes.
             *                                <p>
             *                                If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeConstraintStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.SizeConstraintStatementProperty sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getSizeConstraintStatement}
             * @param sizeConstraintStatement A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).
             *                                For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
             *                                <p>
             *                                If you configure AWS WAF to inspect the request body, AWS WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you could use a size constraint statement to block requests that have a request body greater than 8192 bytes.
             *                                <p>
             *                                If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI <code>/logo.jpg</code> is nine characters long.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeConstraintStatement(software.amazon.awscdk.IResolvable sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getSqliMatchStatement}
             * @param sqliMatchStatement A rule statement that inspects for malicious SQL code.
             *                           Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqliMatchStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.SqliMatchStatementProperty sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getSqliMatchStatement}
             * @param sqliMatchStatement A rule statement that inspects for malicious SQL code.
             *                           Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqliMatchStatement(software.amazon.awscdk.IResolvable sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getXssMatchStatement}
             * @param xssMatchStatement A rule statement that inspects for cross-site scripting (XSS) attacks.
             *                          In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xssMatchStatement(software.amazon.awscdk.services.wafv2.CfnRuleGroup.XssMatchStatementProperty xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            /**
             * Sets the value of {@link StatementProperty#getXssMatchStatement}
             * @param xssMatchStatement A rule statement that inspects for cross-site scripting (XSS) attacks.
             *                          In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xssMatchStatement(software.amazon.awscdk.IResolvable xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatementProperty {
            private final java.lang.Object andStatement;
            private final java.lang.Object byteMatchStatement;
            private final java.lang.Object geoMatchStatement;
            private final java.lang.Object ipSetReferenceStatement;
            private final java.lang.Object labelMatchStatement;
            private final java.lang.Object notStatement;
            private final java.lang.Object orStatement;
            private final java.lang.Object rateBasedStatement;
            private final java.lang.Object regexMatchStatement;
            private final java.lang.Object regexPatternSetReferenceStatement;
            private final java.lang.Object sizeConstraintStatement;
            private final java.lang.Object sqliMatchStatement;
            private final java.lang.Object xssMatchStatement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.andStatement = software.amazon.jsii.Kernel.get(this, "andStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.byteMatchStatement = software.amazon.jsii.Kernel.get(this, "byteMatchStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.geoMatchStatement = software.amazon.jsii.Kernel.get(this, "geoMatchStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipSetReferenceStatement = software.amazon.jsii.Kernel.get(this, "ipSetReferenceStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.labelMatchStatement = software.amazon.jsii.Kernel.get(this, "labelMatchStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.notStatement = software.amazon.jsii.Kernel.get(this, "notStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.orStatement = software.amazon.jsii.Kernel.get(this, "orStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rateBasedStatement = software.amazon.jsii.Kernel.get(this, "rateBasedStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regexMatchStatement = software.amazon.jsii.Kernel.get(this, "regexMatchStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regexPatternSetReferenceStatement = software.amazon.jsii.Kernel.get(this, "regexPatternSetReferenceStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sizeConstraintStatement = software.amazon.jsii.Kernel.get(this, "sizeConstraintStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqliMatchStatement = software.amazon.jsii.Kernel.get(this, "sqliMatchStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.xssMatchStatement = software.amazon.jsii.Kernel.get(this, "xssMatchStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.andStatement = builder.andStatement;
                this.byteMatchStatement = builder.byteMatchStatement;
                this.geoMatchStatement = builder.geoMatchStatement;
                this.ipSetReferenceStatement = builder.ipSetReferenceStatement;
                this.labelMatchStatement = builder.labelMatchStatement;
                this.notStatement = builder.notStatement;
                this.orStatement = builder.orStatement;
                this.rateBasedStatement = builder.rateBasedStatement;
                this.regexMatchStatement = builder.regexMatchStatement;
                this.regexPatternSetReferenceStatement = builder.regexPatternSetReferenceStatement;
                this.sizeConstraintStatement = builder.sizeConstraintStatement;
                this.sqliMatchStatement = builder.sqliMatchStatement;
                this.xssMatchStatement = builder.xssMatchStatement;
            }

            @Override
            public final java.lang.Object getAndStatement() {
                return this.andStatement;
            }

            @Override
            public final java.lang.Object getByteMatchStatement() {
                return this.byteMatchStatement;
            }

            @Override
            public final java.lang.Object getGeoMatchStatement() {
                return this.geoMatchStatement;
            }

            @Override
            public final java.lang.Object getIpSetReferenceStatement() {
                return this.ipSetReferenceStatement;
            }

            @Override
            public final java.lang.Object getLabelMatchStatement() {
                return this.labelMatchStatement;
            }

            @Override
            public final java.lang.Object getNotStatement() {
                return this.notStatement;
            }

            @Override
            public final java.lang.Object getOrStatement() {
                return this.orStatement;
            }

            @Override
            public final java.lang.Object getRateBasedStatement() {
                return this.rateBasedStatement;
            }

            @Override
            public final java.lang.Object getRegexMatchStatement() {
                return this.regexMatchStatement;
            }

            @Override
            public final java.lang.Object getRegexPatternSetReferenceStatement() {
                return this.regexPatternSetReferenceStatement;
            }

            @Override
            public final java.lang.Object getSizeConstraintStatement() {
                return this.sizeConstraintStatement;
            }

            @Override
            public final java.lang.Object getSqliMatchStatement() {
                return this.sqliMatchStatement;
            }

            @Override
            public final java.lang.Object getXssMatchStatement() {
                return this.xssMatchStatement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAndStatement() != null) {
                    data.set("andStatement", om.valueToTree(this.getAndStatement()));
                }
                if (this.getByteMatchStatement() != null) {
                    data.set("byteMatchStatement", om.valueToTree(this.getByteMatchStatement()));
                }
                if (this.getGeoMatchStatement() != null) {
                    data.set("geoMatchStatement", om.valueToTree(this.getGeoMatchStatement()));
                }
                if (this.getIpSetReferenceStatement() != null) {
                    data.set("ipSetReferenceStatement", om.valueToTree(this.getIpSetReferenceStatement()));
                }
                if (this.getLabelMatchStatement() != null) {
                    data.set("labelMatchStatement", om.valueToTree(this.getLabelMatchStatement()));
                }
                if (this.getNotStatement() != null) {
                    data.set("notStatement", om.valueToTree(this.getNotStatement()));
                }
                if (this.getOrStatement() != null) {
                    data.set("orStatement", om.valueToTree(this.getOrStatement()));
                }
                if (this.getRateBasedStatement() != null) {
                    data.set("rateBasedStatement", om.valueToTree(this.getRateBasedStatement()));
                }
                if (this.getRegexMatchStatement() != null) {
                    data.set("regexMatchStatement", om.valueToTree(this.getRegexMatchStatement()));
                }
                if (this.getRegexPatternSetReferenceStatement() != null) {
                    data.set("regexPatternSetReferenceStatement", om.valueToTree(this.getRegexPatternSetReferenceStatement()));
                }
                if (this.getSizeConstraintStatement() != null) {
                    data.set("sizeConstraintStatement", om.valueToTree(this.getSizeConstraintStatement()));
                }
                if (this.getSqliMatchStatement() != null) {
                    data.set("sqliMatchStatement", om.valueToTree(this.getSqliMatchStatement()));
                }
                if (this.getXssMatchStatement() != null) {
                    data.set("xssMatchStatement", om.valueToTree(this.getXssMatchStatement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.StatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatementProperty.Jsii$Proxy that = (StatementProperty.Jsii$Proxy) o;

                if (this.andStatement != null ? !this.andStatement.equals(that.andStatement) : that.andStatement != null) return false;
                if (this.byteMatchStatement != null ? !this.byteMatchStatement.equals(that.byteMatchStatement) : that.byteMatchStatement != null) return false;
                if (this.geoMatchStatement != null ? !this.geoMatchStatement.equals(that.geoMatchStatement) : that.geoMatchStatement != null) return false;
                if (this.ipSetReferenceStatement != null ? !this.ipSetReferenceStatement.equals(that.ipSetReferenceStatement) : that.ipSetReferenceStatement != null) return false;
                if (this.labelMatchStatement != null ? !this.labelMatchStatement.equals(that.labelMatchStatement) : that.labelMatchStatement != null) return false;
                if (this.notStatement != null ? !this.notStatement.equals(that.notStatement) : that.notStatement != null) return false;
                if (this.orStatement != null ? !this.orStatement.equals(that.orStatement) : that.orStatement != null) return false;
                if (this.rateBasedStatement != null ? !this.rateBasedStatement.equals(that.rateBasedStatement) : that.rateBasedStatement != null) return false;
                if (this.regexMatchStatement != null ? !this.regexMatchStatement.equals(that.regexMatchStatement) : that.regexMatchStatement != null) return false;
                if (this.regexPatternSetReferenceStatement != null ? !this.regexPatternSetReferenceStatement.equals(that.regexPatternSetReferenceStatement) : that.regexPatternSetReferenceStatement != null) return false;
                if (this.sizeConstraintStatement != null ? !this.sizeConstraintStatement.equals(that.sizeConstraintStatement) : that.sizeConstraintStatement != null) return false;
                if (this.sqliMatchStatement != null ? !this.sqliMatchStatement.equals(that.sqliMatchStatement) : that.sqliMatchStatement != null) return false;
                return this.xssMatchStatement != null ? this.xssMatchStatement.equals(that.xssMatchStatement) : that.xssMatchStatement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.andStatement != null ? this.andStatement.hashCode() : 0;
                result = 31 * result + (this.byteMatchStatement != null ? this.byteMatchStatement.hashCode() : 0);
                result = 31 * result + (this.geoMatchStatement != null ? this.geoMatchStatement.hashCode() : 0);
                result = 31 * result + (this.ipSetReferenceStatement != null ? this.ipSetReferenceStatement.hashCode() : 0);
                result = 31 * result + (this.labelMatchStatement != null ? this.labelMatchStatement.hashCode() : 0);
                result = 31 * result + (this.notStatement != null ? this.notStatement.hashCode() : 0);
                result = 31 * result + (this.orStatement != null ? this.orStatement.hashCode() : 0);
                result = 31 * result + (this.rateBasedStatement != null ? this.rateBasedStatement.hashCode() : 0);
                result = 31 * result + (this.regexMatchStatement != null ? this.regexMatchStatement.hashCode() : 0);
                result = 31 * result + (this.regexPatternSetReferenceStatement != null ? this.regexPatternSetReferenceStatement.hashCode() : 0);
                result = 31 * result + (this.sizeConstraintStatement != null ? this.sizeConstraintStatement.hashCode() : 0);
                result = 31 * result + (this.sqliMatchStatement != null ? this.sqliMatchStatement.hashCode() : 0);
                result = 31 * result + (this.xssMatchStatement != null ? this.xssMatchStatement.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * TextTransformationProperty textTransformationProperty = TextTransformationProperty.builder()
     *         .priority(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.TextTransformationProperty")
    @software.amazon.jsii.Jsii.Proxy(TextTransformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextTransformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets the relative processing order for multiple transformations that are defined for a rule statement.
         * <p>
         * AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * You can specify the following transformation types:.
         * <p>
         * <em>BASE64_DECODE</em> - Decode a <code>Base64</code> -encoded string.
         * <p>
         * <em>BASE64_DECODE_EXT</em> - Decode a <code>Base64</code> -encoded string, but use a forgiving implementation that ignores characters that aren't valid.
         * <p>
         * <em>CMD_LINE</em> - Command-line transformations. These are helpful in reducing effectiveness of attackers who inject an operating system command-line command and use unusual formatting to disguise some or all of the command.
         * <p>
         * <ul>
         * <li>Delete the following characters: <code>\ " ' ^</code></li>
         * <li>Delete spaces before the following characters: <code>/ (</code></li>
         * <li>Replace the following characters with a space: <code>, ;</code></li>
         * <li>Replace multiple spaces with one space</li>
         * <li>Convert uppercase letters (A-Z) to lowercase (a-z)</li>
         * </ul>
         * <p>
         * <em>COMPRESS_WHITE_SPACE</em> - Replace these characters with a space character (decimal 32):
         * <p>
         * <ul>
         * <li><code>\f</code> , formfeed, decimal 12</li>
         * <li><code>\t</code> , tab, decimal 9</li>
         * <li><code>\n</code> , newline, decimal 10</li>
         * <li><code>\r</code> , carriage return, decimal 13</li>
         * <li><code>\v</code> , vertical tab, decimal 11</li>
         * <li>Non-breaking space, decimal 160</li>
         * </ul>
         * <p>
         * <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.
         * <p>
         * <em>CSS_DECODE</em> - Decode characters that were encoded using CSS 2.x escape rules <code>syndata.html#characters</code> . This function uses up to two bytes in the decoding process, so it can help to uncover ASCII characters that were encoded using CSS encoding that wouldn’t typically be encoded. It's also useful in countering evasion, which is a combination of a backslash and non-hexadecimal characters. For example, <code>ja\vascript</code> for javascript.
         * <p>
         * <em>ESCAPE_SEQ_DECODE</em> - Decode the following ANSI C escape sequences: <code>\a</code> , <code>\b</code> , <code>\f</code> , <code>\n</code> , <code>\r</code> , <code>\t</code> , <code>\v</code> , <code>\\</code> , <code>\?</code> , <code>\'</code> , <code>\"</code> , <code>\xHH</code> (hexadecimal), <code>\0OOO</code> (octal). Encodings that aren't valid remain in the output.
         * <p>
         * <em>HEX_DECODE</em> - Decode a string of hexadecimal characters into a binary.
         * <p>
         * <em>HTML_ENTITY_DECODE</em> - Replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs these operations:
         * <p>
         * <ul>
         * <li>Replaces <code>(ampersand)quot;</code> with <code>"</code></li>
         * <li>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</li>
         * <li>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</li>
         * <li>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code></li>
         * <li>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code> , with the corresponding characters</li>
         * <li>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code> , with the corresponding characters</li>
         * </ul>
         * <p>
         * <em>JS_DECODE</em> - Decode JavaScript escape sequences. If a <code>\</code> <code>u</code> <code>HHHH</code> code is in the full-width ASCII code range of <code>FF01-FF5E</code> , then the higher byte is used to detect and adjust the lower byte. If not, only the lower byte is used and the higher byte is zeroed, causing a possible loss of information.
         * <p>
         * <em>LOWERCASE</em> - Convert uppercase letters (A-Z) to lowercase (a-z).
         * <p>
         * <em>MD5</em> - Calculate an MD5 hash from the data in the input. The computed hash is in a raw binary form.
         * <p>
         * <em>NONE</em> - Specify <code>NONE</code> if you don't want any text transformations.
         * <p>
         * <em>NORMALIZE_PATH</em> - Remove multiple slashes, directory self-references, and directory back-references that are not at the beginning of the input from an input string.
         * <p>
         * <em>NORMALIZE_PATH_WIN</em> - This is the same as <code>NORMALIZE_PATH</code> , but first converts backslash characters to forward slashes.
         * <p>
         * <em>REMOVE_NULLS</em> - Remove all <code>NULL</code> bytes from the input.
         * <p>
         * <em>REPLACE_COMMENTS</em> - Replace each occurrence of a C-style comment ( <code>/* ... * /</code> ) with a single space. Multiple consecutive occurrences are not compressed. Unterminated comments are also replaced with a space (ASCII 0x20). However, a standalone termination of a comment ( <code>* /</code> ) is not acted upon.
         * <p>
         * <em>REPLACE_NULLS</em> - Replace NULL bytes in the input with space characters (ASCII <code>0x20</code> ).
         * <p>
         * <em>SQL_HEX_DECODE</em> - Decode SQL hex data. Example ( <code>0x414243</code> ) will be decoded to ( <code>ABC</code> ).
         * <p>
         * <em>URL_DECODE</em> - Decode a URL-encoded value.
         * <p>
         * <em>URL_DECODE_UNI</em> - Like <code>URL_DECODE</code> , but with support for Microsoft-specific <code>%u</code> encoding. If the code is in the full-width ASCII code range of <code>FF01-FF5E</code> , the higher byte is used to detect and adjust the lower byte. Otherwise, only the lower byte is used and the higher byte is zeroed.
         * <p>
         * <em>UTF8_TO_UNICODE</em> - Convert all UTF-8 character sequences to Unicode. This helps input normalization, and minimizing false-positives and false-negatives for non-English languages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link TextTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextTransformationProperty> {
            java.lang.Number priority;
            java.lang.String type;

            /**
             * Sets the value of {@link TextTransformationProperty#getPriority}
             * @param priority Sets the relative processing order for multiple transformations that are defined for a rule statement. This parameter is required.
             *                 AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link TextTransformationProperty#getType}
             * @param type You can specify the following transformation types:. This parameter is required.
             *             <em>BASE64_DECODE</em> - Decode a <code>Base64</code> -encoded string.
             *             <p>
             *             <em>BASE64_DECODE_EXT</em> - Decode a <code>Base64</code> -encoded string, but use a forgiving implementation that ignores characters that aren't valid.
             *             <p>
             *             <em>CMD_LINE</em> - Command-line transformations. These are helpful in reducing effectiveness of attackers who inject an operating system command-line command and use unusual formatting to disguise some or all of the command.
             *             <p>
             *             <ul>
             *             <li>Delete the following characters: <code>\ " ' ^</code></li>
             *             <li>Delete spaces before the following characters: <code>/ (</code></li>
             *             <li>Replace the following characters with a space: <code>, ;</code></li>
             *             <li>Replace multiple spaces with one space</li>
             *             <li>Convert uppercase letters (A-Z) to lowercase (a-z)</li>
             *             </ul>
             *             <p>
             *             <em>COMPRESS_WHITE_SPACE</em> - Replace these characters with a space character (decimal 32):
             *             <p>
             *             <ul>
             *             <li><code>\f</code> , formfeed, decimal 12</li>
             *             <li><code>\t</code> , tab, decimal 9</li>
             *             <li><code>\n</code> , newline, decimal 10</li>
             *             <li><code>\r</code> , carriage return, decimal 13</li>
             *             <li><code>\v</code> , vertical tab, decimal 11</li>
             *             <li>Non-breaking space, decimal 160</li>
             *             </ul>
             *             <p>
             *             <code>COMPRESS_WHITE_SPACE</code> also replaces multiple spaces with one space.
             *             <p>
             *             <em>CSS_DECODE</em> - Decode characters that were encoded using CSS 2.x escape rules <code>syndata.html#characters</code> . This function uses up to two bytes in the decoding process, so it can help to uncover ASCII characters that were encoded using CSS encoding that wouldn’t typically be encoded. It's also useful in countering evasion, which is a combination of a backslash and non-hexadecimal characters. For example, <code>ja\vascript</code> for javascript.
             *             <p>
             *             <em>ESCAPE_SEQ_DECODE</em> - Decode the following ANSI C escape sequences: <code>\a</code> , <code>\b</code> , <code>\f</code> , <code>\n</code> , <code>\r</code> , <code>\t</code> , <code>\v</code> , <code>\\</code> , <code>\?</code> , <code>\'</code> , <code>\"</code> , <code>\xHH</code> (hexadecimal), <code>\0OOO</code> (octal). Encodings that aren't valid remain in the output.
             *             <p>
             *             <em>HEX_DECODE</em> - Decode a string of hexadecimal characters into a binary.
             *             <p>
             *             <em>HTML_ENTITY_DECODE</em> - Replace HTML-encoded characters with unencoded characters. <code>HTML_ENTITY_DECODE</code> performs these operations:
             *             <p>
             *             <ul>
             *             <li>Replaces <code>(ampersand)quot;</code> with <code>"</code></li>
             *             <li>Replaces <code>(ampersand)nbsp;</code> with a non-breaking space, decimal 160</li>
             *             <li>Replaces <code>(ampersand)lt;</code> with a "less than" symbol</li>
             *             <li>Replaces <code>(ampersand)gt;</code> with <code>&gt;</code></li>
             *             <li>Replaces characters that are represented in hexadecimal format, <code>(ampersand)#xhhhh;</code> , with the corresponding characters</li>
             *             <li>Replaces characters that are represented in decimal format, <code>(ampersand)#nnnn;</code> , with the corresponding characters</li>
             *             </ul>
             *             <p>
             *             <em>JS_DECODE</em> - Decode JavaScript escape sequences. If a <code>\</code> <code>u</code> <code>HHHH</code> code is in the full-width ASCII code range of <code>FF01-FF5E</code> , then the higher byte is used to detect and adjust the lower byte. If not, only the lower byte is used and the higher byte is zeroed, causing a possible loss of information.
             *             <p>
             *             <em>LOWERCASE</em> - Convert uppercase letters (A-Z) to lowercase (a-z).
             *             <p>
             *             <em>MD5</em> - Calculate an MD5 hash from the data in the input. The computed hash is in a raw binary form.
             *             <p>
             *             <em>NONE</em> - Specify <code>NONE</code> if you don't want any text transformations.
             *             <p>
             *             <em>NORMALIZE_PATH</em> - Remove multiple slashes, directory self-references, and directory back-references that are not at the beginning of the input from an input string.
             *             <p>
             *             <em>NORMALIZE_PATH_WIN</em> - This is the same as <code>NORMALIZE_PATH</code> , but first converts backslash characters to forward slashes.
             *             <p>
             *             <em>REMOVE_NULLS</em> - Remove all <code>NULL</code> bytes from the input.
             *             <p>
             *             <em>REPLACE_COMMENTS</em> - Replace each occurrence of a C-style comment ( <code>/* ... * /</code> ) with a single space. Multiple consecutive occurrences are not compressed. Unterminated comments are also replaced with a space (ASCII 0x20). However, a standalone termination of a comment ( <code>* /</code> ) is not acted upon.
             *             <p>
             *             <em>REPLACE_NULLS</em> - Replace NULL bytes in the input with space characters (ASCII <code>0x20</code> ).
             *             <p>
             *             <em>SQL_HEX_DECODE</em> - Decode SQL hex data. Example ( <code>0x414243</code> ) will be decoded to ( <code>ABC</code> ).
             *             <p>
             *             <em>URL_DECODE</em> - Decode a URL-encoded value.
             *             <p>
             *             <em>URL_DECODE_UNI</em> - Like <code>URL_DECODE</code> , but with support for Microsoft-specific <code>%u</code> encoding. If the code is in the full-width ASCII code range of <code>FF01-FF5E</code> , the higher byte is used to detect and adjust the lower byte. Otherwise, only the lower byte is used and the higher byte is zeroed.
             *             <p>
             *             <em>UTF8_TO_UNICODE</em> - Convert all UTF-8 character sequences to Unicode. This helps input normalization, and minimizing false-positives and false-negatives for non-English languages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextTransformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextTransformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextTransformationProperty {
            private final java.lang.Number priority;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("priority", om.valueToTree(this.getPriority()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.TextTransformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextTransformationProperty.Jsii$Proxy that = (TextTransformationProperty.Jsii$Proxy) o;

                if (!priority.equals(that.priority)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.priority.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * VisibilityConfigProperty visibilityConfigProperty = VisibilityConfigProperty.builder()
     *         .cloudWatchMetricsEnabled(false)
     *         .metricName("metricName")
     *         .sampledRequestsEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.VisibilityConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VisibilityConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VisibilityConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch.
         * <p>
         * For the list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">AWS WAF Metrics</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatchMetricsEnabled();

        /**
         * A name of the Amazon CloudWatch metric.
         * <p>
         * The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names reserved for AWS WAF , for example "All" and "Default_Action."
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules.
         * <p>
         * You can view the sampled requests through the AWS WAF console.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSampledRequestsEnabled();

        /**
         * @return a {@link Builder} of {@link VisibilityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VisibilityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VisibilityConfigProperty> {
            java.lang.Object cloudWatchMetricsEnabled;
            java.lang.String metricName;
            java.lang.Object sampledRequestsEnabled;

            /**
             * Sets the value of {@link VisibilityConfigProperty#getCloudWatchMetricsEnabled}
             * @param cloudWatchMetricsEnabled A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. This parameter is required.
             *                                 For the list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">AWS WAF Metrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchMetricsEnabled(java.lang.Boolean cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link VisibilityConfigProperty#getCloudWatchMetricsEnabled}
             * @param cloudWatchMetricsEnabled A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. This parameter is required.
             *                                 For the list of available metrics, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics">AWS WAF Metrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchMetricsEnabled(software.amazon.awscdk.IResolvable cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link VisibilityConfigProperty#getMetricName}
             * @param metricName A name of the Amazon CloudWatch metric. This parameter is required.
             *                   The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names reserved for AWS WAF , for example "All" and "Default_Action."
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link VisibilityConfigProperty#getSampledRequestsEnabled}
             * @param sampledRequestsEnabled A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. This parameter is required.
             *                               You can view the sampled requests through the AWS WAF console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampledRequestsEnabled(java.lang.Boolean sampledRequestsEnabled) {
                this.sampledRequestsEnabled = sampledRequestsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link VisibilityConfigProperty#getSampledRequestsEnabled}
             * @param sampledRequestsEnabled A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. This parameter is required.
             *                               You can view the sampled requests through the AWS WAF console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampledRequestsEnabled(software.amazon.awscdk.IResolvable sampledRequestsEnabled) {
                this.sampledRequestsEnabled = sampledRequestsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VisibilityConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VisibilityConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VisibilityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VisibilityConfigProperty {
            private final java.lang.Object cloudWatchMetricsEnabled;
            private final java.lang.String metricName;
            private final java.lang.Object sampledRequestsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchMetricsEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampledRequestsEnabled = software.amazon.jsii.Kernel.get(this, "sampledRequestsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchMetricsEnabled = java.util.Objects.requireNonNull(builder.cloudWatchMetricsEnabled, "cloudWatchMetricsEnabled is required");
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.sampledRequestsEnabled = java.util.Objects.requireNonNull(builder.sampledRequestsEnabled, "sampledRequestsEnabled is required");
            }

            @Override
            public final java.lang.Object getCloudWatchMetricsEnabled() {
                return this.cloudWatchMetricsEnabled;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.Object getSampledRequestsEnabled() {
                return this.sampledRequestsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchMetricsEnabled", om.valueToTree(this.getCloudWatchMetricsEnabled()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("sampledRequestsEnabled", om.valueToTree(this.getSampledRequestsEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.VisibilityConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VisibilityConfigProperty.Jsii$Proxy that = (VisibilityConfigProperty.Jsii$Proxy) o;

                if (!cloudWatchMetricsEnabled.equals(that.cloudWatchMetricsEnabled)) return false;
                if (!metricName.equals(that.metricName)) return false;
                return this.sampledRequestsEnabled.equals(that.sampledRequestsEnabled);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchMetricsEnabled.hashCode();
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.sampledRequestsEnabled.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement that inspects for cross-site scripting (XSS) attacks.
     * <p>
     * In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * XssMatchStatementProperty xssMatchStatementProperty = XssMatchStatementProperty.builder()
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriPath(uriPath)
     *                 .build())
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroup.XssMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(XssMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface XssMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of the web request that you want AWS WAF to inspect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link XssMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link XssMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<XssMatchStatementProperty> {
            java.lang.Object fieldToMatch;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link XssMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnRuleGroup.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link XssMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link XssMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link XssMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link XssMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public XssMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link XssMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements XssMatchStatementProperty {
            private final java.lang.Object fieldToMatch;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroup.XssMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                XssMatchStatementProperty.Jsii$Proxy that = (XssMatchStatementProperty.Jsii$Proxy) o;

                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldToMatch.hashCode();
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wafv2.CfnRuleGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wafv2.CfnRuleGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wafv2.CfnRuleGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wafv2.CfnRuleGroupProps.Builder();
        }

        /**
         * The web ACL capacity units (WCUs) required for this rule group.
         * <p>
         * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.
         * <p>
         * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
         * <p>
         * @return {@code this}
         * @param capacity The web ACL capacity units (WCUs) required for this rule group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(final java.lang.Number capacity) {
            this.props.capacity(capacity);
            return this;
        }

        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
         * <p>
         * A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AWS AppSync GraphQL API. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
         * <p>
         * <blockquote>
         * <p>
         * For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param scope Specifies whether this is for an Amazon CloudFront distribution or for a regional application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(final java.lang.String scope) {
            this.props.scope(scope);
            return this;
        }

        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * <p>
         * @return {@code this}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(final software.amazon.awscdk.services.wafv2.CfnRuleGroup.VisibilityConfigProperty visibilityConfig) {
            this.props.visibilityConfig(visibilityConfig);
            return this;
        }
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * <p>
         * @return {@code this}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(final software.amazon.awscdk.IResolvable visibilityConfig) {
            this.props.visibilityConfig(visibilityConfig);
            return this;
        }

        /**
         * A map of custom response keys and content bodies.
         * <p>
         * When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
         * <p>
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         * <p>
         * @return {@code this}
         * @param customResponseBodies A map of custom response keys and content bodies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(final software.amazon.awscdk.IResolvable customResponseBodies) {
            this.props.customResponseBodies(customResponseBodies);
            return this;
        }
        /**
         * A map of custom response keys and content bodies.
         * <p>
         * When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
         * <p>
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         * <p>
         * @return {@code this}
         * @param customResponseBodies A map of custom response keys and content bodies. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(final java.util.Map<java.lang.String, ? extends java.lang.Object> customResponseBodies) {
            this.props.customResponseBodies(customResponseBodies);
            return this;
        }

        /**
         * A description of the rule group that helps with identification.
         * <p>
         * @return {@code this}
         * @param description A description of the rule group that helps with identification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the rule group.
         * <p>
         * You cannot change the name of a rule group after you create it.
         * <p>
         * @return {@code this}
         * @param name The name of the rule group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The rule statements used to identify the web requests that you want to allow, block, or count.
         * <p>
         * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * <p>
         * @return {@code this}
         * @param rules The rule statements used to identify the web requests that you want to allow, block, or count. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final software.amazon.awscdk.IResolvable rules) {
            this.props.rules(rules);
            return this;
        }
        /**
         * The rule statements used to identify the web requests that you want to allow, block, or count.
         * <p>
         * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * <p>
         * @return {@code this}
         * @param rules The rule statements used to identify the web requests that you want to allow, block, or count. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final java.util.List<? extends java.lang.Object> rules) {
            this.props.rules(rules);
            return this;
        }

        /**
         * Key:value pairs associated with an AWS resource.
         * <p>
         * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
         * <p>
         * <blockquote>
         * <p>
         * To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tags Key:value pairs associated with an AWS resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.wafv2.CfnRuleGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wafv2.CfnRuleGroup build() {
            return new software.amazon.awscdk.services.wafv2.CfnRuleGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
