package software.amazon.awscdk.services.wafv2;

/**
 * Properties for defining a `CfnWebACL`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * Object all;
 * Object allQueryArguments;
 * Object count;
 * Object method;
 * Object none;
 * Object queryString;
 * Object singleHeader;
 * Object singleQueryArgument;
 * StatementProperty statementProperty_;
 * Object uriPath;
 * CfnWebACLProps cfnWebACLProps = CfnWebACLProps.builder()
 *         .defaultAction(DefaultActionProperty.builder()
 *                 .allow(AllowActionProperty.builder()
 *                         .customRequestHandling(CustomRequestHandlingProperty.builder()
 *                                 .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .block(BlockActionProperty.builder()
 *                         .customResponse(CustomResponseProperty.builder()
 *                                 .responseCode(123)
 *                                 // the properties below are optional
 *                                 .customResponseBodyKey("customResponseBodyKey")
 *                                 .responseHeaders(List.of(CustomHTTPHeaderProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .scope("scope")
 *         .visibilityConfig(VisibilityConfigProperty.builder()
 *                 .cloudWatchMetricsEnabled(false)
 *                 .metricName("metricName")
 *                 .sampledRequestsEnabled(false)
 *                 .build())
 *         // the properties below are optional
 *         .captchaConfig(CaptchaConfigProperty.builder()
 *                 .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
 *                         .immunityTime(123)
 *                         .build())
 *                 .build())
 *         .customResponseBodies(Map.of(
 *                 "customResponseBodiesKey", CustomResponseBodyProperty.builder()
 *                         .content("content")
 *                         .contentType("contentType")
 *                         .build()))
 *         .description("description")
 *         .name("name")
 *         .rules(List.of(RuleProperty.builder()
 *                 .name("name")
 *                 .priority(123)
 *                 .statement(StatementProperty.builder()
 *                         .andStatement(AndStatementProperty.builder()
 *                                 .statements(List.of(statementProperty_))
 *                                 .build())
 *                         .byteMatchStatement(ByteMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .positionalConstraint("positionalConstraint")
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .searchString("searchString")
 *                                 .searchStringBase64("searchStringBase64")
 *                                 .build())
 *                         .geoMatchStatement(GeoMatchStatementProperty.builder()
 *                                 .countryCodes(List.of("countryCodes"))
 *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
 *                                         .fallbackBehavior("fallbackBehavior")
 *                                         .headerName("headerName")
 *                                         .build())
 *                                 .build())
 *                         .ipSetReferenceStatement(Map.of(
 *                                 "arn", "arn",
 *                                 // the properties below are optional
 *                                 "ipSetForwardedIpConfig", Map.of(
 *                                         "fallbackBehavior", "fallbackBehavior",
 *                                         "headerName", "headerName",
 *                                         "position", "position")))
 *                         .labelMatchStatement(LabelMatchStatementProperty.builder()
 *                                 .key("key")
 *                                 .scope("scope")
 *                                 .build())
 *                         .managedRuleGroupStatement(ManagedRuleGroupStatementProperty.builder()
 *                                 .name("name")
 *                                 .vendorName("vendorName")
 *                                 // the properties below are optional
 *                                 .excludedRules(List.of(ExcludedRuleProperty.builder()
 *                                         .name("name")
 *                                         .build()))
 *                                 .managedRuleGroupConfigs(List.of(ManagedRuleGroupConfigProperty.builder()
 *                                         .loginPath("loginPath")
 *                                         .passwordField(FieldIdentifierProperty.builder()
 *                                                 .identifier("identifier")
 *                                                 .build())
 *                                         .payloadType("payloadType")
 *                                         .usernameField(FieldIdentifierProperty.builder()
 *                                                 .identifier("identifier")
 *                                                 .build())
 *                                         .build()))
 *                                 .scopeDownStatement(statementProperty_)
 *                                 .version("version")
 *                                 .build())
 *                         .notStatement(NotStatementProperty.builder()
 *                                 .statement(statementProperty_)
 *                                 .build())
 *                         .orStatement(OrStatementProperty.builder()
 *                                 .statements(List.of(statementProperty_))
 *                                 .build())
 *                         .rateBasedStatement(RateBasedStatementProperty.builder()
 *                                 .aggregateKeyType("aggregateKeyType")
 *                                 .limit(123)
 *                                 // the properties below are optional
 *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
 *                                         .fallbackBehavior("fallbackBehavior")
 *                                         .headerName("headerName")
 *                                         .build())
 *                                 .scopeDownStatement(statementProperty_)
 *                                 .build())
 *                         .regexMatchStatement(RegexMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .regexString("regexString")
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
 *                                 .arn("arn")
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .ruleGroupReferenceStatement(RuleGroupReferenceStatementProperty.builder()
 *                                 .arn("arn")
 *                                 // the properties below are optional
 *                                 .excludedRules(List.of(ExcludedRuleProperty.builder()
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
 *                                 .comparisonOperator("comparisonOperator")
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .size(123)
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .sqliMatchStatement(SqliMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .sensitivityLevel("sensitivityLevel")
 *                                 .build())
 *                         .xssMatchStatement(XssMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .visibilityConfig(VisibilityConfigProperty.builder()
 *                         .cloudWatchMetricsEnabled(false)
 *                         .metricName("metricName")
 *                         .sampledRequestsEnabled(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .action(RuleActionProperty.builder()
 *                         .allow(AllowActionProperty.builder()
 *                                 .customRequestHandling(CustomRequestHandlingProperty.builder()
 *                                         .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .block(BlockActionProperty.builder()
 *                                 .customResponse(CustomResponseProperty.builder()
 *                                         .responseCode(123)
 *                                         // the properties below are optional
 *                                         .customResponseBodyKey("customResponseBodyKey")
 *                                         .responseHeaders(List.of(CustomHTTPHeaderProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .captcha(CaptchaActionProperty.builder()
 *                                 .customRequestHandling(CustomRequestHandlingProperty.builder()
 *                                         .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .count(CountActionProperty.builder()
 *                                 .customRequestHandling(CustomRequestHandlingProperty.builder()
 *                                         .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .captchaConfig(CaptchaConfigProperty.builder()
 *                         .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
 *                                 .immunityTime(123)
 *                                 .build())
 *                         .build())
 *                 .overrideAction(OverrideActionProperty.builder()
 *                         .count(count)
 *                         .none(none)
 *                         .build())
 *                 .ruleLabels(List.of(LabelProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:06.857Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACLProps")
@software.amazon.jsii.Jsii.Proxy(CfnWebACLProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWebACLProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The action to perform if none of the `Rules` contained in the `WebACL` match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefaultAction();

    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
     * <p>
     * A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AWS AppSync GraphQL API. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
     * <p>
     * <blockquote>
     * <p>
     * For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
     * <p>
     * </blockquote>
     * <p>
     * For information about how to define the association of the web ACL with your resource, see <code>WebACLAssociation</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVisibilityConfig();

    /**
     * Specifies how AWS WAF should handle `CAPTCHA` evaluations for rules that don't have their own `CaptchaConfig` settings.
     * <p>
     * If you don't specify this, AWS WAF uses its default settings for <code>CaptchaConfig</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCaptchaConfig() {
        return null;
    }

    /**
     * A map of custom response keys and content bodies.
     * <p>
     * When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomResponseBodies() {
        return null;
    }

    /**
     * A description of the web ACL that helps with identification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the web ACL.
     * <p>
     * You cannot change the name of a web ACL after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The rule statements used to identify the web requests that you want to allow, block, or count.
     * <p>
     * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
        return null;
    }

    /**
     * Key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     * <p>
     * <blockquote>
     * <p>
     * To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWebACLProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWebACLProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWebACLProps> {
        java.lang.Object defaultAction;
        java.lang.String scope;
        java.lang.Object visibilityConfig;
        java.lang.Object captchaConfig;
        java.lang.Object customResponseBodies;
        java.lang.String description;
        java.lang.String name;
        java.lang.Object rules;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnWebACLProps#getDefaultAction}
         * @param defaultAction The action to perform if none of the `Rules` contained in the `WebACL` match. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(software.amazon.awscdk.services.wafv2.CfnWebACL.DefaultActionProperty defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getDefaultAction}
         * @param defaultAction The action to perform if none of the `Rules` contained in the `WebACL` match. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(software.amazon.awscdk.IResolvable defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getScope}
         * @param scope Specifies whether this is for an Amazon CloudFront distribution or for a regional application. This parameter is required.
         *              A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AWS AppSync GraphQL API. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
         *              <p>
         *              <blockquote>
         *              <p>
         *              For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
         *              <p>
         *              </blockquote>
         *              <p>
         *              For information about how to define the association of the web ACL with your resource, see <code>WebACLAssociation</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getVisibilityConfig}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.VisibilityConfigProperty visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getVisibilityConfig}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(software.amazon.awscdk.IResolvable visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCaptchaConfig}
         * @param captchaConfig Specifies how AWS WAF should handle `CAPTCHA` evaluations for rules that don't have their own `CaptchaConfig` settings.
         *                      If you don't specify this, AWS WAF uses its default settings for <code>CaptchaConfig</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder captchaConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.CaptchaConfigProperty captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCaptchaConfig}
         * @param captchaConfig Specifies how AWS WAF should handle `CAPTCHA` evaluations for rules that don't have their own `CaptchaConfig` settings.
         *                      If you don't specify this, AWS WAF uses its default settings for <code>CaptchaConfig</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder captchaConfig(software.amazon.awscdk.IResolvable captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCustomResponseBodies}
         * @param customResponseBodies A map of custom response keys and content bodies.
         *                             When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
         *                             <p>
         *                             For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         *                             <p>
         *                             For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(software.amazon.awscdk.IResolvable customResponseBodies) {
            this.customResponseBodies = customResponseBodies;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCustomResponseBodies}
         * @param customResponseBodies A map of custom response keys and content bodies.
         *                             When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
         *                             <p>
         *                             For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         *                             <p>
         *                             For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(java.util.Map<java.lang.String, ? extends java.lang.Object> customResponseBodies) {
            this.customResponseBodies = customResponseBodies;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getDescription}
         * @param description A description of the web ACL that helps with identification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getName}
         * @param name The name of the web ACL.
         *             You cannot change the name of a web ACL after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getRules}
         * @param rules The rule statements used to identify the web requests that you want to allow, block, or count.
         *              Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(software.amazon.awscdk.IResolvable rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getRules}
         * @param rules The rule statements used to identify the web requests that you want to allow, block, or count.
         *              Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(java.util.List<? extends java.lang.Object> rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getTags}
         * @param tags Key:value pairs associated with an AWS resource.
         *             The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
         *             <p>
         *             <blockquote>
         *             <p>
         *             To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWebACLProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWebACLProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWebACLProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWebACLProps {
        private final java.lang.Object defaultAction;
        private final java.lang.String scope;
        private final java.lang.Object visibilityConfig;
        private final java.lang.Object captchaConfig;
        private final java.lang.Object customResponseBodies;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.Object rules;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.visibilityConfig = software.amazon.jsii.Kernel.get(this, "visibilityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.captchaConfig = software.amazon.jsii.Kernel.get(this, "captchaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customResponseBodies = software.amazon.jsii.Kernel.get(this, "customResponseBodies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultAction = java.util.Objects.requireNonNull(builder.defaultAction, "defaultAction is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            this.visibilityConfig = java.util.Objects.requireNonNull(builder.visibilityConfig, "visibilityConfig is required");
            this.captchaConfig = builder.captchaConfig;
            this.customResponseBodies = builder.customResponseBodies;
            this.description = builder.description;
            this.name = builder.name;
            this.rules = builder.rules;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.Object getVisibilityConfig() {
            return this.visibilityConfig;
        }

        @Override
        public final java.lang.Object getCaptchaConfig() {
            return this.captchaConfig;
        }

        @Override
        public final java.lang.Object getCustomResponseBodies() {
            return this.customResponseBodies;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRules() {
            return this.rules;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
            data.set("scope", om.valueToTree(this.getScope()));
            data.set("visibilityConfig", om.valueToTree(this.getVisibilityConfig()));
            if (this.getCaptchaConfig() != null) {
                data.set("captchaConfig", om.valueToTree(this.getCaptchaConfig()));
            }
            if (this.getCustomResponseBodies() != null) {
                data.set("customResponseBodies", om.valueToTree(this.getCustomResponseBodies()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACLProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWebACLProps.Jsii$Proxy that = (CfnWebACLProps.Jsii$Proxy) o;

            if (!defaultAction.equals(that.defaultAction)) return false;
            if (!scope.equals(that.scope)) return false;
            if (!visibilityConfig.equals(that.visibilityConfig)) return false;
            if (this.captchaConfig != null ? !this.captchaConfig.equals(that.captchaConfig) : that.captchaConfig != null) return false;
            if (this.customResponseBodies != null ? !this.customResponseBodies.equals(that.customResponseBodies) : that.customResponseBodies != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultAction.hashCode();
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.visibilityConfig.hashCode());
            result = 31 * result + (this.captchaConfig != null ? this.captchaConfig.hashCode() : 0);
            result = 31 * result + (this.customResponseBodies != null ? this.customResponseBodies.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
