/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.msk;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.msk.CfnCluster;
import software.amazon.awscdk.services.msk.CfnClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getBrokerNodeGroupInfo() {
        return Kernel.get((Object)this, (String)"brokerNodeGroupInfo", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBrokerNodeGroupInfo(@NotNull BrokerNodeGroupInfoProperty value) {
        Kernel.set((Object)this, (String)"brokerNodeGroupInfo", (Object)Objects.requireNonNull(value, "brokerNodeGroupInfo is required"));
    }

    public void setBrokerNodeGroupInfo(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"brokerNodeGroupInfo", (Object)Objects.requireNonNull(value, "brokerNodeGroupInfo is required"));
    }

    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterName(@NotNull String value) {
        Kernel.set((Object)this, (String)"clusterName", (Object)Objects.requireNonNull(value, "clusterName is required"));
    }

    @NotNull
    public String getKafkaVersion() {
        return (String)Kernel.get((Object)this, (String)"kafkaVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setKafkaVersion(@NotNull String value) {
        Kernel.set((Object)this, (String)"kafkaVersion", (Object)Objects.requireNonNull(value, "kafkaVersion is required"));
    }

    @NotNull
    public Number getNumberOfBrokerNodes() {
        return (Number)Kernel.get((Object)this, (String)"numberOfBrokerNodes", (NativeType)NativeType.forClass(Number.class));
    }

    public void setNumberOfBrokerNodes(@NotNull Number value) {
        Kernel.set((Object)this, (String)"numberOfBrokerNodes", (Object)Objects.requireNonNull(value, "numberOfBrokerNodes is required"));
    }

    @Nullable
    public Object getClientAuthentication() {
        return Kernel.get((Object)this, (String)"clientAuthentication", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClientAuthentication(@Nullable ClientAuthenticationProperty value) {
        Kernel.set((Object)this, (String)"clientAuthentication", (Object)value);
    }

    public void setClientAuthentication(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"clientAuthentication", (Object)value);
    }

    @Nullable
    public Object getConfigurationInfo() {
        return Kernel.get((Object)this, (String)"configurationInfo", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfigurationInfo(@Nullable ConfigurationInfoProperty value) {
        Kernel.set((Object)this, (String)"configurationInfo", (Object)value);
    }

    public void setConfigurationInfo(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"configurationInfo", (Object)value);
    }

    @Nullable
    public String getCurrentVersion() {
        return (String)Kernel.get((Object)this, (String)"currentVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setCurrentVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"currentVersion", (Object)value);
    }

    @Nullable
    public Object getEncryptionInfo() {
        return Kernel.get((Object)this, (String)"encryptionInfo", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryptionInfo(@Nullable EncryptionInfoProperty value) {
        Kernel.set((Object)this, (String)"encryptionInfo", (Object)value);
    }

    public void setEncryptionInfo(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"encryptionInfo", (Object)value);
    }

    @Nullable
    public String getEnhancedMonitoring() {
        return (String)Kernel.get((Object)this, (String)"enhancedMonitoring", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnhancedMonitoring(@Nullable String value) {
        Kernel.set((Object)this, (String)"enhancedMonitoring", (Object)value);
    }

    @Nullable
    public Object getLoggingInfo() {
        return Kernel.get((Object)this, (String)"loggingInfo", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLoggingInfo(@Nullable LoggingInfoProperty value) {
        Kernel.set((Object)this, (String)"loggingInfo", (Object)value);
    }

    public void setLoggingInfo(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"loggingInfo", (Object)value);
    }

    @Nullable
    public Object getOpenMonitoring() {
        return Kernel.get((Object)this, (String)"openMonitoring", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOpenMonitoring(@Nullable OpenMonitoringProperty value) {
        Kernel.set((Object)this, (String)"openMonitoring", (Object)value);
    }

    public void setOpenMonitoring(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"openMonitoring", (Object)value);
    }

    @Nullable
    public String getStorageMode() {
        return (String)Kernel.get((Object)this, (String)"storageMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setStorageMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"storageMode", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfoProperty brokerNodeGroupInfo) {
            this.props.brokerNodeGroupInfo(brokerNodeGroupInfo);
            return this;
        }

        public Builder brokerNodeGroupInfo(IResolvable brokerNodeGroupInfo) {
            this.props.brokerNodeGroupInfo(brokerNodeGroupInfo);
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder kafkaVersion(String kafkaVersion) {
            this.props.kafkaVersion(kafkaVersion);
            return this;
        }

        public Builder numberOfBrokerNodes(Number numberOfBrokerNodes) {
            this.props.numberOfBrokerNodes(numberOfBrokerNodes);
            return this;
        }

        public Builder clientAuthentication(ClientAuthenticationProperty clientAuthentication) {
            this.props.clientAuthentication(clientAuthentication);
            return this;
        }

        public Builder clientAuthentication(IResolvable clientAuthentication) {
            this.props.clientAuthentication(clientAuthentication);
            return this;
        }

        public Builder configurationInfo(ConfigurationInfoProperty configurationInfo) {
            this.props.configurationInfo(configurationInfo);
            return this;
        }

        public Builder configurationInfo(IResolvable configurationInfo) {
            this.props.configurationInfo(configurationInfo);
            return this;
        }

        public Builder currentVersion(String currentVersion) {
            this.props.currentVersion(currentVersion);
            return this;
        }

        public Builder encryptionInfo(EncryptionInfoProperty encryptionInfo) {
            this.props.encryptionInfo(encryptionInfo);
            return this;
        }

        public Builder encryptionInfo(IResolvable encryptionInfo) {
            this.props.encryptionInfo(encryptionInfo);
            return this;
        }

        public Builder enhancedMonitoring(String enhancedMonitoring) {
            this.props.enhancedMonitoring(enhancedMonitoring);
            return this;
        }

        public Builder loggingInfo(LoggingInfoProperty loggingInfo) {
            this.props.loggingInfo(loggingInfo);
            return this;
        }

        public Builder loggingInfo(IResolvable loggingInfo) {
            this.props.loggingInfo(loggingInfo);
            return this;
        }

        public Builder openMonitoring(OpenMonitoringProperty openMonitoring) {
            this.props.openMonitoring(openMonitoring);
            return this;
        }

        public Builder openMonitoring(IResolvable openMonitoring) {
            this.props.openMonitoring(openMonitoring);
            return this;
        }

        public Builder storageMode(String storageMode) {
            this.props.storageMode(storageMode);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.UnauthenticatedProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UnauthenticatedProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UnauthenticatedProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public UnauthenticatedProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.TlsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TlsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCertificateAuthorityArnList() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TlsProperty> {
            List<String> certificateAuthorityArnList;
            Object enabled;

            public Builder certificateAuthorityArnList(List<String> certificateAuthorityArnList) {
                this.certificateAuthorityArnList = certificateAuthorityArnList;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public TlsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.StorageInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEbsStorageInfo() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageInfoProperty> {
            Object ebsStorageInfo;

            public Builder ebsStorageInfo(EBSStorageInfoProperty ebsStorageInfo) {
                this.ebsStorageInfo = ebsStorageInfo;
                return this;
            }

            public Builder ebsStorageInfo(IResolvable ebsStorageInfo) {
                this.ebsStorageInfo = ebsStorageInfo;
                return this;
            }

            public StorageInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.ScramProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScramProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScramProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public ScramProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.SaslProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SaslProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIam() {
            return null;
        }

        @Nullable
        default public Object getScram() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SaslProperty> {
            Object iam;
            Object scram;

            public Builder iam(IamProperty iam) {
                this.iam = iam;
                return this;
            }

            public Builder iam(IResolvable iam) {
                this.iam = iam;
                return this;
            }

            public Builder scram(ScramProperty scram) {
                this.scram = scram;
                return this;
            }

            public Builder scram(IResolvable scram) {
                this.scram = scram;
                return this;
            }

            public SaslProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.S3Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3Property
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getBucket() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3Property> {
            Object enabled;
            String bucket;
            String prefix;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public S3Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.PublicAccessProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PublicAccessProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PublicAccessProperty> {
            String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public PublicAccessProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisionedThroughputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Number getVolumeThroughput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProvisionedThroughputProperty> {
            Object enabled;
            Number volumeThroughput;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder volumeThroughput(Number volumeThroughput) {
                this.volumeThroughput = volumeThroughput;
                return this;
            }

            public ProvisionedThroughputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.PrometheusProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrometheusProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getJmxExporter() {
            return null;
        }

        @Nullable
        default public Object getNodeExporter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrometheusProperty> {
            Object jmxExporter;
            Object nodeExporter;

            public Builder jmxExporter(JmxExporterProperty jmxExporter) {
                this.jmxExporter = jmxExporter;
                return this;
            }

            public Builder jmxExporter(IResolvable jmxExporter) {
                this.jmxExporter = jmxExporter;
                return this;
            }

            public Builder nodeExporter(NodeExporterProperty nodeExporter) {
                this.nodeExporter = nodeExporter;
                return this;
            }

            public Builder nodeExporter(IResolvable nodeExporter) {
                this.nodeExporter = nodeExporter;
                return this;
            }

            public PrometheusProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.OpenMonitoringProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OpenMonitoringProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPrometheus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OpenMonitoringProperty> {
            Object prometheus;

            public Builder prometheus(PrometheusProperty prometheus) {
                this.prometheus = prometheus;
                return this;
            }

            public Builder prometheus(IResolvable prometheus) {
                this.prometheus = prometheus;
                return this;
            }

            public OpenMonitoringProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.NodeExporterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NodeExporterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabledInBroker();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NodeExporterProperty> {
            Object enabledInBroker;

            public Builder enabledInBroker(Boolean enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            public Builder enabledInBroker(IResolvable enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            public NodeExporterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.LoggingInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingInfoProperty
    extends JsiiSerializable {
        @NotNull
        public Object getBrokerLogs();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingInfoProperty> {
            Object brokerLogs;

            public Builder brokerLogs(BrokerLogsProperty brokerLogs) {
                this.brokerLogs = brokerLogs;
                return this;
            }

            public Builder brokerLogs(IResolvable brokerLogs) {
                this.brokerLogs = brokerLogs;
                return this;
            }

            public LoggingInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.JmxExporterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JmxExporterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabledInBroker();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JmxExporterProperty> {
            Object enabledInBroker;

            public Builder enabledInBroker(Boolean enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            public Builder enabledInBroker(IResolvable enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            public JmxExporterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.IamProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public IamProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.FirehoseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirehoseProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getDeliveryStream() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirehoseProperty> {
            Object enabled;
            String deliveryStream;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder deliveryStream(String deliveryStream) {
                this.deliveryStream = deliveryStream;
                return this;
            }

            public FirehoseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.EncryptionInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEncryptionAtRest() {
            return null;
        }

        @Nullable
        default public Object getEncryptionInTransit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionInfoProperty> {
            Object encryptionAtRest;
            Object encryptionInTransit;

            public Builder encryptionAtRest(EncryptionAtRestProperty encryptionAtRest) {
                this.encryptionAtRest = encryptionAtRest;
                return this;
            }

            public Builder encryptionAtRest(IResolvable encryptionAtRest) {
                this.encryptionAtRest = encryptionAtRest;
                return this;
            }

            public Builder encryptionInTransit(EncryptionInTransitProperty encryptionInTransit) {
                this.encryptionInTransit = encryptionInTransit;
                return this;
            }

            public Builder encryptionInTransit(IResolvable encryptionInTransit) {
                this.encryptionInTransit = encryptionInTransit;
                return this;
            }

            public EncryptionInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.EncryptionInTransitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionInTransitProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClientBroker() {
            return null;
        }

        @Nullable
        default public Object getInCluster() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionInTransitProperty> {
            String clientBroker;
            Object inCluster;

            public Builder clientBroker(String clientBroker) {
                this.clientBroker = clientBroker;
                return this;
            }

            public Builder inCluster(Boolean inCluster) {
                this.inCluster = inCluster;
                return this;
            }

            public Builder inCluster(IResolvable inCluster) {
                this.inCluster = inCluster;
                return this;
            }

            public EncryptionInTransitProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.EncryptionAtRestProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionAtRestProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataVolumeKmsKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionAtRestProperty> {
            String dataVolumeKmsKeyId;

            public Builder dataVolumeKmsKeyId(String dataVolumeKmsKeyId) {
                this.dataVolumeKmsKeyId = dataVolumeKmsKeyId;
                return this;
            }

            public EncryptionAtRestProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.EBSStorageInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EBSStorageInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getProvisionedThroughput() {
            return null;
        }

        @Nullable
        default public Number getVolumeSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EBSStorageInfoProperty> {
            Object provisionedThroughput;
            Number volumeSize;

            public Builder provisionedThroughput(ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public Builder provisionedThroughput(IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public EBSStorageInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.ConnectivityInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectivityInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPublicAccess() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectivityInfoProperty> {
            Object publicAccess;

            public Builder publicAccess(PublicAccessProperty publicAccess) {
                this.publicAccess = publicAccess;
                return this;
            }

            public Builder publicAccess(IResolvable publicAccess) {
                this.publicAccess = publicAccess;
                return this;
            }

            public ConnectivityInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.ConfigurationInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationInfoProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @NotNull
        public Number getRevision();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationInfoProperty> {
            String arn;
            Number revision;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder revision(Number revision) {
                this.revision = revision;
                return this;
            }

            public ConfigurationInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.CloudWatchLogsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getLogGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsProperty> {
            Object enabled;
            String logGroup;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder logGroup(String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            public CloudWatchLogsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.ClientAuthenticationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClientAuthenticationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getSasl() {
            return null;
        }

        @Nullable
        default public Object getTls() {
            return null;
        }

        @Nullable
        default public Object getUnauthenticated() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClientAuthenticationProperty> {
            Object sasl;
            Object tls;
            Object unauthenticated;

            public Builder sasl(SaslProperty sasl) {
                this.sasl = sasl;
                return this;
            }

            public Builder sasl(IResolvable sasl) {
                this.sasl = sasl;
                return this;
            }

            public Builder tls(TlsProperty tls) {
                this.tls = tls;
                return this;
            }

            public Builder tls(IResolvable tls) {
                this.tls = tls;
                return this;
            }

            public Builder unauthenticated(UnauthenticatedProperty unauthenticated) {
                this.unauthenticated = unauthenticated;
                return this;
            }

            public Builder unauthenticated(IResolvable unauthenticated) {
                this.unauthenticated = unauthenticated;
                return this;
            }

            public ClientAuthenticationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.BrokerNodeGroupInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BrokerNodeGroupInfoProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getClientSubnets();

        @NotNull
        public String getInstanceType();

        @Nullable
        default public String getBrokerAzDistribution() {
            return null;
        }

        @Nullable
        default public Object getConnectivityInfo() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getStorageInfo() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BrokerNodeGroupInfoProperty> {
            List<String> clientSubnets;
            String instanceType;
            String brokerAzDistribution;
            Object connectivityInfo;
            List<String> securityGroups;
            Object storageInfo;

            public Builder clientSubnets(List<String> clientSubnets) {
                this.clientSubnets = clientSubnets;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder brokerAzDistribution(String brokerAzDistribution) {
                this.brokerAzDistribution = brokerAzDistribution;
                return this;
            }

            public Builder connectivityInfo(ConnectivityInfoProperty connectivityInfo) {
                this.connectivityInfo = connectivityInfo;
                return this;
            }

            public Builder connectivityInfo(IResolvable connectivityInfo) {
                this.connectivityInfo = connectivityInfo;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder storageInfo(StorageInfoProperty storageInfo) {
                this.storageInfo = storageInfo;
                return this;
            }

            public Builder storageInfo(IResolvable storageInfo) {
                this.storageInfo = storageInfo;
                return this;
            }

            public BrokerNodeGroupInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_msk.CfnCluster.BrokerLogsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BrokerLogsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudWatchLogs() {
            return null;
        }

        @Nullable
        default public Object getFirehose() {
            return null;
        }

        @Nullable
        default public Object getS3() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BrokerLogsProperty> {
            Object cloudWatchLogs;
            Object firehose;
            Object s3;

            public Builder cloudWatchLogs(CloudWatchLogsProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            public Builder cloudWatchLogs(IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            public Builder firehose(FirehoseProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder firehose(IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder s3(S3Property s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public BrokerLogsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

