/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ssm.CfnAssociation;
import software.amazon.awscdk.services.ssm.CfnAssociationProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ssm.CfnAssociation")
public class CfnAssociation
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAssociation.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAssociation(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAssociation(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAssociation(@NotNull Construct scope, @NotNull String id, @NotNull CfnAssociationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAssociationId() {
        return (String)Kernel.get((Object)this, (String)"attrAssociationId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getApplyOnlyAtCronInterval() {
        return Kernel.get((Object)this, (String)"applyOnlyAtCronInterval", (NativeType)NativeType.forClass(Object.class));
    }

    public void setApplyOnlyAtCronInterval(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"applyOnlyAtCronInterval", (Object)value);
    }

    public void setApplyOnlyAtCronInterval(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"applyOnlyAtCronInterval", (Object)value);
    }

    @Nullable
    public String getAssociationName() {
        return (String)Kernel.get((Object)this, (String)"associationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAssociationName(@Nullable String value) {
        Kernel.set((Object)this, (String)"associationName", (Object)value);
    }

    @Nullable
    public String getAutomationTargetParameterName() {
        return (String)Kernel.get((Object)this, (String)"automationTargetParameterName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutomationTargetParameterName(@Nullable String value) {
        Kernel.set((Object)this, (String)"automationTargetParameterName", (Object)value);
    }

    @Nullable
    public List<String> getCalendarNames() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"calendarNames", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCalendarNames(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"calendarNames", value);
    }

    @Nullable
    public String getComplianceSeverity() {
        return (String)Kernel.get((Object)this, (String)"complianceSeverity", (NativeType)NativeType.forClass(String.class));
    }

    public void setComplianceSeverity(@Nullable String value) {
        Kernel.set((Object)this, (String)"complianceSeverity", (Object)value);
    }

    @Nullable
    public String getDocumentVersion() {
        return (String)Kernel.get((Object)this, (String)"documentVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setDocumentVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"documentVersion", (Object)value);
    }

    @Nullable
    public String getInstanceId() {
        return (String)Kernel.get((Object)this, (String)"instanceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceId(@Nullable String value) {
        Kernel.set((Object)this, (String)"instanceId", (Object)value);
    }

    @Nullable
    public String getMaxConcurrency() {
        return (String)Kernel.get((Object)this, (String)"maxConcurrency", (NativeType)NativeType.forClass(String.class));
    }

    public void setMaxConcurrency(@Nullable String value) {
        Kernel.set((Object)this, (String)"maxConcurrency", (Object)value);
    }

    @Nullable
    public String getMaxErrors() {
        return (String)Kernel.get((Object)this, (String)"maxErrors", (NativeType)NativeType.forClass(String.class));
    }

    public void setMaxErrors(@Nullable String value) {
        Kernel.set((Object)this, (String)"maxErrors", (Object)value);
    }

    @Nullable
    public Object getOutputLocation() {
        return Kernel.get((Object)this, (String)"outputLocation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOutputLocation(@Nullable InstanceAssociationOutputLocationProperty value) {
        Kernel.set((Object)this, (String)"outputLocation", (Object)value);
    }

    public void setOutputLocation(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"outputLocation", (Object)value);
    }

    @Nullable
    public Object getParameters() {
        return Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"parameters", (Object)value);
    }

    public void setParameters(@Nullable Map<String, Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException("Expected " + "value" + ".keySet()" + " to contain class String; received " + value.keySet().toArray()[0].getClass());
            }
            for (Map.Entry<String, Object> __item_ac66f0 : value.entrySet()) {
                Object object = __item_ac66f0.getValue();
            }
        }
        Kernel.set((Object)this, (String)"parameters", value);
    }

    @Nullable
    public String getScheduleExpression() {
        return (String)Kernel.get((Object)this, (String)"scheduleExpression", (NativeType)NativeType.forClass(String.class));
    }

    public void setScheduleExpression(@Nullable String value) {
        Kernel.set((Object)this, (String)"scheduleExpression", (Object)value);
    }

    @Nullable
    public Number getScheduleOffset() {
        return (Number)Kernel.get((Object)this, (String)"scheduleOffset", (NativeType)NativeType.forClass(Number.class));
    }

    public void setScheduleOffset(@Nullable Number value) {
        Kernel.set((Object)this, (String)"scheduleOffset", (Object)value);
    }

    @Nullable
    public String getSyncCompliance() {
        return (String)Kernel.get((Object)this, (String)"syncCompliance", (NativeType)NativeType.forClass(String.class));
    }

    public void setSyncCompliance(@Nullable String value) {
        Kernel.set((Object)this, (String)"syncCompliance", (Object)value);
    }

    @Nullable
    public Object getTargets() {
        return Kernel.get((Object)this, (String)"targets", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTargets(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"targets", (Object)value);
    }

    public void setTargets(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof TargetProperty || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.services.ssm.CfnAssociation.TargetProperty, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"targets", value);
    }

    @Nullable
    public Number getWaitForSuccessTimeoutSeconds() {
        return (Number)Kernel.get((Object)this, (String)"waitForSuccessTimeoutSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setWaitForSuccessTimeoutSeconds(@Nullable Number value) {
        Kernel.set((Object)this, (String)"waitForSuccessTimeoutSeconds", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAssociation> {
        private final Construct scope;
        private final String id;
        private final CfnAssociationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAssociationProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.props.applyOnlyAtCronInterval(applyOnlyAtCronInterval);
            return this;
        }

        public Builder applyOnlyAtCronInterval(IResolvable applyOnlyAtCronInterval) {
            this.props.applyOnlyAtCronInterval(applyOnlyAtCronInterval);
            return this;
        }

        public Builder associationName(String associationName) {
            this.props.associationName(associationName);
            return this;
        }

        public Builder automationTargetParameterName(String automationTargetParameterName) {
            this.props.automationTargetParameterName(automationTargetParameterName);
            return this;
        }

        public Builder calendarNames(List<String> calendarNames) {
            this.props.calendarNames(calendarNames);
            return this;
        }

        public Builder complianceSeverity(String complianceSeverity) {
            this.props.complianceSeverity(complianceSeverity);
            return this;
        }

        public Builder documentVersion(String documentVersion) {
            this.props.documentVersion(documentVersion);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        public Builder maxConcurrency(String maxConcurrency) {
            this.props.maxConcurrency(maxConcurrency);
            return this;
        }

        public Builder maxErrors(String maxErrors) {
            this.props.maxErrors(maxErrors);
            return this;
        }

        public Builder outputLocation(InstanceAssociationOutputLocationProperty outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder outputLocation(IResolvable outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        public Builder parameters(IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder parameters(Map<String, ? extends Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder scheduleExpression(String scheduleExpression) {
            this.props.scheduleExpression(scheduleExpression);
            return this;
        }

        public Builder scheduleOffset(Number scheduleOffset) {
            this.props.scheduleOffset(scheduleOffset);
            return this;
        }

        public Builder syncCompliance(String syncCompliance) {
            this.props.syncCompliance(syncCompliance);
            return this;
        }

        public Builder targets(IResolvable targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder targets(List<? extends Object> targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder waitForSuccessTimeoutSeconds(Number waitForSuccessTimeoutSeconds) {
            this.props.waitForSuccessTimeoutSeconds(waitForSuccessTimeoutSeconds);
            return this;
        }

        public CfnAssociation build() {
            return new CfnAssociation(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ssm.CfnAssociation.TargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetProperty> {
            String key;
            List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public TargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ssm.CfnAssociation.S3OutputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OutputLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOutputS3BucketName() {
            return null;
        }

        @Nullable
        default public String getOutputS3KeyPrefix() {
            return null;
        }

        @Nullable
        default public String getOutputS3Region() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OutputLocationProperty> {
            String outputS3BucketName;
            String outputS3KeyPrefix;
            String outputS3Region;

            public Builder outputS3BucketName(String outputS3BucketName) {
                this.outputS3BucketName = outputS3BucketName;
                return this;
            }

            public Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
                this.outputS3KeyPrefix = outputS3KeyPrefix;
                return this;
            }

            public Builder outputS3Region(String outputS3Region) {
                this.outputS3Region = outputS3Region;
                return this;
            }

            public S3OutputLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ssm.CfnAssociation.InstanceAssociationOutputLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceAssociationOutputLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3Location() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceAssociationOutputLocationProperty> {
            Object s3Location;

            public Builder s3Location(S3OutputLocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public InstanceAssociationOutputLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

