/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.dynamodb.ITable;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig;
import software.amazon.awscdk.services.stepfunctions.TaskStateBase;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValue;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoUpdateItemProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.DynamoUpdateItem")
public class DynamoUpdateItem
extends TaskStateBase {
    protected DynamoUpdateItem(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DynamoUpdateItem(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DynamoUpdateItem(@NotNull Construct scope, @NotNull String id, @NotNull DynamoUpdateItemProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @Nullable
    protected TaskMetricsConfig getTaskMetrics() {
        return (TaskMetricsConfig)Kernel.get((Object)this, (String)"taskMetrics", (NativeType)NativeType.forClass(TaskMetricsConfig.class));
    }

    @Override
    @Nullable
    protected List<PolicyStatement> getTaskPolicies() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"taskPolicies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DynamoUpdateItem> {
        private final Construct scope;
        private final String id;
        private final DynamoUpdateItemProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DynamoUpdateItemProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        public Builder heartbeat(Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder key(Map<String, ? extends DynamoAttributeValue> key) {
            this.props.key(key);
            return this;
        }

        public Builder table(ITable table) {
            this.props.table(table);
            return this;
        }

        public Builder conditionExpression(String conditionExpression) {
            this.props.conditionExpression(conditionExpression);
            return this;
        }

        public Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.props.expressionAttributeNames(expressionAttributeNames);
            return this;
        }

        public Builder expressionAttributeValues(Map<String, ? extends DynamoAttributeValue> expressionAttributeValues) {
            this.props.expressionAttributeValues(expressionAttributeValues);
            return this;
        }

        public Builder returnConsumedCapacity(DynamoConsumedCapacity returnConsumedCapacity) {
            this.props.returnConsumedCapacity(returnConsumedCapacity);
            return this;
        }

        public Builder returnItemCollectionMetrics(DynamoItemCollectionMetrics returnItemCollectionMetrics) {
            this.props.returnItemCollectionMetrics(returnItemCollectionMetrics);
            return this;
        }

        public Builder returnValues(DynamoReturnValues returnValues) {
            this.props.returnValues(returnValues);
            return this;
        }

        public Builder updateExpression(String updateExpression) {
            this.props.updateExpression(updateExpression);
            return this;
        }

        public DynamoUpdateItem build() {
            return new DynamoUpdateItem(this.scope, this.id, this.props.build());
        }
    }
}

