/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ecs.CfnTaskDefinition;
import software.amazon.awscdk.services.ecs.ContainerDefinitionProps;
import software.amazon.awscdk.services.ecs.ContainerDependency;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.EnvironmentFile;
import software.amazon.awscdk.services.ecs.EnvironmentFileConfig;
import software.amazon.awscdk.services.ecs.HealthCheck;
import software.amazon.awscdk.services.ecs.LinuxParameters;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.LogDriverConfig;
import software.amazon.awscdk.services.ecs.MountPoint;
import software.amazon.awscdk.services.ecs.PortMapping;
import software.amazon.awscdk.services.ecs.Protocol;
import software.amazon.awscdk.services.ecs.ScratchSpace;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.SystemControl;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.ecs.Ulimit;
import software.amazon.awscdk.services.ecs.VolumeFrom;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs.ContainerDefinition")
public class ContainerDefinition
extends Construct {
    protected ContainerDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ContainerDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ContainerDefinition(@NotNull Construct scope, @NotNull String id, @NotNull ContainerDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addContainerDependencies(ContainerDependency ... containerDependencies) {
        Kernel.call((Object)((Object)this), (String)"addContainerDependencies", (NativeType)NativeType.VOID, (Object[])Arrays.stream(containerDependencies).toArray(Object[]::new));
    }

    public void addEnvironment(@NotNull String name, @NotNull String value) {
        Kernel.call((Object)((Object)this), (String)"addEnvironment", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(value, "value is required")});
    }

    public void addInferenceAcceleratorResource(String ... inferenceAcceleratorResources) {
        Kernel.call((Object)((Object)this), (String)"addInferenceAcceleratorResource", (NativeType)NativeType.VOID, (Object[])Arrays.stream(inferenceAcceleratorResources).toArray(Object[]::new));
    }

    public void addLink(@NotNull ContainerDefinition container, @Nullable String alias) {
        Kernel.call((Object)((Object)this), (String)"addLink", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(container, "container is required"), alias});
    }

    public void addLink(@NotNull ContainerDefinition container) {
        Kernel.call((Object)((Object)this), (String)"addLink", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(container, "container is required")});
    }

    public void addMountPoints(MountPoint ... mountPoints) {
        Kernel.call((Object)((Object)this), (String)"addMountPoints", (NativeType)NativeType.VOID, (Object[])Arrays.stream(mountPoints).toArray(Object[]::new));
    }

    public void addPortMappings(PortMapping ... portMappings) {
        Kernel.call((Object)((Object)this), (String)"addPortMappings", (NativeType)NativeType.VOID, (Object[])Arrays.stream(portMappings).toArray(Object[]::new));
    }

    public void addScratch(@NotNull ScratchSpace scratch) {
        Kernel.call((Object)((Object)this), (String)"addScratch", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(scratch, "scratch is required")});
    }

    public void addSecret(@NotNull String name, @NotNull Secret secret) {
        Kernel.call((Object)((Object)this), (String)"addSecret", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(secret, "secret is required")});
    }

    public void addToExecutionPolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)((Object)this), (String)"addToExecutionPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addUlimits(Ulimit ... ulimits) {
        Kernel.call((Object)((Object)this), (String)"addUlimits", (NativeType)NativeType.VOID, (Object[])Arrays.stream(ulimits).toArray(Object[]::new));
    }

    public void addVolumesFrom(VolumeFrom ... volumesFrom) {
        Kernel.call((Object)((Object)this), (String)"addVolumesFrom", (NativeType)NativeType.VOID, (Object[])Arrays.stream(volumesFrom).toArray(Object[]::new));
    }

    @Nullable
    public PortMapping findPortMapping(@NotNull Number containerPort, @NotNull Protocol protocol) {
        return (PortMapping)Kernel.call((Object)((Object)this), (String)"findPortMapping", (NativeType)NativeType.forClass(PortMapping.class), (Object[])new Object[]{Objects.requireNonNull(containerPort, "containerPort is required"), Objects.requireNonNull(protocol, "protocol is required")});
    }

    @Nullable
    public PortMapping findPortMappingByName(@NotNull String name) {
        return (PortMapping)Kernel.call((Object)((Object)this), (String)"findPortMappingByName", (NativeType)NativeType.forClass(PortMapping.class), (Object[])new Object[]{Objects.requireNonNull(name, "name is required")});
    }

    @NotNull
    public CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition(@Nullable TaskDefinition _taskDefinition) {
        return (CfnTaskDefinition.ContainerDefinitionProperty)Kernel.call((Object)((Object)this), (String)"renderContainerDefinition", (NativeType)NativeType.forClass(CfnTaskDefinition.ContainerDefinitionProperty.class), (Object[])new Object[]{_taskDefinition});
    }

    @NotNull
    public CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition() {
        return (CfnTaskDefinition.ContainerDefinitionProperty)Kernel.call((Object)((Object)this), (String)"renderContainerDefinition", (NativeType)NativeType.forClass(CfnTaskDefinition.ContainerDefinitionProperty.class), (Object[])new Object[0]);
    }

    @NotNull
    public List<ContainerDependency> getContainerDependencies() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"containerDependencies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ContainerDependency.class))));
    }

    @NotNull
    public String getContainerName() {
        return (String)Kernel.get((Object)((Object)this), (String)"containerName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getContainerPort() {
        return (Number)Kernel.get((Object)((Object)this), (String)"containerPort", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public Boolean getEssential() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"essential", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public String getImageName() {
        return (String)Kernel.get((Object)((Object)this), (String)"imageName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getIngressPort() {
        return (Number)Kernel.get((Object)((Object)this), (String)"ingressPort", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public Boolean getMemoryLimitSpecified() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"memoryLimitSpecified", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<MountPoint> getMountPoints() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"mountPoints", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(MountPoint.class))));
    }

    @NotNull
    public List<PortMapping> getPortMappings() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"portMappings", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PortMapping.class))));
    }

    @NotNull
    public TaskDefinition getTaskDefinition() {
        return (TaskDefinition)Kernel.get((Object)((Object)this), (String)"taskDefinition", (NativeType)NativeType.forClass(TaskDefinition.class));
    }

    @NotNull
    public List<Ulimit> getUlimits() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"ulimits", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Ulimit.class))));
    }

    @NotNull
    public List<VolumeFrom> getVolumesFrom() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"volumesFrom", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(VolumeFrom.class))));
    }

    @Nullable
    public List<EnvironmentFileConfig> getEnvironmentFiles() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"environmentFiles", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(EnvironmentFileConfig.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public LinuxParameters getLinuxParameters() {
        return (LinuxParameters)((Object)Kernel.get((Object)((Object)this), (String)"linuxParameters", (NativeType)NativeType.forClass(LinuxParameters.class)));
    }

    @Nullable
    public LogDriverConfig getLogDriverConfig() {
        return (LogDriverConfig)Kernel.get((Object)((Object)this), (String)"logDriverConfig", (NativeType)NativeType.forClass(LogDriverConfig.class));
    }

    @Nullable
    public Boolean getReferencesSecretJsonField() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"referencesSecretJsonField", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ContainerDefinition> {
        private final Construct scope;
        private final String id;
        private final ContainerDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ContainerDefinitionProps.Builder();
        }

        public Builder image(ContainerImage image) {
            this.props.image(image);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder containerName(String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        public Builder cpu(Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder disableNetworking(Boolean disableNetworking) {
            this.props.disableNetworking(disableNetworking);
            return this;
        }

        public Builder dnsSearchDomains(List<String> dnsSearchDomains) {
            this.props.dnsSearchDomains(dnsSearchDomains);
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        public Builder dockerLabels(Map<String, String> dockerLabels) {
            this.props.dockerLabels(dockerLabels);
            return this;
        }

        public Builder dockerSecurityOptions(List<String> dockerSecurityOptions) {
            this.props.dockerSecurityOptions(dockerSecurityOptions);
            return this;
        }

        public Builder entryPoint(List<String> entryPoint) {
            this.props.entryPoint(entryPoint);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder environmentFiles(List<? extends EnvironmentFile> environmentFiles) {
            this.props.environmentFiles(environmentFiles);
            return this;
        }

        public Builder essential(Boolean essential) {
            this.props.essential(essential);
            return this;
        }

        public Builder extraHosts(Map<String, String> extraHosts) {
            this.props.extraHosts(extraHosts);
            return this;
        }

        public Builder gpuCount(Number gpuCount) {
            this.props.gpuCount(gpuCount);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder hostname(String hostname) {
            this.props.hostname(hostname);
            return this;
        }

        public Builder inferenceAcceleratorResources(List<String> inferenceAcceleratorResources) {
            this.props.inferenceAcceleratorResources(inferenceAcceleratorResources);
            return this;
        }

        public Builder linuxParameters(LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        public Builder logging(LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.props.memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        public Builder portMappings(List<? extends PortMapping> portMappings) {
            this.props.portMappings(portMappings);
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        public Builder startTimeout(Duration startTimeout) {
            this.props.startTimeout(startTimeout);
            return this;
        }

        public Builder stopTimeout(Duration stopTimeout) {
            this.props.stopTimeout(stopTimeout);
            return this;
        }

        public Builder systemControls(List<? extends SystemControl> systemControls) {
            this.props.systemControls(systemControls);
            return this;
        }

        public Builder user(String user) {
            this.props.user(user);
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.props.workingDirectory(workingDirectory);
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public ContainerDefinition build() {
            return new ContainerDefinition(this.scope, this.id, this.props.build());
        }
    }
}

