/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.efs;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.efs.AccessPoint;
import software.amazon.awscdk.services.efs.AccessPointOptions;
import software.amazon.awscdk.services.efs.FileSystemAttributes;
import software.amazon.awscdk.services.efs.FileSystemProps;
import software.amazon.awscdk.services.efs.IFileSystem;
import software.amazon.awscdk.services.efs.LifecyclePolicy;
import software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy;
import software.amazon.awscdk.services.efs.PerformanceMode;
import software.amazon.awscdk.services.efs.ThroughputMode;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IDependable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.FileSystem")
public class FileSystem
extends Resource
implements IFileSystem {
    public static final Number DEFAULT_PORT = (Number)JsiiObject.jsiiStaticGet(FileSystem.class, (String)"DEFAULT_PORT", (NativeType)NativeType.forClass(Number.class));

    protected FileSystem(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystem(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FileSystem(@NotNull Construct scope, @NotNull String id, @NotNull FileSystemProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IFileSystem fromFileSystemAttributes(@NotNull Construct scope, @NotNull String id, @NotNull FileSystemAttributes attrs) {
        return (IFileSystem)JsiiObject.jsiiStaticCall(FileSystem.class, (String)"fromFileSystemAttributes", (NativeType)NativeType.forClass(IFileSystem.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public AccessPoint addAccessPoint(@NotNull String id, @Nullable AccessPointOptions accessPointOptions) {
        return (AccessPoint)Kernel.call((Object)this, (String)"addAccessPoint", (NativeType)NativeType.forClass(AccessPoint.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), accessPointOptions});
    }

    @NotNull
    public AccessPoint addAccessPoint(@NotNull String id) {
        return (AccessPoint)Kernel.call((Object)this, (String)"addAccessPoint", (NativeType)NativeType.forClass(AccessPoint.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getFileSystemArn() {
        return (String)Kernel.get((Object)this, (String)"fileSystemArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getFileSystemId() {
        return (String)Kernel.get((Object)this, (String)"fileSystemId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IDependable getMountTargetsAvailable() {
        return (IDependable)Kernel.get((Object)this, (String)"mountTargetsAvailable", (NativeType)NativeType.forClass(IDependable.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FileSystem> {
        private final Construct scope;
        private final String id;
        private final FileSystemProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new FileSystemProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder enableAutomaticBackups(Boolean enableAutomaticBackups) {
            this.props.enableAutomaticBackups(enableAutomaticBackups);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        public Builder fileSystemName(String fileSystemName) {
            this.props.fileSystemName(fileSystemName);
            return this;
        }

        public Builder fileSystemPolicy(PolicyDocument fileSystemPolicy) {
            this.props.fileSystemPolicy(fileSystemPolicy);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder lifecyclePolicy(LifecyclePolicy lifecyclePolicy) {
            this.props.lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        public Builder outOfInfrequentAccessPolicy(OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy) {
            this.props.outOfInfrequentAccessPolicy(outOfInfrequentAccessPolicy);
            return this;
        }

        public Builder performanceMode(PerformanceMode performanceMode) {
            this.props.performanceMode(performanceMode);
            return this;
        }

        public Builder provisionedThroughputPerSecond(Size provisionedThroughputPerSecond) {
            this.props.provisionedThroughputPerSecond(provisionedThroughputPerSecond);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder throughputMode(ThroughputMode throughputMode) {
            this.props.throughputMode(throughputMode);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public FileSystem build() {
            return new FileSystem(this.scope, this.id, this.props.build());
        }
    }
}

