/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.backup;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.backup.BackupVaultEvents;
import software.amazon.awscdk.services.backup.BackupVaultProps;
import software.amazon.awscdk.services.backup.IBackupVault;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_backup.BackupVault")
public class BackupVault
extends Resource
implements IBackupVault {
    protected BackupVault(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BackupVault(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public BackupVault(@NotNull Construct scope, @NotNull String id, @Nullable BackupVaultProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public BackupVault(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IBackupVault fromBackupVaultArn(@NotNull Construct scope, @NotNull String id, @NotNull String backupVaultArn) {
        return (IBackupVault)JsiiObject.jsiiStaticCall(BackupVault.class, (String)"fromBackupVaultArn", (NativeType)NativeType.forClass(IBackupVault.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(backupVaultArn, "backupVaultArn is required")});
    }

    @NotNull
    public static IBackupVault fromBackupVaultName(@NotNull Construct scope, @NotNull String id, @NotNull String backupVaultName) {
        return (IBackupVault)JsiiObject.jsiiStaticCall(BackupVault.class, (String)"fromBackupVaultName", (NativeType)NativeType.forClass(IBackupVault.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(backupVaultName, "backupVaultName is required")});
    }

    public void addToAccessPolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)this, (String)"addToAccessPolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void blockRecoveryPointDeletion() {
        Kernel.call((Object)this, (String)"blockRecoveryPointDeletion", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public String getBackupVaultArn() {
        return (String)Kernel.get((Object)this, (String)"backupVaultArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getBackupVaultName() {
        return (String)Kernel.get((Object)this, (String)"backupVaultName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BackupVault> {
        private final Construct scope;
        private final String id;
        private BackupVaultProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder accessPolicy(PolicyDocument accessPolicy) {
            this.props().accessPolicy(accessPolicy);
            return this;
        }

        public Builder backupVaultName(String backupVaultName) {
            this.props().backupVaultName(backupVaultName);
            return this;
        }

        public Builder blockRecoveryPointDeletion(Boolean blockRecoveryPointDeletion) {
            this.props().blockRecoveryPointDeletion(blockRecoveryPointDeletion);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder notificationEvents(List<? extends BackupVaultEvents> notificationEvents) {
            this.props().notificationEvents(notificationEvents);
            return this;
        }

        public Builder notificationTopic(ITopic notificationTopic) {
            this.props().notificationTopic(notificationTopic);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public BackupVault build() {
            return new BackupVault(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private BackupVaultProps.Builder props() {
            if (this.props == null) {
                this.props = new BackupVaultProps.Builder();
            }
            return this.props;
        }
    }
}

