/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apprunner;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.apprunner.CfnService;
import software.amazon.awscdk.services.apprunner.CfnServiceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService")
public class CfnService
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnService.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnService(@NotNull Construct scope, @NotNull String id, @NotNull CfnServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrServiceArn() {
        return (String)Kernel.get((Object)this, (String)"attrServiceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrServiceId() {
        return (String)Kernel.get((Object)this, (String)"attrServiceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrServiceUrl() {
        return (String)Kernel.get((Object)this, (String)"attrServiceUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getSourceConfiguration() {
        return Kernel.get((Object)this, (String)"sourceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"sourceConfiguration", (Object)Objects.requireNonNull(value, "sourceConfiguration is required"));
    }

    public void setSourceConfiguration(@NotNull SourceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"sourceConfiguration", (Object)Objects.requireNonNull(value, "sourceConfiguration is required"));
    }

    @Nullable
    public String getAutoScalingConfigurationArn() {
        return (String)Kernel.get((Object)this, (String)"autoScalingConfigurationArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutoScalingConfigurationArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"autoScalingConfigurationArn", (Object)value);
    }

    @Nullable
    public Object getEncryptionConfiguration() {
        return Kernel.get((Object)this, (String)"encryptionConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryptionConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"encryptionConfiguration", (Object)value);
    }

    public void setEncryptionConfiguration(@Nullable EncryptionConfigurationProperty value) {
        Kernel.set((Object)this, (String)"encryptionConfiguration", (Object)value);
    }

    @Nullable
    public Object getHealthCheckConfiguration() {
        return Kernel.get((Object)this, (String)"healthCheckConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHealthCheckConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"healthCheckConfiguration", (Object)value);
    }

    public void setHealthCheckConfiguration(@Nullable HealthCheckConfigurationProperty value) {
        Kernel.set((Object)this, (String)"healthCheckConfiguration", (Object)value);
    }

    @Nullable
    public Object getInstanceConfiguration() {
        return Kernel.get((Object)this, (String)"instanceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInstanceConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"instanceConfiguration", (Object)value);
    }

    public void setInstanceConfiguration(@Nullable InstanceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"instanceConfiguration", (Object)value);
    }

    @Nullable
    public Object getNetworkConfiguration() {
        return Kernel.get((Object)this, (String)"networkConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNetworkConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"networkConfiguration", (Object)value);
    }

    public void setNetworkConfiguration(@Nullable NetworkConfigurationProperty value) {
        Kernel.set((Object)this, (String)"networkConfiguration", (Object)value);
    }

    @Nullable
    public Object getObservabilityConfiguration() {
        return Kernel.get((Object)this, (String)"observabilityConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setObservabilityConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"observabilityConfiguration", (Object)value);
    }

    public void setObservabilityConfiguration(@Nullable ServiceObservabilityConfigurationProperty value) {
        Kernel.set((Object)this, (String)"observabilityConfiguration", (Object)value);
    }

    @Nullable
    public String getServiceName() {
        return (String)Kernel.get((Object)this, (String)"serviceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceName(@Nullable String value) {
        Kernel.set((Object)this, (String)"serviceName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnService> {
        private final Construct scope;
        private final String id;
        private final CfnServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnServiceProps.Builder();
        }

        public Builder sourceConfiguration(IResolvable sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        public Builder sourceConfiguration(SourceConfigurationProperty sourceConfiguration) {
            this.props.sourceConfiguration(sourceConfiguration);
            return this;
        }

        public Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.props.autoScalingConfigurationArn(autoScalingConfigurationArn);
            return this;
        }

        public Builder encryptionConfiguration(IResolvable encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        public Builder encryptionConfiguration(EncryptionConfigurationProperty encryptionConfiguration) {
            this.props.encryptionConfiguration(encryptionConfiguration);
            return this;
        }

        public Builder healthCheckConfiguration(IResolvable healthCheckConfiguration) {
            this.props.healthCheckConfiguration(healthCheckConfiguration);
            return this;
        }

        public Builder healthCheckConfiguration(HealthCheckConfigurationProperty healthCheckConfiguration) {
            this.props.healthCheckConfiguration(healthCheckConfiguration);
            return this;
        }

        public Builder instanceConfiguration(IResolvable instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }

        public Builder instanceConfiguration(InstanceConfigurationProperty instanceConfiguration) {
            this.props.instanceConfiguration(instanceConfiguration);
            return this;
        }

        public Builder networkConfiguration(IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        public Builder observabilityConfiguration(IResolvable observabilityConfiguration) {
            this.props.observabilityConfiguration(observabilityConfiguration);
            return this;
        }

        public Builder observabilityConfiguration(ServiceObservabilityConfigurationProperty observabilityConfiguration) {
            this.props.observabilityConfiguration(observabilityConfiguration);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnService build() {
            return new CfnService(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.SourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAuthenticationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getAutoDeploymentsEnabled() {
            return null;
        }

        @Nullable
        default public Object getCodeRepository() {
            return null;
        }

        @Nullable
        default public Object getImageRepository() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceConfigurationProperty> {
            Object authenticationConfiguration;
            Object autoDeploymentsEnabled;
            Object codeRepository;
            Object imageRepository;

            public Builder authenticationConfiguration(IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder authenticationConfiguration(AuthenticationConfigurationProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder autoDeploymentsEnabled(Boolean autoDeploymentsEnabled) {
                this.autoDeploymentsEnabled = autoDeploymentsEnabled;
                return this;
            }

            public Builder autoDeploymentsEnabled(IResolvable autoDeploymentsEnabled) {
                this.autoDeploymentsEnabled = autoDeploymentsEnabled;
                return this;
            }

            public Builder codeRepository(IResolvable codeRepository) {
                this.codeRepository = codeRepository;
                return this;
            }

            public Builder codeRepository(CodeRepositoryProperty codeRepository) {
                this.codeRepository = codeRepository;
                return this;
            }

            public Builder imageRepository(IResolvable imageRepository) {
                this.imageRepository = imageRepository;
                return this;
            }

            public Builder imageRepository(ImageRepositoryProperty imageRepository) {
                this.imageRepository = imageRepository;
                return this;
            }

            public SourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.SourceCodeVersionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceCodeVersionProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceCodeVersionProperty> {
            String type;
            String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public SourceCodeVersionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.ServiceObservabilityConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceObservabilityConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getObservabilityEnabled();

        @Nullable
        default public String getObservabilityConfigurationArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceObservabilityConfigurationProperty> {
            Object observabilityEnabled;
            String observabilityConfigurationArn;

            public Builder observabilityEnabled(Boolean observabilityEnabled) {
                this.observabilityEnabled = observabilityEnabled;
                return this;
            }

            public Builder observabilityEnabled(IResolvable observabilityEnabled) {
                this.observabilityEnabled = observabilityEnabled;
                return this;
            }

            public Builder observabilityConfigurationArn(String observabilityConfigurationArn) {
                this.observabilityConfigurationArn = observabilityConfigurationArn;
                return this;
            }

            public ServiceObservabilityConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEgressConfiguration() {
            return null;
        }

        @Nullable
        default public Object getIngressConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            Object egressConfiguration;
            Object ingressConfiguration;

            public Builder egressConfiguration(IResolvable egressConfiguration) {
                this.egressConfiguration = egressConfiguration;
                return this;
            }

            public Builder egressConfiguration(EgressConfigurationProperty egressConfiguration) {
                this.egressConfiguration = egressConfiguration;
                return this;
            }

            public Builder ingressConfiguration(IResolvable ingressConfiguration) {
                this.ingressConfiguration = ingressConfiguration;
                return this;
            }

            public Builder ingressConfiguration(IngressConfigurationProperty ingressConfiguration) {
                this.ingressConfiguration = ingressConfiguration;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.KeyValuePairProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyValuePairProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyValuePairProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public KeyValuePairProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.InstanceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCpu() {
            return null;
        }

        @Nullable
        default public String getInstanceRoleArn() {
            return null;
        }

        @Nullable
        default public String getMemory() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceConfigurationProperty> {
            String cpu;
            String instanceRoleArn;
            String memory;

            public Builder cpu(String cpu) {
                this.cpu = cpu;
                return this;
            }

            public Builder instanceRoleArn(String instanceRoleArn) {
                this.instanceRoleArn = instanceRoleArn;
                return this;
            }

            public Builder memory(String memory) {
                this.memory = memory;
                return this;
            }

            public InstanceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.IngressConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IngressConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getIsPubliclyAccessible();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IngressConfigurationProperty> {
            Object isPubliclyAccessible;

            public Builder isPubliclyAccessible(Boolean isPubliclyAccessible) {
                this.isPubliclyAccessible = isPubliclyAccessible;
                return this;
            }

            public Builder isPubliclyAccessible(IResolvable isPubliclyAccessible) {
                this.isPubliclyAccessible = isPubliclyAccessible;
                return this;
            }

            public IngressConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.ImageRepositoryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImageRepositoryProperty
    extends JsiiSerializable {
        @NotNull
        public String getImageIdentifier();

        @NotNull
        public String getImageRepositoryType();

        @Nullable
        default public Object getImageConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImageRepositoryProperty> {
            String imageIdentifier;
            String imageRepositoryType;
            Object imageConfiguration;

            public Builder imageIdentifier(String imageIdentifier) {
                this.imageIdentifier = imageIdentifier;
                return this;
            }

            public Builder imageRepositoryType(String imageRepositoryType) {
                this.imageRepositoryType = imageRepositoryType;
                return this;
            }

            public Builder imageConfiguration(IResolvable imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            public Builder imageConfiguration(ImageConfigurationProperty imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            public ImageRepositoryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.ImageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImageConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPort() {
            return null;
        }

        @Nullable
        default public Object getRuntimeEnvironmentSecrets() {
            return null;
        }

        @Nullable
        default public Object getRuntimeEnvironmentVariables() {
            return null;
        }

        @Nullable
        default public String getStartCommand() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImageConfigurationProperty> {
            String port;
            Object runtimeEnvironmentSecrets;
            Object runtimeEnvironmentVariables;
            String startCommand;

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public Builder runtimeEnvironmentSecrets(IResolvable runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            public Builder runtimeEnvironmentSecrets(List<? extends Object> runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            public Builder runtimeEnvironmentVariables(IResolvable runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            public Builder runtimeEnvironmentVariables(List<? extends Object> runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            public Builder startCommand(String startCommand) {
                this.startCommand = startCommand;
                return this;
            }

            public ImageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.HealthCheckConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HealthCheckConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getHealthyThreshold() {
            return null;
        }

        @Nullable
        default public Number getInterval() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        @Nullable
        default public String getProtocol() {
            return null;
        }

        @Nullable
        default public Number getTimeout() {
            return null;
        }

        @Nullable
        default public Number getUnhealthyThreshold() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HealthCheckConfigurationProperty> {
            Number healthyThreshold;
            Number interval;
            String path;
            String protocol;
            Number timeout;
            Number unhealthyThreshold;

            public Builder healthyThreshold(Number healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            public Builder interval(Number interval) {
                this.interval = interval;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder timeout(Number timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder unhealthyThreshold(Number unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            public HealthCheckConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getKmsKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            String kmsKey;

            public Builder kmsKey(String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            public EncryptionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.EgressConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EgressConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEgressType();

        @Nullable
        default public String getVpcConnectorArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EgressConfigurationProperty> {
            String egressType;
            String vpcConnectorArn;

            public Builder egressType(String egressType) {
                this.egressType = egressType;
                return this;
            }

            public Builder vpcConnectorArn(String vpcConnectorArn) {
                this.vpcConnectorArn = vpcConnectorArn;
                return this;
            }

            public EgressConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.CodeRepositoryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeRepositoryProperty
    extends JsiiSerializable {
        @NotNull
        public String getRepositoryUrl();

        @NotNull
        public Object getSourceCodeVersion();

        @Nullable
        default public Object getCodeConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeRepositoryProperty> {
            String repositoryUrl;
            Object sourceCodeVersion;
            Object codeConfiguration;

            public Builder repositoryUrl(String repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
                return this;
            }

            public Builder sourceCodeVersion(IResolvable sourceCodeVersion) {
                this.sourceCodeVersion = sourceCodeVersion;
                return this;
            }

            public Builder sourceCodeVersion(SourceCodeVersionProperty sourceCodeVersion) {
                this.sourceCodeVersion = sourceCodeVersion;
                return this;
            }

            public Builder codeConfiguration(IResolvable codeConfiguration) {
                this.codeConfiguration = codeConfiguration;
                return this;
            }

            public Builder codeConfiguration(CodeConfigurationProperty codeConfiguration) {
                this.codeConfiguration = codeConfiguration;
                return this;
            }

            public CodeRepositoryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationValuesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeConfigurationValuesProperty
    extends JsiiSerializable {
        @NotNull
        public String getRuntime();

        @Nullable
        default public String getBuildCommand() {
            return null;
        }

        @Nullable
        default public String getPort() {
            return null;
        }

        @Nullable
        default public Object getRuntimeEnvironmentSecrets() {
            return null;
        }

        @Nullable
        default public Object getRuntimeEnvironmentVariables() {
            return null;
        }

        @Nullable
        default public String getStartCommand() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeConfigurationValuesProperty> {
            String runtime;
            String buildCommand;
            String port;
            Object runtimeEnvironmentSecrets;
            Object runtimeEnvironmentVariables;
            String startCommand;

            public Builder runtime(String runtime) {
                this.runtime = runtime;
                return this;
            }

            public Builder buildCommand(String buildCommand) {
                this.buildCommand = buildCommand;
                return this;
            }

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public Builder runtimeEnvironmentSecrets(IResolvable runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            public Builder runtimeEnvironmentSecrets(List<? extends Object> runtimeEnvironmentSecrets) {
                this.runtimeEnvironmentSecrets = runtimeEnvironmentSecrets;
                return this;
            }

            public Builder runtimeEnvironmentVariables(IResolvable runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            public Builder runtimeEnvironmentVariables(List<? extends Object> runtimeEnvironmentVariables) {
                this.runtimeEnvironmentVariables = runtimeEnvironmentVariables;
                return this;
            }

            public Builder startCommand(String startCommand) {
                this.startCommand = startCommand;
                return this;
            }

            public CodeConfigurationValuesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.CodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getConfigurationSource();

        @Nullable
        default public Object getCodeConfigurationValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeConfigurationProperty> {
            String configurationSource;
            Object codeConfigurationValues;

            public Builder configurationSource(String configurationSource) {
                this.configurationSource = configurationSource;
                return this;
            }

            public Builder codeConfigurationValues(IResolvable codeConfigurationValues) {
                this.codeConfigurationValues = codeConfigurationValues;
                return this;
            }

            public Builder codeConfigurationValues(CodeConfigurationValuesProperty codeConfigurationValues) {
                this.codeConfigurationValues = codeConfigurationValues;
                return this;
            }

            public CodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apprunner.CfnService.AuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthenticationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessRoleArn() {
            return null;
        }

        @Nullable
        default public String getConnectionArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthenticationConfigurationProperty> {
            String accessRoleArn;
            String connectionArn;

            public Builder accessRoleArn(String accessRoleArn) {
                this.accessRoleArn = accessRoleArn;
                return this;
            }

            public Builder connectionArn(String connectionArn) {
                this.connectionArn = connectionArn;
                return this;
            }

            public AuthenticationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

