/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cognito;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.cognito.CfnUserPool;
import software.amazon.awscdk.services.cognito.CfnUserPoolProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool")
public class CfnUserPool
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnUserPool.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnUserPool(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPool(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnUserPool(@NotNull Construct scope, @NotNull String id, @Nullable CfnUserPoolProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnUserPool(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProviderName() {
        return (String)Kernel.get((Object)this, (String)"attrProviderName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProviderUrl() {
        return (String)Kernel.get((Object)this, (String)"attrProviderUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Object getAccountRecoverySetting() {
        return Kernel.get((Object)this, (String)"accountRecoverySetting", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAccountRecoverySetting(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"accountRecoverySetting", (Object)value);
    }

    public void setAccountRecoverySetting(@Nullable AccountRecoverySettingProperty value) {
        Kernel.set((Object)this, (String)"accountRecoverySetting", (Object)value);
    }

    @Nullable
    public Object getAdminCreateUserConfig() {
        return Kernel.get((Object)this, (String)"adminCreateUserConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAdminCreateUserConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"adminCreateUserConfig", (Object)value);
    }

    public void setAdminCreateUserConfig(@Nullable AdminCreateUserConfigProperty value) {
        Kernel.set((Object)this, (String)"adminCreateUserConfig", (Object)value);
    }

    @Nullable
    public List<String> getAliasAttributes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"aliasAttributes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAliasAttributes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"aliasAttributes", value);
    }

    @Nullable
    public List<String> getAutoVerifiedAttributes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"autoVerifiedAttributes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAutoVerifiedAttributes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"autoVerifiedAttributes", value);
    }

    @Nullable
    public String getDeletionProtection() {
        return (String)Kernel.get((Object)this, (String)"deletionProtection", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeletionProtection(@Nullable String value) {
        Kernel.set((Object)this, (String)"deletionProtection", (Object)value);
    }

    @Nullable
    public Object getDeviceConfiguration() {
        return Kernel.get((Object)this, (String)"deviceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeviceConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deviceConfiguration", (Object)value);
    }

    public void setDeviceConfiguration(@Nullable DeviceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"deviceConfiguration", (Object)value);
    }

    @Nullable
    public Object getEmailConfiguration() {
        return Kernel.get((Object)this, (String)"emailConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEmailConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"emailConfiguration", (Object)value);
    }

    public void setEmailConfiguration(@Nullable EmailConfigurationProperty value) {
        Kernel.set((Object)this, (String)"emailConfiguration", (Object)value);
    }

    @Nullable
    public String getEmailVerificationMessage() {
        return (String)Kernel.get((Object)this, (String)"emailVerificationMessage", (NativeType)NativeType.forClass(String.class));
    }

    public void setEmailVerificationMessage(@Nullable String value) {
        Kernel.set((Object)this, (String)"emailVerificationMessage", (Object)value);
    }

    @Nullable
    public String getEmailVerificationSubject() {
        return (String)Kernel.get((Object)this, (String)"emailVerificationSubject", (NativeType)NativeType.forClass(String.class));
    }

    public void setEmailVerificationSubject(@Nullable String value) {
        Kernel.set((Object)this, (String)"emailVerificationSubject", (Object)value);
    }

    @Nullable
    public List<String> getEnabledMfas() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"enabledMfas", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setEnabledMfas(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"enabledMfas", value);
    }

    @Nullable
    public Object getLambdaConfig() {
        return Kernel.get((Object)this, (String)"lambdaConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLambdaConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lambdaConfig", (Object)value);
    }

    public void setLambdaConfig(@Nullable LambdaConfigProperty value) {
        Kernel.set((Object)this, (String)"lambdaConfig", (Object)value);
    }

    @Nullable
    public String getMfaConfiguration() {
        return (String)Kernel.get((Object)this, (String)"mfaConfiguration", (NativeType)NativeType.forClass(String.class));
    }

    public void setMfaConfiguration(@Nullable String value) {
        Kernel.set((Object)this, (String)"mfaConfiguration", (Object)value);
    }

    @Nullable
    public Object getPolicies() {
        return Kernel.get((Object)this, (String)"policies", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPolicies(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"policies", (Object)value);
    }

    public void setPolicies(@Nullable PoliciesProperty value) {
        Kernel.set((Object)this, (String)"policies", (Object)value);
    }

    @Nullable
    public Object getSchema() {
        return Kernel.get((Object)this, (String)"schema", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSchema(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"schema", (Object)value);
    }

    public void setSchema(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof SchemaAttributeProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cognito.CfnUserPool.SchemaAttributeProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"schema", value);
    }

    @Nullable
    public String getSmsAuthenticationMessage() {
        return (String)Kernel.get((Object)this, (String)"smsAuthenticationMessage", (NativeType)NativeType.forClass(String.class));
    }

    public void setSmsAuthenticationMessage(@Nullable String value) {
        Kernel.set((Object)this, (String)"smsAuthenticationMessage", (Object)value);
    }

    @Nullable
    public Object getSmsConfiguration() {
        return Kernel.get((Object)this, (String)"smsConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSmsConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"smsConfiguration", (Object)value);
    }

    public void setSmsConfiguration(@Nullable SmsConfigurationProperty value) {
        Kernel.set((Object)this, (String)"smsConfiguration", (Object)value);
    }

    @Nullable
    public String getSmsVerificationMessage() {
        return (String)Kernel.get((Object)this, (String)"smsVerificationMessage", (NativeType)NativeType.forClass(String.class));
    }

    public void setSmsVerificationMessage(@Nullable String value) {
        Kernel.set((Object)this, (String)"smsVerificationMessage", (Object)value);
    }

    @Nullable
    public Object getUserAttributeUpdateSettings() {
        return Kernel.get((Object)this, (String)"userAttributeUpdateSettings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUserAttributeUpdateSettings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"userAttributeUpdateSettings", (Object)value);
    }

    public void setUserAttributeUpdateSettings(@Nullable UserAttributeUpdateSettingsProperty value) {
        Kernel.set((Object)this, (String)"userAttributeUpdateSettings", (Object)value);
    }

    @Nullable
    public List<String> getUsernameAttributes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"usernameAttributes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setUsernameAttributes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"usernameAttributes", value);
    }

    @Nullable
    public Object getUsernameConfiguration() {
        return Kernel.get((Object)this, (String)"usernameConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUsernameConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"usernameConfiguration", (Object)value);
    }

    public void setUsernameConfiguration(@Nullable UsernameConfigurationProperty value) {
        Kernel.set((Object)this, (String)"usernameConfiguration", (Object)value);
    }

    @Nullable
    public Object getUserPoolAddOns() {
        return Kernel.get((Object)this, (String)"userPoolAddOns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUserPoolAddOns(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"userPoolAddOns", (Object)value);
    }

    public void setUserPoolAddOns(@Nullable UserPoolAddOnsProperty value) {
        Kernel.set((Object)this, (String)"userPoolAddOns", (Object)value);
    }

    @Nullable
    public String getUserPoolName() {
        return (String)Kernel.get((Object)this, (String)"userPoolName", (NativeType)NativeType.forClass(String.class));
    }

    public void setUserPoolName(@Nullable String value) {
        Kernel.set((Object)this, (String)"userPoolName", (Object)value);
    }

    @Nullable
    public Object getVerificationMessageTemplate() {
        return Kernel.get((Object)this, (String)"verificationMessageTemplate", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVerificationMessageTemplate(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"verificationMessageTemplate", (Object)value);
    }

    public void setVerificationMessageTemplate(@Nullable VerificationMessageTemplateProperty value) {
        Kernel.set((Object)this, (String)"verificationMessageTemplate", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.SchemaAttributeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SchemaAttributeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAttributeDataType() {
            return null;
        }

        @Nullable
        default public Object getDeveloperOnlyAttribute() {
            return null;
        }

        @Nullable
        default public Object getMutable() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getNumberAttributeConstraints() {
            return null;
        }

        @Nullable
        default public Object getRequired() {
            return null;
        }

        @Nullable
        default public Object getStringAttributeConstraints() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SchemaAttributeProperty> {
            String attributeDataType;
            Object developerOnlyAttribute;
            Object mutable;
            String name;
            Object numberAttributeConstraints;
            Object required;
            Object stringAttributeConstraints;

            public Builder attributeDataType(String attributeDataType) {
                this.attributeDataType = attributeDataType;
                return this;
            }

            public Builder developerOnlyAttribute(Boolean developerOnlyAttribute) {
                this.developerOnlyAttribute = developerOnlyAttribute;
                return this;
            }

            public Builder developerOnlyAttribute(IResolvable developerOnlyAttribute) {
                this.developerOnlyAttribute = developerOnlyAttribute;
                return this;
            }

            public Builder mutable(Boolean mutable) {
                this.mutable = mutable;
                return this;
            }

            public Builder mutable(IResolvable mutable) {
                this.mutable = mutable;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder numberAttributeConstraints(IResolvable numberAttributeConstraints) {
                this.numberAttributeConstraints = numberAttributeConstraints;
                return this;
            }

            public Builder numberAttributeConstraints(NumberAttributeConstraintsProperty numberAttributeConstraints) {
                this.numberAttributeConstraints = numberAttributeConstraints;
                return this;
            }

            public Builder required(Boolean required) {
                this.required = required;
                return this;
            }

            public Builder required(IResolvable required) {
                this.required = required;
                return this;
            }

            public Builder stringAttributeConstraints(IResolvable stringAttributeConstraints) {
                this.stringAttributeConstraints = stringAttributeConstraints;
                return this;
            }

            public Builder stringAttributeConstraints(StringAttributeConstraintsProperty stringAttributeConstraints) {
                this.stringAttributeConstraints = stringAttributeConstraints;
                return this;
            }

            public SchemaAttributeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnUserPool> {
        private final Construct scope;
        private final String id;
        private CfnUserPoolProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder accountRecoverySetting(IResolvable accountRecoverySetting) {
            this.props().accountRecoverySetting(accountRecoverySetting);
            return this;
        }

        public Builder accountRecoverySetting(AccountRecoverySettingProperty accountRecoverySetting) {
            this.props().accountRecoverySetting(accountRecoverySetting);
            return this;
        }

        public Builder adminCreateUserConfig(IResolvable adminCreateUserConfig) {
            this.props().adminCreateUserConfig(adminCreateUserConfig);
            return this;
        }

        public Builder adminCreateUserConfig(AdminCreateUserConfigProperty adminCreateUserConfig) {
            this.props().adminCreateUserConfig(adminCreateUserConfig);
            return this;
        }

        public Builder aliasAttributes(List<String> aliasAttributes) {
            this.props().aliasAttributes(aliasAttributes);
            return this;
        }

        public Builder autoVerifiedAttributes(List<String> autoVerifiedAttributes) {
            this.props().autoVerifiedAttributes(autoVerifiedAttributes);
            return this;
        }

        public Builder deletionProtection(String deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        public Builder deviceConfiguration(IResolvable deviceConfiguration) {
            this.props().deviceConfiguration(deviceConfiguration);
            return this;
        }

        public Builder deviceConfiguration(DeviceConfigurationProperty deviceConfiguration) {
            this.props().deviceConfiguration(deviceConfiguration);
            return this;
        }

        public Builder emailConfiguration(IResolvable emailConfiguration) {
            this.props().emailConfiguration(emailConfiguration);
            return this;
        }

        public Builder emailConfiguration(EmailConfigurationProperty emailConfiguration) {
            this.props().emailConfiguration(emailConfiguration);
            return this;
        }

        public Builder emailVerificationMessage(String emailVerificationMessage) {
            this.props().emailVerificationMessage(emailVerificationMessage);
            return this;
        }

        public Builder emailVerificationSubject(String emailVerificationSubject) {
            this.props().emailVerificationSubject(emailVerificationSubject);
            return this;
        }

        public Builder enabledMfas(List<String> enabledMfas) {
            this.props().enabledMfas(enabledMfas);
            return this;
        }

        public Builder lambdaConfig(IResolvable lambdaConfig) {
            this.props().lambdaConfig(lambdaConfig);
            return this;
        }

        public Builder lambdaConfig(LambdaConfigProperty lambdaConfig) {
            this.props().lambdaConfig(lambdaConfig);
            return this;
        }

        public Builder mfaConfiguration(String mfaConfiguration) {
            this.props().mfaConfiguration(mfaConfiguration);
            return this;
        }

        public Builder policies(IResolvable policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder policies(PoliciesProperty policies) {
            this.props().policies(policies);
            return this;
        }

        public Builder schema(IResolvable schema) {
            this.props().schema(schema);
            return this;
        }

        public Builder schema(List<? extends Object> schema) {
            this.props().schema(schema);
            return this;
        }

        public Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.props().smsAuthenticationMessage(smsAuthenticationMessage);
            return this;
        }

        public Builder smsConfiguration(IResolvable smsConfiguration) {
            this.props().smsConfiguration(smsConfiguration);
            return this;
        }

        public Builder smsConfiguration(SmsConfigurationProperty smsConfiguration) {
            this.props().smsConfiguration(smsConfiguration);
            return this;
        }

        public Builder smsVerificationMessage(String smsVerificationMessage) {
            this.props().smsVerificationMessage(smsVerificationMessage);
            return this;
        }

        public Builder userAttributeUpdateSettings(IResolvable userAttributeUpdateSettings) {
            this.props().userAttributeUpdateSettings(userAttributeUpdateSettings);
            return this;
        }

        public Builder userAttributeUpdateSettings(UserAttributeUpdateSettingsProperty userAttributeUpdateSettings) {
            this.props().userAttributeUpdateSettings(userAttributeUpdateSettings);
            return this;
        }

        public Builder usernameAttributes(List<String> usernameAttributes) {
            this.props().usernameAttributes(usernameAttributes);
            return this;
        }

        public Builder usernameConfiguration(IResolvable usernameConfiguration) {
            this.props().usernameConfiguration(usernameConfiguration);
            return this;
        }

        public Builder usernameConfiguration(UsernameConfigurationProperty usernameConfiguration) {
            this.props().usernameConfiguration(usernameConfiguration);
            return this;
        }

        public Builder userPoolAddOns(IResolvable userPoolAddOns) {
            this.props().userPoolAddOns(userPoolAddOns);
            return this;
        }

        public Builder userPoolAddOns(UserPoolAddOnsProperty userPoolAddOns) {
            this.props().userPoolAddOns(userPoolAddOns);
            return this;
        }

        public Builder userPoolName(String userPoolName) {
            this.props().userPoolName(userPoolName);
            return this;
        }

        public Builder userPoolTags(Object userPoolTags) {
            this.props().userPoolTags(userPoolTags);
            return this;
        }

        public Builder verificationMessageTemplate(IResolvable verificationMessageTemplate) {
            this.props().verificationMessageTemplate(verificationMessageTemplate);
            return this;
        }

        public Builder verificationMessageTemplate(VerificationMessageTemplateProperty verificationMessageTemplate) {
            this.props().verificationMessageTemplate(verificationMessageTemplate);
            return this;
        }

        public CfnUserPool build() {
            return new CfnUserPool(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnUserPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnUserPoolProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.VerificationMessageTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VerificationMessageTemplateProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDefaultEmailOption() {
            return null;
        }

        @Nullable
        default public String getEmailMessage() {
            return null;
        }

        @Nullable
        default public String getEmailMessageByLink() {
            return null;
        }

        @Nullable
        default public String getEmailSubject() {
            return null;
        }

        @Nullable
        default public String getEmailSubjectByLink() {
            return null;
        }

        @Nullable
        default public String getSmsMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VerificationMessageTemplateProperty> {
            String defaultEmailOption;
            String emailMessage;
            String emailMessageByLink;
            String emailSubject;
            String emailSubjectByLink;
            String smsMessage;

            public Builder defaultEmailOption(String defaultEmailOption) {
                this.defaultEmailOption = defaultEmailOption;
                return this;
            }

            public Builder emailMessage(String emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Builder emailMessageByLink(String emailMessageByLink) {
                this.emailMessageByLink = emailMessageByLink;
                return this;
            }

            public Builder emailSubject(String emailSubject) {
                this.emailSubject = emailSubject;
                return this;
            }

            public Builder emailSubjectByLink(String emailSubjectByLink) {
                this.emailSubjectByLink = emailSubjectByLink;
                return this;
            }

            public Builder smsMessage(String smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            public VerificationMessageTemplateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.UsernameConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UsernameConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCaseSensitive() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UsernameConfigurationProperty> {
            Object caseSensitive;

            public Builder caseSensitive(Boolean caseSensitive) {
                this.caseSensitive = caseSensitive;
                return this;
            }

            public Builder caseSensitive(IResolvable caseSensitive) {
                this.caseSensitive = caseSensitive;
                return this;
            }

            public UsernameConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.UserPoolAddOnsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UserPoolAddOnsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAdvancedSecurityMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UserPoolAddOnsProperty> {
            String advancedSecurityMode;

            public Builder advancedSecurityMode(String advancedSecurityMode) {
                this.advancedSecurityMode = advancedSecurityMode;
                return this;
            }

            public UserPoolAddOnsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.UserAttributeUpdateSettingsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UserAttributeUpdateSettingsProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getAttributesRequireVerificationBeforeUpdate();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UserAttributeUpdateSettingsProperty> {
            List<String> attributesRequireVerificationBeforeUpdate;

            public Builder attributesRequireVerificationBeforeUpdate(List<String> attributesRequireVerificationBeforeUpdate) {
                this.attributesRequireVerificationBeforeUpdate = attributesRequireVerificationBeforeUpdate;
                return this;
            }

            public UserAttributeUpdateSettingsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.StringAttributeConstraintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringAttributeConstraintsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMaxLength() {
            return null;
        }

        @Nullable
        default public String getMinLength() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringAttributeConstraintsProperty> {
            String maxLength;
            String minLength;

            public Builder maxLength(String maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public Builder minLength(String minLength) {
                this.minLength = minLength;
                return this;
            }

            public StringAttributeConstraintsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.SmsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SmsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getExternalId() {
            return null;
        }

        @Nullable
        default public String getSnsCallerArn() {
            return null;
        }

        @Nullable
        default public String getSnsRegion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SmsConfigurationProperty> {
            String externalId;
            String snsCallerArn;
            String snsRegion;

            public Builder externalId(String externalId) {
                this.externalId = externalId;
                return this;
            }

            public Builder snsCallerArn(String snsCallerArn) {
                this.snsCallerArn = snsCallerArn;
                return this;
            }

            public Builder snsRegion(String snsRegion) {
                this.snsRegion = snsRegion;
                return this;
            }

            public SmsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.RecoveryOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecoveryOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Number getPriority() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecoveryOptionProperty> {
            String name;
            Number priority;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public RecoveryOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.PoliciesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PoliciesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPasswordPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PoliciesProperty> {
            Object passwordPolicy;

            public Builder passwordPolicy(IResolvable passwordPolicy) {
                this.passwordPolicy = passwordPolicy;
                return this;
            }

            public Builder passwordPolicy(PasswordPolicyProperty passwordPolicy) {
                this.passwordPolicy = passwordPolicy;
                return this;
            }

            public PoliciesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.PasswordPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PasswordPolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMinimumLength() {
            return null;
        }

        @Nullable
        default public Object getRequireLowercase() {
            return null;
        }

        @Nullable
        default public Object getRequireNumbers() {
            return null;
        }

        @Nullable
        default public Object getRequireSymbols() {
            return null;
        }

        @Nullable
        default public Object getRequireUppercase() {
            return null;
        }

        @Nullable
        default public Number getTemporaryPasswordValidityDays() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PasswordPolicyProperty> {
            Number minimumLength;
            Object requireLowercase;
            Object requireNumbers;
            Object requireSymbols;
            Object requireUppercase;
            Number temporaryPasswordValidityDays;

            public Builder minimumLength(Number minimumLength) {
                this.minimumLength = minimumLength;
                return this;
            }

            public Builder requireLowercase(Boolean requireLowercase) {
                this.requireLowercase = requireLowercase;
                return this;
            }

            public Builder requireLowercase(IResolvable requireLowercase) {
                this.requireLowercase = requireLowercase;
                return this;
            }

            public Builder requireNumbers(Boolean requireNumbers) {
                this.requireNumbers = requireNumbers;
                return this;
            }

            public Builder requireNumbers(IResolvable requireNumbers) {
                this.requireNumbers = requireNumbers;
                return this;
            }

            public Builder requireSymbols(Boolean requireSymbols) {
                this.requireSymbols = requireSymbols;
                return this;
            }

            public Builder requireSymbols(IResolvable requireSymbols) {
                this.requireSymbols = requireSymbols;
                return this;
            }

            public Builder requireUppercase(Boolean requireUppercase) {
                this.requireUppercase = requireUppercase;
                return this;
            }

            public Builder requireUppercase(IResolvable requireUppercase) {
                this.requireUppercase = requireUppercase;
                return this;
            }

            public Builder temporaryPasswordValidityDays(Number temporaryPasswordValidityDays) {
                this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
                return this;
            }

            public PasswordPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.NumberAttributeConstraintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumberAttributeConstraintsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMaxValue() {
            return null;
        }

        @Nullable
        default public String getMinValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumberAttributeConstraintsProperty> {
            String maxValue;
            String minValue;

            public Builder maxValue(String maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            public Builder minValue(String minValue) {
                this.minValue = minValue;
                return this;
            }

            public NumberAttributeConstraintsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.LambdaConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCreateAuthChallenge() {
            return null;
        }

        @Nullable
        default public Object getCustomEmailSender() {
            return null;
        }

        @Nullable
        default public String getCustomMessage() {
            return null;
        }

        @Nullable
        default public Object getCustomSmsSender() {
            return null;
        }

        @Nullable
        default public String getDefineAuthChallenge() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public String getPostAuthentication() {
            return null;
        }

        @Nullable
        default public String getPostConfirmation() {
            return null;
        }

        @Nullable
        default public String getPreAuthentication() {
            return null;
        }

        @Nullable
        default public String getPreSignUp() {
            return null;
        }

        @Nullable
        default public String getPreTokenGeneration() {
            return null;
        }

        @Nullable
        default public String getUserMigration() {
            return null;
        }

        @Nullable
        default public String getVerifyAuthChallengeResponse() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaConfigProperty> {
            String createAuthChallenge;
            Object customEmailSender;
            String customMessage;
            Object customSmsSender;
            String defineAuthChallenge;
            String kmsKeyId;
            String postAuthentication;
            String postConfirmation;
            String preAuthentication;
            String preSignUp;
            String preTokenGeneration;
            String userMigration;
            String verifyAuthChallengeResponse;

            public Builder createAuthChallenge(String createAuthChallenge) {
                this.createAuthChallenge = createAuthChallenge;
                return this;
            }

            public Builder customEmailSender(IResolvable customEmailSender) {
                this.customEmailSender = customEmailSender;
                return this;
            }

            public Builder customEmailSender(CustomEmailSenderProperty customEmailSender) {
                this.customEmailSender = customEmailSender;
                return this;
            }

            public Builder customMessage(String customMessage) {
                this.customMessage = customMessage;
                return this;
            }

            public Builder customSmsSender(IResolvable customSmsSender) {
                this.customSmsSender = customSmsSender;
                return this;
            }

            public Builder customSmsSender(CustomSMSSenderProperty customSmsSender) {
                this.customSmsSender = customSmsSender;
                return this;
            }

            public Builder defineAuthChallenge(String defineAuthChallenge) {
                this.defineAuthChallenge = defineAuthChallenge;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder postAuthentication(String postAuthentication) {
                this.postAuthentication = postAuthentication;
                return this;
            }

            public Builder postConfirmation(String postConfirmation) {
                this.postConfirmation = postConfirmation;
                return this;
            }

            public Builder preAuthentication(String preAuthentication) {
                this.preAuthentication = preAuthentication;
                return this;
            }

            public Builder preSignUp(String preSignUp) {
                this.preSignUp = preSignUp;
                return this;
            }

            public Builder preTokenGeneration(String preTokenGeneration) {
                this.preTokenGeneration = preTokenGeneration;
                return this;
            }

            public Builder userMigration(String userMigration) {
                this.userMigration = userMigration;
                return this;
            }

            public Builder verifyAuthChallengeResponse(String verifyAuthChallengeResponse) {
                this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
                return this;
            }

            public LambdaConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.InviteMessageTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InviteMessageTemplateProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEmailMessage() {
            return null;
        }

        @Nullable
        default public String getEmailSubject() {
            return null;
        }

        @Nullable
        default public String getSmsMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InviteMessageTemplateProperty> {
            String emailMessage;
            String emailSubject;
            String smsMessage;

            public Builder emailMessage(String emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            public Builder emailSubject(String emailSubject) {
                this.emailSubject = emailSubject;
                return this;
            }

            public Builder smsMessage(String smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            public InviteMessageTemplateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.EmailConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmailConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConfigurationSet() {
            return null;
        }

        @Nullable
        default public String getEmailSendingAccount() {
            return null;
        }

        @Nullable
        default public String getFrom() {
            return null;
        }

        @Nullable
        default public String getReplyToEmailAddress() {
            return null;
        }

        @Nullable
        default public String getSourceArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmailConfigurationProperty> {
            String configurationSet;
            String emailSendingAccount;
            String from;
            String replyToEmailAddress;
            String sourceArn;

            public Builder configurationSet(String configurationSet) {
                this.configurationSet = configurationSet;
                return this;
            }

            public Builder emailSendingAccount(String emailSendingAccount) {
                this.emailSendingAccount = emailSendingAccount;
                return this;
            }

            public Builder from(String from) {
                this.from = from;
                return this;
            }

            public Builder replyToEmailAddress(String replyToEmailAddress) {
                this.replyToEmailAddress = replyToEmailAddress;
                return this;
            }

            public Builder sourceArn(String sourceArn) {
                this.sourceArn = sourceArn;
                return this;
            }

            public EmailConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.DeviceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeviceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getChallengeRequiredOnNewDevice() {
            return null;
        }

        @Nullable
        default public Object getDeviceOnlyRememberedOnUserPrompt() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeviceConfigurationProperty> {
            Object challengeRequiredOnNewDevice;
            Object deviceOnlyRememberedOnUserPrompt;

            public Builder challengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
                this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
                return this;
            }

            public Builder challengeRequiredOnNewDevice(IResolvable challengeRequiredOnNewDevice) {
                this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
                return this;
            }

            public Builder deviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
                this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
                return this;
            }

            public Builder deviceOnlyRememberedOnUserPrompt(IResolvable deviceOnlyRememberedOnUserPrompt) {
                this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
                return this;
            }

            public DeviceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.CustomSMSSenderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomSMSSenderProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLambdaArn() {
            return null;
        }

        @Nullable
        default public String getLambdaVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomSMSSenderProperty> {
            String lambdaArn;
            String lambdaVersion;

            public Builder lambdaArn(String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            public Builder lambdaVersion(String lambdaVersion) {
                this.lambdaVersion = lambdaVersion;
                return this;
            }

            public CustomSMSSenderProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.CustomEmailSenderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomEmailSenderProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLambdaArn() {
            return null;
        }

        @Nullable
        default public String getLambdaVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomEmailSenderProperty> {
            String lambdaArn;
            String lambdaVersion;

            public Builder lambdaArn(String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            public Builder lambdaVersion(String lambdaVersion) {
                this.lambdaVersion = lambdaVersion;
                return this;
            }

            public CustomEmailSenderProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.AdminCreateUserConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AdminCreateUserConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllowAdminCreateUserOnly() {
            return null;
        }

        @Nullable
        default public Object getInviteMessageTemplate() {
            return null;
        }

        @Nullable
        default public Number getUnusedAccountValidityDays() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AdminCreateUserConfigProperty> {
            Object allowAdminCreateUserOnly;
            Object inviteMessageTemplate;
            Number unusedAccountValidityDays;

            public Builder allowAdminCreateUserOnly(Boolean allowAdminCreateUserOnly) {
                this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
                return this;
            }

            public Builder allowAdminCreateUserOnly(IResolvable allowAdminCreateUserOnly) {
                this.allowAdminCreateUserOnly = allowAdminCreateUserOnly;
                return this;
            }

            public Builder inviteMessageTemplate(IResolvable inviteMessageTemplate) {
                this.inviteMessageTemplate = inviteMessageTemplate;
                return this;
            }

            public Builder inviteMessageTemplate(InviteMessageTemplateProperty inviteMessageTemplate) {
                this.inviteMessageTemplate = inviteMessageTemplate;
                return this;
            }

            public Builder unusedAccountValidityDays(Number unusedAccountValidityDays) {
                this.unusedAccountValidityDays = unusedAccountValidityDays;
                return this;
            }

            public AdminCreateUserConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.CfnUserPool.AccountRecoverySettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccountRecoverySettingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getRecoveryMechanisms() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccountRecoverySettingProperty> {
            Object recoveryMechanisms;

            public Builder recoveryMechanisms(IResolvable recoveryMechanisms) {
                this.recoveryMechanisms = recoveryMechanisms;
                return this;
            }

            public Builder recoveryMechanisms(List<? extends Object> recoveryMechanisms) {
                this.recoveryMechanisms = recoveryMechanisms;
                return this;
            }

            public AccountRecoverySettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

