/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.emr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.emr.CfnInstanceFleetConfig;
import software.amazon.awscdk.services.emr.CfnInstanceFleetConfigProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig")
public class CfnInstanceFleetConfig
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInstanceFleetConfig.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInstanceFleetConfig(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstanceFleetConfig(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInstanceFleetConfig(@NotNull Construct scope, @NotNull String id, @NotNull CfnInstanceFleetConfigProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getClusterId() {
        return (String)Kernel.get((Object)this, (String)"clusterId", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterId(@NotNull String value) {
        Kernel.set((Object)this, (String)"clusterId", (Object)Objects.requireNonNull(value, "clusterId is required"));
    }

    @NotNull
    public String getInstanceFleetType() {
        return (String)Kernel.get((Object)this, (String)"instanceFleetType", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceFleetType(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceFleetType", (Object)Objects.requireNonNull(value, "instanceFleetType is required"));
    }

    @Nullable
    public Object getInstanceTypeConfigs() {
        return Kernel.get((Object)this, (String)"instanceTypeConfigs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInstanceTypeConfigs(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"instanceTypeConfigs", (Object)value);
    }

    public void setInstanceTypeConfigs(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof InstanceTypeConfigProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceTypeConfigProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"instanceTypeConfigs", value);
    }

    @Nullable
    public Object getLaunchSpecifications() {
        return Kernel.get((Object)this, (String)"launchSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLaunchSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"launchSpecifications", (Object)value);
    }

    public void setLaunchSpecifications(@Nullable InstanceFleetProvisioningSpecificationsProperty value) {
        Kernel.set((Object)this, (String)"launchSpecifications", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Number getTargetOnDemandCapacity() {
        return (Number)Kernel.get((Object)this, (String)"targetOnDemandCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTargetOnDemandCapacity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"targetOnDemandCapacity", (Object)value);
    }

    @Nullable
    public Number getTargetSpotCapacity() {
        return (Number)Kernel.get((Object)this, (String)"targetSpotCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setTargetSpotCapacity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"targetSpotCapacity", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceTypeConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceType();

        @Nullable
        default public String getBidPrice() {
            return null;
        }

        @Nullable
        default public Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        @Nullable
        default public Object getConfigurations() {
            return null;
        }

        @Nullable
        default public String getCustomAmiId() {
            return null;
        }

        @Nullable
        default public Object getEbsConfiguration() {
            return null;
        }

        @Nullable
        default public Number getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceTypeConfigProperty> {
            String instanceType;
            String bidPrice;
            Number bidPriceAsPercentageOfOnDemandPrice;
            Object configurations;
            String customAmiId;
            Object ebsConfiguration;
            Number weightedCapacity;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder bidPrice(String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            public Builder bidPriceAsPercentageOfOnDemandPrice(Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            public Builder configurations(IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder configurations(List<? extends Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder customAmiId(String customAmiId) {
                this.customAmiId = customAmiId;
                return this;
            }

            public Builder ebsConfiguration(IResolvable ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public InstanceTypeConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInstanceFleetConfig> {
        private final Construct scope;
        private final String id;
        private final CfnInstanceFleetConfigProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInstanceFleetConfigProps.Builder();
        }

        public Builder clusterId(String clusterId) {
            this.props.clusterId(clusterId);
            return this;
        }

        public Builder instanceFleetType(String instanceFleetType) {
            this.props.instanceFleetType(instanceFleetType);
            return this;
        }

        public Builder instanceTypeConfigs(IResolvable instanceTypeConfigs) {
            this.props.instanceTypeConfigs(instanceTypeConfigs);
            return this;
        }

        public Builder instanceTypeConfigs(List<? extends Object> instanceTypeConfigs) {
            this.props.instanceTypeConfigs(instanceTypeConfigs);
            return this;
        }

        public Builder launchSpecifications(IResolvable launchSpecifications) {
            this.props.launchSpecifications(launchSpecifications);
            return this;
        }

        public Builder launchSpecifications(InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
            this.props.launchSpecifications(launchSpecifications);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder targetOnDemandCapacity(Number targetOnDemandCapacity) {
            this.props.targetOnDemandCapacity(targetOnDemandCapacity);
            return this;
        }

        public Builder targetSpotCapacity(Number targetSpotCapacity) {
            this.props.targetSpotCapacity(targetSpotCapacity);
            return this;
        }

        public CfnInstanceFleetConfig build() {
            return new CfnInstanceFleetConfig(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSizeInGb();

        @NotNull
        public String getVolumeType();

        @Nullable
        default public Number getIops() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            Number sizeInGb;
            String volumeType;
            Number iops;

            public Builder sizeInGb(Number sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public VolumeSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotProvisioningSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimeoutAction();

        @NotNull
        public Number getTimeoutDurationMinutes();

        @Nullable
        default public String getAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getBlockDurationMinutes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotProvisioningSpecificationProperty> {
            String timeoutAction;
            Number timeoutDurationMinutes;
            String allocationStrategy;
            Number blockDurationMinutes;

            public Builder timeoutAction(String timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            public Builder timeoutDurationMinutes(Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder blockDurationMinutes(Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            public SpotProvisioningSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.OnDemandProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnDemandProvisioningSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAllocationStrategy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnDemandProvisioningSpecificationProperty> {
            String allocationStrategy;

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public OnDemandProvisioningSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceFleetProvisioningSpecificationsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnDemandSpecification() {
            return null;
        }

        @Nullable
        default public Object getSpotSpecification() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceFleetProvisioningSpecificationsProperty> {
            Object onDemandSpecification;
            Object spotSpecification;

            public Builder onDemandSpecification(IResolvable onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            public Builder onDemandSpecification(OnDemandProvisioningSpecificationProperty onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            public Builder spotSpecification(IResolvable spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            public Builder spotSpecification(SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEbsBlockDeviceConfigs() {
            return null;
        }

        @Nullable
        default public Object getEbsOptimized() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            Object ebsBlockDeviceConfigs;
            Object ebsOptimized;

            public Builder ebsBlockDeviceConfigs(IResolvable ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsBlockDeviceConfigs(List<? extends Object> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public EbsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsBlockDeviceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getVolumeSpecification();

        @Nullable
        default public Number getVolumesPerInstance() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            Object volumeSpecification;
            Number volumesPerInstance;

            public Builder volumeSpecification(IResolvable volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumeSpecification(VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumesPerInstance(Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            public EbsBlockDeviceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClassification() {
            return null;
        }

        @Nullable
        default public Object getConfigurationProperties() {
            return null;
        }

        @Nullable
        default public Object getConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationProperty> {
            String classification;
            Object configurationProperties;
            Object configurations;

            public Builder classification(String classification) {
                this.classification = classification;
                return this;
            }

            public Builder configurationProperties(IResolvable configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            public Builder configurationProperties(Map<String, String> configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            public Builder configurations(IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder configurations(List<? extends Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            public ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

