/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.wafv2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.wafv2.CfnRuleGroup;
import software.amazon.awscdk.services.wafv2.CfnRuleGroupProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup")
public class CfnRuleGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnRuleGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnRuleGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRuleGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnRuleGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnRuleGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLabelNamespace() {
        return (String)Kernel.get((Object)this, (String)"attrLabelNamespace", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Number getCapacity() {
        return (Number)Kernel.get((Object)this, (String)"capacity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setCapacity(@NotNull Number value) {
        Kernel.set((Object)this, (String)"capacity", (Object)Objects.requireNonNull(value, "capacity is required"));
    }

    @NotNull
    public String getScope() {
        return (String)Kernel.get((Object)this, (String)"scope", (NativeType)NativeType.forClass(String.class));
    }

    public void setScope(@NotNull String value) {
        Kernel.set((Object)this, (String)"scope", (Object)Objects.requireNonNull(value, "scope is required"));
    }

    @NotNull
    public Object getVisibilityConfig() {
        return Kernel.get((Object)this, (String)"visibilityConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVisibilityConfig(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"visibilityConfig", (Object)Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    public void setVisibilityConfig(@NotNull VisibilityConfigProperty value) {
        Kernel.set((Object)this, (String)"visibilityConfig", (Object)Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    @Nullable
    public Object getAvailableLabels() {
        return Kernel.get((Object)this, (String)"availableLabels", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAvailableLabels(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"availableLabels", (Object)value);
    }

    public void setAvailableLabels(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof LabelSummaryProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.wafv2.CfnRuleGroup.LabelSummaryProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"availableLabels", value);
    }

    @Nullable
    public Object getConsumedLabels() {
        return Kernel.get((Object)this, (String)"consumedLabels", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConsumedLabels(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"consumedLabels", (Object)value);
    }

    public void setConsumedLabels(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof LabelSummaryProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.wafv2.CfnRuleGroup.LabelSummaryProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"consumedLabels", value);
    }

    @Nullable
    public Object getCustomResponseBodies() {
        return Kernel.get((Object)this, (String)"customResponseBodies", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCustomResponseBodies(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"customResponseBodies", (Object)value);
    }

    public void setCustomResponseBodies(@Nullable Map<String, Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException("Expected " + "value" + ".keySet()" + " to contain class String; received " + value.keySet().toArray()[0].getClass());
            }
            for (Map.Entry<String, Object> __item_ac66f0 : value.entrySet()) {
                Object __val_ac66f0 = __item_ac66f0.getValue();
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof CustomResponseBodyProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(\"" + __item_ac66f0.getKey() + "\")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.wafv2.CfnRuleGroup.CustomResponseBodyProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"customResponseBodies", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getRules() {
        return Kernel.get((Object)this, (String)"rules", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRules(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"rules", (Object)value);
    }

    public void setRules(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof RuleProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.wafv2.CfnRuleGroup.RuleProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"rules", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelSummaryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LabelSummaryProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LabelSummaryProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public LabelSummaryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseBodyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomResponseBodyProperty
    extends JsiiSerializable {
        @NotNull
        public String getContent();

        @NotNull
        public String getContentType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomResponseBodyProperty> {
            String content;
            String contentType;

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public CustomResponseBodyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public Number getPriority();

        @NotNull
        public Object getStatement();

        @NotNull
        public Object getVisibilityConfig();

        @Nullable
        default public Object getAction() {
            return null;
        }

        @Nullable
        default public Object getCaptchaConfig() {
            return null;
        }

        @Nullable
        default public Object getChallengeConfig() {
            return null;
        }

        @Nullable
        default public Object getRuleLabels() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RuleProperty> {
            String name;
            Number priority;
            Object statement;
            Object visibilityConfig;
            Object action;
            Object captchaConfig;
            Object challengeConfig;
            Object ruleLabels;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder statement(IResolvable statement) {
                this.statement = statement;
                return this;
            }

            public Builder statement(StatementProperty statement) {
                this.statement = statement;
                return this;
            }

            public Builder visibilityConfig(IResolvable visibilityConfig) {
                this.visibilityConfig = visibilityConfig;
                return this;
            }

            public Builder visibilityConfig(VisibilityConfigProperty visibilityConfig) {
                this.visibilityConfig = visibilityConfig;
                return this;
            }

            public Builder action(IResolvable action) {
                this.action = action;
                return this;
            }

            public Builder action(RuleActionProperty action) {
                this.action = action;
                return this;
            }

            public Builder captchaConfig(IResolvable captchaConfig) {
                this.captchaConfig = captchaConfig;
                return this;
            }

            public Builder captchaConfig(CaptchaConfigProperty captchaConfig) {
                this.captchaConfig = captchaConfig;
                return this;
            }

            public Builder challengeConfig(IResolvable challengeConfig) {
                this.challengeConfig = challengeConfig;
                return this;
            }

            public Builder challengeConfig(ChallengeConfigProperty challengeConfig) {
                this.challengeConfig = challengeConfig;
                return this;
            }

            public Builder ruleLabels(IResolvable ruleLabels) {
                this.ruleLabels = ruleLabels;
                return this;
            }

            public Builder ruleLabels(List<? extends Object> ruleLabels) {
                this.ruleLabels = ruleLabels;
                return this;
            }

            public RuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnRuleGroup> {
        private final Construct scope;
        private final String id;
        private final CfnRuleGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnRuleGroupProps.Builder();
        }

        public Builder capacity(Number capacity) {
            this.props.capacity(capacity);
            return this;
        }

        public Builder scope(String scope) {
            this.props.scope(scope);
            return this;
        }

        public Builder visibilityConfig(IResolvable visibilityConfig) {
            this.props.visibilityConfig(visibilityConfig);
            return this;
        }

        public Builder visibilityConfig(VisibilityConfigProperty visibilityConfig) {
            this.props.visibilityConfig(visibilityConfig);
            return this;
        }

        public Builder availableLabels(IResolvable availableLabels) {
            this.props.availableLabels(availableLabels);
            return this;
        }

        public Builder availableLabels(List<? extends Object> availableLabels) {
            this.props.availableLabels(availableLabels);
            return this;
        }

        public Builder consumedLabels(IResolvable consumedLabels) {
            this.props.consumedLabels(consumedLabels);
            return this;
        }

        public Builder consumedLabels(List<? extends Object> consumedLabels) {
            this.props.consumedLabels(consumedLabels);
            return this;
        }

        public Builder customResponseBodies(IResolvable customResponseBodies) {
            this.props.customResponseBodies(customResponseBodies);
            return this;
        }

        public Builder customResponseBodies(Map<String, ? extends Object> customResponseBodies) {
            this.props.customResponseBodies(customResponseBodies);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder rules(IResolvable rules) {
            this.props.rules(rules);
            return this;
        }

        public Builder rules(List<? extends Object> rules) {
            this.props.rules(rules);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnRuleGroup build() {
            return new CfnRuleGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.XssMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface XssMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<XssMatchStatementProperty> {
            Object fieldToMatch;
            Object textTransformations;

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<? extends Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public XssMatchStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.VisibilityConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VisibilityConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCloudWatchMetricsEnabled();

        @NotNull
        public String getMetricName();

        @NotNull
        public Object getSampledRequestsEnabled();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VisibilityConfigProperty> {
            Object cloudWatchMetricsEnabled;
            String metricName;
            Object sampledRequestsEnabled;

            public Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            public Builder cloudWatchMetricsEnabled(IResolvable cloudWatchMetricsEnabled) {
                this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder sampledRequestsEnabled(Boolean sampledRequestsEnabled) {
                this.sampledRequestsEnabled = sampledRequestsEnabled;
                return this;
            }

            public Builder sampledRequestsEnabled(IResolvable sampledRequestsEnabled) {
                this.sampledRequestsEnabled = sampledRequestsEnabled;
                return this;
            }

            public VisibilityConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.TextTransformationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextTransformationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getPriority();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TextTransformationProperty> {
            Number priority;
            String type;

            public Builder priority(Number priority) {
                this.priority = priority;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public TextTransformationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.StatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatementProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAndStatement() {
            return null;
        }

        @Nullable
        default public Object getByteMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getGeoMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getIpSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getLabelMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getNotStatement() {
            return null;
        }

        @Nullable
        default public Object getOrStatement() {
            return null;
        }

        @Nullable
        default public Object getRateBasedStatement() {
            return null;
        }

        @Nullable
        default public Object getRegexMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getRegexPatternSetReferenceStatement() {
            return null;
        }

        @Nullable
        default public Object getSizeConstraintStatement() {
            return null;
        }

        @Nullable
        default public Object getSqliMatchStatement() {
            return null;
        }

        @Nullable
        default public Object getXssMatchStatement() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatementProperty> {
            Object andStatement;
            Object byteMatchStatement;
            Object geoMatchStatement;
            Object ipSetReferenceStatement;
            Object labelMatchStatement;
            Object notStatement;
            Object orStatement;
            Object rateBasedStatement;
            Object regexMatchStatement;
            Object regexPatternSetReferenceStatement;
            Object sizeConstraintStatement;
            Object sqliMatchStatement;
            Object xssMatchStatement;

            public Builder andStatement(IResolvable andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            public Builder andStatement(AndStatementProperty andStatement) {
                this.andStatement = andStatement;
                return this;
            }

            public Builder byteMatchStatement(IResolvable byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder byteMatchStatement(ByteMatchStatementProperty byteMatchStatement) {
                this.byteMatchStatement = byteMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(IResolvable geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder geoMatchStatement(GeoMatchStatementProperty geoMatchStatement) {
                this.geoMatchStatement = geoMatchStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IResolvable ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder ipSetReferenceStatement(IPSetReferenceStatementProperty ipSetReferenceStatement) {
                this.ipSetReferenceStatement = ipSetReferenceStatement;
                return this;
            }

            public Builder labelMatchStatement(IResolvable labelMatchStatement) {
                this.labelMatchStatement = labelMatchStatement;
                return this;
            }

            public Builder labelMatchStatement(LabelMatchStatementProperty labelMatchStatement) {
                this.labelMatchStatement = labelMatchStatement;
                return this;
            }

            public Builder notStatement(IResolvable notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            public Builder notStatement(NotStatementProperty notStatement) {
                this.notStatement = notStatement;
                return this;
            }

            public Builder orStatement(IResolvable orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            public Builder orStatement(OrStatementProperty orStatement) {
                this.orStatement = orStatement;
                return this;
            }

            public Builder rateBasedStatement(IResolvable rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            public Builder rateBasedStatement(RateBasedStatementProperty rateBasedStatement) {
                this.rateBasedStatement = rateBasedStatement;
                return this;
            }

            public Builder regexMatchStatement(IResolvable regexMatchStatement) {
                this.regexMatchStatement = regexMatchStatement;
                return this;
            }

            public Builder regexMatchStatement(RegexMatchStatementProperty regexMatchStatement) {
                this.regexMatchStatement = regexMatchStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(IResolvable regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty regexPatternSetReferenceStatement) {
                this.regexPatternSetReferenceStatement = regexPatternSetReferenceStatement;
                return this;
            }

            public Builder sizeConstraintStatement(IResolvable sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sizeConstraintStatement(SizeConstraintStatementProperty sizeConstraintStatement) {
                this.sizeConstraintStatement = sizeConstraintStatement;
                return this;
            }

            public Builder sqliMatchStatement(IResolvable sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder sqliMatchStatement(SqliMatchStatementProperty sqliMatchStatement) {
                this.sqliMatchStatement = sqliMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(IResolvable xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public Builder xssMatchStatement(XssMatchStatementProperty xssMatchStatement) {
                this.xssMatchStatement = xssMatchStatement;
                return this;
            }

            public StatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SqliMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqliMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Object getTextTransformations();

        @Nullable
        default public String getSensitivityLevel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqliMatchStatementProperty> {
            Object fieldToMatch;
            Object textTransformations;
            String sensitivityLevel;

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<? extends Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder sensitivityLevel(String sensitivityLevel) {
                this.sensitivityLevel = sensitivityLevel;
                return this;
            }

            public SqliMatchStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SizeConstraintStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SizeConstraintStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparisonOperator();

        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Number getSize();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SizeConstraintStatementProperty> {
            String comparisonOperator;
            Object fieldToMatch;
            Number size;
            Object textTransformations;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<? extends Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public SizeConstraintStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SingleQueryArgumentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SingleQueryArgumentProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SingleQueryArgumentProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public SingleQueryArgumentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.SingleHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SingleHeaderProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SingleHeaderProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public SingleHeaderProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RuleActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuleActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllow() {
            return null;
        }

        @Nullable
        default public Object getBlock() {
            return null;
        }

        @Nullable
        default public Object getCaptcha() {
            return null;
        }

        @Nullable
        default public Object getChallenge() {
            return null;
        }

        @Nullable
        default public Object getCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RuleActionProperty> {
            Object allow;
            Object block;
            Object captcha;
            Object challenge;
            Object count;

            public Builder allow(Object allow) {
                this.allow = allow;
                return this;
            }

            public Builder block(Object block) {
                this.block = block;
                return this;
            }

            public Builder captcha(Object captcha) {
                this.captcha = captcha;
                return this;
            }

            public Builder challenge(Object challenge) {
                this.challenge = challenge;
                return this;
            }

            public Builder count(Object count) {
                this.count = count;
                return this;
            }

            public RuleActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RegexPatternSetReferenceStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RegexPatternSetReferenceStatementProperty> {
            String arn;
            Object fieldToMatch;
            Object textTransformations;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<? extends Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public RegexPatternSetReferenceStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RegexMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RegexMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public String getRegexString();

        @NotNull
        public Object getTextTransformations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RegexMatchStatementProperty> {
            Object fieldToMatch;
            String regexString;
            Object textTransformations;

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder regexString(String regexString) {
                this.regexString = regexString;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<? extends Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public RegexMatchStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.RateBasedStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RateBasedStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getAggregateKeyType();

        @NotNull
        public Number getLimit();

        @Nullable
        default public Object getForwardedIpConfig() {
            return null;
        }

        @Nullable
        default public Object getScopeDownStatement() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RateBasedStatementProperty> {
            String aggregateKeyType;
            Number limit;
            Object forwardedIpConfig;
            Object scopeDownStatement;

            public Builder aggregateKeyType(String aggregateKeyType) {
                this.aggregateKeyType = aggregateKeyType;
                return this;
            }

            public Builder limit(Number limit) {
                this.limit = limit;
                return this;
            }

            public Builder forwardedIpConfig(IResolvable forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            public Builder forwardedIpConfig(ForwardedIPConfigurationProperty forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            public Builder scopeDownStatement(IResolvable scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            public Builder scopeDownStatement(StatementProperty scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            public RateBasedStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.OrStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OrStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatements();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OrStatementProperty> {
            Object statements;

            public Builder statements(IResolvable statements) {
                this.statements = statements;
                return this;
            }

            public Builder statements(List<? extends Object> statements) {
                this.statements = statements;
                return this;
            }

            public OrStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.NotStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatement();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotStatementProperty> {
            Object statement;

            public Builder statement(IResolvable statement) {
                this.statement = statement;
                return this;
            }

            public Builder statement(StatementProperty statement) {
                this.statement = statement;
                return this;
            }

            public NotStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LabelProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LabelProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public LabelProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.LabelMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LabelMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getScope();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LabelMatchStatementProperty> {
            String key;
            String scope;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public LabelMatchStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonMatchPatternProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JsonMatchPatternProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAll() {
            return null;
        }

        @Nullable
        default public List<String> getIncludedPaths() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JsonMatchPatternProperty> {
            Object all;
            List<String> includedPaths;

            public Builder all(Object all) {
                this.all = all;
                return this;
            }

            public Builder includedPaths(List<String> includedPaths) {
                this.includedPaths = includedPaths;
                return this;
            }

            public JsonMatchPatternProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.JsonBodyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JsonBodyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMatchPattern();

        @NotNull
        public String getMatchScope();

        @Nullable
        default public String getInvalidFallbackBehavior() {
            return null;
        }

        @Nullable
        default public String getOversizeHandling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JsonBodyProperty> {
            Object matchPattern;
            String matchScope;
            String invalidFallbackBehavior;
            String oversizeHandling;

            public Builder matchPattern(IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            public Builder matchPattern(JsonMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            public Builder matchScope(String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            public Builder invalidFallbackBehavior(String invalidFallbackBehavior) {
                this.invalidFallbackBehavior = invalidFallbackBehavior;
                return this;
            }

            public Builder oversizeHandling(String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            public JsonBodyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ImmunityTimePropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImmunityTimePropertyProperty
    extends JsiiSerializable {
        @NotNull
        public Number getImmunityTime();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImmunityTimePropertyProperty> {
            Number immunityTime;

            public Builder immunityTime(Number immunityTime) {
                this.immunityTime = immunityTime;
                return this;
            }

            public ImmunityTimePropertyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IPSetReferenceStatementProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @Nullable
        default public Object getIpSetForwardedIpConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IPSetReferenceStatementProperty> {
            String arn;
            Object ipSetForwardedIpConfig;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder ipSetForwardedIpConfig(IResolvable ipSetForwardedIpConfig) {
                this.ipSetForwardedIpConfig = ipSetForwardedIpConfig;
                return this;
            }

            public Builder ipSetForwardedIpConfig(IPSetForwardedIPConfigurationProperty ipSetForwardedIpConfig) {
                this.ipSetForwardedIpConfig = ipSetForwardedIpConfig;
                return this;
            }

            public IPSetReferenceStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.IPSetForwardedIPConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IPSetForwardedIPConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getFallbackBehavior();

        @NotNull
        public String getHeaderName();

        @NotNull
        public String getPosition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IPSetForwardedIPConfigurationProperty> {
            String fallbackBehavior;
            String headerName;
            String position;

            public Builder fallbackBehavior(String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            public Builder headerName(String headerName) {
                this.headerName = headerName;
                return this;
            }

            public Builder position(String position) {
                this.position = position;
                return this;
            }

            public IPSetForwardedIPConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeadersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeadersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMatchPattern();

        @NotNull
        public String getMatchScope();

        @NotNull
        public String getOversizeHandling();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeadersProperty> {
            Object matchPattern;
            String matchScope;
            String oversizeHandling;

            public Builder matchPattern(IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            public Builder matchPattern(HeaderMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            public Builder matchScope(String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            public Builder oversizeHandling(String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            public HeadersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.HeaderMatchPatternProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HeaderMatchPatternProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAll() {
            return null;
        }

        @Nullable
        default public List<String> getExcludedHeaders() {
            return null;
        }

        @Nullable
        default public List<String> getIncludedHeaders() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HeaderMatchPatternProperty> {
            Object all;
            List<String> excludedHeaders;
            List<String> includedHeaders;

            public Builder all(Object all) {
                this.all = all;
                return this;
            }

            public Builder excludedHeaders(List<String> excludedHeaders) {
                this.excludedHeaders = excludedHeaders;
                return this;
            }

            public Builder includedHeaders(List<String> includedHeaders) {
                this.includedHeaders = includedHeaders;
                return this;
            }

            public HeaderMatchPatternProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.GeoMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GeoMatchStatementProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCountryCodes() {
            return null;
        }

        @Nullable
        default public Object getForwardedIpConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GeoMatchStatementProperty> {
            List<String> countryCodes;
            Object forwardedIpConfig;

            public Builder countryCodes(List<String> countryCodes) {
                this.countryCodes = countryCodes;
                return this;
            }

            public Builder forwardedIpConfig(IResolvable forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            public Builder forwardedIpConfig(ForwardedIPConfigurationProperty forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            public GeoMatchStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ForwardedIPConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getFallbackBehavior();

        @NotNull
        public String getHeaderName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ForwardedIPConfigurationProperty> {
            String fallbackBehavior;
            String headerName;

            public Builder fallbackBehavior(String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            public Builder headerName(String headerName) {
                this.headerName = headerName;
                return this;
            }

            public ForwardedIPConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.FieldToMatchProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldToMatchProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllQueryArguments() {
            return null;
        }

        @Nullable
        default public Object getBody() {
            return null;
        }

        @Nullable
        default public Object getCookies() {
            return null;
        }

        @Nullable
        default public Object getHeaders() {
            return null;
        }

        @Nullable
        default public Object getJsonBody() {
            return null;
        }

        @Nullable
        default public Object getMethod() {
            return null;
        }

        @Nullable
        default public Object getQueryString() {
            return null;
        }

        @Nullable
        default public Object getSingleHeader() {
            return null;
        }

        @Nullable
        default public Object getSingleQueryArgument() {
            return null;
        }

        @Nullable
        default public Object getUriPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldToMatchProperty> {
            Object allQueryArguments;
            Object body;
            Object cookies;
            Object headers;
            Object jsonBody;
            Object method;
            Object queryString;
            Object singleHeader;
            Object singleQueryArgument;
            Object uriPath;

            public Builder allQueryArguments(Object allQueryArguments) {
                this.allQueryArguments = allQueryArguments;
                return this;
            }

            public Builder body(IResolvable body) {
                this.body = body;
                return this;
            }

            public Builder body(BodyProperty body) {
                this.body = body;
                return this;
            }

            public Builder cookies(IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            public Builder cookies(CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            public Builder headers(IResolvable headers) {
                this.headers = headers;
                return this;
            }

            public Builder headers(HeadersProperty headers) {
                this.headers = headers;
                return this;
            }

            public Builder jsonBody(IResolvable jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            public Builder jsonBody(JsonBodyProperty jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            public Builder method(Object method) {
                this.method = method;
                return this;
            }

            public Builder queryString(Object queryString) {
                this.queryString = queryString;
                return this;
            }

            public Builder singleHeader(Object singleHeader) {
                this.singleHeader = singleHeader;
                return this;
            }

            public Builder singleQueryArgument(Object singleQueryArgument) {
                this.singleQueryArgument = singleQueryArgument;
                return this;
            }

            public Builder uriPath(Object uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            public FieldToMatchProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomResponseProperty
    extends JsiiSerializable {
        @NotNull
        public Number getResponseCode();

        @Nullable
        default public String getCustomResponseBodyKey() {
            return null;
        }

        @Nullable
        default public Object getResponseHeaders() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomResponseProperty> {
            Number responseCode;
            String customResponseBodyKey;
            Object responseHeaders;

            public Builder responseCode(Number responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            public Builder customResponseBodyKey(String customResponseBodyKey) {
                this.customResponseBodyKey = customResponseBodyKey;
                return this;
            }

            public Builder responseHeaders(IResolvable responseHeaders) {
                this.responseHeaders = responseHeaders;
                return this;
            }

            public Builder responseHeaders(List<? extends Object> responseHeaders) {
                this.responseHeaders = responseHeaders;
                return this;
            }

            public CustomResponseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomRequestHandlingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomRequestHandlingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getInsertHeaders();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomRequestHandlingProperty> {
            Object insertHeaders;

            public Builder insertHeaders(IResolvable insertHeaders) {
                this.insertHeaders = insertHeaders;
                return this;
            }

            public Builder insertHeaders(List<? extends Object> insertHeaders) {
                this.insertHeaders = insertHeaders;
                return this;
            }

            public CustomRequestHandlingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CustomHTTPHeaderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomHTTPHeaderProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomHTTPHeaderProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public CustomHTTPHeaderProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CountProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CountProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomRequestHandling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CountProperty> {
            Object customRequestHandling;

            public Builder customRequestHandling(IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public Builder customRequestHandling(CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public CountProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CookiesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMatchPattern();

        @NotNull
        public String getMatchScope();

        @NotNull
        public String getOversizeHandling();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CookiesProperty> {
            Object matchPattern;
            String matchScope;
            String oversizeHandling;

            public Builder matchPattern(IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            public Builder matchPattern(CookieMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            public Builder matchScope(String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            public Builder oversizeHandling(String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            public CookiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CookieMatchPatternProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CookieMatchPatternProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAll() {
            return null;
        }

        @Nullable
        default public List<String> getExcludedCookies() {
            return null;
        }

        @Nullable
        default public List<String> getIncludedCookies() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CookieMatchPatternProperty> {
            Object all;
            List<String> excludedCookies;
            List<String> includedCookies;

            public Builder all(Object all) {
                this.all = all;
                return this;
            }

            public Builder excludedCookies(List<String> excludedCookies) {
                this.excludedCookies = excludedCookies;
                return this;
            }

            public Builder includedCookies(List<String> includedCookies) {
                this.includedCookies = includedCookies;
                return this;
            }

            public CookieMatchPatternProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ChallengeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ChallengeProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomRequestHandling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ChallengeProperty> {
            Object customRequestHandling;

            public Builder customRequestHandling(IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public Builder customRequestHandling(CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public ChallengeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ChallengeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ChallengeConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getImmunityTimeProperty() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ChallengeConfigProperty> {
            Object immunityTimeProperty;

            public Builder immunityTimeProperty(IResolvable immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            public Builder immunityTimeProperty(ImmunityTimePropertyProperty immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            public ChallengeConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptchaProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomRequestHandling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptchaProperty> {
            Object customRequestHandling;

            public Builder customRequestHandling(IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public Builder customRequestHandling(CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public CaptchaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.CaptchaConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CaptchaConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getImmunityTimeProperty() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CaptchaConfigProperty> {
            Object immunityTimeProperty;

            public Builder immunityTimeProperty(IResolvable immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            public Builder immunityTimeProperty(ImmunityTimePropertyProperty immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            public CaptchaConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.ByteMatchStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ByteMatchStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getFieldToMatch();

        @NotNull
        public String getPositionalConstraint();

        @NotNull
        public Object getTextTransformations();

        @Nullable
        default public String getSearchString() {
            return null;
        }

        @Nullable
        default public String getSearchStringBase64() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ByteMatchStatementProperty> {
            Object fieldToMatch;
            String positionalConstraint;
            Object textTransformations;
            String searchString;
            String searchStringBase64;

            public Builder fieldToMatch(IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder fieldToMatch(FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            public Builder positionalConstraint(String positionalConstraint) {
                this.positionalConstraint = positionalConstraint;
                return this;
            }

            public Builder textTransformations(IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder textTransformations(List<? extends Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            public Builder searchString(String searchString) {
                this.searchString = searchString;
                return this;
            }

            public Builder searchStringBase64(String searchStringBase64) {
                this.searchStringBase64 = searchStringBase64;
                return this;
            }

            public ByteMatchStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.BodyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BodyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getOversizeHandling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BodyProperty> {
            String oversizeHandling;

            public Builder oversizeHandling(String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            public BodyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.BlockProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomResponse() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockProperty> {
            Object customResponse;

            public Builder customResponse(IResolvable customResponse) {
                this.customResponse = customResponse;
                return this;
            }

            public Builder customResponse(CustomResponseProperty customResponse) {
                this.customResponse = customResponse;
                return this;
            }

            public BlockProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.AndStatementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AndStatementProperty
    extends JsiiSerializable {
        @NotNull
        public Object getStatements();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AndStatementProperty> {
            Object statements;

            public Builder statements(IResolvable statements) {
                this.statements = statements;
                return this;
            }

            public Builder statements(List<? extends Object> statements) {
                this.statements = statements;
                return this;
            }

            public AndStatementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_wafv2.CfnRuleGroup.AllowProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AllowProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomRequestHandling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AllowProperty> {
            Object customRequestHandling;

            public Builder customRequestHandling(IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public Builder customRequestHandling(CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            public AllowProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

