/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.ClientVpnEndpoint;
import software.amazon.awscdk.services.ec2.ClientVpnEndpointOptions;
import software.amazon.awscdk.services.ec2.DefaultInstanceTenancy;
import software.amazon.awscdk.services.ec2.EnableVpnGatewayOptions;
import software.amazon.awscdk.services.ec2.FlowLog;
import software.amazon.awscdk.services.ec2.FlowLogOptions;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpoint;
import software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.IIpAddresses;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.NatProvider;
import software.amazon.awscdk.services.ec2.SelectedSubnets;
import software.amazon.awscdk.services.ec2.SubnetConfiguration;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.VpcAttributes;
import software.amazon.awscdk.services.ec2.VpcLookupOptions;
import software.amazon.awscdk.services.ec2.VpcProps;
import software.amazon.awscdk.services.ec2.VpnConnection;
import software.amazon.awscdk.services.ec2.VpnConnectionOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;
import software.constructs.IDependable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.Vpc")
public class Vpc
extends Resource
implements IVpc {
    public static final String DEFAULT_CIDR_RANGE = (String)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_CIDR_RANGE", (NativeType)NativeType.forClass(String.class));
    public static final List<SubnetConfiguration> DEFAULT_SUBNETS = Collections.unmodifiableList((List)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_SUBNETS", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(SubnetConfiguration.class))));
    public static final List<SubnetConfiguration> DEFAULT_SUBNETS_NO_NAT = Collections.unmodifiableList((List)JsiiObject.jsiiStaticGet(Vpc.class, (String)"DEFAULT_SUBNETS_NO_NAT", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(SubnetConfiguration.class))));

    protected Vpc(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Vpc(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Vpc(@NotNull Construct scope, @NotNull String id, @Nullable VpcProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Vpc(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IVpc fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull VpcLookupOptions options) {
        return (IVpc)JsiiObject.jsiiStaticCall(Vpc.class, (String)"fromLookup", (NativeType)NativeType.forClass(IVpc.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public static IVpc fromVpcAttributes(@NotNull Construct scope, @NotNull String id, @NotNull VpcAttributes attrs) {
        return (IVpc)JsiiObject.jsiiStaticCall(Vpc.class, (String)"fromVpcAttributes", (NativeType)NativeType.forClass(IVpc.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public ClientVpnEndpoint addClientVpnEndpoint(@NotNull String id, @NotNull ClientVpnEndpointOptions options) {
        return (ClientVpnEndpoint)Kernel.call((Object)this, (String)"addClientVpnEndpoint", (NativeType)NativeType.forClass(ClientVpnEndpoint.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public FlowLog addFlowLog(@NotNull String id, @Nullable FlowLogOptions options) {
        return (FlowLog)Kernel.call((Object)this, (String)"addFlowLog", (NativeType)NativeType.forClass(FlowLog.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public FlowLog addFlowLog(@NotNull String id) {
        return (FlowLog)Kernel.call((Object)this, (String)"addFlowLog", (NativeType)NativeType.forClass(FlowLog.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public GatewayVpcEndpoint addGatewayEndpoint(@NotNull String id, @NotNull GatewayVpcEndpointOptions options) {
        return (GatewayVpcEndpoint)Kernel.call((Object)this, (String)"addGatewayEndpoint", (NativeType)NativeType.forClass(GatewayVpcEndpoint.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public InterfaceVpcEndpoint addInterfaceEndpoint(@NotNull String id, @NotNull InterfaceVpcEndpointOptions options) {
        return (InterfaceVpcEndpoint)Kernel.call((Object)this, (String)"addInterfaceEndpoint", (NativeType)NativeType.forClass(InterfaceVpcEndpoint.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public VpnConnection addVpnConnection(@NotNull String id, @NotNull VpnConnectionOptions options) {
        return (VpnConnection)Kernel.call((Object)this, (String)"addVpnConnection", (NativeType)NativeType.forClass(VpnConnection.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void enableVpnGateway(@NotNull EnableVpnGatewayOptions options) {
        Kernel.call((Object)this, (String)"enableVpnGateway", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    protected List<ISubnet> selectSubnetObjects(@Nullable SubnetSelection selection) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"selectSubnetObjects", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class)), (Object[])new Object[]{selection}));
    }

    @NotNull
    protected List<ISubnet> selectSubnetObjects() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"selectSubnetObjects", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public SelectedSubnets selectSubnets(@Nullable SubnetSelection selection) {
        return (SelectedSubnets)Kernel.call((Object)this, (String)"selectSubnets", (NativeType)NativeType.forClass(SelectedSubnets.class), (Object[])new Object[]{selection});
    }

    @Override
    @NotNull
    public SelectedSubnets selectSubnets() {
        return (SelectedSubnets)Kernel.call((Object)this, (String)"selectSubnets", (NativeType)NativeType.forClass(SelectedSubnets.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<String> getAvailabilityZones() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"availabilityZones", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Boolean getDnsHostnamesEnabled() {
        return (Boolean)Kernel.get((Object)this, (String)"dnsHostnamesEnabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getDnsSupportEnabled() {
        return (Boolean)Kernel.get((Object)this, (String)"dnsSupportEnabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    public IDependable getInternetConnectivityEstablished() {
        return (IDependable)Kernel.get((Object)this, (String)"internetConnectivityEstablished", (NativeType)NativeType.forClass(IDependable.class));
    }

    @Override
    @NotNull
    public List<ISubnet> getIsolatedSubnets() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"isolatedSubnets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class))));
    }

    @Override
    @NotNull
    public List<ISubnet> getPrivateSubnets() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"privateSubnets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class))));
    }

    @Override
    @NotNull
    public List<ISubnet> getPublicSubnets() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"publicSubnets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ISubnet.class))));
    }

    @Override
    @NotNull
    public String getVpcArn() {
        return (String)Kernel.get((Object)this, (String)"vpcArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getVpcCidrBlock() {
        return (String)Kernel.get((Object)this, (String)"vpcCidrBlock", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getVpcCidrBlockAssociations() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"vpcCidrBlockAssociations", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getVpcDefaultNetworkAcl() {
        return (String)Kernel.get((Object)this, (String)"vpcDefaultNetworkAcl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getVpcDefaultSecurityGroup() {
        return (String)Kernel.get((Object)this, (String)"vpcDefaultSecurityGroup", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getVpcId() {
        return (String)Kernel.get((Object)this, (String)"vpcId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getVpcIpv6CidrBlocks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"vpcIpv6CidrBlocks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Nullable
    public String getInternetGatewayId() {
        return (String)Kernel.get((Object)this, (String)"internetGatewayId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getVpnGatewayId() {
        return (String)Kernel.get((Object)this, (String)"vpnGatewayId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Boolean getIncompleteSubnetDefinition() {
        return (Boolean)Kernel.get((Object)this, (String)"incompleteSubnetDefinition", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setIncompleteSubnetDefinition(@NotNull Boolean value) {
        Kernel.set((Object)this, (String)"incompleteSubnetDefinition", (Object)Objects.requireNonNull(value, "incompleteSubnetDefinition is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Vpc> {
        private final Construct scope;
        private final String id;
        private VpcProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder availabilityZones(List<String> availabilityZones) {
            this.props().availabilityZones(availabilityZones);
            return this;
        }

        @Deprecated
        public Builder cidr(String cidr) {
            this.props().cidr(cidr);
            return this;
        }

        public Builder defaultInstanceTenancy(DefaultInstanceTenancy defaultInstanceTenancy) {
            this.props().defaultInstanceTenancy(defaultInstanceTenancy);
            return this;
        }

        public Builder enableDnsHostnames(Boolean enableDnsHostnames) {
            this.props().enableDnsHostnames(enableDnsHostnames);
            return this;
        }

        public Builder enableDnsSupport(Boolean enableDnsSupport) {
            this.props().enableDnsSupport(enableDnsSupport);
            return this;
        }

        public Builder flowLogs(Map<String, ? extends FlowLogOptions> flowLogs) {
            this.props().flowLogs(flowLogs);
            return this;
        }

        public Builder gatewayEndpoints(Map<String, ? extends GatewayVpcEndpointOptions> gatewayEndpoints) {
            this.props().gatewayEndpoints(gatewayEndpoints);
            return this;
        }

        public Builder ipAddresses(IIpAddresses ipAddresses) {
            this.props().ipAddresses(ipAddresses);
            return this;
        }

        public Builder maxAzs(Number maxAzs) {
            this.props().maxAzs(maxAzs);
            return this;
        }

        public Builder natGatewayProvider(NatProvider natGatewayProvider) {
            this.props().natGatewayProvider(natGatewayProvider);
            return this;
        }

        public Builder natGateways(Number natGateways) {
            this.props().natGateways(natGateways);
            return this;
        }

        public Builder natGatewaySubnets(SubnetSelection natGatewaySubnets) {
            this.props().natGatewaySubnets(natGatewaySubnets);
            return this;
        }

        public Builder reservedAzs(Number reservedAzs) {
            this.props().reservedAzs(reservedAzs);
            return this;
        }

        public Builder restrictDefaultSecurityGroup(Boolean restrictDefaultSecurityGroup) {
            this.props().restrictDefaultSecurityGroup(restrictDefaultSecurityGroup);
            return this;
        }

        public Builder subnetConfiguration(List<? extends SubnetConfiguration> subnetConfiguration) {
            this.props().subnetConfiguration(subnetConfiguration);
            return this;
        }

        public Builder vpcName(String vpcName) {
            this.props().vpcName(vpcName);
            return this;
        }

        public Builder vpnConnections(Map<String, ? extends VpnConnectionOptions> vpnConnections) {
            this.props().vpnConnections(vpnConnections);
            return this;
        }

        public Builder vpnGateway(Boolean vpnGateway) {
            this.props().vpnGateway(vpnGateway);
            return this;
        }

        public Builder vpnGatewayAsn(Number vpnGatewayAsn) {
            this.props().vpnGatewayAsn(vpnGatewayAsn);
            return this;
        }

        public Builder vpnRoutePropagation(List<? extends SubnetSelection> vpnRoutePropagation) {
            this.props().vpnRoutePropagation(vpnRoutePropagation);
            return this;
        }

        public Vpc build() {
            return new Vpc(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private VpcProps.Builder props() {
            if (this.props == null) {
                this.props = new VpcProps.Builder();
            }
            return this.props;
        }
    }
}

