/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IgnoreMode;
import software.amazon.awscdk.SymlinkFollowMode;
import software.amazon.awscdk.services.ecr.assets.DockerCacheOption;
import software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions;
import software.amazon.awscdk.services.ecr.assets.NetworkMode;
import software.amazon.awscdk.services.ecr.assets.Platform;
import software.amazon.awscdk.services.lambda.AssetImageCodeProps;
import software.amazon.awscdk.services.lambda.Code;
import software.amazon.awscdk.services.lambda.CodeConfig;
import software.amazon.awscdk.services.lambda.ResourceBindOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda.AssetImageCode")
public class AssetImageCode
extends Code {
    protected AssetImageCode(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetImageCode(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AssetImageCode(@NotNull String directory, @NotNull AssetImageCodeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(directory, "directory is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public CodeConfig bind(@NotNull Construct scope) {
        return (CodeConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(CodeConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    @Override
    public void bindToResource(@NotNull CfnResource resource, @Nullable ResourceBindOptions options) {
        Kernel.call((Object)((Object)this), (String)"bindToResource", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(resource, "resource is required"), options});
    }

    @Override
    public void bindToResource(@NotNull CfnResource resource) {
        Kernel.call((Object)((Object)this), (String)"bindToResource", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(resource, "resource is required")});
    }

    @NotNull
    public Boolean getIsInline() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"isInline", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AssetImageCode> {
        private final String directory;
        private final AssetImageCodeProps.Builder props;

        public static Builder create(String directory) {
            return new Builder(directory);
        }

        private Builder(String directory) {
            this.directory = directory;
            this.props = new AssetImageCodeProps.Builder();
        }

        public Builder exclude(List<String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        public Builder followSymlinks(SymlinkFollowMode followSymlinks) {
            this.props.followSymlinks(followSymlinks);
            return this;
        }

        public Builder ignoreMode(IgnoreMode ignoreMode) {
            this.props.ignoreMode(ignoreMode);
            return this;
        }

        public Builder extraHash(String extraHash) {
            this.props.extraHash(extraHash);
            return this;
        }

        public Builder assetName(String assetName) {
            this.props.assetName(assetName);
            return this;
        }

        public Builder buildArgs(Map<String, String> buildArgs) {
            this.props.buildArgs(buildArgs);
            return this;
        }

        public Builder buildSecrets(Map<String, String> buildSecrets) {
            this.props.buildSecrets(buildSecrets);
            return this;
        }

        public Builder cacheFrom(List<? extends DockerCacheOption> cacheFrom) {
            this.props.cacheFrom(cacheFrom);
            return this;
        }

        public Builder cacheTo(DockerCacheOption cacheTo) {
            this.props.cacheTo(cacheTo);
            return this;
        }

        public Builder file(String file) {
            this.props.file(file);
            return this;
        }

        public Builder invalidation(DockerImageAssetInvalidationOptions invalidation) {
            this.props.invalidation(invalidation);
            return this;
        }

        public Builder networkMode(NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        public Builder outputs(List<String> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        public Builder platform(Platform platform) {
            this.props.platform(platform);
            return this;
        }

        public Builder target(String target) {
            this.props.target(target);
            return this;
        }

        public Builder cmd(List<String> cmd) {
            this.props.cmd(cmd);
            return this;
        }

        public Builder entrypoint(List<String> entrypoint) {
            this.props.entrypoint(entrypoint);
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.props.workingDirectory(workingDirectory);
            return this;
        }

        public AssetImageCode build() {
            return new AssetImageCode(this.directory, this.props.build());
        }
    }
}

