/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.rds.CfnDBInstance;
import software.amazon.awscdk.services.rds.CfnDBInstanceProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBInstance")
public class CfnDBInstance
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDBInstance.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDBInstance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBInstance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDBInstance(@NotNull Construct scope, @NotNull String id, @Nullable CfnDBInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnDBInstance(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCertificateDetailsCaIdentifier() {
        return (String)Kernel.get((Object)this, (String)"attrCertificateDetailsCaIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCertificateDetailsValidTill() {
        return (String)Kernel.get((Object)this, (String)"attrCertificateDetailsValidTill", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDbInstanceArn() {
        return (String)Kernel.get((Object)this, (String)"attrDbInstanceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDbiResourceId() {
        return (String)Kernel.get((Object)this, (String)"attrDbiResourceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDbSystemId() {
        return (String)Kernel.get((Object)this, (String)"attrDbSystemId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointHostedZoneId() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointHostedZoneId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointPort() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrMasterUserSecretSecretArn() {
        return (String)Kernel.get((Object)this, (String)"attrMasterUserSecretSecretArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public String getAllocatedStorage() {
        return (String)Kernel.get((Object)this, (String)"allocatedStorage", (NativeType)NativeType.forClass(String.class));
    }

    public void setAllocatedStorage(@Nullable String value) {
        Kernel.set((Object)this, (String)"allocatedStorage", (Object)value);
    }

    @Nullable
    public Object getAllowMajorVersionUpgrade() {
        return Kernel.get((Object)this, (String)"allowMajorVersionUpgrade", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAllowMajorVersionUpgrade(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"allowMajorVersionUpgrade", (Object)value);
    }

    public void setAllowMajorVersionUpgrade(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"allowMajorVersionUpgrade", (Object)value);
    }

    @Nullable
    public Object getAssociatedRoles() {
        return Kernel.get((Object)this, (String)"associatedRoles", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAssociatedRoles(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"associatedRoles", (Object)value);
    }

    public void setAssociatedRoles(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof DBInstanceRoleProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rds.CfnDBInstance.DBInstanceRoleProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"associatedRoles", value);
    }

    @Nullable
    public Object getAutoMinorVersionUpgrade() {
        return Kernel.get((Object)this, (String)"autoMinorVersionUpgrade", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoMinorVersionUpgrade(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    public void setAutoMinorVersionUpgrade(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    @Nullable
    public String getAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"availabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZone(@Nullable String value) {
        Kernel.set((Object)this, (String)"availabilityZone", (Object)value);
    }

    @Nullable
    public Number getBackupRetentionPeriod() {
        return (Number)Kernel.get((Object)this, (String)"backupRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setBackupRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)this, (String)"backupRetentionPeriod", (Object)value);
    }

    @Nullable
    public String getCaCertificateIdentifier() {
        return (String)Kernel.get((Object)this, (String)"caCertificateIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setCaCertificateIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"caCertificateIdentifier", (Object)value);
    }

    @Nullable
    public Object getCertificateDetails() {
        return Kernel.get((Object)this, (String)"certificateDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCertificateDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"certificateDetails", (Object)value);
    }

    public void setCertificateDetails(@Nullable CertificateDetailsProperty value) {
        Kernel.set((Object)this, (String)"certificateDetails", (Object)value);
    }

    @Nullable
    public Object getCertificateRotationRestart() {
        return Kernel.get((Object)this, (String)"certificateRotationRestart", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCertificateRotationRestart(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"certificateRotationRestart", (Object)value);
    }

    public void setCertificateRotationRestart(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"certificateRotationRestart", (Object)value);
    }

    @Nullable
    public String getCharacterSetName() {
        return (String)Kernel.get((Object)this, (String)"characterSetName", (NativeType)NativeType.forClass(String.class));
    }

    public void setCharacterSetName(@Nullable String value) {
        Kernel.set((Object)this, (String)"characterSetName", (Object)value);
    }

    @Nullable
    public Object getCopyTagsToSnapshot() {
        return Kernel.get((Object)this, (String)"copyTagsToSnapshot", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCopyTagsToSnapshot(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"copyTagsToSnapshot", (Object)value);
    }

    public void setCopyTagsToSnapshot(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"copyTagsToSnapshot", (Object)value);
    }

    @Nullable
    public String getCustomIamInstanceProfile() {
        return (String)Kernel.get((Object)this, (String)"customIamInstanceProfile", (NativeType)NativeType.forClass(String.class));
    }

    public void setCustomIamInstanceProfile(@Nullable String value) {
        Kernel.set((Object)this, (String)"customIamInstanceProfile", (Object)value);
    }

    @Nullable
    public String getDbClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"dbClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getDbClusterSnapshotIdentifier() {
        return (String)Kernel.get((Object)this, (String)"dbClusterSnapshotIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbClusterSnapshotIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbClusterSnapshotIdentifier", (Object)value);
    }

    @Nullable
    public String getDbInstanceClass() {
        return (String)Kernel.get((Object)this, (String)"dbInstanceClass", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbInstanceClass(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbInstanceClass", (Object)value);
    }

    @Nullable
    public String getDbInstanceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"dbInstanceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbInstanceIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbInstanceIdentifier", (Object)value);
    }

    @Nullable
    public String getDbName() {
        return (String)Kernel.get((Object)this, (String)"dbName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbName", (Object)value);
    }

    @Nullable
    public String getDbParameterGroupName() {
        return (String)Kernel.get((Object)this, (String)"dbParameterGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbParameterGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbParameterGroupName", (Object)value);
    }

    @Nullable
    public List<String> getDbSecurityGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"dbSecurityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setDbSecurityGroups(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"dbSecurityGroups", value);
    }

    @Nullable
    public String getDbSnapshotIdentifier() {
        return (String)Kernel.get((Object)this, (String)"dbSnapshotIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbSnapshotIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbSnapshotIdentifier", (Object)value);
    }

    @Nullable
    public String getDbSubnetGroupName() {
        return (String)Kernel.get((Object)this, (String)"dbSubnetGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbSubnetGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbSubnetGroupName", (Object)value);
    }

    @Nullable
    public Object getDeleteAutomatedBackups() {
        return Kernel.get((Object)this, (String)"deleteAutomatedBackups", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeleteAutomatedBackups(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"deleteAutomatedBackups", (Object)value);
    }

    public void setDeleteAutomatedBackups(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deleteAutomatedBackups", (Object)value);
    }

    @Nullable
    public Object getDeletionProtection() {
        return Kernel.get((Object)this, (String)"deletionProtection", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeletionProtection(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"deletionProtection", (Object)value);
    }

    public void setDeletionProtection(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deletionProtection", (Object)value);
    }

    @Nullable
    public String getDomain() {
        return (String)Kernel.get((Object)this, (String)"domain", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomain(@Nullable String value) {
        Kernel.set((Object)this, (String)"domain", (Object)value);
    }

    @Nullable
    public String getDomainIamRoleName() {
        return (String)Kernel.get((Object)this, (String)"domainIamRoleName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainIamRoleName(@Nullable String value) {
        Kernel.set((Object)this, (String)"domainIamRoleName", (Object)value);
    }

    @Nullable
    public List<String> getEnableCloudwatchLogsExports() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"enableCloudwatchLogsExports", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setEnableCloudwatchLogsExports(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"enableCloudwatchLogsExports", value);
    }

    @Nullable
    public Object getEnableIamDatabaseAuthentication() {
        return Kernel.get((Object)this, (String)"enableIamDatabaseAuthentication", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableIamDatabaseAuthentication(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableIamDatabaseAuthentication", (Object)value);
    }

    public void setEnableIamDatabaseAuthentication(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableIamDatabaseAuthentication", (Object)value);
    }

    @Nullable
    public Object getEnablePerformanceInsights() {
        return Kernel.get((Object)this, (String)"enablePerformanceInsights", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnablePerformanceInsights(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enablePerformanceInsights", (Object)value);
    }

    public void setEnablePerformanceInsights(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enablePerformanceInsights", (Object)value);
    }

    @Nullable
    public Object getEndpoint() {
        return Kernel.get((Object)this, (String)"endpoint", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEndpoint(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"endpoint", (Object)value);
    }

    public void setEndpoint(@Nullable EndpointProperty value) {
        Kernel.set((Object)this, (String)"endpoint", (Object)value);
    }

    @Nullable
    public String getEngine() {
        return (String)Kernel.get((Object)this, (String)"engine", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngine(@Nullable String value) {
        Kernel.set((Object)this, (String)"engine", (Object)value);
    }

    @Nullable
    public String getEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"engineVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineVersion", (Object)value);
    }

    @Nullable
    public Number getIops() {
        return (Number)Kernel.get((Object)this, (String)"iops", (NativeType)NativeType.forClass(Number.class));
    }

    public void setIops(@Nullable Number value) {
        Kernel.set((Object)this, (String)"iops", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public String getLicenseModel() {
        return (String)Kernel.get((Object)this, (String)"licenseModel", (NativeType)NativeType.forClass(String.class));
    }

    public void setLicenseModel(@Nullable String value) {
        Kernel.set((Object)this, (String)"licenseModel", (Object)value);
    }

    @Nullable
    public Object getManageMasterUserPassword() {
        return Kernel.get((Object)this, (String)"manageMasterUserPassword", (NativeType)NativeType.forClass(Object.class));
    }

    public void setManageMasterUserPassword(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"manageMasterUserPassword", (Object)value);
    }

    public void setManageMasterUserPassword(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"manageMasterUserPassword", (Object)value);
    }

    @Nullable
    public String getMasterUsername() {
        return (String)Kernel.get((Object)this, (String)"masterUsername", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUsername(@Nullable String value) {
        Kernel.set((Object)this, (String)"masterUsername", (Object)value);
    }

    @Nullable
    public String getMasterUserPassword() {
        return (String)Kernel.get((Object)this, (String)"masterUserPassword", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUserPassword(@Nullable String value) {
        Kernel.set((Object)this, (String)"masterUserPassword", (Object)value);
    }

    @Nullable
    public Object getMasterUserSecret() {
        return Kernel.get((Object)this, (String)"masterUserSecret", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMasterUserSecret(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"masterUserSecret", (Object)value);
    }

    public void setMasterUserSecret(@Nullable MasterUserSecretProperty value) {
        Kernel.set((Object)this, (String)"masterUserSecret", (Object)value);
    }

    @Nullable
    public Number getMaxAllocatedStorage() {
        return (Number)Kernel.get((Object)this, (String)"maxAllocatedStorage", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxAllocatedStorage(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxAllocatedStorage", (Object)value);
    }

    @Nullable
    public Number getMonitoringInterval() {
        return (Number)Kernel.get((Object)this, (String)"monitoringInterval", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMonitoringInterval(@Nullable Number value) {
        Kernel.set((Object)this, (String)"monitoringInterval", (Object)value);
    }

    @Nullable
    public String getMonitoringRoleArn() {
        return (String)Kernel.get((Object)this, (String)"monitoringRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setMonitoringRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"monitoringRoleArn", (Object)value);
    }

    @Nullable
    public Object getMultiAz() {
        return Kernel.get((Object)this, (String)"multiAz", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMultiAz(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"multiAz", (Object)value);
    }

    public void setMultiAz(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"multiAz", (Object)value);
    }

    @Nullable
    public String getNcharCharacterSetName() {
        return (String)Kernel.get((Object)this, (String)"ncharCharacterSetName", (NativeType)NativeType.forClass(String.class));
    }

    public void setNcharCharacterSetName(@Nullable String value) {
        Kernel.set((Object)this, (String)"ncharCharacterSetName", (Object)value);
    }

    @Nullable
    public String getNetworkType() {
        return (String)Kernel.get((Object)this, (String)"networkType", (NativeType)NativeType.forClass(String.class));
    }

    public void setNetworkType(@Nullable String value) {
        Kernel.set((Object)this, (String)"networkType", (Object)value);
    }

    @Nullable
    public String getOptionGroupName() {
        return (String)Kernel.get((Object)this, (String)"optionGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setOptionGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"optionGroupName", (Object)value);
    }

    @Nullable
    public String getPerformanceInsightsKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"performanceInsightsKmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setPerformanceInsightsKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"performanceInsightsKmsKeyId", (Object)value);
    }

    @Nullable
    public Number getPerformanceInsightsRetentionPeriod() {
        return (Number)Kernel.get((Object)this, (String)"performanceInsightsRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPerformanceInsightsRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)this, (String)"performanceInsightsRetentionPeriod", (Object)value);
    }

    @Nullable
    public String getPort() {
        return (String)Kernel.get((Object)this, (String)"port", (NativeType)NativeType.forClass(String.class));
    }

    public void setPort(@Nullable String value) {
        Kernel.set((Object)this, (String)"port", (Object)value);
    }

    @Nullable
    public String getPreferredBackupWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredBackupWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredBackupWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredBackupWindow", (Object)value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public Object getProcessorFeatures() {
        return Kernel.get((Object)this, (String)"processorFeatures", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProcessorFeatures(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"processorFeatures", (Object)value);
    }

    public void setProcessorFeatures(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ProcessorFeatureProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rds.CfnDBInstance.ProcessorFeatureProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"processorFeatures", value);
    }

    @Nullable
    public Number getPromotionTier() {
        return (Number)Kernel.get((Object)this, (String)"promotionTier", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPromotionTier(@Nullable Number value) {
        Kernel.set((Object)this, (String)"promotionTier", (Object)value);
    }

    @Nullable
    public Object getPubliclyAccessible() {
        return Kernel.get((Object)this, (String)"publiclyAccessible", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPubliclyAccessible(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    public void setPubliclyAccessible(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    @Nullable
    public String getReplicaMode() {
        return (String)Kernel.get((Object)this, (String)"replicaMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setReplicaMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"replicaMode", (Object)value);
    }

    @Nullable
    public String getRestoreTime() {
        return (String)Kernel.get((Object)this, (String)"restoreTime", (NativeType)NativeType.forClass(String.class));
    }

    public void setRestoreTime(@Nullable String value) {
        Kernel.set((Object)this, (String)"restoreTime", (Object)value);
    }

    @Nullable
    public String getSourceDbClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"sourceDbClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceDbClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceDbClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getSourceDbInstanceAutomatedBackupsArn() {
        return (String)Kernel.get((Object)this, (String)"sourceDbInstanceAutomatedBackupsArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceDbInstanceAutomatedBackupsArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceDbInstanceAutomatedBackupsArn", (Object)value);
    }

    @Nullable
    public String getSourceDbInstanceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"sourceDbInstanceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceDbInstanceIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceDbInstanceIdentifier", (Object)value);
    }

    @Nullable
    public String getSourceDbiResourceId() {
        return (String)Kernel.get((Object)this, (String)"sourceDbiResourceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceDbiResourceId(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceDbiResourceId", (Object)value);
    }

    @Nullable
    public String getSourceRegion() {
        return (String)Kernel.get((Object)this, (String)"sourceRegion", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceRegion(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceRegion", (Object)value);
    }

    @Nullable
    public Object getStorageEncrypted() {
        return Kernel.get((Object)this, (String)"storageEncrypted", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStorageEncrypted(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"storageEncrypted", (Object)value);
    }

    public void setStorageEncrypted(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"storageEncrypted", (Object)value);
    }

    @Nullable
    public Number getStorageThroughput() {
        return (Number)Kernel.get((Object)this, (String)"storageThroughput", (NativeType)NativeType.forClass(Number.class));
    }

    public void setStorageThroughput(@Nullable Number value) {
        Kernel.set((Object)this, (String)"storageThroughput", (Object)value);
    }

    @Nullable
    public String getStorageType() {
        return (String)Kernel.get((Object)this, (String)"storageType", (NativeType)NativeType.forClass(String.class));
    }

    public void setStorageType(@Nullable String value) {
        Kernel.set((Object)this, (String)"storageType", (Object)value);
    }

    @Nullable
    public String getTimezone() {
        return (String)Kernel.get((Object)this, (String)"timezone", (NativeType)NativeType.forClass(String.class));
    }

    public void setTimezone(@Nullable String value) {
        Kernel.set((Object)this, (String)"timezone", (Object)value);
    }

    @Nullable
    public Object getUseDefaultProcessorFeatures() {
        return Kernel.get((Object)this, (String)"useDefaultProcessorFeatures", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUseDefaultProcessorFeatures(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"useDefaultProcessorFeatures", (Object)value);
    }

    public void setUseDefaultProcessorFeatures(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"useDefaultProcessorFeatures", (Object)value);
    }

    @Nullable
    public Object getUseLatestRestorableTime() {
        return Kernel.get((Object)this, (String)"useLatestRestorableTime", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUseLatestRestorableTime(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"useLatestRestorableTime", (Object)value);
    }

    public void setUseLatestRestorableTime(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"useLatestRestorableTime", (Object)value);
    }

    @Nullable
    public List<String> getVpcSecurityGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcSecurityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroups(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcSecurityGroups", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBInstance.DBInstanceRoleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DBInstanceRoleProperty
    extends JsiiSerializable {
        @NotNull
        public String getFeatureName();

        @NotNull
        public String getRoleArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DBInstanceRoleProperty> {
            String featureName;
            String roleArn;

            public Builder featureName(String featureName) {
                this.featureName = featureName;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public DBInstanceRoleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBInstance.ProcessorFeatureProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProcessorFeatureProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProcessorFeatureProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ProcessorFeatureProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDBInstance> {
        private final Construct scope;
        private final String id;
        private CfnDBInstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder allocatedStorage(String allocatedStorage) {
            this.props().allocatedStorage(allocatedStorage);
            return this;
        }

        public Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.props().allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }

        public Builder allowMajorVersionUpgrade(IResolvable allowMajorVersionUpgrade) {
            this.props().allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }

        public Builder associatedRoles(IResolvable associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }

        public Builder associatedRoles(List<? extends Object> associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder autoMinorVersionUpgrade(IResolvable autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        public Builder backupRetentionPeriod(Number backupRetentionPeriod) {
            this.props().backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        public Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.props().caCertificateIdentifier(caCertificateIdentifier);
            return this;
        }

        public Builder certificateDetails(IResolvable certificateDetails) {
            this.props().certificateDetails(certificateDetails);
            return this;
        }

        public Builder certificateDetails(CertificateDetailsProperty certificateDetails) {
            this.props().certificateDetails(certificateDetails);
            return this;
        }

        public Builder certificateRotationRestart(Boolean certificateRotationRestart) {
            this.props().certificateRotationRestart(certificateRotationRestart);
            return this;
        }

        public Builder certificateRotationRestart(IResolvable certificateRotationRestart) {
            this.props().certificateRotationRestart(certificateRotationRestart);
            return this;
        }

        public Builder characterSetName(String characterSetName) {
            this.props().characterSetName(characterSetName);
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        public Builder copyTagsToSnapshot(IResolvable copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        public Builder customIamInstanceProfile(String customIamInstanceProfile) {
            this.props().customIamInstanceProfile(customIamInstanceProfile);
            return this;
        }

        public Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.props().dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        public Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.props().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier);
            return this;
        }

        public Builder dbInstanceClass(String dbInstanceClass) {
            this.props().dbInstanceClass(dbInstanceClass);
            return this;
        }

        public Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.props().dbInstanceIdentifier(dbInstanceIdentifier);
            return this;
        }

        public Builder dbName(String dbName) {
            this.props().dbName(dbName);
            return this;
        }

        public Builder dbParameterGroupName(String dbParameterGroupName) {
            this.props().dbParameterGroupName(dbParameterGroupName);
            return this;
        }

        public Builder dbSecurityGroups(List<String> dbSecurityGroups) {
            this.props().dbSecurityGroups(dbSecurityGroups);
            return this;
        }

        public Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.props().dbSnapshotIdentifier(dbSnapshotIdentifier);
            return this;
        }

        public Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.props().dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        public Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.props().deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        public Builder deleteAutomatedBackups(IResolvable deleteAutomatedBackups) {
            this.props().deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        public Builder deletionProtection(IResolvable deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        public Builder domain(String domain) {
            this.props().domain(domain);
            return this;
        }

        public Builder domainIamRoleName(String domainIamRoleName) {
            this.props().domainIamRoleName(domainIamRoleName);
            return this;
        }

        public Builder enableCloudwatchLogsExports(List<String> enableCloudwatchLogsExports) {
            this.props().enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        public Builder enableIamDatabaseAuthentication(Boolean enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        public Builder enableIamDatabaseAuthentication(IResolvable enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.props().enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        public Builder enablePerformanceInsights(IResolvable enablePerformanceInsights) {
            this.props().enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        public Builder endpoint(IResolvable endpoint) {
            this.props().endpoint(endpoint);
            return this;
        }

        public Builder endpoint(EndpointProperty endpoint) {
            this.props().endpoint(endpoint);
            return this;
        }

        public Builder engine(String engine) {
            this.props().engine(engine);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        public Builder iops(Number iops) {
            this.props().iops(iops);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder licenseModel(String licenseModel) {
            this.props().licenseModel(licenseModel);
            return this;
        }

        public Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.props().manageMasterUserPassword(manageMasterUserPassword);
            return this;
        }

        public Builder manageMasterUserPassword(IResolvable manageMasterUserPassword) {
            this.props().manageMasterUserPassword(manageMasterUserPassword);
            return this;
        }

        public Builder masterUsername(String masterUsername) {
            this.props().masterUsername(masterUsername);
            return this;
        }

        public Builder masterUserPassword(String masterUserPassword) {
            this.props().masterUserPassword(masterUserPassword);
            return this;
        }

        public Builder masterUserSecret(IResolvable masterUserSecret) {
            this.props().masterUserSecret(masterUserSecret);
            return this;
        }

        public Builder masterUserSecret(MasterUserSecretProperty masterUserSecret) {
            this.props().masterUserSecret(masterUserSecret);
            return this;
        }

        public Builder maxAllocatedStorage(Number maxAllocatedStorage) {
            this.props().maxAllocatedStorage(maxAllocatedStorage);
            return this;
        }

        public Builder monitoringInterval(Number monitoringInterval) {
            this.props().monitoringInterval(monitoringInterval);
            return this;
        }

        public Builder monitoringRoleArn(String monitoringRoleArn) {
            this.props().monitoringRoleArn(monitoringRoleArn);
            return this;
        }

        public Builder multiAz(Boolean multiAz) {
            this.props().multiAz(multiAz);
            return this;
        }

        public Builder multiAz(IResolvable multiAz) {
            this.props().multiAz(multiAz);
            return this;
        }

        public Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.props().ncharCharacterSetName(ncharCharacterSetName);
            return this;
        }

        public Builder networkType(String networkType) {
            this.props().networkType(networkType);
            return this;
        }

        public Builder optionGroupName(String optionGroupName) {
            this.props().optionGroupName(optionGroupName);
            return this;
        }

        public Builder performanceInsightsKmsKeyId(String performanceInsightsKmsKeyId) {
            this.props().performanceInsightsKmsKeyId(performanceInsightsKmsKeyId);
            return this;
        }

        public Builder performanceInsightsRetentionPeriod(Number performanceInsightsRetentionPeriod) {
            this.props().performanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
            return this;
        }

        public Builder port(String port) {
            this.props().port(port);
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.props().preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props().preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder processorFeatures(IResolvable processorFeatures) {
            this.props().processorFeatures(processorFeatures);
            return this;
        }

        public Builder processorFeatures(List<? extends Object> processorFeatures) {
            this.props().processorFeatures(processorFeatures);
            return this;
        }

        public Builder promotionTier(Number promotionTier) {
            this.props().promotionTier(promotionTier);
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder publiclyAccessible(IResolvable publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder replicaMode(String replicaMode) {
            this.props().replicaMode(replicaMode);
            return this;
        }

        public Builder restoreTime(String restoreTime) {
            this.props().restoreTime(restoreTime);
            return this;
        }

        public Builder sourceDbClusterIdentifier(String sourceDbClusterIdentifier) {
            this.props().sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        public Builder sourceDbInstanceAutomatedBackupsArn(String sourceDbInstanceAutomatedBackupsArn) {
            this.props().sourceDbInstanceAutomatedBackupsArn(sourceDbInstanceAutomatedBackupsArn);
            return this;
        }

        public Builder sourceDbInstanceIdentifier(String sourceDbInstanceIdentifier) {
            this.props().sourceDbInstanceIdentifier(sourceDbInstanceIdentifier);
            return this;
        }

        public Builder sourceDbiResourceId(String sourceDbiResourceId) {
            this.props().sourceDbiResourceId(sourceDbiResourceId);
            return this;
        }

        public Builder sourceRegion(String sourceRegion) {
            this.props().sourceRegion(sourceRegion);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageEncrypted(IResolvable storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageThroughput(Number storageThroughput) {
            this.props().storageThroughput(storageThroughput);
            return this;
        }

        public Builder storageType(String storageType) {
            this.props().storageType(storageType);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder timezone(String timezone) {
            this.props().timezone(timezone);
            return this;
        }

        public Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.props().useDefaultProcessorFeatures(useDefaultProcessorFeatures);
            return this;
        }

        public Builder useDefaultProcessorFeatures(IResolvable useDefaultProcessorFeatures) {
            this.props().useDefaultProcessorFeatures(useDefaultProcessorFeatures);
            return this;
        }

        public Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        public Builder useLatestRestorableTime(IResolvable useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        public Builder vpcSecurityGroups(List<String> vpcSecurityGroups) {
            this.props().vpcSecurityGroups(vpcSecurityGroups);
            return this;
        }

        public CfnDBInstance build() {
            return new CfnDBInstance(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnDBInstanceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnDBInstanceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBInstance.MasterUserSecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MasterUserSecretProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MasterUserSecretProperty> {
            String kmsKeyId;
            String secretArn;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public MasterUserSecretProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBInstance.EndpointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAddress() {
            return null;
        }

        @Nullable
        default public String getHostedZoneId() {
            return null;
        }

        @Nullable
        default public String getPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointProperty> {
            String address;
            String hostedZoneId;
            String port;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder hostedZoneId(String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public EndpointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBInstance.CertificateDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CertificateDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCaIdentifier() {
            return null;
        }

        @Nullable
        default public String getValidTill() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CertificateDetailsProperty> {
            String caIdentifier;
            String validTill;

            public Builder caIdentifier(String caIdentifier) {
                this.caIdentifier = caIdentifier;
                return this;
            }

            public Builder validTill(String validTill) {
                this.validTill = validTill;
                return this;
            }

            public CertificateDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

