/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.transfer.CfnServer;
import software.amazon.awscdk.services.transfer.CfnServerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnServer")
public class CfnServer
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnServer.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnServer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnServer(@NotNull Construct scope, @NotNull String id, @Nullable CfnServerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnServer(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrServerId() {
        return (String)Kernel.get((Object)this, (String)"attrServerId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public String getCertificate() {
        return (String)Kernel.get((Object)this, (String)"certificate", (NativeType)NativeType.forClass(String.class));
    }

    public void setCertificate(@Nullable String value) {
        Kernel.set((Object)this, (String)"certificate", (Object)value);
    }

    @Nullable
    public String getDomain() {
        return (String)Kernel.get((Object)this, (String)"domain", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomain(@Nullable String value) {
        Kernel.set((Object)this, (String)"domain", (Object)value);
    }

    @Nullable
    public Object getEndpointDetails() {
        return Kernel.get((Object)this, (String)"endpointDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEndpointDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"endpointDetails", (Object)value);
    }

    public void setEndpointDetails(@Nullable EndpointDetailsProperty value) {
        Kernel.set((Object)this, (String)"endpointDetails", (Object)value);
    }

    @Nullable
    public String getEndpointType() {
        return (String)Kernel.get((Object)this, (String)"endpointType", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpointType(@Nullable String value) {
        Kernel.set((Object)this, (String)"endpointType", (Object)value);
    }

    @Nullable
    public Object getIdentityProviderDetails() {
        return Kernel.get((Object)this, (String)"identityProviderDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIdentityProviderDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"identityProviderDetails", (Object)value);
    }

    public void setIdentityProviderDetails(@Nullable IdentityProviderDetailsProperty value) {
        Kernel.set((Object)this, (String)"identityProviderDetails", (Object)value);
    }

    @Nullable
    public String getIdentityProviderType() {
        return (String)Kernel.get((Object)this, (String)"identityProviderType", (NativeType)NativeType.forClass(String.class));
    }

    public void setIdentityProviderType(@Nullable String value) {
        Kernel.set((Object)this, (String)"identityProviderType", (Object)value);
    }

    @Nullable
    public String getLoggingRole() {
        return (String)Kernel.get((Object)this, (String)"loggingRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setLoggingRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"loggingRole", (Object)value);
    }

    @Nullable
    public String getPostAuthenticationLoginBanner() {
        return (String)Kernel.get((Object)this, (String)"postAuthenticationLoginBanner", (NativeType)NativeType.forClass(String.class));
    }

    public void setPostAuthenticationLoginBanner(@Nullable String value) {
        Kernel.set((Object)this, (String)"postAuthenticationLoginBanner", (Object)value);
    }

    @Nullable
    public String getPreAuthenticationLoginBanner() {
        return (String)Kernel.get((Object)this, (String)"preAuthenticationLoginBanner", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreAuthenticationLoginBanner(@Nullable String value) {
        Kernel.set((Object)this, (String)"preAuthenticationLoginBanner", (Object)value);
    }

    @Nullable
    public Object getProtocolDetails() {
        return Kernel.get((Object)this, (String)"protocolDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProtocolDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"protocolDetails", (Object)value);
    }

    public void setProtocolDetails(@Nullable ProtocolDetailsProperty value) {
        Kernel.set((Object)this, (String)"protocolDetails", (Object)value);
    }

    @Nullable
    public List<String> getProtocols() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"protocols", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setProtocols(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"protocols", value);
    }

    @Nullable
    public String getSecurityPolicyName() {
        return (String)Kernel.get((Object)this, (String)"securityPolicyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSecurityPolicyName(@Nullable String value) {
        Kernel.set((Object)this, (String)"securityPolicyName", (Object)value);
    }

    @Nullable
    public Object getWorkflowDetails() {
        return Kernel.get((Object)this, (String)"workflowDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setWorkflowDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"workflowDetails", (Object)value);
    }

    public void setWorkflowDetails(@Nullable WorkflowDetailsProperty value) {
        Kernel.set((Object)this, (String)"workflowDetails", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnServer> {
        private final Construct scope;
        private final String id;
        private CfnServerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder certificate(String certificate) {
            this.props().certificate(certificate);
            return this;
        }

        public Builder domain(String domain) {
            this.props().domain(domain);
            return this;
        }

        public Builder endpointDetails(IResolvable endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        public Builder endpointDetails(EndpointDetailsProperty endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        public Builder endpointType(String endpointType) {
            this.props().endpointType(endpointType);
            return this;
        }

        public Builder identityProviderDetails(IResolvable identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        public Builder identityProviderDetails(IdentityProviderDetailsProperty identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        public Builder identityProviderType(String identityProviderType) {
            this.props().identityProviderType(identityProviderType);
            return this;
        }

        public Builder loggingRole(String loggingRole) {
            this.props().loggingRole(loggingRole);
            return this;
        }

        public Builder postAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            this.props().postAuthenticationLoginBanner(postAuthenticationLoginBanner);
            return this;
        }

        public Builder preAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            this.props().preAuthenticationLoginBanner(preAuthenticationLoginBanner);
            return this;
        }

        public Builder protocolDetails(IResolvable protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }

        public Builder protocolDetails(ProtocolDetailsProperty protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }

        public Builder protocols(List<String> protocols) {
            this.props().protocols(protocols);
            return this;
        }

        public Builder securityPolicyName(String securityPolicyName) {
            this.props().securityPolicyName(securityPolicyName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder workflowDetails(IResolvable workflowDetails) {
            this.props().workflowDetails(workflowDetails);
            return this;
        }

        public Builder workflowDetails(WorkflowDetailsProperty workflowDetails) {
            this.props().workflowDetails(workflowDetails);
            return this;
        }

        public CfnServer build() {
            return new CfnServer(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnServerProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnServerProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnServer.WorkflowDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkflowDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnPartialUpload() {
            return null;
        }

        @Nullable
        default public Object getOnUpload() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WorkflowDetailsProperty> {
            Object onPartialUpload;
            Object onUpload;

            public Builder onPartialUpload(IResolvable onPartialUpload) {
                this.onPartialUpload = onPartialUpload;
                return this;
            }

            public Builder onPartialUpload(List<? extends Object> onPartialUpload) {
                this.onPartialUpload = onPartialUpload;
                return this;
            }

            public Builder onUpload(IResolvable onUpload) {
                this.onUpload = onUpload;
                return this;
            }

            public Builder onUpload(List<? extends Object> onUpload) {
                this.onUpload = onUpload;
                return this;
            }

            public WorkflowDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnServer.WorkflowDetailProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkflowDetailProperty
    extends JsiiSerializable {
        @NotNull
        public String getExecutionRole();

        @NotNull
        public String getWorkflowId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WorkflowDetailProperty> {
            String executionRole;
            String workflowId;

            public Builder executionRole(String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            public Builder workflowId(String workflowId) {
                this.workflowId = workflowId;
                return this;
            }

            public WorkflowDetailProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnServer.ProtocolDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProtocolDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAs2Transports() {
            return null;
        }

        @Nullable
        default public String getPassiveIp() {
            return null;
        }

        @Nullable
        default public String getSetStatOption() {
            return null;
        }

        @Nullable
        default public String getTlsSessionResumptionMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProtocolDetailsProperty> {
            List<String> as2Transports;
            String passiveIp;
            String setStatOption;
            String tlsSessionResumptionMode;

            public Builder as2Transports(List<String> as2Transports) {
                this.as2Transports = as2Transports;
                return this;
            }

            public Builder passiveIp(String passiveIp) {
                this.passiveIp = passiveIp;
                return this;
            }

            public Builder setStatOption(String setStatOption) {
                this.setStatOption = setStatOption;
                return this;
            }

            public Builder tlsSessionResumptionMode(String tlsSessionResumptionMode) {
                this.tlsSessionResumptionMode = tlsSessionResumptionMode;
                return this;
            }

            public ProtocolDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnServer.IdentityProviderDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdentityProviderDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDirectoryId() {
            return null;
        }

        @Nullable
        default public String getFunction() {
            return null;
        }

        @Nullable
        default public String getInvocationRole() {
            return null;
        }

        @Nullable
        default public String getSftpAuthenticationMethods() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IdentityProviderDetailsProperty> {
            String directoryId;
            String function;
            String invocationRole;
            String sftpAuthenticationMethods;
            String url;

            public Builder directoryId(String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public Builder invocationRole(String invocationRole) {
                this.invocationRole = invocationRole;
                return this;
            }

            public Builder sftpAuthenticationMethods(String sftpAuthenticationMethods) {
                this.sftpAuthenticationMethods = sftpAuthenticationMethods;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public IdentityProviderDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_transfer.CfnServer.EndpointDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAddressAllocationIds() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIds() {
            return null;
        }

        @Nullable
        default public String getVpcEndpointId() {
            return null;
        }

        @Nullable
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointDetailsProperty> {
            List<String> addressAllocationIds;
            List<String> securityGroupIds;
            List<String> subnetIds;
            String vpcEndpointId;
            String vpcId;

            public Builder addressAllocationIds(List<String> addressAllocationIds) {
                this.addressAllocationIds = addressAllocationIds;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public Builder vpcEndpointId(String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public EndpointDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

