/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codedeploy;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup;
import software.amazon.awscdk.services.codedeploy.CfnDeploymentGroupProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup")
public class CfnDeploymentGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDeploymentGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDeploymentGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeploymentGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDeploymentGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnDeploymentGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getApplicationName() {
        return (String)Kernel.get((Object)this, (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationName(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationName", (Object)Objects.requireNonNull(value, "applicationName is required"));
    }

    @NotNull
    public String getServiceRoleArn() {
        return (String)Kernel.get((Object)this, (String)"serviceRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"serviceRoleArn", (Object)Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    @Nullable
    public Object getAlarmConfiguration() {
        return Kernel.get((Object)this, (String)"alarmConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAlarmConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"alarmConfiguration", (Object)value);
    }

    public void setAlarmConfiguration(@Nullable AlarmConfigurationProperty value) {
        Kernel.set((Object)this, (String)"alarmConfiguration", (Object)value);
    }

    @Nullable
    public Object getAutoRollbackConfiguration() {
        return Kernel.get((Object)this, (String)"autoRollbackConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoRollbackConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoRollbackConfiguration", (Object)value);
    }

    public void setAutoRollbackConfiguration(@Nullable AutoRollbackConfigurationProperty value) {
        Kernel.set((Object)this, (String)"autoRollbackConfiguration", (Object)value);
    }

    @Nullable
    public List<String> getAutoScalingGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"autoScalingGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAutoScalingGroups(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"autoScalingGroups", value);
    }

    @Nullable
    public Object getBlueGreenDeploymentConfiguration() {
        return Kernel.get((Object)this, (String)"blueGreenDeploymentConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBlueGreenDeploymentConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"blueGreenDeploymentConfiguration", (Object)value);
    }

    public void setBlueGreenDeploymentConfiguration(@Nullable BlueGreenDeploymentConfigurationProperty value) {
        Kernel.set((Object)this, (String)"blueGreenDeploymentConfiguration", (Object)value);
    }

    @Nullable
    public Object getDeployment() {
        return Kernel.get((Object)this, (String)"deployment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeployment(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deployment", (Object)value);
    }

    public void setDeployment(@Nullable DeploymentProperty value) {
        Kernel.set((Object)this, (String)"deployment", (Object)value);
    }

    @Nullable
    public String getDeploymentConfigName() {
        return (String)Kernel.get((Object)this, (String)"deploymentConfigName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeploymentConfigName(@Nullable String value) {
        Kernel.set((Object)this, (String)"deploymentConfigName", (Object)value);
    }

    @Nullable
    public String getDeploymentGroupName() {
        return (String)Kernel.get((Object)this, (String)"deploymentGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDeploymentGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"deploymentGroupName", (Object)value);
    }

    @Nullable
    public Object getDeploymentStyle() {
        return Kernel.get((Object)this, (String)"deploymentStyle", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeploymentStyle(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deploymentStyle", (Object)value);
    }

    public void setDeploymentStyle(@Nullable DeploymentStyleProperty value) {
        Kernel.set((Object)this, (String)"deploymentStyle", (Object)value);
    }

    @Nullable
    public Object getEc2TagFilters() {
        return Kernel.get((Object)this, (String)"ec2TagFilters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEc2TagFilters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ec2TagFilters", (Object)value);
    }

    public void setEc2TagFilters(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof EC2TagFilterProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.EC2TagFilterProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"ec2TagFilters", value);
    }

    @Nullable
    public Object getEc2TagSet() {
        return Kernel.get((Object)this, (String)"ec2TagSet", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEc2TagSet(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ec2TagSet", (Object)value);
    }

    public void setEc2TagSet(@Nullable EC2TagSetProperty value) {
        Kernel.set((Object)this, (String)"ec2TagSet", (Object)value);
    }

    @Nullable
    public Object getEcsServices() {
        return Kernel.get((Object)this, (String)"ecsServices", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEcsServices(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ecsServices", (Object)value);
    }

    public void setEcsServices(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ECSServiceProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.ECSServiceProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"ecsServices", value);
    }

    @Nullable
    public Object getLoadBalancerInfo() {
        return Kernel.get((Object)this, (String)"loadBalancerInfo", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLoadBalancerInfo(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"loadBalancerInfo", (Object)value);
    }

    public void setLoadBalancerInfo(@Nullable LoadBalancerInfoProperty value) {
        Kernel.set((Object)this, (String)"loadBalancerInfo", (Object)value);
    }

    @Nullable
    public Object getOnPremisesInstanceTagFilters() {
        return Kernel.get((Object)this, (String)"onPremisesInstanceTagFilters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOnPremisesInstanceTagFilters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"onPremisesInstanceTagFilters", (Object)value);
    }

    public void setOnPremisesInstanceTagFilters(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof TagFilterProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TagFilterProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"onPremisesInstanceTagFilters", value);
    }

    @Nullable
    public Object getOnPremisesTagSet() {
        return Kernel.get((Object)this, (String)"onPremisesTagSet", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOnPremisesTagSet(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"onPremisesTagSet", (Object)value);
    }

    public void setOnPremisesTagSet(@Nullable OnPremisesTagSetProperty value) {
        Kernel.set((Object)this, (String)"onPremisesTagSet", (Object)value);
    }

    @Nullable
    public String getOutdatedInstancesStrategy() {
        return (String)Kernel.get((Object)this, (String)"outdatedInstancesStrategy", (NativeType)NativeType.forClass(String.class));
    }

    public void setOutdatedInstancesStrategy(@Nullable String value) {
        Kernel.set((Object)this, (String)"outdatedInstancesStrategy", (Object)value);
    }

    @Nullable
    public Object getTriggerConfigurations() {
        return Kernel.get((Object)this, (String)"triggerConfigurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTriggerConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"triggerConfigurations", (Object)value);
    }

    public void setTriggerConfigurations(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof TriggerConfigProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codedeploy.CfnDeploymentGroup.TriggerConfigProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"triggerConfigurations", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.EC2TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EC2TagFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EC2TagFilterProperty> {
            String key;
            String type;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EC2TagFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.ECSServiceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ECSServiceProperty
    extends JsiiSerializable {
        @NotNull
        public String getClusterName();

        @NotNull
        public String getServiceName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ECSServiceProperty> {
            String clusterName;
            String serviceName;

            public Builder clusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            public Builder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public ECSServiceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagFilterProperty> {
            String key;
            String type;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.TriggerConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TriggerConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getTriggerEvents() {
            return null;
        }

        @Nullable
        default public String getTriggerName() {
            return null;
        }

        @Nullable
        default public String getTriggerTargetArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TriggerConfigProperty> {
            List<String> triggerEvents;
            String triggerName;
            String triggerTargetArn;

            public Builder triggerEvents(List<String> triggerEvents) {
                this.triggerEvents = triggerEvents;
                return this;
            }

            public Builder triggerName(String triggerName) {
                this.triggerName = triggerName;
                return this;
            }

            public Builder triggerTargetArn(String triggerTargetArn) {
                this.triggerTargetArn = triggerTargetArn;
                return this;
            }

            public TriggerConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDeploymentGroup> {
        private final Construct scope;
        private final String id;
        private final CfnDeploymentGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDeploymentGroupProps.Builder();
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder serviceRoleArn(String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        public Builder alarmConfiguration(IResolvable alarmConfiguration) {
            this.props.alarmConfiguration(alarmConfiguration);
            return this;
        }

        public Builder alarmConfiguration(AlarmConfigurationProperty alarmConfiguration) {
            this.props.alarmConfiguration(alarmConfiguration);
            return this;
        }

        public Builder autoRollbackConfiguration(IResolvable autoRollbackConfiguration) {
            this.props.autoRollbackConfiguration(autoRollbackConfiguration);
            return this;
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfigurationProperty autoRollbackConfiguration) {
            this.props.autoRollbackConfiguration(autoRollbackConfiguration);
            return this;
        }

        public Builder autoScalingGroups(List<String> autoScalingGroups) {
            this.props.autoScalingGroups(autoScalingGroups);
            return this;
        }

        public Builder blueGreenDeploymentConfiguration(IResolvable blueGreenDeploymentConfiguration) {
            this.props.blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration);
            return this;
        }

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfigurationProperty blueGreenDeploymentConfiguration) {
            this.props.blueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration);
            return this;
        }

        public Builder deployment(IResolvable deployment) {
            this.props.deployment(deployment);
            return this;
        }

        public Builder deployment(DeploymentProperty deployment) {
            this.props.deployment(deployment);
            return this;
        }

        public Builder deploymentConfigName(String deploymentConfigName) {
            this.props.deploymentConfigName(deploymentConfigName);
            return this;
        }

        public Builder deploymentGroupName(String deploymentGroupName) {
            this.props.deploymentGroupName(deploymentGroupName);
            return this;
        }

        public Builder deploymentStyle(IResolvable deploymentStyle) {
            this.props.deploymentStyle(deploymentStyle);
            return this;
        }

        public Builder deploymentStyle(DeploymentStyleProperty deploymentStyle) {
            this.props.deploymentStyle(deploymentStyle);
            return this;
        }

        public Builder ec2TagFilters(IResolvable ec2TagFilters) {
            this.props.ec2TagFilters(ec2TagFilters);
            return this;
        }

        public Builder ec2TagFilters(List<? extends Object> ec2TagFilters) {
            this.props.ec2TagFilters(ec2TagFilters);
            return this;
        }

        public Builder ec2TagSet(IResolvable ec2TagSet) {
            this.props.ec2TagSet(ec2TagSet);
            return this;
        }

        public Builder ec2TagSet(EC2TagSetProperty ec2TagSet) {
            this.props.ec2TagSet(ec2TagSet);
            return this;
        }

        public Builder ecsServices(IResolvable ecsServices) {
            this.props.ecsServices(ecsServices);
            return this;
        }

        public Builder ecsServices(List<? extends Object> ecsServices) {
            this.props.ecsServices(ecsServices);
            return this;
        }

        public Builder loadBalancerInfo(IResolvable loadBalancerInfo) {
            this.props.loadBalancerInfo(loadBalancerInfo);
            return this;
        }

        public Builder loadBalancerInfo(LoadBalancerInfoProperty loadBalancerInfo) {
            this.props.loadBalancerInfo(loadBalancerInfo);
            return this;
        }

        public Builder onPremisesInstanceTagFilters(IResolvable onPremisesInstanceTagFilters) {
            this.props.onPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
            return this;
        }

        public Builder onPremisesInstanceTagFilters(List<? extends Object> onPremisesInstanceTagFilters) {
            this.props.onPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
            return this;
        }

        public Builder onPremisesTagSet(IResolvable onPremisesTagSet) {
            this.props.onPremisesTagSet(onPremisesTagSet);
            return this;
        }

        public Builder onPremisesTagSet(OnPremisesTagSetProperty onPremisesTagSet) {
            this.props.onPremisesTagSet(onPremisesTagSet);
            return this;
        }

        public Builder outdatedInstancesStrategy(String outdatedInstancesStrategy) {
            this.props.outdatedInstancesStrategy(outdatedInstancesStrategy);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder triggerConfigurations(IResolvable triggerConfigurations) {
            this.props.triggerConfigurations(triggerConfigurations);
            return this;
        }

        public Builder triggerConfigurations(List<? extends Object> triggerConfigurations) {
            this.props.triggerConfigurations(triggerConfigurations);
            return this;
        }

        public CfnDeploymentGroup build() {
            return new CfnDeploymentGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.TrafficRouteProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TrafficRouteProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getListenerArns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TrafficRouteProperty> {
            List<String> listenerArns;

            public Builder listenerArns(List<String> listenerArns) {
                this.listenerArns = listenerArns;
                return this;
            }

            public TrafficRouteProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.TargetGroupPairInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetGroupPairInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getProdTrafficRoute() {
            return null;
        }

        @Nullable
        default public Object getTargetGroups() {
            return null;
        }

        @Nullable
        default public Object getTestTrafficRoute() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetGroupPairInfoProperty> {
            Object prodTrafficRoute;
            Object targetGroups;
            Object testTrafficRoute;

            public Builder prodTrafficRoute(IResolvable prodTrafficRoute) {
                this.prodTrafficRoute = prodTrafficRoute;
                return this;
            }

            public Builder prodTrafficRoute(TrafficRouteProperty prodTrafficRoute) {
                this.prodTrafficRoute = prodTrafficRoute;
                return this;
            }

            public Builder targetGroups(IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            public Builder targetGroups(List<? extends Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            public Builder testTrafficRoute(IResolvable testTrafficRoute) {
                this.testTrafficRoute = testTrafficRoute;
                return this;
            }

            public Builder testTrafficRoute(TrafficRouteProperty testTrafficRoute) {
                this.testTrafficRoute = testTrafficRoute;
                return this;
            }

            public TargetGroupPairInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.TargetGroupInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetGroupInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetGroupInfoProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public TargetGroupInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public String getBundleType() {
            return null;
        }

        @Nullable
        default public String getETag() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucket;
            String key;
            String bundleType;
            String eTag;
            String version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder bundleType(String bundleType) {
                this.bundleType = bundleType;
                return this;
            }

            public Builder eTag(String eTag) {
                this.eTag = eTag;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.RevisionLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RevisionLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGitHubLocation() {
            return null;
        }

        @Nullable
        default public String getRevisionType() {
            return null;
        }

        @Nullable
        default public Object getS3Location() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RevisionLocationProperty> {
            Object gitHubLocation;
            String revisionType;
            Object s3Location;

            public Builder gitHubLocation(IResolvable gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            public Builder gitHubLocation(GitHubLocationProperty gitHubLocation) {
                this.gitHubLocation = gitHubLocation;
                return this;
            }

            public Builder revisionType(String revisionType) {
                this.revisionType = revisionType;
                return this;
            }

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public RevisionLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.OnPremisesTagSetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnPremisesTagSetProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnPremisesTagSetList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnPremisesTagSetProperty> {
            Object onPremisesTagSetList;

            public Builder onPremisesTagSetList(IResolvable onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            public Builder onPremisesTagSetList(List<? extends Object> onPremisesTagSetList) {
                this.onPremisesTagSetList = onPremisesTagSetList;
                return this;
            }

            public OnPremisesTagSetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.OnPremisesTagSetListObjectProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnPremisesTagSetListObjectProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnPremisesTagGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnPremisesTagSetListObjectProperty> {
            Object onPremisesTagGroup;

            public Builder onPremisesTagGroup(IResolvable onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            public Builder onPremisesTagGroup(List<? extends Object> onPremisesTagGroup) {
                this.onPremisesTagGroup = onPremisesTagGroup;
                return this;
            }

            public OnPremisesTagSetListObjectProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.LoadBalancerInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoadBalancerInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getElbInfoList() {
            return null;
        }

        @Nullable
        default public Object getTargetGroupInfoList() {
            return null;
        }

        @Nullable
        default public Object getTargetGroupPairInfoList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoadBalancerInfoProperty> {
            Object elbInfoList;
            Object targetGroupInfoList;
            Object targetGroupPairInfoList;

            public Builder elbInfoList(IResolvable elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            public Builder elbInfoList(List<? extends Object> elbInfoList) {
                this.elbInfoList = elbInfoList;
                return this;
            }

            public Builder targetGroupInfoList(IResolvable targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            public Builder targetGroupInfoList(List<? extends Object> targetGroupInfoList) {
                this.targetGroupInfoList = targetGroupInfoList;
                return this;
            }

            public Builder targetGroupPairInfoList(IResolvable targetGroupPairInfoList) {
                this.targetGroupPairInfoList = targetGroupPairInfoList;
                return this;
            }

            public Builder targetGroupPairInfoList(List<? extends Object> targetGroupPairInfoList) {
                this.targetGroupPairInfoList = targetGroupPairInfoList;
                return this;
            }

            public LoadBalancerInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.GreenFleetProvisioningOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GreenFleetProvisioningOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAction() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GreenFleetProvisioningOptionProperty> {
            String action;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public GreenFleetProvisioningOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.GitHubLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GitHubLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCommitId();

        @NotNull
        public String getRepository();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GitHubLocationProperty> {
            String commitId;
            String repository;

            public Builder commitId(String commitId) {
                this.commitId = commitId;
                return this;
            }

            public Builder repository(String repository) {
                this.repository = repository;
                return this;
            }

            public GitHubLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.ELBInfoProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ELBInfoProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ELBInfoProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public ELBInfoProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.EC2TagSetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EC2TagSetProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEc2TagSetList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EC2TagSetProperty> {
            Object ec2TagSetList;

            public Builder ec2TagSetList(IResolvable ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            public Builder ec2TagSetList(List<? extends Object> ec2TagSetList) {
                this.ec2TagSetList = ec2TagSetList;
                return this;
            }

            public EC2TagSetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.EC2TagSetListObjectProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EC2TagSetListObjectProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEc2TagGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EC2TagSetListObjectProperty> {
            Object ec2TagGroup;

            public Builder ec2TagGroup(IResolvable ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            public Builder ec2TagGroup(List<? extends Object> ec2TagGroup) {
                this.ec2TagGroup = ec2TagGroup;
                return this;
            }

            public EC2TagSetListObjectProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.DeploymentStyleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentStyleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeploymentOption() {
            return null;
        }

        @Nullable
        default public String getDeploymentType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentStyleProperty> {
            String deploymentOption;
            String deploymentType;

            public Builder deploymentOption(String deploymentOption) {
                this.deploymentOption = deploymentOption;
                return this;
            }

            public Builder deploymentType(String deploymentType) {
                this.deploymentType = deploymentType;
                return this;
            }

            public DeploymentStyleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.DeploymentReadyOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentReadyOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getActionOnTimeout() {
            return null;
        }

        @Nullable
        default public Number getWaitTimeInMinutes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentReadyOptionProperty> {
            String actionOnTimeout;
            Number waitTimeInMinutes;

            public Builder actionOnTimeout(String actionOnTimeout) {
                this.actionOnTimeout = actionOnTimeout;
                return this;
            }

            public Builder waitTimeInMinutes(Number waitTimeInMinutes) {
                this.waitTimeInMinutes = waitTimeInMinutes;
                return this;
            }

            public DeploymentReadyOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.DeploymentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeploymentProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRevision();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getIgnoreApplicationStopFailures() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeploymentProperty> {
            Object revision;
            String description;
            Object ignoreApplicationStopFailures;

            public Builder revision(IResolvable revision) {
                this.revision = revision;
                return this;
            }

            public Builder revision(RevisionLocationProperty revision) {
                this.revision = revision;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            public Builder ignoreApplicationStopFailures(IResolvable ignoreApplicationStopFailures) {
                this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
                return this;
            }

            public DeploymentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.BlueInstanceTerminationOptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlueInstanceTerminationOptionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAction() {
            return null;
        }

        @Nullable
        default public Number getTerminationWaitTimeInMinutes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlueInstanceTerminationOptionProperty> {
            String action;
            Number terminationWaitTimeInMinutes;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public Builder terminationWaitTimeInMinutes(Number terminationWaitTimeInMinutes) {
                this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
                return this;
            }

            public BlueInstanceTerminationOptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.BlueGreenDeploymentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlueGreenDeploymentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeploymentReadyOption() {
            return null;
        }

        @Nullable
        default public Object getGreenFleetProvisioningOption() {
            return null;
        }

        @Nullable
        default public Object getTerminateBlueInstancesOnDeploymentSuccess() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlueGreenDeploymentConfigurationProperty> {
            Object deploymentReadyOption;
            Object greenFleetProvisioningOption;
            Object terminateBlueInstancesOnDeploymentSuccess;

            public Builder deploymentReadyOption(IResolvable deploymentReadyOption) {
                this.deploymentReadyOption = deploymentReadyOption;
                return this;
            }

            public Builder deploymentReadyOption(DeploymentReadyOptionProperty deploymentReadyOption) {
                this.deploymentReadyOption = deploymentReadyOption;
                return this;
            }

            public Builder greenFleetProvisioningOption(IResolvable greenFleetProvisioningOption) {
                this.greenFleetProvisioningOption = greenFleetProvisioningOption;
                return this;
            }

            public Builder greenFleetProvisioningOption(GreenFleetProvisioningOptionProperty greenFleetProvisioningOption) {
                this.greenFleetProvisioningOption = greenFleetProvisioningOption;
                return this;
            }

            public Builder terminateBlueInstancesOnDeploymentSuccess(IResolvable terminateBlueInstancesOnDeploymentSuccess) {
                this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
                return this;
            }

            public Builder terminateBlueInstancesOnDeploymentSuccess(BlueInstanceTerminationOptionProperty terminateBlueInstancesOnDeploymentSuccess) {
                this.terminateBlueInstancesOnDeploymentSuccess = terminateBlueInstancesOnDeploymentSuccess;
                return this;
            }

            public BlueGreenDeploymentConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.AutoRollbackConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoRollbackConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public List<String> getEvents() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoRollbackConfigurationProperty> {
            Object enabled;
            List<String> events;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder events(List<String> events) {
                this.events = events;
                return this;
            }

            public AutoRollbackConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.AlarmProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlarmProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlarmProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public AlarmProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codedeploy.CfnDeploymentGroup.AlarmConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AlarmConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAlarms() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getIgnorePollAlarmFailure() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AlarmConfigurationProperty> {
            Object alarms;
            Object enabled;
            Object ignorePollAlarmFailure;

            public Builder alarms(IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder alarms(List<? extends Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder ignorePollAlarmFailure(Boolean ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            public Builder ignorePollAlarmFailure(IResolvable ignorePollAlarmFailure) {
                this.ignorePollAlarmFailure = ignorePollAlarmFailure;
                return this;
            }

            public AlarmConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

