/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.emr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.emr.CfnCluster;
import software.amazon.awscdk.services.emr.CfnClusterProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrMasterPublicDns() {
        return (String)Kernel.get((Object)this, (String)"attrMasterPublicDns", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getAdditionalInfo() {
        return Kernel.get((Object)this, (String)"additionalInfo", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAdditionalInfo(@NotNull Object value) {
        Kernel.set((Object)this, (String)"additionalInfo", (Object)Objects.requireNonNull(value, "additionalInfo is required"));
    }

    @NotNull
    public Object getInstances() {
        return Kernel.get((Object)this, (String)"instances", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInstances(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"instances", (Object)Objects.requireNonNull(value, "instances is required"));
    }

    public void setInstances(@NotNull JobFlowInstancesConfigProperty value) {
        Kernel.set((Object)this, (String)"instances", (Object)Objects.requireNonNull(value, "instances is required"));
    }

    @NotNull
    public String getJobFlowRole() {
        return (String)Kernel.get((Object)this, (String)"jobFlowRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setJobFlowRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"jobFlowRole", (Object)Objects.requireNonNull(value, "jobFlowRole is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getServiceRole() {
        return (String)Kernel.get((Object)this, (String)"serviceRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"serviceRole", (Object)Objects.requireNonNull(value, "serviceRole is required"));
    }

    @Nullable
    public Object getApplications() {
        return Kernel.get((Object)this, (String)"applications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setApplications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"applications", (Object)value);
    }

    public void setApplications(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ApplicationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emr.CfnCluster.ApplicationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"applications", value);
    }

    @Nullable
    public String getAutoScalingRole() {
        return (String)Kernel.get((Object)this, (String)"autoScalingRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutoScalingRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"autoScalingRole", (Object)value);
    }

    @Nullable
    public Object getAutoTerminationPolicy() {
        return Kernel.get((Object)this, (String)"autoTerminationPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoTerminationPolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoTerminationPolicy", (Object)value);
    }

    public void setAutoTerminationPolicy(@Nullable AutoTerminationPolicyProperty value) {
        Kernel.set((Object)this, (String)"autoTerminationPolicy", (Object)value);
    }

    @Nullable
    public Object getBootstrapActions() {
        return Kernel.get((Object)this, (String)"bootstrapActions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBootstrapActions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"bootstrapActions", (Object)value);
    }

    public void setBootstrapActions(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof BootstrapActionConfigProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emr.CfnCluster.BootstrapActionConfigProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"bootstrapActions", value);
    }

    @Nullable
    public Object getConfigurations() {
        return Kernel.get((Object)this, (String)"configurations", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfigurations(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"configurations", (Object)value);
    }

    public void setConfigurations(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ConfigurationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emr.CfnCluster.ConfigurationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"configurations", value);
    }

    @Nullable
    public String getCustomAmiId() {
        return (String)Kernel.get((Object)this, (String)"customAmiId", (NativeType)NativeType.forClass(String.class));
    }

    public void setCustomAmiId(@Nullable String value) {
        Kernel.set((Object)this, (String)"customAmiId", (Object)value);
    }

    @Nullable
    public Number getEbsRootVolumeSize() {
        return (Number)Kernel.get((Object)this, (String)"ebsRootVolumeSize", (NativeType)NativeType.forClass(Number.class));
    }

    public void setEbsRootVolumeSize(@Nullable Number value) {
        Kernel.set((Object)this, (String)"ebsRootVolumeSize", (Object)value);
    }

    @Nullable
    public Object getKerberosAttributes() {
        return Kernel.get((Object)this, (String)"kerberosAttributes", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKerberosAttributes(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"kerberosAttributes", (Object)value);
    }

    public void setKerberosAttributes(@Nullable KerberosAttributesProperty value) {
        Kernel.set((Object)this, (String)"kerberosAttributes", (Object)value);
    }

    @Nullable
    public String getLogEncryptionKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"logEncryptionKmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setLogEncryptionKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"logEncryptionKmsKeyId", (Object)value);
    }

    @Nullable
    public String getLogUri() {
        return (String)Kernel.get((Object)this, (String)"logUri", (NativeType)NativeType.forClass(String.class));
    }

    public void setLogUri(@Nullable String value) {
        Kernel.set((Object)this, (String)"logUri", (Object)value);
    }

    @Nullable
    public Object getManagedScalingPolicy() {
        return Kernel.get((Object)this, (String)"managedScalingPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setManagedScalingPolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"managedScalingPolicy", (Object)value);
    }

    public void setManagedScalingPolicy(@Nullable ManagedScalingPolicyProperty value) {
        Kernel.set((Object)this, (String)"managedScalingPolicy", (Object)value);
    }

    @Nullable
    public String getOsReleaseLabel() {
        return (String)Kernel.get((Object)this, (String)"osReleaseLabel", (NativeType)NativeType.forClass(String.class));
    }

    public void setOsReleaseLabel(@Nullable String value) {
        Kernel.set((Object)this, (String)"osReleaseLabel", (Object)value);
    }

    @Nullable
    public String getReleaseLabel() {
        return (String)Kernel.get((Object)this, (String)"releaseLabel", (NativeType)NativeType.forClass(String.class));
    }

    public void setReleaseLabel(@Nullable String value) {
        Kernel.set((Object)this, (String)"releaseLabel", (Object)value);
    }

    @Nullable
    public String getScaleDownBehavior() {
        return (String)Kernel.get((Object)this, (String)"scaleDownBehavior", (NativeType)NativeType.forClass(String.class));
    }

    public void setScaleDownBehavior(@Nullable String value) {
        Kernel.set((Object)this, (String)"scaleDownBehavior", (Object)value);
    }

    @Nullable
    public String getSecurityConfiguration() {
        return (String)Kernel.get((Object)this, (String)"securityConfiguration", (NativeType)NativeType.forClass(String.class));
    }

    public void setSecurityConfiguration(@Nullable String value) {
        Kernel.set((Object)this, (String)"securityConfiguration", (Object)value);
    }

    @Nullable
    public Number getStepConcurrencyLevel() {
        return (Number)Kernel.get((Object)this, (String)"stepConcurrencyLevel", (NativeType)NativeType.forClass(Number.class));
    }

    public void setStepConcurrencyLevel(@Nullable Number value) {
        Kernel.set((Object)this, (String)"stepConcurrencyLevel", (Object)value);
    }

    @Nullable
    public Object getSteps() {
        return Kernel.get((Object)this, (String)"steps", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSteps(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"steps", (Object)value);
    }

    public void setSteps(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof StepConfigProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emr.CfnCluster.StepConfigProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"steps", value);
    }

    @Nullable
    public Object getVisibleToAllUsers() {
        return Kernel.get((Object)this, (String)"visibleToAllUsers", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVisibleToAllUsers(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"visibleToAllUsers", (Object)value);
    }

    public void setVisibleToAllUsers(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"visibleToAllUsers", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ApplicationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApplicationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAdditionalInfo() {
            return null;
        }

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApplicationProperty> {
            Object additionalInfo;
            List<String> args;
            String name;
            String version;

            public Builder additionalInfo(IResolvable additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            public Builder additionalInfo(Map<String, String> additionalInfo) {
                this.additionalInfo = additionalInfo;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public ApplicationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.BootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BootstrapActionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public Object getScriptBootstrapAction();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BootstrapActionConfigProperty> {
            String name;
            Object scriptBootstrapAction;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder scriptBootstrapAction(IResolvable scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            public Builder scriptBootstrapAction(ScriptBootstrapActionConfigProperty scriptBootstrapAction) {
                this.scriptBootstrapAction = scriptBootstrapAction;
                return this;
            }

            public BootstrapActionConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClassification() {
            return null;
        }

        @Nullable
        default public Object getConfigurationProperties() {
            return null;
        }

        @Nullable
        default public Object getConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfigurationProperty> {
            String classification;
            Object configurationProperties;
            Object configurations;

            public Builder classification(String classification) {
                this.classification = classification;
                return this;
            }

            public Builder configurationProperties(IResolvable configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            public Builder configurationProperties(Map<String, String> configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            public Builder configurations(IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder configurations(List<? extends Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            public ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.StepConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StepConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getHadoopJarStep();

        @NotNull
        public String getName();

        @Nullable
        default public String getActionOnFailure() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StepConfigProperty> {
            Object hadoopJarStep;
            String name;
            String actionOnFailure;

            public Builder hadoopJarStep(IResolvable hadoopJarStep) {
                this.hadoopJarStep = hadoopJarStep;
                return this;
            }

            public Builder hadoopJarStep(HadoopJarStepConfigProperty hadoopJarStep) {
                this.hadoopJarStep = hadoopJarStep;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder actionOnFailure(String actionOnFailure) {
                this.actionOnFailure = actionOnFailure;
                return this;
            }

            public StepConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder instances(IResolvable instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder instances(JobFlowInstancesConfigProperty instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder jobFlowRole(String jobFlowRole) {
            this.props.jobFlowRole(jobFlowRole);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder serviceRole(String serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        public Builder additionalInfo(Object additionalInfo) {
            this.props.additionalInfo(additionalInfo);
            return this;
        }

        public Builder applications(IResolvable applications) {
            this.props.applications(applications);
            return this;
        }

        public Builder applications(List<? extends Object> applications) {
            this.props.applications(applications);
            return this;
        }

        public Builder autoScalingRole(String autoScalingRole) {
            this.props.autoScalingRole(autoScalingRole);
            return this;
        }

        public Builder autoTerminationPolicy(IResolvable autoTerminationPolicy) {
            this.props.autoTerminationPolicy(autoTerminationPolicy);
            return this;
        }

        public Builder autoTerminationPolicy(AutoTerminationPolicyProperty autoTerminationPolicy) {
            this.props.autoTerminationPolicy(autoTerminationPolicy);
            return this;
        }

        public Builder bootstrapActions(IResolvable bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }

        public Builder bootstrapActions(List<? extends Object> bootstrapActions) {
            this.props.bootstrapActions(bootstrapActions);
            return this;
        }

        public Builder configurations(IResolvable configurations) {
            this.props.configurations(configurations);
            return this;
        }

        public Builder configurations(List<? extends Object> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        public Builder customAmiId(String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        public Builder ebsRootVolumeSize(Number ebsRootVolumeSize) {
            this.props.ebsRootVolumeSize(ebsRootVolumeSize);
            return this;
        }

        public Builder kerberosAttributes(IResolvable kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }

        public Builder kerberosAttributes(KerberosAttributesProperty kerberosAttributes) {
            this.props.kerberosAttributes(kerberosAttributes);
            return this;
        }

        public Builder logEncryptionKmsKeyId(String logEncryptionKmsKeyId) {
            this.props.logEncryptionKmsKeyId(logEncryptionKmsKeyId);
            return this;
        }

        public Builder logUri(String logUri) {
            this.props.logUri(logUri);
            return this;
        }

        public Builder managedScalingPolicy(IResolvable managedScalingPolicy) {
            this.props.managedScalingPolicy(managedScalingPolicy);
            return this;
        }

        public Builder managedScalingPolicy(ManagedScalingPolicyProperty managedScalingPolicy) {
            this.props.managedScalingPolicy(managedScalingPolicy);
            return this;
        }

        public Builder osReleaseLabel(String osReleaseLabel) {
            this.props.osReleaseLabel(osReleaseLabel);
            return this;
        }

        public Builder releaseLabel(String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        public Builder scaleDownBehavior(String scaleDownBehavior) {
            this.props.scaleDownBehavior(scaleDownBehavior);
            return this;
        }

        public Builder securityConfiguration(String securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        public Builder stepConcurrencyLevel(Number stepConcurrencyLevel) {
            this.props.stepConcurrencyLevel(stepConcurrencyLevel);
            return this;
        }

        public Builder steps(IResolvable steps) {
            this.props.steps(steps);
            return this;
        }

        public Builder steps(List<? extends Object> steps) {
            this.props.steps(steps);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }

        public Builder visibleToAllUsers(IResolvable visibleToAllUsers) {
            this.props.visibleToAllUsers(visibleToAllUsers);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSizeInGb();

        @NotNull
        public String getVolumeType();

        @Nullable
        default public Number getIops() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            Number sizeInGb;
            String volumeType;
            Number iops;

            public Builder sizeInGb(Number sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public VolumeSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotProvisioningSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimeoutAction();

        @NotNull
        public Number getTimeoutDurationMinutes();

        @Nullable
        default public String getAllocationStrategy() {
            return null;
        }

        @Nullable
        default public Number getBlockDurationMinutes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotProvisioningSpecificationProperty> {
            String timeoutAction;
            Number timeoutDurationMinutes;
            String allocationStrategy;
            Number blockDurationMinutes;

            public Builder timeoutAction(String timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            public Builder timeoutDurationMinutes(Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public Builder blockDurationMinutes(Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            public SpotProvisioningSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SimpleScalingPolicyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getScalingAdjustment();

        @Nullable
        default public String getAdjustmentType() {
            return null;
        }

        @Nullable
        default public Number getCoolDown() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SimpleScalingPolicyConfigurationProperty> {
            Number scalingAdjustment;
            String adjustmentType;
            Number coolDown;

            public Builder scalingAdjustment(Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            public Builder adjustmentType(String adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            public Builder coolDown(Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ScriptBootstrapActionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScriptBootstrapActionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getPath();

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScriptBootstrapActionConfigProperty> {
            String path;
            List<String> args;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public ScriptBootstrapActionConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingTriggerProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCloudWatchAlarmDefinition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingTriggerProperty> {
            Object cloudWatchAlarmDefinition;

            public Builder cloudWatchAlarmDefinition(IResolvable cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            public Builder cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            public ScalingTriggerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ScalingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAction();

        @NotNull
        public String getName();

        @NotNull
        public Object getTrigger();

        @Nullable
        default public String getDescription() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingRuleProperty> {
            Object action;
            String name;
            Object trigger;
            String description;

            public Builder action(IResolvable action) {
                this.action = action;
                return this;
            }

            public Builder action(ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder trigger(IResolvable trigger) {
                this.trigger = trigger;
                return this;
            }

            public Builder trigger(ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public ScalingRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingConstraintsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxCapacity();

        @NotNull
        public Number getMinCapacity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingConstraintsProperty> {
            Number maxCapacity;
            Number minCapacity;

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder minCapacity(Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            public ScalingConstraintsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ScalingActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingActionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSimpleScalingPolicyConfiguration();

        @Nullable
        default public String getMarket() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingActionProperty> {
            Object simpleScalingPolicyConfiguration;
            String market;

            public Builder simpleScalingPolicyConfiguration(IResolvable simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            public Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            public Builder market(String market) {
                this.market = market;
                return this;
            }

            public ScalingActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.PlacementTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementTypeProperty
    extends JsiiSerializable {
        @NotNull
        public String getAvailabilityZone();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementTypeProperty> {
            String availabilityZone;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public PlacementTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.OnDemandProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnDemandProvisioningSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAllocationStrategy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnDemandProvisioningSpecificationProperty> {
            String allocationStrategy;

            public Builder allocationStrategy(String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            public OnDemandProvisioningSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.MetricDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricDimensionProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MetricDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ManagedScalingPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ManagedScalingPolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getComputeLimits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ManagedScalingPolicyProperty> {
            Object computeLimits;

            public Builder computeLimits(IResolvable computeLimits) {
                this.computeLimits = computeLimits;
                return this;
            }

            public Builder computeLimits(ComputeLimitsProperty computeLimits) {
                this.computeLimits = computeLimits;
                return this;
            }

            public ManagedScalingPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.KeyValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeyValueProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeyValueProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public KeyValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.KerberosAttributesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KerberosAttributesProperty
    extends JsiiSerializable {
        @NotNull
        public String getKdcAdminPassword();

        @NotNull
        public String getRealm();

        @Nullable
        default public String getAdDomainJoinPassword() {
            return null;
        }

        @Nullable
        default public String getAdDomainJoinUser() {
            return null;
        }

        @Nullable
        default public String getCrossRealmTrustPrincipalPassword() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KerberosAttributesProperty> {
            String kdcAdminPassword;
            String realm;
            String adDomainJoinPassword;
            String adDomainJoinUser;
            String crossRealmTrustPrincipalPassword;

            public Builder kdcAdminPassword(String kdcAdminPassword) {
                this.kdcAdminPassword = kdcAdminPassword;
                return this;
            }

            public Builder realm(String realm) {
                this.realm = realm;
                return this;
            }

            public Builder adDomainJoinPassword(String adDomainJoinPassword) {
                this.adDomainJoinPassword = adDomainJoinPassword;
                return this;
            }

            public Builder adDomainJoinUser(String adDomainJoinUser) {
                this.adDomainJoinUser = adDomainJoinUser;
                return this;
            }

            public Builder crossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
                this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
                return this;
            }

            public KerberosAttributesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.JobFlowInstancesConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JobFlowInstancesConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAdditionalMasterSecurityGroups() {
            return null;
        }

        @Nullable
        default public List<String> getAdditionalSlaveSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getCoreInstanceFleet() {
            return null;
        }

        @Nullable
        default public Object getCoreInstanceGroup() {
            return null;
        }

        @Nullable
        default public String getEc2KeyName() {
            return null;
        }

        @Nullable
        default public String getEc2SubnetId() {
            return null;
        }

        @Nullable
        default public List<String> getEc2SubnetIds() {
            return null;
        }

        @Nullable
        default public String getEmrManagedMasterSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getEmrManagedSlaveSecurityGroup() {
            return null;
        }

        @Nullable
        default public String getHadoopVersion() {
            return null;
        }

        @Nullable
        default public Object getKeepJobFlowAliveWhenNoSteps() {
            return null;
        }

        @Nullable
        default public Object getMasterInstanceFleet() {
            return null;
        }

        @Nullable
        default public Object getMasterInstanceGroup() {
            return null;
        }

        @Nullable
        default public Object getPlacement() {
            return null;
        }

        @Nullable
        default public String getServiceAccessSecurityGroup() {
            return null;
        }

        @Nullable
        default public Object getTaskInstanceFleets() {
            return null;
        }

        @Nullable
        default public Object getTaskInstanceGroups() {
            return null;
        }

        @Nullable
        default public Object getTerminationProtected() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JobFlowInstancesConfigProperty> {
            List<String> additionalMasterSecurityGroups;
            List<String> additionalSlaveSecurityGroups;
            Object coreInstanceFleet;
            Object coreInstanceGroup;
            String ec2KeyName;
            String ec2SubnetId;
            List<String> ec2SubnetIds;
            String emrManagedMasterSecurityGroup;
            String emrManagedSlaveSecurityGroup;
            String hadoopVersion;
            Object keepJobFlowAliveWhenNoSteps;
            Object masterInstanceFleet;
            Object masterInstanceGroup;
            Object placement;
            String serviceAccessSecurityGroup;
            Object taskInstanceFleets;
            Object taskInstanceGroups;
            Object terminationProtected;

            public Builder additionalMasterSecurityGroups(List<String> additionalMasterSecurityGroups) {
                this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
                return this;
            }

            public Builder additionalSlaveSecurityGroups(List<String> additionalSlaveSecurityGroups) {
                this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
                return this;
            }

            public Builder coreInstanceFleet(IResolvable coreInstanceFleet) {
                this.coreInstanceFleet = coreInstanceFleet;
                return this;
            }

            public Builder coreInstanceFleet(InstanceFleetConfigProperty coreInstanceFleet) {
                this.coreInstanceFleet = coreInstanceFleet;
                return this;
            }

            public Builder coreInstanceGroup(IResolvable coreInstanceGroup) {
                this.coreInstanceGroup = coreInstanceGroup;
                return this;
            }

            public Builder coreInstanceGroup(InstanceGroupConfigProperty coreInstanceGroup) {
                this.coreInstanceGroup = coreInstanceGroup;
                return this;
            }

            public Builder ec2KeyName(String ec2KeyName) {
                this.ec2KeyName = ec2KeyName;
                return this;
            }

            public Builder ec2SubnetId(String ec2SubnetId) {
                this.ec2SubnetId = ec2SubnetId;
                return this;
            }

            public Builder ec2SubnetIds(List<String> ec2SubnetIds) {
                this.ec2SubnetIds = ec2SubnetIds;
                return this;
            }

            public Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
                this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
                return this;
            }

            public Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
                this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
                return this;
            }

            public Builder hadoopVersion(String hadoopVersion) {
                this.hadoopVersion = hadoopVersion;
                return this;
            }

            public Builder keepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
                this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
                return this;
            }

            public Builder keepJobFlowAliveWhenNoSteps(IResolvable keepJobFlowAliveWhenNoSteps) {
                this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
                return this;
            }

            public Builder masterInstanceFleet(IResolvable masterInstanceFleet) {
                this.masterInstanceFleet = masterInstanceFleet;
                return this;
            }

            public Builder masterInstanceFleet(InstanceFleetConfigProperty masterInstanceFleet) {
                this.masterInstanceFleet = masterInstanceFleet;
                return this;
            }

            public Builder masterInstanceGroup(IResolvable masterInstanceGroup) {
                this.masterInstanceGroup = masterInstanceGroup;
                return this;
            }

            public Builder masterInstanceGroup(InstanceGroupConfigProperty masterInstanceGroup) {
                this.masterInstanceGroup = masterInstanceGroup;
                return this;
            }

            public Builder placement(IResolvable placement) {
                this.placement = placement;
                return this;
            }

            public Builder placement(PlacementTypeProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
                this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
                return this;
            }

            public Builder taskInstanceFleets(IResolvable taskInstanceFleets) {
                this.taskInstanceFleets = taskInstanceFleets;
                return this;
            }

            public Builder taskInstanceFleets(List<? extends Object> taskInstanceFleets) {
                this.taskInstanceFleets = taskInstanceFleets;
                return this;
            }

            public Builder taskInstanceGroups(IResolvable taskInstanceGroups) {
                this.taskInstanceGroups = taskInstanceGroups;
                return this;
            }

            public Builder taskInstanceGroups(List<? extends Object> taskInstanceGroups) {
                this.taskInstanceGroups = taskInstanceGroups;
                return this;
            }

            public Builder terminationProtected(Boolean terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            public Builder terminationProtected(IResolvable terminationProtected) {
                this.terminationProtected = terminationProtected;
                return this;
            }

            public JobFlowInstancesConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceTypeConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceType();

        @Nullable
        default public String getBidPrice() {
            return null;
        }

        @Nullable
        default public Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        @Nullable
        default public Object getConfigurations() {
            return null;
        }

        @Nullable
        default public String getCustomAmiId() {
            return null;
        }

        @Nullable
        default public Object getEbsConfiguration() {
            return null;
        }

        @Nullable
        default public Number getWeightedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceTypeConfigProperty> {
            String instanceType;
            String bidPrice;
            Number bidPriceAsPercentageOfOnDemandPrice;
            Object configurations;
            String customAmiId;
            Object ebsConfiguration;
            Number weightedCapacity;

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder bidPrice(String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            public Builder bidPriceAsPercentageOfOnDemandPrice(Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            public Builder configurations(IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder configurations(List<? extends Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder customAmiId(String customAmiId) {
                this.customAmiId = customAmiId;
                return this;
            }

            public Builder ebsConfiguration(IResolvable ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder weightedCapacity(Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            public InstanceTypeConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.InstanceGroupConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceGroupConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInstanceCount();

        @NotNull
        public String getInstanceType();

        @Nullable
        default public Object getAutoScalingPolicy() {
            return null;
        }

        @Nullable
        default public String getBidPrice() {
            return null;
        }

        @Nullable
        default public Object getConfigurations() {
            return null;
        }

        @Nullable
        default public String getCustomAmiId() {
            return null;
        }

        @Nullable
        default public Object getEbsConfiguration() {
            return null;
        }

        @Nullable
        default public String getMarket() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceGroupConfigProperty> {
            Number instanceCount;
            String instanceType;
            Object autoScalingPolicy;
            String bidPrice;
            Object configurations;
            String customAmiId;
            Object ebsConfiguration;
            String market;
            String name;

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder autoScalingPolicy(IResolvable autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            public Builder autoScalingPolicy(AutoScalingPolicyProperty autoScalingPolicy) {
                this.autoScalingPolicy = autoScalingPolicy;
                return this;
            }

            public Builder bidPrice(String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            public Builder configurations(IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder configurations(List<? extends Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder customAmiId(String customAmiId) {
                this.customAmiId = customAmiId;
                return this;
            }

            public Builder ebsConfiguration(IResolvable ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder ebsConfiguration(EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            public Builder market(String market) {
                this.market = market;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public InstanceGroupConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceFleetProvisioningSpecificationsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getOnDemandSpecification() {
            return null;
        }

        @Nullable
        default public Object getSpotSpecification() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceFleetProvisioningSpecificationsProperty> {
            Object onDemandSpecification;
            Object spotSpecification;

            public Builder onDemandSpecification(IResolvable onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            public Builder onDemandSpecification(OnDemandProvisioningSpecificationProperty onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            public Builder spotSpecification(IResolvable spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            public Builder spotSpecification(SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.InstanceFleetConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceFleetConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInstanceTypeConfigs() {
            return null;
        }

        @Nullable
        default public Object getLaunchSpecifications() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Number getTargetOnDemandCapacity() {
            return null;
        }

        @Nullable
        default public Number getTargetSpotCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceFleetConfigProperty> {
            Object instanceTypeConfigs;
            Object launchSpecifications;
            String name;
            Number targetOnDemandCapacity;
            Number targetSpotCapacity;

            public Builder instanceTypeConfigs(IResolvable instanceTypeConfigs) {
                this.instanceTypeConfigs = instanceTypeConfigs;
                return this;
            }

            public Builder instanceTypeConfigs(List<? extends Object> instanceTypeConfigs) {
                this.instanceTypeConfigs = instanceTypeConfigs;
                return this;
            }

            public Builder launchSpecifications(IResolvable launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder launchSpecifications(InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
                this.launchSpecifications = launchSpecifications;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder targetOnDemandCapacity(Number targetOnDemandCapacity) {
                this.targetOnDemandCapacity = targetOnDemandCapacity;
                return this;
            }

            public Builder targetSpotCapacity(Number targetSpotCapacity) {
                this.targetSpotCapacity = targetSpotCapacity;
                return this;
            }

            public InstanceFleetConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.HadoopJarStepConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HadoopJarStepConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getJar();

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        @Nullable
        default public String getMainClass() {
            return null;
        }

        @Nullable
        default public Object getStepProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HadoopJarStepConfigProperty> {
            String jar;
            List<String> args;
            String mainClass;
            Object stepProperties;

            public Builder jar(String jar) {
                this.jar = jar;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public Builder mainClass(String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            public Builder stepProperties(IResolvable stepProperties) {
                this.stepProperties = stepProperties;
                return this;
            }

            public Builder stepProperties(List<? extends Object> stepProperties) {
                this.stepProperties = stepProperties;
                return this;
            }

            public HadoopJarStepConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEbsBlockDeviceConfigs() {
            return null;
        }

        @Nullable
        default public Object getEbsOptimized() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            Object ebsBlockDeviceConfigs;
            Object ebsOptimized;

            public Builder ebsBlockDeviceConfigs(IResolvable ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsBlockDeviceConfigs(List<? extends Object> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public EbsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsBlockDeviceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getVolumeSpecification();

        @Nullable
        default public Number getVolumesPerInstance() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            Object volumeSpecification;
            Number volumesPerInstance;

            public Builder volumeSpecification(IResolvable volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumeSpecification(VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            public Builder volumesPerInstance(Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            public EbsBlockDeviceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.ComputeLimitsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComputeLimitsProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaximumCapacityUnits();

        @NotNull
        public Number getMinimumCapacityUnits();

        @NotNull
        public String getUnitType();

        @Nullable
        default public Number getMaximumCoreCapacityUnits() {
            return null;
        }

        @Nullable
        default public Number getMaximumOnDemandCapacityUnits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComputeLimitsProperty> {
            Number maximumCapacityUnits;
            Number minimumCapacityUnits;
            String unitType;
            Number maximumCoreCapacityUnits;
            Number maximumOnDemandCapacityUnits;

            public Builder maximumCapacityUnits(Number maximumCapacityUnits) {
                this.maximumCapacityUnits = maximumCapacityUnits;
                return this;
            }

            public Builder minimumCapacityUnits(Number minimumCapacityUnits) {
                this.minimumCapacityUnits = minimumCapacityUnits;
                return this;
            }

            public Builder unitType(String unitType) {
                this.unitType = unitType;
                return this;
            }

            public Builder maximumCoreCapacityUnits(Number maximumCoreCapacityUnits) {
                this.maximumCoreCapacityUnits = maximumCoreCapacityUnits;
                return this;
            }

            public Builder maximumOnDemandCapacityUnits(Number maximumOnDemandCapacityUnits) {
                this.maximumOnDemandCapacityUnits = maximumOnDemandCapacityUnits;
                return this;
            }

            public ComputeLimitsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchAlarmDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparisonOperator();

        @NotNull
        public String getMetricName();

        @NotNull
        public Number getPeriod();

        @NotNull
        public Number getThreshold();

        @Nullable
        default public Object getDimensions() {
            return null;
        }

        @Nullable
        default public Number getEvaluationPeriods() {
            return null;
        }

        @Nullable
        default public String getNamespace() {
            return null;
        }

        @Nullable
        default public String getStatistic() {
            return null;
        }

        @Nullable
        default public String getUnit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchAlarmDefinitionProperty> {
            String comparisonOperator;
            String metricName;
            Number period;
            Number threshold;
            Object dimensions;
            Number evaluationPeriods;
            String namespace;
            String statistic;
            String unit;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder period(Number period) {
                this.period = period;
                return this;
            }

            public Builder threshold(Number threshold) {
                this.threshold = threshold;
                return this;
            }

            public Builder dimensions(IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder dimensions(List<? extends Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder evaluationPeriods(Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public Builder statistic(String statistic) {
                this.statistic = statistic;
                return this;
            }

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.AutoTerminationPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoTerminationPolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getIdleTimeout() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoTerminationPolicyProperty> {
            Number idleTimeout;

            public Builder idleTimeout(Number idleTimeout) {
                this.idleTimeout = idleTimeout;
                return this;
            }

            public AutoTerminationPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_emr.CfnCluster.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConstraints();

        @NotNull
        public Object getRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            Object constraints;
            Object rules;

            public Builder constraints(IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder constraints(ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder rules(IResolvable rules) {
                this.rules = rules;
                return this;
            }

            public Builder rules(List<? extends Object> rules) {
                this.rules = rules;
                return this;
            }

            public AutoScalingPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

