/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.glue.CfnTrigger;
import software.amazon.awscdk.services.glue.CfnTriggerProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnTrigger")
public class CfnTrigger
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTrigger.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnTrigger(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTrigger(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTrigger(@NotNull Construct scope, @NotNull String id, @NotNull CfnTriggerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getActions() {
        return Kernel.get((Object)this, (String)"actions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setActions(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"actions", (Object)Objects.requireNonNull(value, "actions is required"));
    }

    public void setActions(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ActionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.glue.CfnTrigger.ActionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"actions", Objects.requireNonNull(value, "actions is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getEventBatchingCondition() {
        return Kernel.get((Object)this, (String)"eventBatchingCondition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEventBatchingCondition(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"eventBatchingCondition", (Object)value);
    }

    public void setEventBatchingCondition(@Nullable EventBatchingConditionProperty value) {
        Kernel.set((Object)this, (String)"eventBatchingCondition", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getPredicate() {
        return Kernel.get((Object)this, (String)"predicate", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPredicate(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"predicate", (Object)value);
    }

    public void setPredicate(@Nullable PredicateProperty value) {
        Kernel.set((Object)this, (String)"predicate", (Object)value);
    }

    @Nullable
    public String getSchedule() {
        return (String)Kernel.get((Object)this, (String)"schedule", (NativeType)NativeType.forClass(String.class));
    }

    public void setSchedule(@Nullable String value) {
        Kernel.set((Object)this, (String)"schedule", (Object)value);
    }

    @Nullable
    public Object getStartOnCreation() {
        return Kernel.get((Object)this, (String)"startOnCreation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStartOnCreation(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"startOnCreation", (Object)value);
    }

    public void setStartOnCreation(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"startOnCreation", (Object)value);
    }

    @Nullable
    public String getWorkflowName() {
        return (String)Kernel.get((Object)this, (String)"workflowName", (NativeType)NativeType.forClass(String.class));
    }

    public void setWorkflowName(@Nullable String value) {
        Kernel.set((Object)this, (String)"workflowName", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnTrigger.ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArguments() {
            return null;
        }

        @Nullable
        default public String getCrawlerName() {
            return null;
        }

        @Nullable
        default public String getJobName() {
            return null;
        }

        @Nullable
        default public Object getNotificationProperty() {
            return null;
        }

        @Nullable
        default public String getSecurityConfiguration() {
            return null;
        }

        @Nullable
        default public Number getTimeout() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionProperty> {
            Object arguments;
            String crawlerName;
            String jobName;
            Object notificationProperty;
            String securityConfiguration;
            Number timeout;

            public Builder arguments(Object arguments) {
                this.arguments = arguments;
                return this;
            }

            public Builder crawlerName(String crawlerName) {
                this.crawlerName = crawlerName;
                return this;
            }

            public Builder jobName(String jobName) {
                this.jobName = jobName;
                return this;
            }

            public Builder notificationProperty(IResolvable notificationProperty) {
                this.notificationProperty = notificationProperty;
                return this;
            }

            public Builder notificationProperty(NotificationPropertyProperty notificationProperty) {
                this.notificationProperty = notificationProperty;
                return this;
            }

            public Builder securityConfiguration(String securityConfiguration) {
                this.securityConfiguration = securityConfiguration;
                return this;
            }

            public Builder timeout(Number timeout) {
                this.timeout = timeout;
                return this;
            }

            public ActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTrigger> {
        private final Construct scope;
        private final String id;
        private final CfnTriggerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTriggerProps.Builder();
        }

        public Builder actions(IResolvable actions) {
            this.props.actions(actions);
            return this;
        }

        public Builder actions(List<? extends Object> actions) {
            this.props.actions(actions);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder eventBatchingCondition(IResolvable eventBatchingCondition) {
            this.props.eventBatchingCondition(eventBatchingCondition);
            return this;
        }

        public Builder eventBatchingCondition(EventBatchingConditionProperty eventBatchingCondition) {
            this.props.eventBatchingCondition(eventBatchingCondition);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder predicate(IResolvable predicate) {
            this.props.predicate(predicate);
            return this;
        }

        public Builder predicate(PredicateProperty predicate) {
            this.props.predicate(predicate);
            return this;
        }

        public Builder schedule(String schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder startOnCreation(Boolean startOnCreation) {
            this.props.startOnCreation(startOnCreation);
            return this;
        }

        public Builder startOnCreation(IResolvable startOnCreation) {
            this.props.startOnCreation(startOnCreation);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder workflowName(String workflowName) {
            this.props.workflowName(workflowName);
            return this;
        }

        public CfnTrigger build() {
            return new CfnTrigger(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnTrigger.PredicateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PredicateProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConditions() {
            return null;
        }

        @Nullable
        default public String getLogical() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PredicateProperty> {
            Object conditions;
            String logical;

            public Builder conditions(IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            public Builder conditions(List<? extends Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            public Builder logical(String logical) {
                this.logical = logical;
                return this;
            }

            public PredicateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnTrigger.NotificationPropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NotificationPropertyProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getNotifyDelayAfter() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NotificationPropertyProperty> {
            Number notifyDelayAfter;

            public Builder notifyDelayAfter(Number notifyDelayAfter) {
                this.notifyDelayAfter = notifyDelayAfter;
                return this;
            }

            public NotificationPropertyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnTrigger.EventBatchingConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventBatchingConditionProperty
    extends JsiiSerializable {
        @NotNull
        public Number getBatchSize();

        @Nullable
        default public Number getBatchWindow() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventBatchingConditionProperty> {
            Number batchSize;
            Number batchWindow;

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder batchWindow(Number batchWindow) {
                this.batchWindow = batchWindow;
                return this;
            }

            public EventBatchingConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnTrigger.ConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCrawlerName() {
            return null;
        }

        @Nullable
        default public String getCrawlState() {
            return null;
        }

        @Nullable
        default public String getJobName() {
            return null;
        }

        @Nullable
        default public String getLogicalOperator() {
            return null;
        }

        @Nullable
        default public String getState() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionProperty> {
            String crawlerName;
            String crawlState;
            String jobName;
            String logicalOperator;
            String state;

            public Builder crawlerName(String crawlerName) {
                this.crawlerName = crawlerName;
                return this;
            }

            public Builder crawlState(String crawlState) {
                this.crawlState = crawlState;
                return this;
            }

            public Builder jobName(String jobName) {
                this.jobName = jobName;
                return this;
            }

            public Builder logicalOperator(String logicalOperator) {
                this.logicalOperator = logicalOperator;
                return this;
            }

            public Builder state(String state) {
                this.state = state;
                return this;
            }

            public ConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

