/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.route53.CfnHostedZone;
import software.amazon.awscdk.services.route53.HostedZoneAttributes;
import software.amazon.awscdk.services.route53.HostedZoneProps;
import software.amazon.awscdk.services.route53.HostedZoneProviderProps;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_route53.HostedZone")
public class HostedZone
extends Resource
implements IHostedZone {
    protected HostedZone(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HostedZone(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HostedZone(@NotNull Construct scope, @NotNull String id, @NotNull HostedZoneProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IHostedZone fromHostedZoneAttributes(@NotNull Construct scope, @NotNull String id, @NotNull HostedZoneAttributes attrs) {
        return (IHostedZone)JsiiObject.jsiiStaticCall(HostedZone.class, (String)"fromHostedZoneAttributes", (NativeType)NativeType.forClass(IHostedZone.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IHostedZone fromHostedZoneId(@NotNull Construct scope, @NotNull String id, @NotNull String hostedZoneId) {
        return (IHostedZone)JsiiObject.jsiiStaticCall(HostedZone.class, (String)"fromHostedZoneId", (NativeType)NativeType.forClass(IHostedZone.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(hostedZoneId, "hostedZoneId is required")});
    }

    @NotNull
    public static IHostedZone fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull HostedZoneProviderProps query) {
        return (IHostedZone)JsiiObject.jsiiStaticCall(HostedZone.class, (String)"fromLookup", (NativeType)NativeType.forClass(IHostedZone.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(query, "query is required")});
    }

    public void addVpc(@NotNull IVpc vpc) {
        Kernel.call((Object)this, (String)"addVpc", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(vpc, "vpc is required")});
    }

    @Override
    @NotNull
    public String getHostedZoneArn() {
        return (String)Kernel.get((Object)this, (String)"hostedZoneArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getHostedZoneId() {
        return (String)Kernel.get((Object)this, (String)"hostedZoneId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected List<CfnHostedZone.VPCProperty> getVpcs() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"vpcs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnHostedZone.VPCProperty.class))));
    }

    @Override
    @NotNull
    public String getZoneName() {
        return (String)Kernel.get((Object)this, (String)"zoneName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public List<String> getHostedZoneNameServers() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"hostedZoneNameServers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HostedZone> {
        private final Construct scope;
        private final String id;
        private final HostedZoneProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new HostedZoneProps.Builder();
        }

        public Builder zoneName(String zoneName) {
            this.props.zoneName(zoneName);
            return this;
        }

        public Builder addTrailingDot(Boolean addTrailingDot) {
            this.props.addTrailingDot(addTrailingDot);
            return this;
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder queryLogsLogGroupArn(String queryLogsLogGroupArn) {
            this.props.queryLogsLogGroupArn(queryLogsLogGroupArn);
            return this;
        }

        public Builder vpcs(List<? extends IVpc> vpcs) {
            this.props.vpcs(vpcs);
            return this;
        }

        public HostedZone build() {
            return new HostedZone(this.scope, this.id, this.props.build());
        }
    }
}

