/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.services.appsync.AuthorizationConfig;
import software.amazon.awscdk.services.appsync.AuthorizationType;
import software.amazon.awscdk.services.appsync.Definition;
import software.amazon.awscdk.services.appsync.DomainOptions;
import software.amazon.awscdk.services.appsync.GraphqlApiAttributes;
import software.amazon.awscdk.services.appsync.GraphqlApiBase;
import software.amazon.awscdk.services.appsync.GraphqlApiProps;
import software.amazon.awscdk.services.appsync.IGraphqlApi;
import software.amazon.awscdk.services.appsync.ISchema;
import software.amazon.awscdk.services.appsync.IamResource;
import software.amazon.awscdk.services.appsync.LogConfig;
import software.amazon.awscdk.services.appsync.Visibility;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appsync.GraphqlApi")
public class GraphqlApi
extends GraphqlApiBase {
    protected GraphqlApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphqlApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public GraphqlApi(@NotNull Construct scope, @NotNull String id, @NotNull GraphqlApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IGraphqlApi fromGraphqlApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull GraphqlApiAttributes attrs) {
        return (IGraphqlApi)JsiiObject.jsiiStaticCall(GraphqlApi.class, (String)"fromGraphqlApiAttributes", (NativeType)NativeType.forClass(IGraphqlApi.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Boolean addSchemaDependency(@NotNull CfnResource construct) {
        return (Boolean)Kernel.call((Object)this, (String)"addSchemaDependency", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(construct, "construct is required")});
    }

    @NotNull
    public Grant grant(@NotNull IGrantable grantee, @NotNull IamResource resources, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(resources, "resources is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @NotNull
    public Grant grantMutation(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantMutation", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new)));
    }

    @NotNull
    public Grant grantQuery(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantQuery", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new)));
    }

    @NotNull
    public Grant grantSubscription(@NotNull IGrantable grantee, String ... fields) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantSubscription", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(fields)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public String getApiId() {
        return (String)Kernel.get((Object)this, (String)"apiId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAppSyncDomainName() {
        return (String)Kernel.get((Object)this, (String)"appSyncDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getArn() {
        return (String)Kernel.get((Object)this, (String)"arn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getGraphqlUrl() {
        return (String)Kernel.get((Object)this, (String)"graphqlUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ILogGroup getLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"logGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @NotNull
    public List<AuthorizationType> getModes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"modes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AuthorizationType.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ISchema getSchema() {
        return (ISchema)Kernel.get((Object)this, (String)"schema", (NativeType)NativeType.forClass(ISchema.class));
    }

    @Nullable
    public String getApiKey() {
        return (String)Kernel.get((Object)this, (String)"apiKey", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<GraphqlApi> {
        private final Construct scope;
        private final String id;
        private final GraphqlApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new GraphqlApiProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder authorizationConfig(AuthorizationConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        public Builder definition(Definition definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder domainName(DomainOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder logConfig(LogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        @Deprecated
        public Builder schema(ISchema schema) {
            this.props.schema(schema);
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.props.visibility(visibility);
            return this;
        }

        public Builder xrayEnabled(Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        public GraphqlApi build() {
            return new GraphqlApi(this.scope, this.id, this.props.build());
        }
    }
}

