/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.efs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.efs.CfnFileSystem;
import software.amazon.awscdk.services.efs.CfnFileSystemProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnFileSystem")
public class CfnFileSystem
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFileSystem.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFileSystem(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFileSystem(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFileSystem(@NotNull Construct scope, @NotNull String id, @Nullable CfnFileSystemProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnFileSystem(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrFileSystemId() {
        return (String)Kernel.get((Object)this, (String)"attrFileSystemId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public String getAvailabilityZoneName() {
        return (String)Kernel.get((Object)this, (String)"availabilityZoneName", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZoneName(@Nullable String value) {
        Kernel.set((Object)this, (String)"availabilityZoneName", (Object)value);
    }

    @Nullable
    public Object getBackupPolicy() {
        return Kernel.get((Object)this, (String)"backupPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBackupPolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"backupPolicy", (Object)value);
    }

    public void setBackupPolicy(@Nullable BackupPolicyProperty value) {
        Kernel.set((Object)this, (String)"backupPolicy", (Object)value);
    }

    @Nullable
    public Object getBypassPolicyLockoutSafetyCheck() {
        return Kernel.get((Object)this, (String)"bypassPolicyLockoutSafetyCheck", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBypassPolicyLockoutSafetyCheck(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"bypassPolicyLockoutSafetyCheck", (Object)value);
    }

    public void setBypassPolicyLockoutSafetyCheck(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"bypassPolicyLockoutSafetyCheck", (Object)value);
    }

    @Nullable
    public Object getEncrypted() {
        return Kernel.get((Object)this, (String)"encrypted", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncrypted(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"encrypted", (Object)value);
    }

    public void setEncrypted(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"encrypted", (Object)value);
    }

    @Nullable
    public Object getFileSystemPolicy() {
        return Kernel.get((Object)this, (String)"fileSystemPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFileSystemPolicy(@Nullable Object value) {
        Kernel.set((Object)this, (String)"fileSystemPolicy", (Object)value);
    }

    @Nullable
    public List<ElasticFileSystemTagProperty> getFileSystemTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"fileSystemTagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ElasticFileSystemTagProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setFileSystemTagsRaw(@Nullable List<ElasticFileSystemTagProperty> value) {
        Kernel.set((Object)this, (String)"fileSystemTagsRaw", value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public Object getLifecyclePolicies() {
        return Kernel.get((Object)this, (String)"lifecyclePolicies", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLifecyclePolicies(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lifecyclePolicies", (Object)value);
    }

    public void setLifecyclePolicies(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof LifecyclePolicyProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.efs.CfnFileSystem.LifecyclePolicyProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"lifecyclePolicies", value);
    }

    @Nullable
    public String getPerformanceMode() {
        return (String)Kernel.get((Object)this, (String)"performanceMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setPerformanceMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"performanceMode", (Object)value);
    }

    @Nullable
    public Number getProvisionedThroughputInMibps() {
        return (Number)Kernel.get((Object)this, (String)"provisionedThroughputInMibps", (NativeType)NativeType.forClass(Number.class));
    }

    public void setProvisionedThroughputInMibps(@Nullable Number value) {
        Kernel.set((Object)this, (String)"provisionedThroughputInMibps", (Object)value);
    }

    @Nullable
    public String getThroughputMode() {
        return (String)Kernel.get((Object)this, (String)"throughputMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setThroughputMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"throughputMode", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnFileSystem.ElasticFileSystemTagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticFileSystemTagProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticFileSystemTagProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ElasticFileSystemTagProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnFileSystem.LifecyclePolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LifecyclePolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getTransitionToIa() {
            return null;
        }

        @Nullable
        default public String getTransitionToPrimaryStorageClass() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LifecyclePolicyProperty> {
            String transitionToIa;
            String transitionToPrimaryStorageClass;

            public Builder transitionToIa(String transitionToIa) {
                this.transitionToIa = transitionToIa;
                return this;
            }

            public Builder transitionToPrimaryStorageClass(String transitionToPrimaryStorageClass) {
                this.transitionToPrimaryStorageClass = transitionToPrimaryStorageClass;
                return this;
            }

            public LifecyclePolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFileSystem> {
        private final Construct scope;
        private final String id;
        private CfnFileSystemProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder availabilityZoneName(String availabilityZoneName) {
            this.props().availabilityZoneName(availabilityZoneName);
            return this;
        }

        public Builder backupPolicy(IResolvable backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }

        public Builder backupPolicy(BackupPolicyProperty backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }

        public Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }

        public Builder bypassPolicyLockoutSafetyCheck(IResolvable bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }

        public Builder encrypted(Boolean encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }

        public Builder encrypted(IResolvable encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }

        public Builder fileSystemPolicy(Object fileSystemPolicy) {
            this.props().fileSystemPolicy(fileSystemPolicy);
            return this;
        }

        public Builder fileSystemTags(List<? extends ElasticFileSystemTagProperty> fileSystemTags) {
            this.props().fileSystemTags(fileSystemTags);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder lifecyclePolicies(IResolvable lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }

        public Builder lifecyclePolicies(List<? extends Object> lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }

        public Builder performanceMode(String performanceMode) {
            this.props().performanceMode(performanceMode);
            return this;
        }

        public Builder provisionedThroughputInMibps(Number provisionedThroughputInMibps) {
            this.props().provisionedThroughputInMibps(provisionedThroughputInMibps);
            return this;
        }

        public Builder throughputMode(String throughputMode) {
            this.props().throughputMode(throughputMode);
            return this;
        }

        public CfnFileSystem build() {
            return new CfnFileSystem(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnFileSystemProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnFileSystemProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_efs.CfnFileSystem.BackupPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BackupPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BackupPolicyProperty> {
            String status;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public BackupPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

