/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.cxapi.CloudFormationStackArtifact;
import software.amazon.awscdk.pipelines.StackAsset;
import software.amazon.awscdk.pipelines.Step;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.pipelines.StackDeployment")
public class StackDeployment
extends JsiiObject {
    protected StackDeployment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StackDeployment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    @NotNull
    public static StackDeployment fromArtifact(@NotNull CloudFormationStackArtifact stackArtifact) {
        return (StackDeployment)((Object)JsiiObject.jsiiStaticCall(StackDeployment.class, (String)"fromArtifact", (NativeType)NativeType.forClass(StackDeployment.class), (Object[])new Object[]{Objects.requireNonNull(stackArtifact, "stackArtifact is required")}));
    }

    public void addStackDependency(@NotNull StackDeployment stackDeployment) {
        Kernel.call((Object)((Object)this), (String)"addStackDependency", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(stackDeployment, "stackDeployment is required")});
    }

    public void addStackSteps(@NotNull List<Step> pre, @NotNull List<Step> changeSet, @NotNull List<Step> post) {
        Kernel.call((Object)((Object)this), (String)"addStackSteps", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(pre, "pre is required"), Objects.requireNonNull(changeSet, "changeSet is required"), Objects.requireNonNull(post, "post is required")});
    }

    @NotNull
    public String getAbsoluteTemplatePath() {
        return (String)Kernel.get((Object)((Object)this), (String)"absoluteTemplatePath", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<StackAsset> getAssets() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"assets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(StackAsset.class))));
    }

    @NotNull
    public List<Step> getChangeSet() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"changeSet", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Step.class))));
    }

    @NotNull
    public String getConstructPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"constructPath", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<Step> getPost() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"post", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Step.class))));
    }

    @NotNull
    public List<Step> getPre() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"pre", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Step.class))));
    }

    @NotNull
    public String getStackArtifactId() {
        return (String)Kernel.get((Object)((Object)this), (String)"stackArtifactId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<StackDeployment> getStackDependencies() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"stackDependencies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(StackDeployment.class))));
    }

    @NotNull
    public String getStackName() {
        return (String)Kernel.get((Object)((Object)this), (String)"stackName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Map<String, String> getTags() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @Nullable
    public String getAccount() {
        return (String)Kernel.get((Object)((Object)this), (String)"account", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getAssumeRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"assumeRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getExecutionRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getRegion() {
        return (String)Kernel.get((Object)((Object)this), (String)"region", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public StackAsset getTemplateAsset() {
        return (StackAsset)Kernel.get((Object)((Object)this), (String)"templateAsset", (NativeType)NativeType.forClass(StackAsset.class));
    }

    @Nullable
    public String getTemplateUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"templateUrl", (NativeType)NativeType.forClass(String.class));
    }
}

