/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.applicationautoscaling;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.applicationautoscaling.BasicStepScalingPolicyProps;
import software.amazon.awscdk.services.applicationautoscaling.BasicTargetTrackingScalingPolicyProps;
import software.amazon.awscdk.services.applicationautoscaling.IScalableTarget;
import software.amazon.awscdk.services.applicationautoscaling.ScalableTargetProps;
import software.amazon.awscdk.services.applicationautoscaling.ScalingSchedule;
import software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace;
import software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy;
import software.amazon.awscdk.services.applicationautoscaling.TargetTrackingScalingPolicy;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_applicationautoscaling.ScalableTarget")
public class ScalableTarget
extends Resource
implements IScalableTarget {
    protected ScalableTarget(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScalableTarget(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ScalableTarget(@NotNull Construct scope, @NotNull String id, @NotNull ScalableTargetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IScalableTarget fromScalableTargetId(@NotNull Construct scope, @NotNull String id, @NotNull String scalableTargetId) {
        return (IScalableTarget)JsiiObject.jsiiStaticCall(ScalableTarget.class, (String)"fromScalableTargetId", (NativeType)NativeType.forClass(IScalableTarget.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(scalableTargetId, "scalableTargetId is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        Kernel.call((Object)this, (String)"addToRolePolicy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @NotNull
    public StepScalingPolicy scaleOnMetric(@NotNull String id, @NotNull BasicStepScalingPolicyProps props) {
        return (StepScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleOnMetric", (NativeType)NativeType.forClass(StepScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    public void scaleOnSchedule(@NotNull String id, @NotNull ScalingSchedule action) {
        Kernel.call((Object)this, (String)"scaleOnSchedule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(action, "action is required")});
    }

    @NotNull
    public TargetTrackingScalingPolicy scaleToTrackMetric(@NotNull String id, @NotNull BasicTargetTrackingScalingPolicyProps props) {
        return (TargetTrackingScalingPolicy)((Object)Kernel.call((Object)this, (String)"scaleToTrackMetric", (NativeType)NativeType.forClass(TargetTrackingScalingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public String getScalableTargetId() {
        return (String)Kernel.get((Object)this, (String)"scalableTargetId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ScalableTarget> {
        private final Construct scope;
        private final String id;
        private final ScalableTargetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ScalableTargetProps.Builder();
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        public Builder scalableDimension(String scalableDimension) {
            this.props.scalableDimension(scalableDimension);
            return this;
        }

        public Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.props.serviceNamespace(serviceNamespace);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public ScalableTarget build() {
            return new ScalableTarget(this.scope, this.id, this.props.build());
        }
    }
}

