/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ecs.BaseServiceOptions;
import software.amazon.awscdk.services.ecs.BaseServiceProps;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentAlarmConfig;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LaunchType;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.ServiceConnectProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecs.BaseServiceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface BaseServiceProps
extends JsiiSerializable,
BaseServiceOptions {
    @NotNull
    public LaunchType getLaunchType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BaseServiceProps> {
        LaunchType launchType;
        ICluster cluster;
        List<CapacityProviderStrategy> capacityProviderStrategies;
        DeploymentCircuitBreaker circuitBreaker;
        CloudMapOptions cloudMapOptions;
        DeploymentAlarmConfig deploymentAlarms;
        DeploymentController deploymentController;
        Number desiredCount;
        Boolean enableEcsManagedTags;
        Boolean enableExecuteCommand;
        Duration healthCheckGracePeriod;
        Number maxHealthyPercent;
        Number minHealthyPercent;
        PropagatedTagSource propagateTags;
        ServiceConnectProps serviceConnectConfiguration;
        String serviceName;

        public Builder launchType(LaunchType launchType) {
            this.launchType = launchType;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.capacityProviderStrategies = capacityProviderStrategies;
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        public Builder deploymentAlarms(DeploymentAlarmConfig deploymentAlarms) {
            this.deploymentAlarms = deploymentAlarms;
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder serviceConnectConfiguration(ServiceConnectProps serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public BaseServiceProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

