/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.stepfunctions.CfnStateMachine;
import software.amazon.awscdk.services.stepfunctions.CfnStateMachineProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine")
public class CfnStateMachine
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnStateMachine.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnStateMachine(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStateMachine(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnStateMachine(@NotNull Construct scope, @NotNull String id, @NotNull CfnStateMachineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStateMachineRevisionId() {
        return (String)Kernel.get((Object)this, (String)"attrStateMachineRevisionId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public Object getDefinition() {
        return Kernel.get((Object)this, (String)"definition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinition(@Nullable Object value) {
        Kernel.set((Object)this, (String)"definition", (Object)value);
    }

    @Nullable
    public Object getDefinitionS3Location() {
        return Kernel.get((Object)this, (String)"definitionS3Location", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionS3Location(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"definitionS3Location", (Object)value);
    }

    public void setDefinitionS3Location(@Nullable S3LocationProperty value) {
        Kernel.set((Object)this, (String)"definitionS3Location", (Object)value);
    }

    @Nullable
    public String getDefinitionString() {
        return (String)Kernel.get((Object)this, (String)"definitionString", (NativeType)NativeType.forClass(String.class));
    }

    public void setDefinitionString(@Nullable String value) {
        Kernel.set((Object)this, (String)"definitionString", (Object)value);
    }

    @Nullable
    public Object getDefinitionSubstitutions() {
        return Kernel.get((Object)this, (String)"definitionSubstitutions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionSubstitutions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"definitionSubstitutions", (Object)value);
    }

    public void setDefinitionSubstitutions(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"definitionSubstitutions", value);
    }

    @Nullable
    public Object getLoggingConfiguration() {
        return Kernel.get((Object)this, (String)"loggingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLoggingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"loggingConfiguration", (Object)value);
    }

    public void setLoggingConfiguration(@Nullable LoggingConfigurationProperty value) {
        Kernel.set((Object)this, (String)"loggingConfiguration", (Object)value);
    }

    @Nullable
    public String getStateMachineName() {
        return (String)Kernel.get((Object)this, (String)"stateMachineName", (NativeType)NativeType.forClass(String.class));
    }

    public void setStateMachineName(@Nullable String value) {
        Kernel.set((Object)this, (String)"stateMachineName", (Object)value);
    }

    @Nullable
    public String getStateMachineType() {
        return (String)Kernel.get((Object)this, (String)"stateMachineType", (NativeType)NativeType.forClass(String.class));
    }

    public void setStateMachineType(@Nullable String value) {
        Kernel.set((Object)this, (String)"stateMachineType", (Object)value);
    }

    @Nullable
    public List<TagsEntryProperty> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(TagsEntryProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<TagsEntryProperty> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Object getTracingConfiguration() {
        return Kernel.get((Object)this, (String)"tracingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTracingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"tracingConfiguration", (Object)value);
    }

    public void setTracingConfiguration(@Nullable TracingConfigurationProperty value) {
        Kernel.set((Object)this, (String)"tracingConfiguration", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine.TagsEntryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagsEntryProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagsEntryProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public TagsEntryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnStateMachine> {
        private final Construct scope;
        private final String id;
        private final CfnStateMachineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnStateMachineProps.Builder();
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder definition(Object definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder definitionS3Location(IResolvable definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        public Builder definitionS3Location(S3LocationProperty definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        public Builder definitionString(String definitionString) {
            this.props.definitionString(definitionString);
            return this;
        }

        public Builder definitionSubstitutions(IResolvable definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder definitionSubstitutions(Map<String, String> definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder loggingConfiguration(IResolvable loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder loggingConfiguration(LoggingConfigurationProperty loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        public Builder stateMachineName(String stateMachineName) {
            this.props.stateMachineName(stateMachineName);
            return this;
        }

        public Builder stateMachineType(String stateMachineType) {
            this.props.stateMachineType(stateMachineType);
            return this;
        }

        public Builder tags(List<? extends TagsEntryProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder tracingConfiguration(IResolvable tracingConfiguration) {
            this.props.tracingConfiguration(tracingConfiguration);
            return this;
        }

        public Builder tracingConfiguration(TracingConfigurationProperty tracingConfiguration) {
            this.props.tracingConfiguration(tracingConfiguration);
            return this;
        }

        public CfnStateMachine build() {
            return new CfnStateMachine(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine.TracingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TracingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TracingConfigurationProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public TracingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucket;
            String key;
            String version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoggingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDestinations() {
            return null;
        }

        @Nullable
        default public Object getIncludeExecutionData() {
            return null;
        }

        @Nullable
        default public String getLevel() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            Object destinations;
            Object includeExecutionData;
            String level;

            public Builder destinations(IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            public Builder destinations(List<? extends Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            public Builder includeExecutionData(Boolean includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            public Builder includeExecutionData(IResolvable includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public LoggingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine.LogDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogDestinationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudWatchLogsLogGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogDestinationProperty> {
            Object cloudWatchLogsLogGroup;

            public Builder cloudWatchLogsLogGroup(IResolvable cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            public Builder cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            public LogDestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine.DefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DefinitionProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DefinitionProperty> {
            public DefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions.CfnStateMachine.CloudWatchLogsLogGroupProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsLogGroupProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLogGroupArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsLogGroupProperty> {
            String logGroupArn;

            public Builder logGroupArn(String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            public CloudWatchLogsLogGroupProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

