/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.backup;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.backup.;
import software.amazon.awscdk.services.backup.TagCondition;
import software.amazon.awscdk.services.backup.TagOperation;
import software.amazon.awscdk.services.dynamodb.ITable;
import software.amazon.awscdk.services.ec2.IInstance;
import software.amazon.awscdk.services.efs.IFileSystem;
import software.amazon.awscdk.services.rds.IDatabaseInstance;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-backup.BackupResource")
public class BackupResource
extends JsiiObject {
    protected BackupResource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BackupResource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public BackupResource(@Nullable String resource, @Nullable TagCondition tagCondition, @Nullable software.constructs.Construct construct) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{resource, tagCondition, construct});
    }

    public BackupResource(@Nullable String resource, @Nullable TagCondition tagCondition) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{resource, tagCondition});
    }

    public BackupResource(@Nullable String resource) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{resource});
    }

    public BackupResource() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static BackupResource fromArn(@NotNull String arn) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromArn", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(arn, "arn is required")}));
    }

    @NotNull
    public static BackupResource fromConstruct(@NotNull software.constructs.Construct construct) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromConstruct", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(construct, "construct is required")}));
    }

    @NotNull
    public static BackupResource fromDynamoDbTable(@NotNull ITable table) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromDynamoDbTable", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(table, "table is required")}));
    }

    @NotNull
    public static BackupResource fromEc2Instance(@NotNull IInstance instance) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromEc2Instance", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(instance, "instance is required")}));
    }

    @NotNull
    public static BackupResource fromEfsFileSystem(@NotNull IFileSystem fileSystem) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromEfsFileSystem", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(fileSystem, "fileSystem is required")}));
    }

    @NotNull
    public static BackupResource fromRdsDatabaseInstance(@NotNull IDatabaseInstance instance) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromRdsDatabaseInstance", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(instance, "instance is required")}));
    }

    @NotNull
    public static BackupResource fromTag(@NotNull String key, @NotNull String value, @Nullable TagOperation operation) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromTag", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required"), operation}));
    }

    @NotNull
    public static BackupResource fromTag(@NotNull String key, @NotNull String value) {
        return (BackupResource)((Object)JsiiObject.jsiiStaticCall(BackupResource.class, (String)"fromTag", (NativeType)NativeType.forClass(BackupResource.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")}));
    }

    @Nullable
    public Construct getConstruct() {
        return (Construct)Kernel.get((Object)((Object)this), (String)"construct", (NativeType)NativeType.forClass(Construct.class));
    }

    @Nullable
    public String getResource() {
        return (String)Kernel.get((Object)((Object)this), (String)"resource", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public TagCondition getTagCondition() {
        return (TagCondition)Kernel.get((Object)((Object)this), (String)"tagCondition", (NativeType)NativeType.forClass(TagCondition.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<BackupResource> {
        private final String resource;
        private final software.constructs.Construct construct;
        private TagCondition.Builder tagCondition;

        public static Builder create(String resource, software.constructs.Construct construct) {
            return new Builder(resource, construct);
        }

        public static Builder create(String resource) {
            return new Builder(resource, null);
        }

        public static Builder create() {
            return new Builder(null, null);
        }

        private Builder(String resource, software.constructs.Construct construct) {
            this.resource = resource;
            this.construct = construct;
        }

        public Builder key(String key) {
            this.tagCondition().key(key);
            return this;
        }

        public Builder value(String value) {
            this.tagCondition().value(value);
            return this;
        }

        public Builder operation(TagOperation operation) {
            this.tagCondition().operation(operation);
            return this;
        }

        public BackupResource build() {
            return new BackupResource(this.resource, this.tagCondition != null ? this.tagCondition.build() : null, this.construct);
        }

        private TagCondition.Builder tagCondition() {
            if (this.tagCondition == null) {
                this.tagCondition = new TagCondition.Builder();
            }
            return this.tagCondition;
        }
    }
}

