/**
 * <h1>Asset with AWS CLI v1</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module bundles the AWS CLI v1 as a local asset. It exposes
 * constants <code>ASSET_FILE</code> and <code>LAYER_SOURCE_DIR</code> that can be consumed
 * via the CDK <code>Asset</code> construct.
 * <p>
 * Any Lambda Function that uses uses this asset must use a Python 3.x
 * runtime.
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // AwsCliLayer bundles the AWS CLI in a lambda layer
 * import aws.cdk.asset.awscli.v1.ASSET_FILE;
 * import aws.cdk.asset.awscli.v1.LAYER_SOURCE_DIR;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.s3.assets.*;
 * import software.amazon.awscdk.FileSystem;
 * 
 * Function fn;
 * 
 * Asset asset = Asset.Builder.create(this, "layer-asset")
 *         .path(ASSET_FILE)
 *         .assetHash(FileSystem.fingerprint(LAYER_SOURCE_DIR))
 *         .build();
 * fn.addLayers(LayerVersion.Builder.create(this, "AwsCliLayer")
 *         .code(Code.fromBucket(asset.getBucket(), asset.getS3ObjectKey()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * The CLI will be installed under <code>/opt/awscli/aws</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cdk.asset.awscli.v1;
