/**
 * <h1>Asset with KubeCtl v1.20</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module bundles the
 * <a href="https://kubernetes.io/docs/reference/kubectl/kubectl/"><code>kubectl</code></a> and the
 * <a href="https://helm.sh/"><code>helm</code></a> command line as a local asset. It exposes constants
 * <code>ASSET_FILE</code> and <code>LAYER_SOURCE_DIR</code> that can be consumed via the cdk <code>Asset</code>
 * construct.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>Helm Version: 3.8.1</li>
 * <li>Kubectl Version: 1.20.0</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // ASSET_FILE bundles the 'kubectl' and 'helm' command lines
 * import { ASSET_FILE, LAYER_SOURCE_DIR } from '&#64;aws-cdk/asset-kubectl-v20';
 * import * as lambda from 'aws-cdk-lib/aws-lambda';
 * import * as s3_assets from 'aws-cdk-lib/aws-s3-assets';
 * import { FileSystem } from 'aws-cdk-lib';
 * 
 * declare const fn: lambda.Function;
 * const asset = new s3_assets.Asset(this, 'layer-asset', {
 *   path: ASSET_FILE,
 *   assetHash: FileSystem.fingerprint(LAYER_SOURCE_DIR),
 * });
 * 
 * fn.addLayers(new lambda.LayerVersion(this, 'KubectlLayer', {
 *   code: lambda.Code.fromBucket(asset.bucket, asset.s3ObjectKey),
 *   description: '/opt/kubectl/kubectl and /opt/helm/helm',
 * }));
 * </pre></blockquote>
 * <p>
 * <code>kubectl</code> will be installed under <code>/opt/kubectl/kubectl</code>, and <code>helm</code> will be installed under <code>/opt/helm/helm</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cdk.asset.kubectl.v20;
