package software.amazon.awscdk.cloudassembly.schema;

/**
 * Options for specific cdk commands that are run as part of the integration test workflow.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * Stack stackUnderTest = new Stack(app, "StackUnderTest");
 * Stack stack = new Stack(app, "stack");
 * IntegTest testCase = IntegTest.Builder.create(app, "CustomizedDeploymentWorkflow")
 *         .testCases(List.of(stackUnderTest))
 *         .diffAssets(true)
 *         .stackUpdateWorkflow(true)
 *         .cdkCommandOptions(CdkCommands.builder()
 *                 .deploy(DeployCommand.builder()
 *                         .args(DeployOptions.builder()
 *                                 .requireApproval(RequireApproval.NEVER)
 *                                 .json(true)
 *                                 .build())
 *                         .build())
 *                 .destroy(DestroyCommand.builder()
 *                         .args(DestroyOptions.builder()
 *                                 .force(true)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:29:54.667Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.CdkCommands")
@software.amazon.jsii.Jsii.Proxy(CdkCommands.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CdkCommands extends software.amazon.jsii.JsiiSerializable {

    /**
     * Options to for the cdk deploy command.
     * <p>
     * Default: - default deploy options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.DeployCommand getDeploy() {
        return null;
    }

    /**
     * Options to for the cdk destroy command.
     * <p>
     * Default: - default destroy options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.DestroyCommand getDestroy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CdkCommands}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CdkCommands}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CdkCommands> {
        software.amazon.awscdk.cloudassembly.schema.DeployCommand deploy;
        software.amazon.awscdk.cloudassembly.schema.DestroyCommand destroy;

        /**
         * Sets the value of {@link CdkCommands#getDeploy}
         * @param deploy Options to for the cdk deploy command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(software.amazon.awscdk.cloudassembly.schema.DeployCommand deploy) {
            this.deploy = deploy;
            return this;
        }

        /**
         * Sets the value of {@link CdkCommands#getDestroy}
         * @param destroy Options to for the cdk destroy command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destroy(software.amazon.awscdk.cloudassembly.schema.DestroyCommand destroy) {
            this.destroy = destroy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CdkCommands}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CdkCommands build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CdkCommands}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdkCommands {
        private final software.amazon.awscdk.cloudassembly.schema.DeployCommand deploy;
        private final software.amazon.awscdk.cloudassembly.schema.DestroyCommand destroy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploy = software.amazon.jsii.Kernel.get(this, "deploy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.DeployCommand.class));
            this.destroy = software.amazon.jsii.Kernel.get(this, "destroy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.DestroyCommand.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploy = builder.deploy;
            this.destroy = builder.destroy;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.DeployCommand getDeploy() {
            return this.deploy;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.DestroyCommand getDestroy() {
            return this.destroy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeploy() != null) {
                data.set("deploy", om.valueToTree(this.getDeploy()));
            }
            if (this.getDestroy() != null) {
                data.set("destroy", om.valueToTree(this.getDestroy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.CdkCommands"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CdkCommands.Jsii$Proxy that = (CdkCommands.Jsii$Proxy) o;

            if (this.deploy != null ? !this.deploy.equals(that.deploy) : that.deploy != null) return false;
            return this.destroy != null ? this.destroy.equals(that.destroy) : that.destroy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploy != null ? this.deploy.hashCode() : 0;
            result = 31 * result + (this.destroy != null ? this.destroy.hashCode() : 0);
            return result;
        }
    }
}
