package software.amazon.awscdk.cloudassembly.schema;

/**
 * Options for context lookup roles.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-06T00:26:15.129Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.ContextLookupRoleOptions")
@software.amazon.jsii.Jsii.Proxy(ContextLookupRoleOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContextLookupRoleOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Query account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccount();

    /**
     * Query region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegion();

    /**
     * Additional options to pass to STS when assuming the lookup role.
     * <p>
     * <ul>
     * <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
     * <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
     * </ul>
     * <p>
     * Default: - No additional options.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
        return null;
    }

    /**
     * The ARN of the role that should be used to look up the missing values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleArn() {
        return null;
    }

    /**
     * The ExternalId that needs to be supplied while assuming this role.
     * <p>
     * Default: - No ExternalId will be supplied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleExternalId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContextLookupRoleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContextLookupRoleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContextLookupRoleOptions> {
        java.lang.String account;
        java.lang.String region;
        java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        java.lang.String lookupRoleArn;
        java.lang.String lookupRoleExternalId;

        /**
         * Sets the value of {@link ContextLookupRoleOptions#getAccount}
         * @param account Query account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link ContextLookupRoleOptions#getRegion}
         * @param region Query region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link ContextLookupRoleOptions#getAssumeRoleAdditionalOptions}
         * @param assumeRoleAdditionalOptions Additional options to pass to STS when assuming the lookup role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assumeRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> assumeRoleAdditionalOptions) {
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)assumeRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link ContextLookupRoleOptions#getLookupRoleArn}
         * @param lookupRoleArn The ARN of the role that should be used to look up the missing values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link ContextLookupRoleOptions#getLookupRoleExternalId}
         * @param lookupRoleExternalId The ExternalId that needs to be supplied while assuming this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleExternalId(java.lang.String lookupRoleExternalId) {
            this.lookupRoleExternalId = lookupRoleExternalId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContextLookupRoleOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContextLookupRoleOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContextLookupRoleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContextLookupRoleOptions {
        private final java.lang.String account;
        private final java.lang.String region;
        private final java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        private final java.lang.String lookupRoleArn;
        private final java.lang.String lookupRoleExternalId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "assumeRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleExternalId = software.amazon.jsii.Kernel.get(this, "lookupRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = java.util.Objects.requireNonNull(builder.account, "account is required");
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.assumeRoleAdditionalOptions;
            this.lookupRoleArn = builder.lookupRoleArn;
            this.lookupRoleExternalId = builder.lookupRoleExternalId;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
            return this.assumeRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final java.lang.String getLookupRoleExternalId() {
            return this.lookupRoleExternalId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("account", om.valueToTree(this.getAccount()));
            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getAssumeRoleAdditionalOptions() != null) {
                data.set("assumeRoleAdditionalOptions", om.valueToTree(this.getAssumeRoleAdditionalOptions()));
            }
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            if (this.getLookupRoleExternalId() != null) {
                data.set("lookupRoleExternalId", om.valueToTree(this.getLookupRoleExternalId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.ContextLookupRoleOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContextLookupRoleOptions.Jsii$Proxy that = (ContextLookupRoleOptions.Jsii$Proxy) o;

            if (!account.equals(that.account)) return false;
            if (!region.equals(that.region)) return false;
            if (this.assumeRoleAdditionalOptions != null ? !this.assumeRoleAdditionalOptions.equals(that.assumeRoleAdditionalOptions) : that.assumeRoleAdditionalOptions != null) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            return this.lookupRoleExternalId != null ? this.lookupRoleExternalId.equals(that.lookupRoleExternalId) : that.lookupRoleExternalId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.account.hashCode();
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.assumeRoleAdditionalOptions != null ? this.assumeRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.lookupRoleExternalId != null ? this.lookupRoleExternalId.hashCode() : 0);
            return result;
        }
    }
}
