package software.amazon.awscdk.cloudassembly.schema;

/**
 * Interoperable representation of a deployable cloud application.
 * <p>
 * The external and interoperable contract for a Cloud Assembly is
 * a directory containing a valid Cloud Assembly.
 * <p>
 * Implementations should use the directory to load the Cloud Assembly from disk.
 * It is recommended that implementations validate loaded manifest files using
 * the provided functionality from this package.
 * Within an implementation, it may be prudent to keep (parts of) the Cloud Assembly
 * in memory during execution and use an implementation-specific contract.
 * However when an implementation is providing an external contract,
 * this interface should be used.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-02T00:25:36.462Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.ICloudAssembly")
@software.amazon.jsii.Jsii.Proxy(ICloudAssembly.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ICloudAssembly extends software.amazon.jsii.JsiiSerializable {

    /**
     * The directory of the cloud assembly.
     * <p>
     * This directory will be used to read the Cloud Assembly from.
     * Its contents (in particular <code>manifest.json</code>) must comply with the schema defined in this package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectory();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.cloudassembly.schema.ICloudAssembly.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The directory of the cloud assembly.
         * <p>
         * This directory will be used to read the Cloud Assembly from.
         * Its contents (in particular <code>manifest.json</code>) must comply with the schema defined in this package.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDirectory() {
            return software.amazon.jsii.Kernel.get(this, "directory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }

    /**
     * Internal default implementation for {@link ICloudAssembly}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ICloudAssembly {

        /**
         * The directory of the cloud assembly.
         * <p>
         * This directory will be used to read the Cloud Assembly from.
         * Its contents (in particular <code>manifest.json</code>) must comply with the schema defined in this package.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getDirectory() {
            return software.amazon.jsii.Kernel.get(this, "directory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
