package software.amazon.awscdk.cloudassembly.schema;

/**
 * A manifest which describes the cloud assembly.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.108.0 (build f680d68)", date = "2025-03-19T07:35:56.803Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.AssemblyManifest")
@software.amazon.jsii.Jsii.Proxy(AssemblyManifest.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssemblyManifest extends software.amazon.jsii.JsiiSerializable {

    /**
     * Protocol version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersion();

    /**
     * The set of artifacts in this assembly.
     * <p>
     * Default: - no artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.ArtifactManifest> getArtifacts() {
        return null;
    }

    /**
     * Required CLI version, if available.
     * <p>
     * If the manifest producer knows, it can put the minimum version of the CLI
     * here that supports reading this assembly.
     * <p>
     * If set, it can be used to show a more informative error message to users.
     * <p>
     * Default: - Minimum CLI version unknown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMinimumCliVersion() {
        return null;
    }

    /**
     * Missing context information.
     * <p>
     * If this field has values, it means that the
     * cloud assembly is not complete and should not be deployed.
     * <p>
     * Default: - no missing context.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.cloudassembly.schema.MissingContext> getMissing() {
        return null;
    }

    /**
     * Runtime information.
     * <p>
     * Default: - no info.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.RuntimeInfo getRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssemblyManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssemblyManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssemblyManifest> {
        java.lang.String version;
        java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.ArtifactManifest> artifacts;
        java.lang.String minimumCliVersion;
        java.util.List<software.amazon.awscdk.cloudassembly.schema.MissingContext> missing;
        software.amazon.awscdk.cloudassembly.schema.RuntimeInfo runtime;

        /**
         * Sets the value of {@link AssemblyManifest#getVersion}
         * @param version Protocol version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link AssemblyManifest#getArtifacts}
         * @param artifacts The set of artifacts in this assembly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder artifacts(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloudassembly.schema.ArtifactManifest> artifacts) {
            this.artifacts = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.ArtifactManifest>)artifacts;
            return this;
        }

        /**
         * Sets the value of {@link AssemblyManifest#getMinimumCliVersion}
         * @param minimumCliVersion Required CLI version, if available.
         *                          If the manifest producer knows, it can put the minimum version of the CLI
         *                          here that supports reading this assembly.
         *                          <p>
         *                          If set, it can be used to show a more informative error message to users.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCliVersion(java.lang.String minimumCliVersion) {
            this.minimumCliVersion = minimumCliVersion;
            return this;
        }

        /**
         * Sets the value of {@link AssemblyManifest#getMissing}
         * @param missing Missing context information.
         *                If this field has values, it means that the
         *                cloud assembly is not complete and should not be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder missing(java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.MissingContext> missing) {
            this.missing = (java.util.List<software.amazon.awscdk.cloudassembly.schema.MissingContext>)missing;
            return this;
        }

        /**
         * Sets the value of {@link AssemblyManifest#getRuntime}
         * @param runtime Runtime information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.cloudassembly.schema.RuntimeInfo runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssemblyManifest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssemblyManifest build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssemblyManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssemblyManifest {
        private final java.lang.String version;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.ArtifactManifest> artifacts;
        private final java.lang.String minimumCliVersion;
        private final java.util.List<software.amazon.awscdk.cloudassembly.schema.MissingContext> missing;
        private final software.amazon.awscdk.cloudassembly.schema.RuntimeInfo runtime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.artifacts = software.amazon.jsii.Kernel.get(this, "artifacts", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.ArtifactManifest.class)));
            this.minimumCliVersion = software.amazon.jsii.Kernel.get(this, "minimumCliVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.missing = software.amazon.jsii.Kernel.get(this, "missing", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.MissingContext.class)));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.RuntimeInfo.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.artifacts = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.ArtifactManifest>)builder.artifacts;
            this.minimumCliVersion = builder.minimumCliVersion;
            this.missing = (java.util.List<software.amazon.awscdk.cloudassembly.schema.MissingContext>)builder.missing;
            this.runtime = builder.runtime;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.ArtifactManifest> getArtifacts() {
            return this.artifacts;
        }

        @Override
        public final java.lang.String getMinimumCliVersion() {
            return this.minimumCliVersion;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cloudassembly.schema.MissingContext> getMissing() {
            return this.missing;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.RuntimeInfo getRuntime() {
            return this.runtime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getArtifacts() != null) {
                data.set("artifacts", om.valueToTree(this.getArtifacts()));
            }
            if (this.getMinimumCliVersion() != null) {
                data.set("minimumCliVersion", om.valueToTree(this.getMinimumCliVersion()));
            }
            if (this.getMissing() != null) {
                data.set("missing", om.valueToTree(this.getMissing()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.AssemblyManifest"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssemblyManifest.Jsii$Proxy that = (AssemblyManifest.Jsii$Proxy) o;

            if (!version.equals(that.version)) return false;
            if (this.artifacts != null ? !this.artifacts.equals(that.artifacts) : that.artifacts != null) return false;
            if (this.minimumCliVersion != null ? !this.minimumCliVersion.equals(that.minimumCliVersion) : that.minimumCliVersion != null) return false;
            if (this.missing != null ? !this.missing.equals(that.missing) : that.missing != null) return false;
            return this.runtime != null ? this.runtime.equals(that.runtime) : that.runtime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.version.hashCode();
            result = 31 * result + (this.artifacts != null ? this.artifacts.hashCode() : 0);
            result = 31 * result + (this.minimumCliVersion != null ? this.minimumCliVersion.hashCode() : 0);
            result = 31 * result + (this.missing != null ? this.missing.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            return result;
        }
    }
}
