package software.amazon.awscdk.cloudassembly.schema;

/**
 * Filters for selecting load balancers.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.114.1 (build 8a29f60)", date = "2025-09-17T11:55:39.134Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.LoadBalancerFilter")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerFilter.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerFilter extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloudassembly.schema.ContextLookupRoleOptions {

    /**
     * Filter load balancers by their type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.LoadBalancerType getLoadBalancerType();

    /**
     * Find by load balancer's ARN.
     * <p>
     * Default: - does not search by load balancer arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerArn() {
        return null;
    }

    /**
     * Match load balancer tags.
     * <p>
     * Default: - does not match load balancers by tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> getLoadBalancerTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerFilter> {
        software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        java.lang.String loadBalancerArn;
        java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;
        java.lang.String account;
        java.lang.String region;
        java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        java.lang.String lookupRoleArn;
        java.lang.String lookupRoleExternalId;

        /**
         * Sets the value of {@link LoadBalancerFilter#getLoadBalancerType}
         * @param loadBalancerType Filter load balancers by their type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerType(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType) {
            this.loadBalancerType = loadBalancerType;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getLoadBalancerArn}
         * @param loadBalancerArn Find by load balancer's ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerArn(java.lang.String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getLoadBalancerTags}
         * @param loadBalancerTags Match load balancer tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder loadBalancerTags(java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags) {
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)loadBalancerTags;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getAccount}
         * @param account Query account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getRegion}
         * @param region Query region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getAssumeRoleAdditionalOptions}
         * @param assumeRoleAdditionalOptions Additional options to pass to STS when assuming the lookup role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assumeRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> assumeRoleAdditionalOptions) {
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)assumeRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getLookupRoleArn}
         * @param lookupRoleArn The ARN of the role that should be used to look up the missing values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerFilter#getLookupRoleExternalId}
         * @param lookupRoleExternalId The ExternalId that needs to be supplied while assuming this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleExternalId(java.lang.String lookupRoleExternalId) {
            this.lookupRoleExternalId = lookupRoleExternalId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerFilter}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerFilter build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerFilter {
        private final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType loadBalancerType;
        private final java.lang.String loadBalancerArn;
        private final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> loadBalancerTags;
        private final java.lang.String account;
        private final java.lang.String region;
        private final java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        private final java.lang.String lookupRoleArn;
        private final java.lang.String lookupRoleExternalId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loadBalancerType = software.amazon.jsii.Kernel.get(this, "loadBalancerType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.LoadBalancerType.class));
            this.loadBalancerArn = software.amazon.jsii.Kernel.get(this, "loadBalancerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadBalancerTags = software.amazon.jsii.Kernel.get(this, "loadBalancerTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.Tag.class)));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "assumeRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleExternalId = software.amazon.jsii.Kernel.get(this, "lookupRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loadBalancerType = java.util.Objects.requireNonNull(builder.loadBalancerType, "loadBalancerType is required");
            this.loadBalancerArn = builder.loadBalancerArn;
            this.loadBalancerTags = (java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag>)builder.loadBalancerTags;
            this.account = java.util.Objects.requireNonNull(builder.account, "account is required");
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.assumeRoleAdditionalOptions;
            this.lookupRoleArn = builder.lookupRoleArn;
            this.lookupRoleExternalId = builder.lookupRoleExternalId;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.LoadBalancerType getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @Override
        public final java.lang.String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cloudassembly.schema.Tag> getLoadBalancerTags() {
            return this.loadBalancerTags;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
            return this.assumeRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final java.lang.String getLookupRoleExternalId() {
            return this.lookupRoleExternalId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loadBalancerType", om.valueToTree(this.getLoadBalancerType()));
            if (this.getLoadBalancerArn() != null) {
                data.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
            }
            if (this.getLoadBalancerTags() != null) {
                data.set("loadBalancerTags", om.valueToTree(this.getLoadBalancerTags()));
            }
            data.set("account", om.valueToTree(this.getAccount()));
            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getAssumeRoleAdditionalOptions() != null) {
                data.set("assumeRoleAdditionalOptions", om.valueToTree(this.getAssumeRoleAdditionalOptions()));
            }
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            if (this.getLookupRoleExternalId() != null) {
                data.set("lookupRoleExternalId", om.valueToTree(this.getLookupRoleExternalId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.LoadBalancerFilter"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerFilter.Jsii$Proxy that = (LoadBalancerFilter.Jsii$Proxy) o;

            if (!loadBalancerType.equals(that.loadBalancerType)) return false;
            if (this.loadBalancerArn != null ? !this.loadBalancerArn.equals(that.loadBalancerArn) : that.loadBalancerArn != null) return false;
            if (this.loadBalancerTags != null ? !this.loadBalancerTags.equals(that.loadBalancerTags) : that.loadBalancerTags != null) return false;
            if (!account.equals(that.account)) return false;
            if (!region.equals(that.region)) return false;
            if (this.assumeRoleAdditionalOptions != null ? !this.assumeRoleAdditionalOptions.equals(that.assumeRoleAdditionalOptions) : that.assumeRoleAdditionalOptions != null) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            return this.lookupRoleExternalId != null ? this.lookupRoleExternalId.equals(that.lookupRoleExternalId) : that.lookupRoleExternalId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loadBalancerType.hashCode();
            result = 31 * result + (this.loadBalancerArn != null ? this.loadBalancerArn.hashCode() : 0);
            result = 31 * result + (this.loadBalancerTags != null ? this.loadBalancerTags.hashCode() : 0);
            result = 31 * result + (this.account.hashCode());
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.assumeRoleAdditionalOptions != null ? this.assumeRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.lookupRoleExternalId != null ? this.lookupRoleExternalId.hashCode() : 0);
            return result;
        }
    }
}
