package software.amazon.awscdk.cloudassembly.schema;

/**
 * The set of options to control the workflow of the test runner.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.114.1 (build 8a29f60)", date = "2025-09-17T11:55:39.143Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.TestOptions")
@software.amazon.jsii.Jsii.Proxy(TestOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TestOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test.
     * <p>
     * This list should only include resources that for this specific
     * integration test we are sure will not cause errors or an outage if
     * destroyed. For example, maybe we know that a new resource will be created
     * first before the old resource is destroyed which prevents any outage.
     * <p>
     * e.g. ['AWS::IAM::Role']
     * <p>
     * Default: - do not allow destruction of any resources on update
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowDestroy() {
        return null;
    }

    /**
     * Additional options to use for each CDK command.
     * <p>
     * Default: - runner default options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.CdkCommands getCdkCommandOptions() {
        return null;
    }

    /**
     * Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes <em>should</em> be included.
     * <p>
     * For example
     * any tests involving custom resources or bundling
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDiffAssets() {
        return null;
    }

    /**
     * Additional commands to run at predefined points in the test workflow.
     * <p>
     * e.g. { postDeploy: ['yarn', 'test'] }
     * <p>
     * Default: - no hooks
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.Hooks getHooks() {
        return null;
    }

    /**
     * Limit deployment to these regions.
     * <p>
     * Default: - can run in any region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
        return null;
    }

    /**
     * Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStackUpdateWorkflow() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TestOptions> {
        java.util.List<java.lang.String> allowDestroy;
        software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions;
        java.lang.Boolean diffAssets;
        software.amazon.awscdk.cloudassembly.schema.Hooks hooks;
        java.util.List<java.lang.String> regions;
        java.lang.Boolean stackUpdateWorkflow;

        /**
         * Sets the value of {@link TestOptions#getAllowDestroy}
         * @param allowDestroy List of CloudFormation resource types in this stack that can be destroyed as part of an update without failing the test.
         *                     This list should only include resources that for this specific
         *                     integration test we are sure will not cause errors or an outage if
         *                     destroyed. For example, maybe we know that a new resource will be created
         *                     first before the old resource is destroyed which prevents any outage.
         *                     <p>
         *                     e.g. ['AWS::IAM::Role']
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowDestroy(java.util.List<java.lang.String> allowDestroy) {
            this.allowDestroy = allowDestroy;
            return this;
        }

        /**
         * Sets the value of {@link TestOptions#getCdkCommandOptions}
         * @param cdkCommandOptions Additional options to use for each CDK command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdkCommandOptions(software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions) {
            this.cdkCommandOptions = cdkCommandOptions;
            return this;
        }

        /**
         * Sets the value of {@link TestOptions#getDiffAssets}
         * @param diffAssets Whether or not to include asset hashes in the diff Asset hashes can introduces a lot of unneccessary noise into tests, but there are some cases where asset hashes <em>should</em> be included.
         *                   For example
         *                   any tests involving custom resources or bundling
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diffAssets(java.lang.Boolean diffAssets) {
            this.diffAssets = diffAssets;
            return this;
        }

        /**
         * Sets the value of {@link TestOptions#getHooks}
         * @param hooks Additional commands to run at predefined points in the test workflow.
         *              e.g. { postDeploy: ['yarn', 'test'] }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hooks(software.amazon.awscdk.cloudassembly.schema.Hooks hooks) {
            this.hooks = hooks;
            return this;
        }

        /**
         * Sets the value of {@link TestOptions#getRegions}
         * @param regions Limit deployment to these regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link TestOptions#getStackUpdateWorkflow}
         * @param stackUpdateWorkflow Run update workflow on this test case This should only be set to false to test scenarios that are not possible to test as part of the update workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackUpdateWorkflow(java.lang.Boolean stackUpdateWorkflow) {
            this.stackUpdateWorkflow = stackUpdateWorkflow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TestOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TestOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TestOptions {
        private final java.util.List<java.lang.String> allowDestroy;
        private final software.amazon.awscdk.cloudassembly.schema.CdkCommands cdkCommandOptions;
        private final java.lang.Boolean diffAssets;
        private final software.amazon.awscdk.cloudassembly.schema.Hooks hooks;
        private final java.util.List<java.lang.String> regions;
        private final java.lang.Boolean stackUpdateWorkflow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowDestroy = software.amazon.jsii.Kernel.get(this, "allowDestroy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cdkCommandOptions = software.amazon.jsii.Kernel.get(this, "cdkCommandOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.CdkCommands.class));
            this.diffAssets = software.amazon.jsii.Kernel.get(this, "diffAssets", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.hooks = software.amazon.jsii.Kernel.get(this, "hooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.Hooks.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackUpdateWorkflow = software.amazon.jsii.Kernel.get(this, "stackUpdateWorkflow", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowDestroy = builder.allowDestroy;
            this.cdkCommandOptions = builder.cdkCommandOptions;
            this.diffAssets = builder.diffAssets;
            this.hooks = builder.hooks;
            this.regions = builder.regions;
            this.stackUpdateWorkflow = builder.stackUpdateWorkflow;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowDestroy() {
            return this.allowDestroy;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.CdkCommands getCdkCommandOptions() {
            return this.cdkCommandOptions;
        }

        @Override
        public final java.lang.Boolean getDiffAssets() {
            return this.diffAssets;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.Hooks getHooks() {
            return this.hooks;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        public final java.lang.Boolean getStackUpdateWorkflow() {
            return this.stackUpdateWorkflow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowDestroy() != null) {
                data.set("allowDestroy", om.valueToTree(this.getAllowDestroy()));
            }
            if (this.getCdkCommandOptions() != null) {
                data.set("cdkCommandOptions", om.valueToTree(this.getCdkCommandOptions()));
            }
            if (this.getDiffAssets() != null) {
                data.set("diffAssets", om.valueToTree(this.getDiffAssets()));
            }
            if (this.getHooks() != null) {
                data.set("hooks", om.valueToTree(this.getHooks()));
            }
            if (this.getRegions() != null) {
                data.set("regions", om.valueToTree(this.getRegions()));
            }
            if (this.getStackUpdateWorkflow() != null) {
                data.set("stackUpdateWorkflow", om.valueToTree(this.getStackUpdateWorkflow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.TestOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TestOptions.Jsii$Proxy that = (TestOptions.Jsii$Proxy) o;

            if (this.allowDestroy != null ? !this.allowDestroy.equals(that.allowDestroy) : that.allowDestroy != null) return false;
            if (this.cdkCommandOptions != null ? !this.cdkCommandOptions.equals(that.cdkCommandOptions) : that.cdkCommandOptions != null) return false;
            if (this.diffAssets != null ? !this.diffAssets.equals(that.diffAssets) : that.diffAssets != null) return false;
            if (this.hooks != null ? !this.hooks.equals(that.hooks) : that.hooks != null) return false;
            if (this.regions != null ? !this.regions.equals(that.regions) : that.regions != null) return false;
            return this.stackUpdateWorkflow != null ? this.stackUpdateWorkflow.equals(that.stackUpdateWorkflow) : that.stackUpdateWorkflow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowDestroy != null ? this.allowDestroy.hashCode() : 0;
            result = 31 * result + (this.cdkCommandOptions != null ? this.cdkCommandOptions.hashCode() : 0);
            result = 31 * result + (this.diffAssets != null ? this.diffAssets.hashCode() : 0);
            result = 31 * result + (this.hooks != null ? this.hooks.hashCode() : 0);
            result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
            result = 31 * result + (this.stackUpdateWorkflow != null ? this.stackUpdateWorkflow.hashCode() : 0);
            return result;
        }
    }
}
