package software.amazon.awscdk.cloudassembly.schema;

/**
 * Metadata Entry spec for container images.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map&lt;String, String&gt; entry = Map.of(
 *         "packaging", "container-image",
 *         "repositoryName", "repository-name",
 *         "imageTag", "tag");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.114.1 (build 8a29f60)", date = "2025-10-01T17:52:27.562Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.ContainerImageAssetMetadataEntry")
@software.amazon.jsii.Jsii.Proxy(ContainerImageAssetMetadataEntry.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerImageAssetMetadataEntry extends software.amazon.jsii.JsiiSerializable {

    /**
     * Logical identifier for the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getId();

    /**
     * Type of asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackaging();

    /**
     * Path on disk to the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPath();

    /**
     * The hash of the asset source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceHash();

    /**
     * Build args to pass to the <code>docker build</code> command.
     * <p>
     * Default: no build args are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
        return null;
    }

    /**
     * Build secrets to pass to the <code>docker build</code> command.
     * <p>
     * Default: no build secrets are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildSecrets() {
        return null;
    }

    /**
     * SSH agent socket or keys to pass to the <code>docker build</code> command.
     * <p>
     * Default: no ssh arg is passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildSsh() {
        return null;
    }

    /**
     * Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command.
     * <p>
     * Default: - cache is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCacheDisabled() {
        return null;
    }

    /**
     * Cache from options to pass to the <code>docker build</code> command.
     * <p>
     * Default: - no cache from options are passed to the build command
     * <p>
     * @see <a href="https://docs.docker.com/build/cache/backends/">https://docs.docker.com/build/cache/backends/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption> getCacheFrom() {
        return null;
    }

    /**
     * Cache to options to pass to the <code>docker build</code> command.
     * <p>
     * Default: - no cache to options are passed to the build command
     * <p>
     * @see <a href="https://docs.docker.com/build/cache/backends/">https://docs.docker.com/build/cache/backends/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption getCacheTo() {
        return null;
    }

    /**
     * Path to the Dockerfile (relative to the directory).
     * <p>
     * Default: - no file is passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFile() {
        return null;
    }

    /**
     * (deprecated) ECR Repository name and repo digest (separated by "&#64;sha256:") where this image is stored.
     * <p>
     * Default: undefined If not specified, `repositoryName` and `imageTag` are
     * required because otherwise how will the stack know where to find the asset,
     * ha?
     * <p>
     * @deprecated specify <code>repositoryName</code> and <code>imageTag</code> instead, and then you
     * know where the image will go.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getImageNameParameter() {
        return null;
    }

    /**
     * The docker image tag to use for tagging pushed images.
     * <p>
     * This field is
     * required if <code>imageParameterName</code> is ommited (otherwise, the app won't be
     * able to find the image).
     * <p>
     * Default: - this parameter is REQUIRED after 1.21.0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageTag() {
        return null;
    }

    /**
     * Networking mode for the RUN commands during build.
     * <p>
     * Default: - no networking mode specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkMode() {
        return null;
    }

    /**
     * Outputs to pass to the <code>docker build</code> command.
     * <p>
     * Default: - no outputs are passed to the build command (default outputs are used)
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/commandline/build/#custom-build-outputs">https://docs.docker.com/engine/reference/commandline/build/#custom-build-outputs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOutputs() {
        return null;
    }

    /**
     * Platform to build for.
     * <p>
     * <em>Requires Docker Buildx</em>.
     * <p>
     * Default: - current machine platform
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlatform() {
        return null;
    }

    /**
     * ECR repository name, if omitted a default name based on the asset's ID is used instead.
     * <p>
     * Specify this property if you need to statically address the
     * image, e.g. from a Kubernetes Pod. Note, this is only the repository name,
     * without the registry and the tag parts.
     * <p>
     * Default: - this parameter is REQUIRED after 1.21.0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryName() {
        return null;
    }

    /**
     * Docker target to build to.
     * <p>
     * Default: no build target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerImageAssetMetadataEntry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerImageAssetMetadataEntry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerImageAssetMetadataEntry> {
        java.lang.String id;
        java.lang.String packaging;
        java.lang.String path;
        java.lang.String sourceHash;
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        java.util.Map<java.lang.String, java.lang.String> buildSecrets;
        java.lang.String buildSsh;
        java.lang.Boolean cacheDisabled;
        java.util.List<software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption> cacheFrom;
        software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption cacheTo;
        java.lang.String file;
        java.lang.String imageNameParameter;
        java.lang.String imageTag;
        java.lang.String networkMode;
        java.util.List<java.lang.String> outputs;
        java.lang.String platform;
        java.lang.String repositoryName;
        java.lang.String target;

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getId}
         * @param id Logical identifier for the asset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getPackaging}
         * @param packaging Type of asset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packaging(java.lang.String packaging) {
            this.packaging = packaging;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getPath}
         * @param path Path on disk to the asset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getSourceHash}
         * @param sourceHash The hash of the asset source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceHash(java.lang.String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getBuildArgs}
         * @param buildArgs Build args to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getBuildSecrets}
         * @param buildSecrets Build secrets to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSecrets(java.util.Map<java.lang.String, java.lang.String> buildSecrets) {
            this.buildSecrets = buildSecrets;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getBuildSsh}
         * @param buildSsh SSH agent socket or keys to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSsh(java.lang.String buildSsh) {
            this.buildSsh = buildSsh;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getCacheDisabled}
         * @param cacheDisabled Disable the cache and pass <code>--no-cache</code> to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDisabled(java.lang.Boolean cacheDisabled) {
            this.cacheDisabled = cacheDisabled;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getCacheFrom}
         * @param cacheFrom Cache from options to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder cacheFrom(java.util.List<? extends software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption> cacheFrom) {
            this.cacheFrom = (java.util.List<software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption>)cacheFrom;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getCacheTo}
         * @param cacheTo Cache to options to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTo(software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption cacheTo) {
            this.cacheTo = cacheTo;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getFile}
         * @param file Path to the Dockerfile (relative to the directory).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getImageNameParameter}
         * @param imageNameParameter ECR Repository name and repo digest (separated by "&#64;sha256:") where this image is stored.
         * @return {@code this}
         * @deprecated specify `repositoryName` and `imageTag` instead, and then you
know where the image will go.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder imageNameParameter(java.lang.String imageNameParameter) {
            this.imageNameParameter = imageNameParameter;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getImageTag}
         * @param imageTag The docker image tag to use for tagging pushed images.
         *                 This field is
         *                 required if <code>imageParameterName</code> is ommited (otherwise, the app won't be
         *                 able to find the image).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTag(java.lang.String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getNetworkMode}
         * @param networkMode Networking mode for the RUN commands during build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(java.lang.String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getOutputs}
         * @param outputs Outputs to pass to the <code>docker build</code> command.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.util.List<java.lang.String> outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getPlatform}
         * @param platform Platform to build for.
         *                 <em>Requires Docker Buildx</em>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(java.lang.String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getRepositoryName}
         * @param repositoryName ECR repository name, if omitted a default name based on the asset's ID is used instead.
         *                       Specify this property if you need to statically address the
         *                       image, e.g. from a Kubernetes Pod. Note, this is only the repository name,
         *                       without the registry and the tag parts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link ContainerImageAssetMetadataEntry#getTarget}
         * @param target Docker target to build to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerImageAssetMetadataEntry}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerImageAssetMetadataEntry build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerImageAssetMetadataEntry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerImageAssetMetadataEntry {
        private final java.lang.String id;
        private final java.lang.String packaging;
        private final java.lang.String path;
        private final java.lang.String sourceHash;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.util.Map<java.lang.String, java.lang.String> buildSecrets;
        private final java.lang.String buildSsh;
        private final java.lang.Boolean cacheDisabled;
        private final java.util.List<software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption> cacheFrom;
        private final software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption cacheTo;
        private final java.lang.String file;
        private final java.lang.String imageNameParameter;
        private final java.lang.String imageTag;
        private final java.lang.String networkMode;
        private final java.util.List<java.lang.String> outputs;
        private final java.lang.String platform;
        private final java.lang.String repositoryName;
        private final java.lang.String target;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packaging = software.amazon.jsii.Kernel.get(this, "packaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceHash = software.amazon.jsii.Kernel.get(this, "sourceHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.buildSecrets = software.amazon.jsii.Kernel.get(this, "buildSecrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.buildSsh = software.amazon.jsii.Kernel.get(this, "buildSsh", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cacheDisabled = software.amazon.jsii.Kernel.get(this, "cacheDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheFrom = software.amazon.jsii.Kernel.get(this, "cacheFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption.class)));
            this.cacheTo = software.amazon.jsii.Kernel.get(this, "cacheTo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption.class));
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageNameParameter = software.amazon.jsii.Kernel.get(this, "imageNameParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageTag = software.amazon.jsii.Kernel.get(this, "imageTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            this.packaging = java.util.Objects.requireNonNull(builder.packaging, "packaging is required");
            this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
            this.sourceHash = java.util.Objects.requireNonNull(builder.sourceHash, "sourceHash is required");
            this.buildArgs = builder.buildArgs;
            this.buildSecrets = builder.buildSecrets;
            this.buildSsh = builder.buildSsh;
            this.cacheDisabled = builder.cacheDisabled;
            this.cacheFrom = (java.util.List<software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption>)builder.cacheFrom;
            this.cacheTo = builder.cacheTo;
            this.file = builder.file;
            this.imageNameParameter = builder.imageNameParameter;
            this.imageTag = builder.imageTag;
            this.networkMode = builder.networkMode;
            this.outputs = builder.outputs;
            this.platform = builder.platform;
            this.repositoryName = builder.repositoryName;
            this.target = builder.target;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getPackaging() {
            return this.packaging;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.lang.String getSourceHash() {
            return this.sourceHash;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildSecrets() {
            return this.buildSecrets;
        }

        @Override
        public final java.lang.String getBuildSsh() {
            return this.buildSsh;
        }

        @Override
        public final java.lang.Boolean getCacheDisabled() {
            return this.cacheDisabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption> getCacheFrom() {
            return this.cacheFrom;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.ContainerImageAssetCacheOption getCacheTo() {
            return this.cacheTo;
        }

        @Override
        public final java.lang.String getFile() {
            return this.file;
        }

        @Override
        public final java.lang.String getImageNameParameter() {
            return this.imageNameParameter;
        }

        @Override
        public final java.lang.String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final java.lang.String getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final java.util.List<java.lang.String> getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.lang.String getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("id", om.valueToTree(this.getId()));
            data.set("packaging", om.valueToTree(this.getPackaging()));
            data.set("path", om.valueToTree(this.getPath()));
            data.set("sourceHash", om.valueToTree(this.getSourceHash()));
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getBuildSecrets() != null) {
                data.set("buildSecrets", om.valueToTree(this.getBuildSecrets()));
            }
            if (this.getBuildSsh() != null) {
                data.set("buildSsh", om.valueToTree(this.getBuildSsh()));
            }
            if (this.getCacheDisabled() != null) {
                data.set("cacheDisabled", om.valueToTree(this.getCacheDisabled()));
            }
            if (this.getCacheFrom() != null) {
                data.set("cacheFrom", om.valueToTree(this.getCacheFrom()));
            }
            if (this.getCacheTo() != null) {
                data.set("cacheTo", om.valueToTree(this.getCacheTo()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getImageNameParameter() != null) {
                data.set("imageNameParameter", om.valueToTree(this.getImageNameParameter()));
            }
            if (this.getImageTag() != null) {
                data.set("imageTag", om.valueToTree(this.getImageTag()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.ContainerImageAssetMetadataEntry"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerImageAssetMetadataEntry.Jsii$Proxy that = (ContainerImageAssetMetadataEntry.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (!packaging.equals(that.packaging)) return false;
            if (!path.equals(that.path)) return false;
            if (!sourceHash.equals(that.sourceHash)) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.buildSecrets != null ? !this.buildSecrets.equals(that.buildSecrets) : that.buildSecrets != null) return false;
            if (this.buildSsh != null ? !this.buildSsh.equals(that.buildSsh) : that.buildSsh != null) return false;
            if (this.cacheDisabled != null ? !this.cacheDisabled.equals(that.cacheDisabled) : that.cacheDisabled != null) return false;
            if (this.cacheFrom != null ? !this.cacheFrom.equals(that.cacheFrom) : that.cacheFrom != null) return false;
            if (this.cacheTo != null ? !this.cacheTo.equals(that.cacheTo) : that.cacheTo != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.imageNameParameter != null ? !this.imageNameParameter.equals(that.imageNameParameter) : that.imageNameParameter != null) return false;
            if (this.imageTag != null ? !this.imageTag.equals(that.imageTag) : that.imageTag != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
            return this.target != null ? this.target.equals(that.target) : that.target == null;
        }

        @Override
        public final int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.packaging.hashCode());
            result = 31 * result + (this.path.hashCode());
            result = 31 * result + (this.sourceHash.hashCode());
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.buildSecrets != null ? this.buildSecrets.hashCode() : 0);
            result = 31 * result + (this.buildSsh != null ? this.buildSsh.hashCode() : 0);
            result = 31 * result + (this.cacheDisabled != null ? this.cacheDisabled.hashCode() : 0);
            result = 31 * result + (this.cacheFrom != null ? this.cacheFrom.hashCode() : 0);
            result = 31 * result + (this.cacheTo != null ? this.cacheTo.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.imageNameParameter != null ? this.imageNameParameter.hashCode() : 0);
            result = 31 * result + (this.imageTag != null ? this.imageTag.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }
    }
}
