package software.amazon.awscdk.cloudassembly.schema;

/**
 * A single feature flag.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-06T20:25:05.783Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.FeatureFlag")
@software.amazon.jsii.Jsii.Proxy(FeatureFlag.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FeatureFlag extends software.amazon.jsii.JsiiSerializable {

    /**
     * Explanation about the purpose of this flag that can be shown to the user.
     * <p>
     * Default: - No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExplanation() {
        return null;
    }

    /**
     * The library-recommended value for this flag, if any.
     * <p>
     * It is possible that there is no recommended value.
     * <p>
     * Default: - No recommended value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecommendedValue() {
        return null;
    }

    /**
     * The value of the flag that produces the same behavior as when the flag is not configured at all.
     * <p>
     * The structure of this field is a historical accident. The type of this field
     * should have been boolean, which should have contained the default value for
     * the flag appropriate for the <em>current</em> version of the CDK library. We are
     * not rectifying this accident because doing so
     * <p>
     * Instead, the canonical way to access this value is by evaluating
     * <code>unconfiguredBehavesLike?.v2 ?? false</code>.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.UnconfiguredBehavesLike getUnconfiguredBehavesLike() {
        return null;
    }

    /**
     * The value configured by the user.
     * <p>
     * This is the value configured at the root of the tree. Users may also have
     * configured values at specific locations in the tree; we don't report on
     * those.
     * <p>
     * Default: - Not configured by the user
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserValue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FeatureFlag}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FeatureFlag}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FeatureFlag> {
        java.lang.String explanation;
        java.lang.Object recommendedValue;
        software.amazon.awscdk.cloudassembly.schema.UnconfiguredBehavesLike unconfiguredBehavesLike;
        java.lang.Object userValue;

        /**
         * Sets the value of {@link FeatureFlag#getExplanation}
         * @param explanation Explanation about the purpose of this flag that can be shown to the user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder explanation(java.lang.String explanation) {
            this.explanation = explanation;
            return this;
        }

        /**
         * Sets the value of {@link FeatureFlag#getRecommendedValue}
         * @param recommendedValue The library-recommended value for this flag, if any.
         *                         It is possible that there is no recommended value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recommendedValue(java.lang.Object recommendedValue) {
            this.recommendedValue = recommendedValue;
            return this;
        }

        /**
         * Sets the value of {@link FeatureFlag#getUnconfiguredBehavesLike}
         * @param unconfiguredBehavesLike The value of the flag that produces the same behavior as when the flag is not configured at all.
         *                                The structure of this field is a historical accident. The type of this field
         *                                should have been boolean, which should have contained the default value for
         *                                the flag appropriate for the <em>current</em> version of the CDK library. We are
         *                                not rectifying this accident because doing so
         *                                <p>
         *                                Instead, the canonical way to access this value is by evaluating
         *                                <code>unconfiguredBehavesLike?.v2 ?? false</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unconfiguredBehavesLike(software.amazon.awscdk.cloudassembly.schema.UnconfiguredBehavesLike unconfiguredBehavesLike) {
            this.unconfiguredBehavesLike = unconfiguredBehavesLike;
            return this;
        }

        /**
         * Sets the value of {@link FeatureFlag#getUserValue}
         * @param userValue The value configured by the user.
         *                  This is the value configured at the root of the tree. Users may also have
         *                  configured values at specific locations in the tree; we don't report on
         *                  those.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userValue(java.lang.Object userValue) {
            this.userValue = userValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FeatureFlag}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FeatureFlag build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FeatureFlag}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeatureFlag {
        private final java.lang.String explanation;
        private final java.lang.Object recommendedValue;
        private final software.amazon.awscdk.cloudassembly.schema.UnconfiguredBehavesLike unconfiguredBehavesLike;
        private final java.lang.Object userValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.explanation = software.amazon.jsii.Kernel.get(this, "explanation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recommendedValue = software.amazon.jsii.Kernel.get(this, "recommendedValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.unconfiguredBehavesLike = software.amazon.jsii.Kernel.get(this, "unconfiguredBehavesLike", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.UnconfiguredBehavesLike.class));
            this.userValue = software.amazon.jsii.Kernel.get(this, "userValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.explanation = builder.explanation;
            this.recommendedValue = builder.recommendedValue;
            this.unconfiguredBehavesLike = builder.unconfiguredBehavesLike;
            this.userValue = builder.userValue;
        }

        @Override
        public final java.lang.String getExplanation() {
            return this.explanation;
        }

        @Override
        public final java.lang.Object getRecommendedValue() {
            return this.recommendedValue;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.UnconfiguredBehavesLike getUnconfiguredBehavesLike() {
            return this.unconfiguredBehavesLike;
        }

        @Override
        public final java.lang.Object getUserValue() {
            return this.userValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExplanation() != null) {
                data.set("explanation", om.valueToTree(this.getExplanation()));
            }
            if (this.getRecommendedValue() != null) {
                data.set("recommendedValue", om.valueToTree(this.getRecommendedValue()));
            }
            if (this.getUnconfiguredBehavesLike() != null) {
                data.set("unconfiguredBehavesLike", om.valueToTree(this.getUnconfiguredBehavesLike()));
            }
            if (this.getUserValue() != null) {
                data.set("userValue", om.valueToTree(this.getUserValue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.FeatureFlag"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FeatureFlag.Jsii$Proxy that = (FeatureFlag.Jsii$Proxy) o;

            if (this.explanation != null ? !this.explanation.equals(that.explanation) : that.explanation != null) return false;
            if (this.recommendedValue != null ? !this.recommendedValue.equals(that.recommendedValue) : that.recommendedValue != null) return false;
            if (this.unconfiguredBehavesLike != null ? !this.unconfiguredBehavesLike.equals(that.unconfiguredBehavesLike) : that.unconfiguredBehavesLike != null) return false;
            return this.userValue != null ? this.userValue.equals(that.userValue) : that.userValue == null;
        }

        @Override
        public final int hashCode() {
            int result = this.explanation != null ? this.explanation.hashCode() : 0;
            result = 31 * result + (this.recommendedValue != null ? this.recommendedValue.hashCode() : 0);
            result = 31 * result + (this.unconfiguredBehavesLike != null ? this.unconfiguredBehavesLike.hashCode() : 0);
            result = 31 * result + (this.userValue != null ? this.userValue.hashCode() : 0);
            return result;
        }
    }
}
