package software.amazon.awscdk.cloudassembly.schema;

/**
 * Artifact properties for a feature flag report.
 * <p>
 * A feature flag report is small enough that all the properties can be inlined
 * here, and doesn't need an additional file.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-19T12:19:17.003Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.FeatureFlagReportProperties")
@software.amazon.jsii.Jsii.Proxy(FeatureFlagReportProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FeatureFlagReportProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     * Information about every feature flag supported by this library.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.FeatureFlag> getFlags();

    /**
     * The library that this feature flag report applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModule();

    /**
     * @return a {@link Builder} of {@link FeatureFlagReportProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FeatureFlagReportProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FeatureFlagReportProperties> {
        java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.FeatureFlag> flags;
        java.lang.String module;

        /**
         * Sets the value of {@link FeatureFlagReportProperties#getFlags}
         * @param flags Information about every feature flag supported by this library. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder flags(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloudassembly.schema.FeatureFlag> flags) {
            this.flags = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.FeatureFlag>)flags;
            return this;
        }

        /**
         * Sets the value of {@link FeatureFlagReportProperties#getModule}
         * @param module The library that this feature flag report applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder module(java.lang.String module) {
            this.module = module;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FeatureFlagReportProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FeatureFlagReportProperties build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FeatureFlagReportProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeatureFlagReportProperties {
        private final java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.FeatureFlag> flags;
        private final java.lang.String module;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.flags = software.amazon.jsii.Kernel.get(this, "flags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.FeatureFlag.class)));
            this.module = software.amazon.jsii.Kernel.get(this, "module", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.flags = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.FeatureFlag>)java.util.Objects.requireNonNull(builder.flags, "flags is required");
            this.module = java.util.Objects.requireNonNull(builder.module, "module is required");
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.cloudassembly.schema.FeatureFlag> getFlags() {
            return this.flags;
        }

        @Override
        public final java.lang.String getModule() {
            return this.module;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("flags", om.valueToTree(this.getFlags()));
            data.set("module", om.valueToTree(this.getModule()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.FeatureFlagReportProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FeatureFlagReportProperties.Jsii$Proxy that = (FeatureFlagReportProperties.Jsii$Proxy) o;

            if (!flags.equals(that.flags)) return false;
            return this.module.equals(that.module);
        }

        @Override
        public final int hashCode() {
            int result = this.flags.hashCode();
            result = 31 * result + (this.module.hashCode());
            return result;
        }
    }
}
