/**
 * <h2>CDK Custom Resources</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This module is part of the <a href="https://github.com/awslabs/aws-cdk">AWS Cloud Development Kit</a> project.</p>
 * <h4>AWS Custom Resource</h4>
 * <p>Sometimes a single API call can fill the gap in the CloudFormation coverage. In
 * this case you can use the <code>AwsCustomResource</code> construct. This construct creates
 * a custom resource that can be customized to make specific API calls for the
 * <code>CREATE</code>, <code>UPDATE</code> and <code>DELETE</code> events. Additionally, data returned by the API
 * call can be extracted and used in other constructs/resources (creating a real
 * CloudFormation dependency using <code>Fn::GetAtt</code> under the hood).</p>
 * <p>The physical id of the custom resource can be specified or derived from the data
 * returned by the API call.</p>
 * <p>The <code>AwsCustomResource</code> uses the AWS SDK for JavaScript. Services, actions and
 * parameters can be found in the <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html">API documentation</a>.</p>
 * <p>Path to data must be specified using a dot notation, e.g. to get the string value
 * of the <code>Title</code> attribute for the first item returned by <code>dynamodb.query</code> it should
 * be <code>Items.0.Title.S</code>.</p>
 * <h5>Examples</h5>
 * <p>Verify a domain with SES:</p>
 * <pre><code class="language-ts">const verifyDomainIdentity = new AwsCustomResource(this, 'VerifyDomainIdentity', {
 *   onCreate: {
 *     service: 'SES',
 *     action: 'verifyDomainIdentity',
 *     parameters: {
 *       Domain: 'example.com'
 *     },
 *     physicalResourceIdPath: 'VerificationToken' // Use the token returned by the call as physical id
 *   }
 * });
 * 
 * new route53.TxtRecord(zone, 'SESVerificationRecord', {
 *   recordName: `_amazonses.example.com`,
 *   recordValue: verifyDomainIdentity.getData('VerificationToken')
 * });
 * </code></pre>
 * <p>Get the latest version of a secure SSM parameter:</p>
 * <pre><code class="language-ts">const getParameter = new AwsCustomResource(this, 'GetParameter', {
 *   onUpdate: { // will also be called for a CREATE event
 *     service: 'SSM',
 *     action: 'getParameter',
 *     parameters: {
 *       Name: 'my-parameter',
 *       WithDecryption: true
 *     },
 *     physicalResourceId: Date.now().toString() // Update physical id to always fetch the latest version
 *   }
 * });
 * 
 * // Use the value in another construct with
 * getParameter.getData('Parameter.Value')
 * </code></pre>
 * <p>IAM policy statements required to make the API calls are derived from the calls
 * and allow by default the actions to be made on all resources (<code>*</code>). You can
 * restrict the permissions by specifying your own list of statements with the
 * <code>policyStatements</code> prop.</p>
 * <p>Chained API calls can be achieved by creating dependencies:</p>
 * <pre><code class="language-ts">const awsCustom1 = new AwsCustomResource(this, 'API1', {
 *   onCreate: {
 *     service: '...',
 *     action: '...',
 *     physicalResourceId: '...'
 *   }
 * });
 * 
 * const awsCustom2 = new AwsCustomResource(this, 'API2', {
 *   onCreate: {
 *     service: '...',
 *     action: '...'
 *     parameters: {
 *       text: awsCustom1.getData('Items.0.text')
 *     },
 *     physicalResourceId: '...'
 *   }
 * })
 * </code></pre>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.customresources;
