package software.amazon.awscdk.customresources;

/**
 * An AWS SDK call.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:18:43.796Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AwsSdkCall extends software.amazon.jsii.JsiiSerializable {
    /**
     * The service action to call.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getAction();
    /**
     * The service to call.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getService();
    /**
     * API version to use for the service.
     * 
     * Default: use latest available API version
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getApiVersion();
    /**
     * The regex pattern to use to catch API errors.
     * 
     * The `code` property of the
     * `Error` object will be tested against this pattern. If there is a match an
     * error will not be thrown.
     * 
     * Default: do not catch errors
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getCatchErrorPattern();
    /**
     * Restrict the data returned by the custom resource to a specific path in the API response.
     * 
     * Use this to limit the data returned by the custom
     * resource if working with API calls that could potentially result in custom
     * response objects exceeding the hard limit of 4096 bytes.
     * 
     * Example for ECS / updateService: 'service.deploymentConfiguration.maximumPercent'
     * 
     * Default: return all data
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getOutputPath();
    /**
     * The parameters for the service action.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Object getParameters();
    /**
     * The physical resource id of the custom resource for this call.
     * 
     * Either
     * `physicalResourceId` or `physicalResourceIdPath` must be specified for
     * onCreate or onUpdate calls.
     * 
     * Default: no physical resource id
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getPhysicalResourceId();
    /**
     * The path to the data in the API call response to use as the physical resource id.
     * 
     * Either `physicalResourceId` or `physicalResourceIdPath`
     * must be specified for onCreate or onUpdate calls.
     * 
     * Default: no path
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getPhysicalResourceIdPath();

    /**
     * @return a {@link Builder} of {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AwsSdkCall}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _action;
        private java.lang.String _service;
        @javax.annotation.Nullable
        private java.lang.String _apiVersion;
        @javax.annotation.Nullable
        private java.lang.String _catchErrorPattern;
        @javax.annotation.Nullable
        private java.lang.String _outputPath;
        @javax.annotation.Nullable
        private java.lang.Object _parameters;
        @javax.annotation.Nullable
        private java.lang.String _physicalResourceId;
        @javax.annotation.Nullable
        private java.lang.String _physicalResourceIdPath;

        /**
         * Sets the value of Action
         * @param value The service action to call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withAction(final java.lang.String value) {
            this._action = java.util.Objects.requireNonNull(value, "action is required");
            return this;
        }
        /**
         * Sets the value of Service
         * @param value The service to call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withService(final java.lang.String value) {
            this._service = java.util.Objects.requireNonNull(value, "service is required");
            return this;
        }
        /**
         * Sets the value of ApiVersion
         * @param value API version to use for the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withApiVersion(@javax.annotation.Nullable final java.lang.String value) {
            this._apiVersion = value;
            return this;
        }
        /**
         * Sets the value of CatchErrorPattern
         * @param value The regex pattern to use to catch API errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCatchErrorPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._catchErrorPattern = value;
            return this;
        }
        /**
         * Sets the value of OutputPath
         * @param value Restrict the data returned by the custom resource to a specific path in the API response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withOutputPath(@javax.annotation.Nullable final java.lang.String value) {
            this._outputPath = value;
            return this;
        }
        /**
         * Sets the value of Parameters
         * @param value The parameters for the service action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withParameters(@javax.annotation.Nullable final java.lang.Object value) {
            this._parameters = value;
            return this;
        }
        /**
         * Sets the value of PhysicalResourceId
         * @param value The physical resource id of the custom resource for this call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPhysicalResourceId(@javax.annotation.Nullable final java.lang.String value) {
            this._physicalResourceId = value;
            return this;
        }
        /**
         * Sets the value of PhysicalResourceIdPath
         * @param value The path to the data in the API call response to use as the physical resource id.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPhysicalResourceIdPath(@javax.annotation.Nullable final java.lang.String value) {
            this._physicalResourceIdPath = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsSdkCall}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public AwsSdkCall build() {
            return new AwsSdkCall() {
                private final java.lang.String $action = java.util.Objects.requireNonNull(_action, "action is required");
                private final java.lang.String $service = java.util.Objects.requireNonNull(_service, "service is required");
                @javax.annotation.Nullable
                private final java.lang.String $apiVersion = _apiVersion;
                @javax.annotation.Nullable
                private final java.lang.String $catchErrorPattern = _catchErrorPattern;
                @javax.annotation.Nullable
                private final java.lang.String $outputPath = _outputPath;
                @javax.annotation.Nullable
                private final java.lang.Object $parameters = _parameters;
                @javax.annotation.Nullable
                private final java.lang.String $physicalResourceId = _physicalResourceId;
                @javax.annotation.Nullable
                private final java.lang.String $physicalResourceIdPath = _physicalResourceIdPath;

                @Override
                public java.lang.String getAction() {
                    return this.$action;
                }

                @Override
                public java.lang.String getService() {
                    return this.$service;
                }

                @Override
                public java.lang.String getApiVersion() {
                    return this.$apiVersion;
                }

                @Override
                public java.lang.String getCatchErrorPattern() {
                    return this.$catchErrorPattern;
                }

                @Override
                public java.lang.String getOutputPath() {
                    return this.$outputPath;
                }

                @Override
                public java.lang.Object getParameters() {
                    return this.$parameters;
                }

                @Override
                public java.lang.String getPhysicalResourceId() {
                    return this.$physicalResourceId;
                }

                @Override
                public java.lang.String getPhysicalResourceIdPath() {
                    return this.$physicalResourceIdPath;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("action", om.valueToTree(this.getAction()));
                    obj.set("service", om.valueToTree(this.getService()));
                    if (this.getApiVersion() != null) {
                        obj.set("apiVersion", om.valueToTree(this.getApiVersion()));
                    }
                    if (this.getCatchErrorPattern() != null) {
                        obj.set("catchErrorPattern", om.valueToTree(this.getCatchErrorPattern()));
                    }
                    if (this.getOutputPath() != null) {
                        obj.set("outputPath", om.valueToTree(this.getOutputPath()));
                    }
                    if (this.getParameters() != null) {
                        obj.set("parameters", om.valueToTree(this.getParameters()));
                    }
                    if (this.getPhysicalResourceId() != null) {
                        obj.set("physicalResourceId", om.valueToTree(this.getPhysicalResourceId()));
                    }
                    if (this.getPhysicalResourceIdPath() != null) {
                        obj.set("physicalResourceIdPath", om.valueToTree(this.getPhysicalResourceIdPath()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.customresources.AwsSdkCall {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The service action to call.
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getAction() {
            return this.jsiiGet("action", java.lang.String.class);
        }

        /**
         * The service to call.
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getService() {
            return this.jsiiGet("service", java.lang.String.class);
        }

        /**
         * API version to use for the service.
         * 
         * Default: use latest available API version
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getApiVersion() {
            return this.jsiiGet("apiVersion", java.lang.String.class);
        }

        /**
         * The regex pattern to use to catch API errors.
         * 
         * The `code` property of the
         * `Error` object will be tested against this pattern. If there is a match an
         * error will not be thrown.
         * 
         * Default: do not catch errors
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getCatchErrorPattern() {
            return this.jsiiGet("catchErrorPattern", java.lang.String.class);
        }

        /**
         * Restrict the data returned by the custom resource to a specific path in the API response.
         * 
         * Use this to limit the data returned by the custom
         * resource if working with API calls that could potentially result in custom
         * response objects exceeding the hard limit of 4096 bytes.
         * 
         * Example for ECS / updateService: 'service.deploymentConfiguration.maximumPercent'
         * 
         * Default: return all data
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getOutputPath() {
            return this.jsiiGet("outputPath", java.lang.String.class);
        }

        /**
         * The parameters for the service action.
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Object getParameters() {
            return this.jsiiGet("parameters", java.lang.Object.class);
        }

        /**
         * The physical resource id of the custom resource for this call.
         * 
         * Either
         * `physicalResourceId` or `physicalResourceIdPath` must be specified for
         * onCreate or onUpdate calls.
         * 
         * Default: no physical resource id
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getPhysicalResourceId() {
            return this.jsiiGet("physicalResourceId", java.lang.String.class);
        }

        /**
         * The path to the data in the API call response to use as the physical resource id.
         * 
         * Either `physicalResourceId` or `physicalResourceIdPath`
         * must be specified for onCreate or onUpdate calls.
         * 
         * Default: no path
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getPhysicalResourceIdPath() {
            return this.jsiiGet("physicalResourceIdPath", java.lang.String.class);
        }
    }
}
