package software.amazon.awscdk.customresources;

/**
 * The IAM Policy that will be applied to the different calls.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.customresources.*;
 * AwsCustomResourcePolicy awsCustomResourcePolicy = AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *         .resources(List.of("resources"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.47.0 (build 86d2c33)", date = "2021-12-10T18:02:01.845Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.AwsCustomResourcePolicy")
public class AwsCustomResourcePolicy extends software.amazon.jsii.JsiiObject {

    protected AwsCustomResourcePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsCustomResourcePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ANY_RESOURCE = java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class, "ANY_RESOURCE", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Generate IAM Policy Statements from the configured SDK calls.
     * <p>
     * Each SDK call with be translated to an IAM Policy Statement in the form of: <code>call.service:call.action</code> (e.g <code>s3:PutObject</code>).
     * <p>
     * @param options options for the policy generation. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.AwsCustomResourcePolicy fromSdkCalls(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.SdkCallsPolicyOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class, "fromSdkCalls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Explicit IAM Policy Statements.
     * <p>
     * @param statements the statements to propagate to the SDK calls. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.AwsCustomResourcePolicy fromStatements(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class, "fromStatements", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class), new Object[] { java.util.Objects.requireNonNull(statements, "statements is required") });
    }

    /**
     * Use this constant to configure access to any resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.util.List<java.lang.String> ANY_RESOURCE;

    /**
     * resources for auto-generated from SDK calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * statements for explicit policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }
}
