/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.customresources;

import java.util.List;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.customresources.AwsCustomResourceProps;
import software.amazon.awscdk.customresources.AwsSdkCall;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.JsiiSerializable;

public interface AwsCustomResourceProps
extends JsiiSerializable {
    public AwsSdkCall getOnCreate();

    public AwsSdkCall getOnDelete();

    public AwsSdkCall getOnUpdate();

    public List<PolicyStatement> getPolicyStatements();

    public Duration getTimeout();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AwsSdkCall onCreate;
        private AwsSdkCall onDelete;
        private AwsSdkCall onUpdate;
        private List<PolicyStatement> policyStatements;
        private Duration timeout;

        public Builder onCreate(AwsSdkCall onCreate) {
            this.onCreate = onCreate;
            return this;
        }

        public Builder onDelete(AwsSdkCall onDelete) {
            this.onDelete = onDelete;
            return this;
        }

        public Builder onUpdate(AwsSdkCall onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        public Builder policyStatements(List<PolicyStatement> policyStatements) {
            this.policyStatements = policyStatements;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public AwsCustomResourceProps build() {
            return new Jsii.Proxy(this.onCreate, this.onDelete, this.onUpdate, this.policyStatements, this.timeout, null);
        }
    }
}

