package software.amazon.awscdk.customresources;

/**
 * Defines an AWS CloudFormation custom resource provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.customresources.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.core.Stack;
 * Function myOnEventLambda;
 * Function myIsCompleteLambda;
 * Stack stack = new Stack();
 * Provider provider = Provider.Builder.create(stack, "myProvider")
 *         .onEventHandler(myOnEventLambda)
 *         .isCompleteHandler(myIsCompleteLambda)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-22T09:25:21.738Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.Provider")
public class Provider extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.services.cloudformation.ICustomResourceProvider {

    protected Provider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Provider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Provider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.ProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (deprecated) Called by `CustomResource` which uses this provider.
     * <p>
     * @deprecated use `provider.serviceToken` instead
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudformation.CustomResourceProviderConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudformation.CustomResourceProviderConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * The user-defined AWS Lambda function which is invoked for all resource lifecycle operations (CREATE/UPDATE/DELETE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getOnEventHandler() {
        return software.amazon.jsii.Kernel.get(this, "onEventHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
    }

    /**
     * The service token to use in order to define custom resources that are backed by this provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceToken() {
        return software.amazon.jsii.Kernel.get(this, "serviceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-defined AWS Lambda function which is invoked asynchronously in order to determine if the operation is complete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getIsCompleteHandler() {
        return software.amazon.jsii.Kernel.get(this, "isCompleteHandler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.customresources.Provider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.customresources.Provider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.customresources.ProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.customresources.ProviderProps.Builder();
        }

        /**
         * The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE).
         * <p>
         * This function is responsible to begin the requested resource operation
         * (CREATE/UPDATE/DELETE) and return any additional properties to add to the
         * event, which will later be passed to <code>isComplete</code>. The <code>PhysicalResourceId</code>
         * property must be included in the response.
         * <p>
         * @return {@code this}
         * @param onEventHandler The AWS Lambda function to invoke for all resource lifecycle operations (CREATE/UPDATE/DELETE). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventHandler(final software.amazon.awscdk.services.lambda.IFunction onEventHandler) {
            this.props.onEventHandler(onEventHandler);
            return this;
        }

        /**
         * The AWS Lambda function to invoke in order to determine if the operation is complete.
         * <p>
         * This function will be called immediately after <code>onEvent</code> and then
         * periodically based on the configured query interval as long as it returns
         * <code>false</code>. If the function still returns <code>false</code> and the alloted timeout has
         * passed, the operation will fail.
         * <p>
         * Default: - provider is synchronous. This means that the `onEvent` handler
         * is expected to finish all lifecycle operations within the initial invocation.
         * <p>
         * @return {@code this}
         * @param isCompleteHandler The AWS Lambda function to invoke in order to determine if the operation is complete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isCompleteHandler(final software.amazon.awscdk.services.lambda.IFunction isCompleteHandler) {
            this.props.isCompleteHandler(isCompleteHandler);
            return this;
        }

        /**
         * The number of days framework log events are kept in CloudWatch Logs.
         * <p>
         * When
         * updating this property, unsetting it doesn't remove the log retention policy.
         * To remove the retention policy, set the value to <code>INFINITE</code>.
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @param logRetention The number of days framework log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * Provider Lambda name.
         * <p>
         * The provider lambda function name.
         * <p>
         * Default: -  CloudFormation default name from unique physical ID
         * <p>
         * @return {@code this}
         * @param providerFunctionName Provider Lambda name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerFunctionName(final java.lang.String providerFunctionName) {
            this.props.providerFunctionName(providerFunctionName);
            return this;
        }

        /**
         * Time between calls to the `isComplete` handler which determines if the resource has been stabilized.
         * <p>
         * The first <code>isComplete</code> will be called immediately after <code>handler</code> and then
         * every <code>queryInterval</code> seconds, and until <code>timeout</code> has been reached or until
         * <code>isComplete</code> returns <code>true</code>.
         * <p>
         * Default: Duration.seconds(5)
         * <p>
         * @return {@code this}
         * @param queryInterval Time between calls to the `isComplete` handler which determines if the resource has been stabilized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryInterval(final software.amazon.awscdk.core.Duration queryInterval) {
            this.props.queryInterval(queryInterval);
            return this;
        }

        /**
         * AWS Lambda execution role.
         * <p>
         * The role that will be assumed by the AWS Lambda.
         * Must be assumable by the 'lambda.amazonaws.com' service principal.
         * <p>
         * Default: - A default role will be created.
         * <p>
         * @return {@code this}
         * @param role AWS Lambda execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Security groups to attach to the provider functions.
         * <p>
         * Only used if 'vpc' is supplied
         * <p>
         * Default: - If `vpc` is not supplied, no security groups are attached. Otherwise, a dedicated security
         * group is created for each function.
         * <p>
         * @return {@code this}
         * @param securityGroups Security groups to attach to the provider functions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Total timeout for the entire operation.
         * <p>
         * The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
         * <p>
         * Default: Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param totalTimeout Total timeout for the entire operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder totalTimeout(final software.amazon.awscdk.core.Duration totalTimeout) {
            this.props.totalTimeout(totalTimeout);
            return this;
        }

        /**
         * The vpc to provision the lambda functions in.
         * <p>
         * Default: - functions are not provisioned inside a vpc.
         * <p>
         * @return {@code this}
         * @param vpc The vpc to provision the lambda functions in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Which subnets from the VPC to place the lambda functions in.
         * <p>
         * Only used if 'vpc' is supplied. Note: internet access for Lambdas
         * requires a NAT gateway, so picking Public subnets is not allowed.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets from the VPC to place the lambda functions in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.customresources.Provider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.customresources.Provider build() {
            return new software.amazon.awscdk.customresources.Provider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
