package software.amazon.awscdk.customresources;

/**
 * The IAM Policy that will be applied to the different calls.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource awsCustom = AwsCustomResource.Builder.create(this, "aws-custom")
 *         .onCreate(AwsSdkCall.builder()
 *                 .service("...")
 *                 .action("...")
 *                 .parameters(Map.of(
 *                         "text", "..."))
 *                 .physicalResourceId(PhysicalResourceId.of("..."))
 *                 .build())
 *         .onUpdate(AwsSdkCall.builder()
 *                 .service("...")
 *                 .action("...")
 *                 .parameters(Map.of(
 *                         "text", "...",
 *                         "resourceId", new PhysicalResourceIdReference()))
 *                 .build())
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-20T22:20:01.354Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.customresources.$Module.class, fqn = "@aws-cdk/custom-resources.AwsCustomResourcePolicy")
public class AwsCustomResourcePolicy extends software.amazon.jsii.JsiiObject {

    protected AwsCustomResourcePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsCustomResourcePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ANY_RESOURCE = java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class, "ANY_RESOURCE", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Generate IAM Policy Statements from the configured SDK calls.
     * <p>
     * Each SDK call with be translated to an IAM Policy Statement in the form of: <code>call.service:call.action</code> (e.g <code>s3:PutObject</code>).
     * <p>
     * This policy generator assumes the IAM policy name has the same name as the API
     * call. This is true in 99% of cases, but there are exceptions (for example,
     * S3's <code>PutBucketLifecycleConfiguration</code> requires
     * <code>s3:PutLifecycleConfiguration</code> permissions, Lambda's <code>Invoke</code> requires
     * <code>lambda:InvokeFunction</code> permissions). Use <code>fromStatements</code> if you want to
     * do a call that requires different IAM action names.
     * <p>
     * @param options options for the policy generation. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.AwsCustomResourcePolicy fromSdkCalls(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.SdkCallsPolicyOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class, "fromSdkCalls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Explicit IAM Policy Statements.
     * <p>
     * @param statements the statements to propagate to the SDK calls. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.customresources.AwsCustomResourcePolicy fromStatements(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class, "fromStatements", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class), new Object[] { java.util.Objects.requireNonNull(statements, "statements is required") });
    }

    /**
     * Use this constant to configure access to any resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.util.List<java.lang.String> ANY_RESOURCE;

    /**
     * statements for explicit policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * resources for auto-generated from SDK calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
